/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.crms.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderReDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsStockSlaesGoodsDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsStockSlaesGoodsReDomain;
import com.qjsoft.laser.controller.facade.crms.repository.CrmsStockSlaesGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/crms/stock"}, name="\u8fdb\u9500\u5b58")
public class CrmsStockSlaesCon
extends SpringmvnNewController {
    private static String CODE = "crms.stock.con";
    @Autowired
    private CtCustrelServiceRepository ctCustrelServiceRepository;
    @Autowired
    private CrmsStockSlaesGoodsServiceRepository crmsStockSlaesGoodsServiceRepository;

    protected String getContext() {
        return "stock";
    }

    @RequestMapping(value={"exportStockSalesByExcel.json"}, name="\u5bfc\u5165\u8fdb\u9500\u5b58")
    @ResponseBody
    public HtmlJsonReBean exportShoppingGoodsByExcel(HttpServletRequest request, String stockDomainStr) {
        if (StringUtils.isBlank((String)stockDomainStr) || StringUtils.isBlank((String)stockDomainStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u7f3a\u5931\uff01");
        }
        this.logger.error(CODE + ".exportShoppingGoodsByExcel params{\u5bfc\u5165\u8fdb\u9500\u5b58\u5f00\u59cb}=====:" + stockDomainStr);
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        JSONArray goodsArray = JSONArray.json2array((String)stockDomainStr);
        this.handelParams(goodsArray);
        Map<String, Object> result = this.checkStockParams(goodsArray, tenantCode);
        this.logger.error(CODE + ".exportShoppingGoodsByExcel 11111\u5bfc\u5165\u8fdb\u9500\u5b58\u68c0\u9a8c\u7a7a\u7ed3\u675f\uff01");
        List successList = (List)result.get("successList");
        List errorList = (List)result.get("errorList");
        if (ListUtil.isNotEmpty((Collection)errorList)) {
            HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
            htmlJsonReBean.setDataObj((Object)errorList);
            htmlJsonReBean.setSysRecode("error");
            htmlJsonReBean.setMsg("\u5bfc\u5165\u8fdb\u9500\u5b58\u6570\u636e\u5f02\u5e38\uff01");
            return htmlJsonReBean;
        }
        this.logger.error(CODE + ".exportShoppingGoodsByExcel 2222\u5bfc\u5165\u8fdb\u9500\u5b58\u5f00\u59cb\u5904\u7406\uff01");
        Map<String, Object> out = this.buildStockSlaesDomain(successList, tenantCode, userSession);
        List stockSlaesGoodsList = (List)out.get("stockSlaesGoodsList");
        List haveStockId = (List)out.get("haveStockId");
        this.logger.error(CODE + ".exportShoppingGoodsByExcel 3333\u5bfc\u5165\u8fdb\u9500\u5b58\u5904\u7406\u5b8c\u6bd5\uff01\uff01\uff01\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)stockSlaesGoodsList));
        HtmlJsonReBean htmlJsonReBean = this.crmsStockSlaesGoodsServiceRepository.savecrmsStockSlaesGoodsBatch(stockSlaesGoodsList);
        if (haveStockId.size() > 0) {
            for (Integer stockId : haveStockId) {
                this.crmsStockSlaesGoodsServiceRepository.deletecrmsStockSlaesGoods(stockId);
            }
        }
        return htmlJsonReBean;
    }

    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        List crmsSOrderReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), CrmsSOrderReDomain.class);
        if (ListUtil.isEmpty((Collection)crmsSOrderReDomainList)) {
            return null;
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        return mapList;
    }

    private void handelParams(JSONArray goodsArray) {
        for (JSONObject jsonObjects : goodsArray) {
            for (Map.Entry set : jsonObjects.entrySet()) {
                if (set.getValue() == null) continue;
                jsonObjects.put(set.getKey().toString(), (Object)set.getValue().toString().trim());
            }
        }
    }

    private Map<String, Object> checkStockParams(JSONArray goodsArray, String tenantCode) {
        this.logger.error(CODE + ".checkStockParams params{\u5bfc\u5165\u8fdb\u9500\u5b58\u6821\u9a8c\u53c2\u6570\u5f00\u59cb}=====");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<JSONObject> errorList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> tempList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> successList = new ArrayList<JSONObject>();
        ArrayList<String> customerNameList = new ArrayList<String>();
        for (JSONObject jsonObject : goodsArray) {
            StringBuilder errorInfo = new StringBuilder();
            if (jsonObject.getString("memberName") == null) {
                errorInfo.append("\u5ba2\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            } else if (!customerNameList.contains(jsonObject.getString("memberName"))) {
                customerNameList.add(jsonObject.getString("memberName"));
            }
            if (jsonObject.getString("goodsBom") == null) {
                errorInfo.append("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (jsonObject.getString("goodsModel") == null) {
                errorInfo.append("BOM\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (jsonObject.getString("uploadMonth") == null) {
                errorInfo.append("\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a!");
            } else if (jsonObject.getString("uploadMonth") != null && jsonObject.getString("uploadMonth").length() != 7) {
                errorInfo.append("\u6708\u4efd\u8bf7\u8f93\u5165\u20182022-01\u2019\u683c\u5f0f\u6570\u636e!");
            }
            if (jsonObject.getString("curryInventory") == null) {
                errorInfo.append("\u5f53\u6708\u5e93\u5b58\u4e0d\u80fd\u4e3a\u7a7a!");
            } else if (!NumberUtils.isDigits((String)jsonObject.getString("curryInventory"))) {
                errorInfo.append("\u5f53\u6708\u5e93\u5b58\u5fc5\u987b\u4e3a\u6574\u6570!");
            }
            if (errorInfo.toString().length() > 0) {
                jsonObject.put("errorMsg", (Object)errorInfo.toString());
                errorList.add(jsonObject);
                continue;
            }
            tempList.add(jsonObject);
        }
        if (errorList.size() > 0) {
            result.put("errorList", errorList);
            result.put("successList", successList);
            return result;
        }
        SupQueryResult<CtCustrelReDomain> queryResult = this.queryExportCustomer(tempList, tenantCode);
        if (queryResult == null || queryResult.getList() == null || queryResult.getList().isEmpty()) {
            for (String customerName : customerNameList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("memberName", (Object)customerName);
                jsonObject.put("errorMsg", (Object)"\u5ba2\u6237\u4e0d\u5b58\u5728");
                errorList.add(jsonObject);
            }
        } else {
            for (JSONObject jsonObject : tempList) {
                String memberCode = "";
                String memberName = jsonObject.getString("memberName");
                for (CtCustrelReDomain ctCustrelReDomain : queryResult.getList()) {
                    if (!memberName.equals(ctCustrelReDomain.getCustrelName())) continue;
                    memberCode = ctCustrelReDomain.getUserinfoCode();
                }
                if (!"".equals(memberCode)) {
                    jsonObject.put("memberCode", (Object)memberCode);
                    successList.add(jsonObject);
                    continue;
                }
                jsonObject.put("errorMsg", (Object)"\u5ba2\u6237\u4e0d\u5b58\u5728");
                errorList.add(jsonObject);
            }
        }
        result.put("errorList", errorList);
        result.put("successList", successList);
        return result;
    }

    private SupQueryResult<CtCustrelReDomain> queryExportCustomer(List<JSONObject> successList, String tenantCode) {
        ArrayList<String> customerNameList = new ArrayList<String>();
        StringBuilder customerNameStr = new StringBuilder();
        if (successList.isEmpty()) {
            return null;
        }
        for (JSONObject jsonObject : successList) {
            String memberName = jsonObject.getString("memberName");
            if (customerNameList.contains(memberName)) continue;
            customerNameList.add(memberName);
            customerNameStr.append(memberName).append(",");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("custrelNameList", customerNameList);
        params.put("tenantCode", tenantCode);
        this.logger.error(CODE + ".queryExportCustomer params{params}=====", (Object)JsonUtil.buildNormalBinder().toJson(params));
        return this.ctCustrelServiceRepository.queryCustrelPage(params);
    }

    private Map<String, Object> buildStockSlaesDomain(List<JSONObject> successList, String tenantCode, UserSession userSession) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.logger.error(CODE + ".buildStockSlaesDomain params{\u5bfc\u5165\u8fdb\u9500\u5b58\u5c01\u88c5\u53c2\u6570\u5f00\u59cb}=====:" + JsonUtil.buildNormalBinder().toJson(successList));
        ArrayList<CrmsStockSlaesGoodsDomain> stockSlaesGoodsList = new ArrayList<CrmsStockSlaesGoodsDomain>();
        ArrayList<Integer> haveStockId = new ArrayList<Integer>();
        for (JSONObject jsonObject : successList) {
            CrmsStockSlaesGoodsDomain crmsStockSlaes = new CrmsStockSlaesGoodsDomain();
            String memberCode = jsonObject.getString("memberCode");
            String memberName = jsonObject.getString("memberName");
            String goodsBom = jsonObject.getString("goodsBom");
            String goodsModel = jsonObject.getString("goodsModel");
            String uploadMonth = jsonObject.getString("uploadMonth");
            Integer curryInventory = jsonObject.getInteger("curryInventory");
            String lastMonth = this.getLastMonth(uploadMonth);
            Integer lastInventory = 0;
            HashMap<String, Object> selectMap = new HashMap<String, Object>();
            selectMap.put("fuzzy", true);
            selectMap.put("tenantCode", tenantCode);
            selectMap.put("memberName", memberName);
            selectMap.put("goodsBom", goodsBom);
            selectMap.put("goodsModel", goodsModel);
            selectMap.put("uploadMonth", uploadMonth + "," + lastMonth);
            SupQueryResult sq = this.crmsStockSlaesGoodsServiceRepository.querycrmsStockSlaesGoodsPage(selectMap);
            if (sq != null && sq.getList() != null && sq.getList().size() > 0) {
                for (CrmsStockSlaesGoodsReDomain cs : sq.getList()) {
                    if (cs.getUploadMonth().equals(uploadMonth)) {
                        haveStockId.add(cs.getStockId());
                        continue;
                    }
                    if (!cs.getUploadMonth().equals(lastMonth)) continue;
                    lastInventory = cs.getCurryInventory();
                }
            }
            Integer aogNumber = 0;
            Integer salesNumber = curryInventory + aogNumber - lastInventory;
            Double salesRatInventory = null;
            if (curryInventory > 0) {
                salesRatInventory = (double)salesNumber.intValue() * 100.0 / (double)curryInventory.intValue();
            }
            String inventoryState = "";
            String inAdvices = "";
            if (aogNumber > 0) {
                if (salesNumber == 0) {
                    inventoryState = "\u51c0\u6d41\u5165";
                    inAdvices = "\u8bc4\u4f30\u8865\u8d27";
                } else if (salesNumber > 0) {
                    if (salesNumber > aogNumber) {
                        inventoryState = "\u6d41\u51fa\u5927\u4e8e\u6d41\u5165";
                        inAdvices = "\u8bc4\u4f30\u8865\u8d27";
                    }
                    if (salesNumber < aogNumber) {
                        inventoryState = "\u6d41\u5165\u5927\u4e8e\u6d41\u51fa";
                        inAdvices = salesRatInventory >= 50.0 ? "\u8bc4\u4f30\u8865\u8d27" : "\u6682\u505c\u8865\u8d27,\u5446\u6ede/\u521a\u5230\u8d27";
                    }
                    if (salesNumber.equals(aogNumber)) {
                        inventoryState = "\u8fdb\u9500\u5e73\u8861";
                        inAdvices = "\u8bc4\u4f30\u8865\u8d27";
                    }
                }
            } else if (aogNumber == 0) {
                if (salesNumber.equals(curryInventory)) {
                    inventoryState = "\u552e\u7f44";
                    inAdvices = "\u9a6c\u4e0a\u8865\u8d27";
                } else {
                    if (salesNumber > 0) {
                        inventoryState = "\u51c0\u6d41\u51fa";
                        inAdvices = "\u8bc4\u4f30\u8865\u8d27";
                    }
                    if (salesNumber == 0) {
                        inventoryState = "\u8fd1\u671f\u65e0\u6d41\u6c34";
                        inAdvices = "\u786e\u8ba4\u5ba2\u6237\u9700\u6c42/\u5e93\u5b58\u5f02\u5e38";
                    }
                    if (salesRatInventory < 0.0) {
                        inventoryState = "\u5728\u5e93\u5e93\u5b58\u5c0f\u4e8e0,\u5f02\u5e38";
                        inAdvices = "\u786e\u8ba4\u5ba2\u6237\u9700\u6c42/\u5e93\u5b58\u5f02\u5e38";
                    }
                }
            }
            crmsStockSlaes.setTenantCode(tenantCode);
            crmsStockSlaes.setMemberCode(memberCode);
            crmsStockSlaes.setMemberName(memberName);
            crmsStockSlaes.setGoodsBom(goodsBom);
            crmsStockSlaes.setGoodsModel(goodsModel);
            crmsStockSlaes.setUploadMonth(uploadMonth);
            crmsStockSlaes.setLastInventory(lastInventory);
            crmsStockSlaes.setCurryInventory(curryInventory);
            crmsStockSlaes.setAogNumber(aogNumber);
            crmsStockSlaes.setSalesNumber(salesNumber);
            crmsStockSlaes.setSalesRatInventory(salesRatInventory);
            crmsStockSlaes.setInventoryState(inventoryState);
            crmsStockSlaes.setInAdvices(inAdvices);
            stockSlaesGoodsList.add(crmsStockSlaes);
        }
        result.put("stockSlaesGoodsList", stockSlaesGoodsList);
        result.put("haveStockId", haveStockId);
        return result;
    }

    private String getLastMonth(String curryMonth) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date time = null;
        try {
            Date currenDate = format.parse(curryMonth);
            Calendar cal = Calendar.getInstance();
            cal.setTime(currenDate);
            cal.add(2, -1);
            time = cal.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return format.format(time);
    }
}

