/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.data.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.da.repository.DaOpsumListServiceRepository;
import com.qjsoft.laser.controller.facade.da.repository.DaOpsumServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.data.domain.DaOpsumListDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumListReDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumReDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/da/opsumlist"}, name="\u6c47\u603b\u6570\u636e\u660e\u7ec6")
public class OpsumlistCon
extends SpringmvcController {
    private static String CODE = "da.opsumlist.con";
    @Autowired
    private DaOpsumListServiceRepository daOpsumListServiceRepository;
    @Autowired
    private DaOpsumServiceRepository daOpsumServiceRepository;

    protected String getContext() {
        return "opsumlist";
    }

    @RequestMapping(value={"saveOpsumlist.json"}, name="\u589e\u52a0\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveOpsumlist(HttpServletRequest request, DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            this.logger.error(CODE + ".saveOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumListDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumListServiceRepository.saveOpsumList(daOpsumListDomain);
    }

    @RequestMapping(value={"getOpsumlist.json"}, name="\u83b7\u53d6\u6c47\u603b\u6570\u636e\u660e\u7ec6\u4fe1\u606f")
    @ResponseBody
    public DaOpsumListReDomain getOpsumlist(Integer opsumlistId) {
        if (StringUtils.isBlank((Integer)opsumlistId)) {
            this.logger.error(CODE + ".getOpsumlist", (Object)"param is null");
            return null;
        }
        return this.daOpsumListServiceRepository.getOpsumList(opsumlistId);
    }

    @RequestMapping(value={"updateOpsumlist.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean updateOpsumlist(HttpServletRequest request, DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            this.logger.error(CODE + ".updateOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumListDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumListServiceRepository.updateOpsumList(daOpsumListDomain);
    }

    @RequestMapping(value={"deleteOpsumlist.json"}, name="\u5220\u9664\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean deleteOpsumlist(Integer opsumlistId) {
        if (StringUtils.isBlank((Integer)opsumlistId)) {
            this.logger.error(CODE + ".deleteOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumListServiceRepository.deleteOpsumList(opsumlistId);
    }

    @RequestMapping(value={"queryOpsumlistPage.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.daOpsumListServiceRepository.queryOpsumListPage(param);
    }

    @RequestMapping(value={"updateOpsumlistState.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e\u660e\u7ec6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOpsumlistState(String opsumlistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)opsumlistId)) {
            this.logger.error(CODE + ".updateOpsumlistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumListServiceRepository.updateOpsumListState(Integer.valueOf(opsumlistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryOpsumListPageForPlat.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListPageForPlat(HttpServletRequest request, String sumType) {
        SupQueryResult daOpsumReDomainSupQueryResult;
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResult = new ArrayList<DaOpsumListReDomain>();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDateLast = sdf.format(date);
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("opsumDate", formatDateLast);
            param.put("opsumType", sumType);
            param.put("opsumDimcode", this.getTenantCode(request));
        }
        if (null == (daOpsumReDomainSupQueryResult = this.daOpsumServiceRepository.queryOpsumPage(param))) {
            this.logger.error(CODE + ".queryOpsumListPageForPlat.daOpsumReDomainSupQueryResult", (Object)"result is null");
            return null;
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)daOpsumReDomainSupQueryResult.getList().get(0);
        String opsumCode = daOpsumReDomain.getOpsumCode();
        Map map = this.assemMapParam(request);
        if (null != map) {
            map.put("opsumCode", opsumCode);
            map.put("opsumDate", formatDateLast);
        }
        SupQueryResult daOpsumListReDomainSupQueryResult = this.daOpsumListServiceRepository.queryOpsumListPage(map);
        List list = daOpsumListReDomainSupQueryResult.getList();
        for (DaOpsumListReDomain daOpsumListReDomain : list) {
            daOpsumListReDomainsResult.add(daOpsumListReDomain);
        }
        Date todayDate = new Date();
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.setTime(todayDate);
        todayDate = calendarToday.getTime();
        SimpleDateFormat sdfToday = new SimpleDateFormat(pattern);
        String today = sdfToday.format(todayDate);
        Map paramToday = this.assemMapParam(request);
        if (null != paramToday) {
            paramToday.put("opsumCode", opsumCode);
            paramToday.put("opsumDate", today);
        }
        SupQueryResult todayResult = this.daOpsumListServiceRepository.queryOpsumListPage(paramToday);
        List listToday = todayResult.getList();
        for (DaOpsumListReDomain todayDomain : listToday) {
            daOpsumListReDomainsResult.add(todayDomain);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        supQueryResult.setList(daOpsumListReDomainsResult);
        return supQueryResult;
    }

    @RequestMapping(value={"queryOpsumListNextPageForPlat.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForPlat(HttpServletRequest request, String sumType) {
        SupQueryResult daOpsumReDomainSupQueryResult;
        ArrayList daOpsumListReDomainsResult = new ArrayList();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDateLast = sdf.format(date);
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("opsumDate", formatDateLast);
            param.put("opsumType", sumType);
        }
        if (null == (daOpsumReDomainSupQueryResult = this.daOpsumServiceRepository.queryOpsumPage(param))) {
            this.logger.error(CODE + ".queryOpsumListPageForPlat.daOpsumReDomainSupQueryResult", (Object)"result is null");
            return null;
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)daOpsumReDomainSupQueryResult.getList().get(0);
        String opsumCode = daOpsumReDomain.getOpsumCode();
        Map map = this.assemMapParam(request);
        if (null != map) {
            map.put("opsumCode", opsumCode);
            map.put("opsumDate", formatDateLast);
        }
        return this.daOpsumListServiceRepository.queryOpsumListPage(map);
    }
}

