/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.data.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.da.domain.DaOpsetDomain;
import com.qjsoft.laser.controller.facade.da.domain.DaOpsetReDomain;
import com.qjsoft.laser.controller.facade.da.repository.DaOpsetServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/da/opset"}, name="\u6c47\u603b\u7c7b\u578b\u8bbe\u7f6e")
public class OpsetCon
extends SpringmvcController {
    private static String CODE = "da.opset.con";
    @Autowired
    private DaOpsetServiceRepository daOpsetServiceRepository;

    protected String getContext() {
        return "opset";
    }

    @RequestMapping(value={"saveOpset.json"}, name="\u589e\u52a0\u6c47\u603b\u7c7b\u578b\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveOpset(HttpServletRequest request, DaOpsetDomain daOpsetDomain) {
        if (null == daOpsetDomain) {
            this.logger.error(CODE + ".saveOpset", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsetDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsetServiceRepository.saveOpset(daOpsetDomain);
    }

    @RequestMapping(value={"getOpset.json"}, name="\u83b7\u53d6\u6c47\u603b\u7c7b\u578b\u8bbe\u7f6e\u4fe1\u606f")
    @ResponseBody
    public DaOpsetReDomain getOpset(Integer opsetId) {
        if (StringUtils.isBlank((Integer)opsetId)) {
            this.logger.error(CODE + ".getOpset", (Object)"param is null");
            return null;
        }
        return this.daOpsetServiceRepository.getOpset(opsetId);
    }

    @RequestMapping(value={"updateOpset.json"}, name="\u66f4\u65b0\u6c47\u603b\u7c7b\u578b\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateOpset(HttpServletRequest request, DaOpsetDomain daOpsetDomain) {
        if (null == daOpsetDomain) {
            this.logger.error(CODE + ".updateOpset", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsetDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsetServiceRepository.updateOpset(daOpsetDomain);
    }

    @RequestMapping(value={"deleteOpset.json"}, name="\u5220\u9664\u6c47\u603b\u7c7b\u578b\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteOpset(Integer opsetId) {
        if (StringUtils.isBlank((Integer)opsetId)) {
            this.logger.error(CODE + ".deleteOpset", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsetServiceRepository.deleteOpset(opsetId);
    }

    @RequestMapping(value={"queryOpsetPage.json"}, name="\u67e5\u8be2\u6c47\u603b\u7c7b\u578b\u8bbe\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsetReDomain> queryOpsetPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.daOpsetServiceRepository.queryOpsetPage(param);
    }

    @RequestMapping(value={"updateOpsetState.json"}, name="\u66f4\u65b0\u6c47\u603b\u7c7b\u578b\u8bbe\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOpsetState(String opsetId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)opsetId)) {
            this.logger.error(CODE + ".updateOpsetState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsetServiceRepository.updateOpsetState(Integer.valueOf(opsetId), dataState, oldDataState, null);
    }
}

