/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.data.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.data.Thread.saveUserinfoSumThread;
import com.qjsoft.laser.controller.facade.da.domain.DaOpsumListBigDataReDomain;
import com.qjsoft.laser.controller.facade.da.domain.DaOpsumListDomain;
import com.qjsoft.laser.controller.facade.da.domain.DaOpsumListReDomain;
import com.qjsoft.laser.controller.facade.da.domain.DaOpsumReDomain;
import com.qjsoft.laser.controller.facade.da.repository.DaOpsumListServiceRepository;
import com.qjsoft.laser.controller.facade.da.repository.DaOpsumServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcRefundServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/da/opsumlist"}, name="\u6c47\u603b\u6570\u636e\u660e\u7ec6")
public class OpsumlistCon
extends SpringmvcController {
    private static String CODE = "da.opsumlist.con";
    @Autowired
    private DaOpsumListServiceRepository daOpsumListServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private DaOpsumServiceRepository daOpsumServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcRefundServiceRepository ocRefundServiceRepository;

    protected String getContext() {
        return "opsumlist";
    }

    @RequestMapping(value={"saveOpsumlist.json"}, name="\u589e\u52a0\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveOpsumlist(HttpServletRequest request, DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            this.logger.error(CODE + ".saveOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumListDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumListServiceRepository.saveOpsumList(daOpsumListDomain);
    }

    @RequestMapping(value={"getOpsumlist.json"}, name="\u83b7\u53d6\u6c47\u603b\u6570\u636e\u660e\u7ec6\u4fe1\u606f")
    @ResponseBody
    public DaOpsumListReDomain getOpsumlist(Integer opsumlistId) {
        if (StringUtils.isBlank((Integer)opsumlistId)) {
            this.logger.error(CODE + ".getOpsumlist", (Object)"param is null");
            return null;
        }
        return this.daOpsumListServiceRepository.getOpsumList(opsumlistId);
    }

    @RequestMapping(value={"updateOpsumlist.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean updateOpsumlist(HttpServletRequest request, DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            this.logger.error(CODE + ".updateOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumListDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumListServiceRepository.updateOpsumList(daOpsumListDomain);
    }

    @RequestMapping(value={"deleteOpsumlist.json"}, name="\u5220\u9664\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean deleteOpsumlist(Integer opsumlistId) {
        if (StringUtils.isBlank((Integer)opsumlistId)) {
            this.logger.error(CODE + ".deleteOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumListServiceRepository.deleteOpsumList(opsumlistId);
    }

    @RequestMapping(value={"queryOpsumlistPage.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.daOpsumListServiceRepository.queryOpsumListPage(param);
    }

    @RequestMapping(value={"updateOpsumlistState.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e\u660e\u7ec6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOpsumlistState(String opsumlistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)opsumlistId)) {
            this.logger.error(CODE + ".updateOpsumlistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumListServiceRepository.updateOpsumListState(Integer.valueOf(opsumlistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryOpsumListPageForPlat.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u79df\u6237")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForPlat(HttpServletRequest request, String sumType) {
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> stringObjectMap = this.queryOpsumListPageComm(tenantCode, sumType, tenantCode, "\u79df\u6237");
        if (null != stringObjectMap) {
            return stringObjectMap;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("dataLast", "0");
        resultMap.put("dataToday", "0");
        return resultMap;
    }

    @RequestMapping(value={"queryOpsumListPageForUser.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u5356\u5bb6")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForUser(HttpServletRequest request, String sumType) {
        String tenantCode;
        String userPcode = this.getUserSession(request).getUserPcode();
        Map<String, Object> stringObjectMap = this.queryOpsumListPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request), "\u7528\u6237");
        if (null != stringObjectMap) {
            return stringObjectMap;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("dataLast", "0");
        resultMap.put("dataToday", "0");
        return resultMap;
    }

    @RequestMapping(value={"queryOpsumListPageForYunying.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u8fd0\u8425")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForYunying(HttpServletRequest request, String sumType) {
        String tenantCode;
        String userPcode = this.getUserSession(request).getUserPcode();
        Map<String, Object> stringObjectMap = this.queryOpsumListPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request), "\u8fd0\u8425");
        if (null != stringObjectMap) {
            return stringObjectMap;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("dataLast", "0");
        resultMap.put("dataToday", "0");
        return resultMap;
    }

    private Map<String, Object> queryOpsumListPageComm(String userPcode, String sumType, String tenantCode, String opsumDimname) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDateLast = sdf.format(date);
        Date todayDate = new Date();
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.setTime(todayDate);
        todayDate = calendarToday.getTime();
        SimpleDateFormat sdfToday = new SimpleDateFormat(pattern);
        String today = sdfToday.format(todayDate);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("order", true);
        param.put("opsumDate", formatDateLast);
        param.put("opsumType", sumType);
        param.put("opsumDimcode", userPcode);
        param.put("opsumDimname", opsumDimname);
        SupQueryResult daOpsumReDomainSupQueryResult = this.daOpsumServiceRepository.queryOpsumPage(param);
        if (null == daOpsumReDomainSupQueryResult || daOpsumReDomainSupQueryResult.getList().isEmpty()) {
            this.logger.error(CODE + ".queryOpsumListPageComm.daOpsumReDomainSupQueryResult", (Object)"result is null");
            return this.queryOpsumListPageCommToday(userPcode, sumType, tenantCode, resultMap);
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)daOpsumReDomainSupQueryResult.getList().get(0);
        String opsumCode = daOpsumReDomain.getOpsumCode();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("opsumCode", opsumCode);
        map.put("opsumDate", formatDateLast);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultLast = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult daOpsumListReDomainSupQueryResult = this.daOpsumListServiceRepository.queryOpsumListPage(map);
        if (null != daOpsumListReDomainSupQueryResult) {
            List list = daOpsumListReDomainSupQueryResult.getList();
            for (DaOpsumListReDomain daOpsumListReDomain : list) {
                daOpsumListReDomain.setOpsumDate("\u6628\u65e5");
                daOpsumListReDomainsResultLast.add(daOpsumListReDomain);
            }
        }
        HashMap<String, Object> paramToday = new HashMap<String, Object>();
        paramToday.put("tenantCode", tenantCode);
        paramToday.put("order", true);
        paramToday.put("opsumDate", today);
        paramToday.put("opsumType", sumType);
        paramToday.put("opsumDimcode", userPcode);
        SupQueryResult daOpsumReDomainSupQueryResult2 = this.daOpsumServiceRepository.queryOpsumPage(paramToday);
        if (null == daOpsumReDomainSupQueryResult2 || daOpsumReDomainSupQueryResult2.getList().isEmpty()) {
            this.logger.error(CODE + ".queryOpsumListPageComm.daOpsumReDomainSupQueryResult2", (Object)"result is null");
            ArrayList<DaOpsumListReDomain> daOpsumListToday = new ArrayList<DaOpsumListReDomain>();
            DaOpsumListReDomain todayDomain = new DaOpsumListReDomain();
            todayDomain.setOpsetName("UmUserinfoSum");
            todayDomain.setOpsetType("UmUserinfoSum");
            todayDomain.setTenantCode(tenantCode);
            todayDomain.setOpsumDimname("\u79df\u6237");
            todayDomain.setOpsumDate("\u4eca\u65e5");
            todayDomain.setOpsumListNum(this.setZeroNum(tenantCode, null));
            daOpsumListToday.add(todayDomain);
            new saveUserinfoSumThread(this.daOpsumServiceRepository, this.daOpsumListServiceRepository, this.userServiceRepository, userPcode, opsumDimname, sumType, tenantCode, today).start();
            resultMap.put("dataLast", daOpsumListReDomainsResultLast);
            resultMap.put("dataToday", daOpsumListToday);
            return resultMap;
        }
        DaOpsumReDomain daOpsumReDomainToday = (DaOpsumReDomain)daOpsumReDomainSupQueryResult2.getList().get(0);
        String opsumCodeToday = daOpsumReDomainToday.getOpsumCode();
        HashMap<String, String> mapmap = new HashMap<String, String>();
        mapmap.put("opsumCode", opsumCodeToday);
        mapmap.put("tenantCode", tenantCode);
        mapmap.put("opsumDate", today);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultToday = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult todayResult = this.daOpsumListServiceRepository.queryOpsumListPage(mapmap);
        if (null != todayResult) {
            List listToday = todayResult.getList();
            for (DaOpsumListReDomain todayDomain : listToday) {
                todayDomain.setOpsumDate("\u4eca\u65e5");
                daOpsumListReDomainsResultToday.add(todayDomain);
            }
            SupQueryResult supQueryResult = new SupQueryResult();
            resultMap.put("dataLast", daOpsumListReDomainsResultLast);
            resultMap.put("dataToday", daOpsumListReDomainsResultToday);
            return resultMap;
        }
        return null;
    }

    private BigDecimal setZeroNum(String tenantCode, String today) {
        HashMap<String, Object> paramUser = new HashMap<String, Object>();
        paramUser.put("userinfoPhoneNot", "true");
        paramUser.put("tenantCode", tenantCode);
        paramUser.put("endDate", today);
        paramUser.put("startRow", 0);
        paramUser.put("rows", 1);
        SupQueryResult userinfoPage = this.userServiceRepository.queryUserinfoPage(paramUser);
        if (null != userinfoPage) {
            return new BigDecimal(userinfoPage.getPageTools().getRecordCount());
        }
        return new BigDecimal(0);
    }

    private Map<String, Object> queryOpsumListPageCommToday(String userPcode, String sumType, String tenantCode, Map<String, Object> resultMap) {
        SupQueryResult QueryResult;
        Date todayDate = new Date();
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.setTime(todayDate);
        String pattern = "yyyy-MM-dd";
        todayDate = calendarToday.getTime();
        SimpleDateFormat sdfToday = new SimpleDateFormat(pattern);
        String today = sdfToday.format(todayDate);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != param) {
            param.put("tenantCode", tenantCode);
            param.put("order", true);
            param.put("opsumDate", today);
            param.put("opsumType", sumType);
            param.put("opsumDimcode", userPcode);
        }
        if (null == (QueryResult = this.daOpsumServiceRepository.queryOpsumPage(param)) || QueryResult.getList().isEmpty()) {
            this.logger.error(CODE + "queryOpsumListPageCommToday.QueryResult.QueryResult", (Object)"result is null");
            return null;
        }
        DaOpsumReDomain daOpsumReDomainToday = (DaOpsumReDomain)QueryResult.getList().get(0);
        String opsumCodeToday = daOpsumReDomainToday.getOpsumCode();
        HashMap<String, String> paramToday = new HashMap<String, String>();
        paramToday.put("opsumCode", opsumCodeToday);
        paramToday.put("tenantCode", tenantCode);
        paramToday.put("opsumDate", today);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultToday = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult todayResult = this.daOpsumListServiceRepository.queryOpsumListPage(paramToday);
        if (null != todayResult) {
            List listToday = todayResult.getList();
            for (DaOpsumListReDomain todayDomain : listToday) {
                todayDomain.setOpsumDate("\u4eca\u65e5");
                daOpsumListReDomainsResultToday.add(todayDomain);
            }
            SupQueryResult supQueryResult = new SupQueryResult();
            resultMap.put("dataLast", "0");
            resultMap.put("dataToday", daOpsumListReDomainsResultToday);
            return resultMap;
        }
        return null;
    }

    @RequestMapping(value={"queryOpsumListNextPageForSeller.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u5546\u5bb6")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForSeller(HttpServletRequest request, String sumType) {
        String tenantCode;
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForSeller" + "param is null");
            return null;
        }
        String userPcode = this.getUserSession(request).getUserPcode();
        SupQueryResult<DaOpsumListReDomain> result = this.queryOpsumListNextPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request));
        if (null == result) {
            this.logger.error(CODE + "queryOpsumListNextPageForSeller" + "result is null");
            return null;
        }
        return result;
    }

    @RequestMapping(value={"queryOpsumListNextPageForBusiness.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u8fd0\u8425")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForBusiness(HttpServletRequest request, String sumType) {
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForBusiness" + "param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        String userPcode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        String opsumUpdateTime = this.getDdFalgSetting(this.getTenantCode(request), "opsumUpdateTime", "opsumUpdateTime", "");
        String userinfoQuality = userSession.getUserinfoQuality();
        String ocContractCountCache = SupDisUtil.get((String)("OcContract-" + userPcode + "-data"));
        String ocContractSendCountCache = SupDisUtil.get((String)("OcContractSend-" + userPcode + "-data"));
        String ocRefundCountCache = SupDisUtil.get((String)("OcRefund-" + userPcode + "-data"));
        if (StringUtils.isBlank((String)ocContractCountCache)) {
            HashMap<String, Object> ocContractParam = new HashMap<String, Object>();
            if (!"plat".equals(userinfoQuality)) {
                ocContractParam.put("memberCode", userPcode);
            }
            ocContractParam.put("tenantCode", this.getTenantCode(request));
            ocContractParam.put("dataState", 1);
            ocContractParam.put("page", 1);
            ocContractParam.put("rows", 0);
            this.makeDefPage(ocContractParam);
            SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryContractPage(ocContractParam);
            long ocContractCount = ocContractReDomainSupQueryResult.getTotal();
            SupDisUtil.set((String)("OcContract-" + userPcode + "-data"), (String)String.valueOf(ocContractCount), (int)(Integer.parseInt(opsumUpdateTime) * 1000));
            ocContractCountCache = String.valueOf(ocContractCount);
        }
        if (StringUtils.isBlank((String)ocContractSendCountCache)) {
            HashMap<String, Object> ocContractSendParam = new HashMap<String, Object>();
            if (!"plat".equals(userinfoQuality)) {
                ocContractSendParam.put("memberCode", userPcode);
            }
            ocContractSendParam.put("tenantCode", this.getTenantCode(request));
            ocContractSendParam.put("dataState", 2);
            ocContractSendParam.put("page", 1);
            ocContractSendParam.put("rows", 0);
            this.makeDefPage(ocContractSendParam);
            SupQueryResult ocContractReDomainSupQueryResult1 = this.ocContractServiceRepository.queryContractPage(ocContractSendParam);
            long ocContractSendCount = ocContractReDomainSupQueryResult1.getTotal();
            SupDisUtil.set((String)("OcContractSend-" + userPcode + "-data"), (String)String.valueOf(ocContractSendCount), (int)(Integer.parseInt(opsumUpdateTime) * 1000));
            ocContractSendCountCache = String.valueOf(ocContractSendCount);
        }
        if (StringUtils.isBlank((String)ocRefundCountCache)) {
            HashMap<String, Object> ocRefundParam = new HashMap<String, Object>();
            if (!"plat".equals(userinfoQuality)) {
                ocRefundParam.put("memberCode", userPcode);
            }
            ocRefundParam.put("tenantCode", tenantCode);
            ocRefundParam.put("dataState", 0);
            ocRefundParam.put("page", 1);
            ocRefundParam.put("rows", 0);
            this.makeDefPage(ocRefundParam);
            SupQueryResult ocRefundReDomainSupQueryResult = this.ocRefundServiceRepository.queryRefundPage(ocRefundParam);
            long ocRefundCount = ocRefundReDomainSupQueryResult.getTotal();
            SupDisUtil.set((String)("OcRefund-" + userPcode + "-data"), (String)String.valueOf(ocRefundCount), (int)(Integer.parseInt(opsumUpdateTime) * 1000));
            ocRefundCountCache = String.valueOf(ocRefundCount);
        }
        ArrayList<DaOpsumListReDomain> daOpsumListReDomains = new ArrayList<DaOpsumListReDomain>();
        DaOpsumListReDomain ocContract = new DaOpsumListReDomain();
        ocContract.setDataState(Integer.valueOf(0));
        ocContract.setOpsetName("OcContract");
        ocContract.setOpsetType("OcContract");
        ocContract.setOpsumDate("next");
        ocContract.setTenantCode(this.getTenantCode(request));
        ocContract.setOpsumListNum(new BigDecimal(ocContractCountCache));
        daOpsumListReDomains.add(ocContract);
        DaOpsumListReDomain ocContractSend = new DaOpsumListReDomain();
        ocContractSend.setDataState(Integer.valueOf(0));
        ocContractSend.setOpsetName("OcContractSend");
        ocContractSend.setOpsetType("OcContractSend");
        ocContractSend.setOpsumDate("next");
        ocContractSend.setTenantCode(this.getTenantCode(request));
        ocContractSend.setOpsumListNum(new BigDecimal(ocContractSendCountCache));
        daOpsumListReDomains.add(ocContractSend);
        DaOpsumListReDomain ocRefund = new DaOpsumListReDomain();
        ocRefund.setDataState(Integer.valueOf(0));
        ocRefund.setOpsetName("OcRefund");
        ocRefund.setOpsetType("OcRefund");
        ocRefund.setOpsumDate("next");
        ocRefund.setTenantCode(this.getTenantCode(request));
        ocRefund.setOpsumListNum(new BigDecimal(ocRefundCountCache));
        daOpsumListReDomains.add(ocRefund);
        SupQueryResult daOpsumListReDomainSupQueryResult = new SupQueryResult();
        daOpsumListReDomainSupQueryResult.setTotal(3L);
        SupPageTools supPageTools = new SupPageTools();
        supPageTools.setRecordCount(3);
        daOpsumListReDomainSupQueryResult.setPageTools(supPageTools);
        daOpsumListReDomainSupQueryResult.setList(daOpsumListReDomains);
        return daOpsumListReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryOpsumListNextPageForPlat.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u4e2d\u53f0")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForPlat(HttpServletRequest request, String sumType) {
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForBusiness" + "param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        String userPcode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        String opsumUpdateTime = this.getDdFalgSetting(this.getTenantCode(request), "opsumUpdateTime", "opsumUpdateTime", "");
        String userinfoQuality = userSession.getUserinfoQuality();
        String ocContractCountCache = SupDisUtil.get((String)("OcContract-" + userPcode + "-data"));
        String ocContractSendCountCache = SupDisUtil.get((String)("OcContractSend-" + userPcode + "-data"));
        String ocRefundCountCache = SupDisUtil.get((String)("OcRefund-" + userPcode + "-data"));
        this.logger.error(CODE + ".queryOpsumListNextPageForPlat  userinfoQuality=", (Object)userinfoQuality);
        if (StringUtils.isBlank((String)ocContractCountCache)) {
            HashMap<String, Object> ocContractParam = new HashMap<String, Object>();
            if ("supplier".equals(userinfoQuality)) {
                ocContractParam.put("memberCcode", userPcode);
            }
            ocContractParam.put("tenantCode", this.getTenantCode(request));
            ocContractParam.put("dataState", 1);
            ocContractParam.put("page", 1);
            ocContractParam.put("rows", 0);
            this.makeDefPage(ocContractParam);
            SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryContractPage(ocContractParam);
            long ocContractCount = ocContractReDomainSupQueryResult.getTotal();
            SupDisUtil.set((String)("OcContract-" + userPcode + "-data"), (String)String.valueOf(ocContractCount), (int)Integer.parseInt(opsumUpdateTime));
            ocContractCountCache = String.valueOf(ocContractCount);
        }
        if (StringUtils.isBlank((String)ocContractSendCountCache)) {
            HashMap<String, Object> ocContractSendParam = new HashMap<String, Object>();
            if ("supplier".equals(userinfoQuality)) {
                ocContractSendParam.put("memberCcode", userPcode);
            }
            ocContractSendParam.put("tenantCode", this.getTenantCode(request));
            ocContractSendParam.put("dataState", 2);
            ocContractSendParam.put("page", 1);
            ocContractSendParam.put("rows", 0);
            this.makeDefPage(ocContractSendParam);
            SupQueryResult ocContractReDomainSupQueryResult1 = this.ocContractServiceRepository.queryContractPage(ocContractSendParam);
            long ocContractSendCount = ocContractReDomainSupQueryResult1.getTotal();
            SupDisUtil.set((String)("OcContractSend-" + userPcode + "-data"), (String)String.valueOf(ocContractSendCount), (int)Integer.parseInt(opsumUpdateTime));
            ocContractSendCountCache = String.valueOf(ocContractSendCount);
        }
        if (StringUtils.isBlank((String)ocRefundCountCache)) {
            HashMap<String, Object> ocRefundParam = new HashMap<String, Object>();
            if ("supplier".equals(userinfoQuality)) {
                ocRefundParam.put("memberCcode", userPcode);
            }
            ocRefundParam.put("tenantCode", tenantCode);
            ocRefundParam.put("dataState", 0);
            ocRefundParam.put("page", 1);
            ocRefundParam.put("rows", 0);
            this.makeDefPage(ocRefundParam);
            SupQueryResult ocRefundReDomainSupQueryResult = this.ocRefundServiceRepository.queryRefundPage(ocRefundParam);
            long ocRefundCount = ocRefundReDomainSupQueryResult.getTotal();
            SupDisUtil.set((String)("OcRefund-" + userPcode + "-data"), (String)String.valueOf(ocRefundCount), (int)Integer.parseInt(opsumUpdateTime));
            ocRefundCountCache = String.valueOf(ocRefundCount);
        }
        ArrayList<DaOpsumListReDomain> daOpsumListReDomains = new ArrayList<DaOpsumListReDomain>();
        DaOpsumListReDomain ocContract = new DaOpsumListReDomain();
        ocContract.setDataState(Integer.valueOf(0));
        ocContract.setOpsetName("OcContract");
        ocContract.setOpsetType("OcContract");
        ocContract.setOpsumDate("next");
        ocContract.setTenantCode(this.getTenantCode(request));
        ocContract.setOpsumListNum(new BigDecimal(ocContractCountCache));
        daOpsumListReDomains.add(ocContract);
        DaOpsumListReDomain ocContractSend = new DaOpsumListReDomain();
        ocContractSend.setDataState(Integer.valueOf(0));
        ocContractSend.setOpsetName("OcContractSend");
        ocContractSend.setOpsetType("OcContractSend");
        ocContractSend.setOpsumDate("next");
        ocContractSend.setTenantCode(this.getTenantCode(request));
        ocContractSend.setOpsumListNum(new BigDecimal(ocContractSendCountCache));
        daOpsumListReDomains.add(ocContractSend);
        DaOpsumListReDomain ocRefund = new DaOpsumListReDomain();
        ocRefund.setDataState(Integer.valueOf(0));
        ocRefund.setOpsetName("OcRefund");
        ocRefund.setOpsetType("OcRefund");
        ocRefund.setOpsumDate("next");
        ocRefund.setTenantCode(this.getTenantCode(request));
        ocRefund.setOpsumListNum(new BigDecimal(ocRefundCountCache));
        daOpsumListReDomains.add(ocRefund);
        SupQueryResult daOpsumListReDomainSupQueryResult = new SupQueryResult();
        daOpsumListReDomainSupQueryResult.setTotal(3L);
        SupPageTools supPageTools = new SupPageTools();
        supPageTools.setRecordCount(3);
        daOpsumListReDomainSupQueryResult.setPageTools(supPageTools);
        daOpsumListReDomainSupQueryResult.setList(daOpsumListReDomains);
        return daOpsumListReDomainSupQueryResult;
    }

    private SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageComm(String opsumDimcode, String sumType, String tenantCode) {
        SupQueryResult daOpsumReDomainSupQueryResult;
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != param) {
            param.put("order", true);
            param.put("tenantCode", tenantCode);
            param.put("opsumType", sumType);
            param.put("opsumDimcode", opsumDimcode);
        }
        if (null == (daOpsumReDomainSupQueryResult = this.daOpsumServiceRepository.queryOpsumPage(param)) || daOpsumReDomainSupQueryResult.getList().isEmpty()) {
            this.logger.error(CODE + ".queryOpsumListNextPageForPlat.daOpsumReDomainSupQueryResult", (Object)"result is null");
            return null;
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)daOpsumReDomainSupQueryResult.getList().get(0);
        String opsumCode = daOpsumReDomain.getOpsumCode();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("opsumCode", opsumCode);
        map.put("tenantCode", tenantCode);
        SupQueryResult daOpsumListReDomainSupQueryResult = this.daOpsumListServiceRepository.queryOpsumListPage(map);
        if (null != daOpsumListReDomainSupQueryResult) {
            return daOpsumListReDomainSupQueryResult;
        }
        return null;
    }

    @RequestMapping(value={"queryOpsumlistPageNewForBus.json"}, name="\u67e5\u8be2\u8fd0\u8425\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPageNewForBus(HttpServletRequest request) {
        HashMap<String, Boolean> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Boolean>();
        }
        param.put("order", true);
        String tenantCode = this.getTenantCode(request);
        String userPcode = this.getUserSession(request).getUserinfoParentCode();
        if (StringUtils.isBlank((String)userPcode)) {
            userPcode = this.getUserSession(request).getUserPcode();
        }
        param.put("opsumDimcode", (Boolean)((Object)userPcode));
        if (null == param.get("orderStr") || StringUtils.isBlank((String)param.get("orderStr").toString())) {
            param.put("orderStr", (Boolean)((Object)"opsum_Date"));
        }
        if (null == param.get("opsumDimcode1") || StringUtils.isBlank((String)param.get("opsumDimcode1").toString())) {
            param.put("opsumDimcode1", (Boolean)((Object)"all"));
        }
        if (null == param.get("opsumDimcode2") || StringUtils.isBlank((String)param.get("opsumDimcode2").toString())) {
            param.put("opsumDimcode2", (Boolean)((Object)"all"));
        }
        if (null == param.get("opsumDate") || StringUtils.isBlank((String)param.get("opsumDate").toString())) {
            param.put("opsumDate", (Boolean)((Object)DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd")));
        }
        param.put("tenantCode", (Boolean)((Object)tenantCode));
        return this.daOpsumListServiceRepository.queryOpsumListPage(param);
    }

    @RequestMapping(value={"queryOpsumlistPageNewForPlat.json"}, name="\u67e5\u8be2\u5e73\u53f0\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPageNewForPlat(HttpServletRequest request) {
        HashMap<String, Boolean> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Boolean>();
        }
        param.put("order", true);
        String tenantCode = this.getTenantCode(request);
        param.put("opsumDimcode", (Boolean)((Object)tenantCode));
        if (null == param.get("orderStr") || StringUtils.isBlank((String)param.get("orderStr").toString())) {
            param.put("orderStr", (Boolean)((Object)"opsum_Date"));
        }
        if (null == param.get("opsumDimcode1") || StringUtils.isBlank((String)param.get("opsumDimcode1").toString())) {
            param.put("opsumDimcode1", (Boolean)((Object)"all"));
        }
        if (null == param.get("opsumDimcode2") || StringUtils.isBlank((String)param.get("opsumDimcode2").toString())) {
            param.put("opsumDimcode2", (Boolean)((Object)"all"));
        }
        if (null != param.get("startDate") && null != param.get("endDate")) {
            Date startDate = DateUtil.getDateToString((String)String.valueOf(param.get("startDate")), (String)"yyyy-MM-dd");
            Date endDate = DateUtil.getDateToString((String)String.valueOf(param.get("endDate")), (String)"yyyy-MM-dd");
            List<Date> dates = OpsumlistCon.findDates(startDate, endDate);
            String opsumDate = "";
            if (ListUtil.isNotEmpty(dates)) {
                for (Date date : dates) {
                    opsumDate = opsumDate + DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + ",";
                }
                opsumDate = opsumDate.substring(0, opsumDate.length() - 1);
            }
            param.put("opsumDate", (Boolean)((Object)opsumDate));
        } else {
            param.put("opsumDate", (Boolean)((Object)DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd")));
        }
        param.put("tenantCode", (Boolean)((Object)tenantCode));
        return this.daOpsumListServiceRepository.queryOpsumListPage(param);
    }

    public static List<Date> findDates(Date dBegin, Date dEnd) {
        ArrayList<Date> lDate = new ArrayList<Date>();
        lDate.add(dBegin);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            lDate.add(calBegin.getTime());
        }
        return lDate;
    }

    public static void main(String[] args) {
        OpsumlistCon.findDates(new Date(), new Date());
    }

    @RequestMapping(value={"queryOpsumlistPageNewForUser.json"}, name="\u67e5\u8be2\u7528\u6237\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPageNewForUser(HttpServletRequest request) {
        HashMap<String, Boolean> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Boolean>();
        }
        param.put("order", true);
        String userPcode = this.getUserSession(request).getUserPcode();
        String tenantCode = this.getTenantCode(request);
        param.put("opsumDimcode", (Boolean)((Object)userPcode));
        if (null == param.get("orderStr") || StringUtils.isBlank((String)param.get("orderStr").toString())) {
            param.put("orderStr", (Boolean)((Object)"opsum_Date"));
        }
        if (null == param.get("opsumDimcode1") || StringUtils.isBlank((String)param.get("opsumDimcode1").toString())) {
            param.put("opsumDimcode1", (Boolean)((Object)"all"));
        }
        if (null == param.get("opsumDimcode2") || StringUtils.isBlank((String)param.get("opsumDimcode2").toString())) {
            param.put("opsumDimcode2", (Boolean)((Object)"all"));
        }
        if (null != param.get("startDate") && null != param.get("endDate")) {
            Date startDate = DateUtil.getDateToString((String)String.valueOf(param.get("startDate")), (String)"yyyy-MM-dd");
            Date endDate = DateUtil.getDateToString((String)String.valueOf(param.get("endDate")), (String)"yyyy-MM-dd");
            List<Date> dates = OpsumlistCon.findDates(startDate, endDate);
            String opsumDate = "";
            if (ListUtil.isNotEmpty(dates)) {
                for (Date date : dates) {
                    opsumDate = opsumDate + DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + ",";
                }
                opsumDate = opsumDate.substring(0, opsumDate.length() - 1);
            }
            param.put("opsumDate", (Boolean)((Object)opsumDate));
        } else {
            param.put("opsumDate", (Boolean)((Object)DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd")));
        }
        param.put("tenantCode", (Boolean)((Object)tenantCode));
        return this.daOpsumListServiceRepository.queryOpsumListPage(param);
    }

    @RequestMapping(value={"queryOpsumlistPageForAtPoPrice.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u6b63\u5411\u6ea2\u4ef7\u6570\u636e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumListBigDataReDomain> queryOpsumlistPageForAtPoPrice(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("opsetType", "PoAtGinfoPrice");
            param.put("groupByDate", true);
            param.put("opsumListNumSum", true);
        }
        return this.daOpsumListServiceRepository.querySimpleOpsumListPage(param);
    }

    @RequestMapping(value={"queryOpsumlistPageForAtRePrice.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u53cd\u5411\u6ea2\u4ef7\u6570\u636e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumListBigDataReDomain> queryOpsumlistPageForAtRePrice(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("opsetType", "ReAtGinfoPrice");
            param.put("groupByDate", true);
            param.put("opsumListNumSum", true);
        }
        return this.daOpsumListServiceRepository.querySimpleOpsumListPage(param);
    }

    public String getRedisValue(String key) {
        String redisValue = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        return redisValue;
    }

    public String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = this.getRedisValue(field);
        return value;
    }
}

