/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.data.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.da.domain.DaStatisticsDomain;
import com.qjsoft.laser.controller.facade.da.domain.DaStatisticsReDomain;
import com.qjsoft.laser.controller.facade.da.repository.DaStatisticsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/da/statistics"}, name="\u53d1\u8d27\u5355\u7edf\u8ba1")
public class StatisticsCon
extends SpringmvcController {
    private static String CODE = "da.statistics.con";
    @Autowired
    private DaStatisticsServiceRepository daStatisticsServiceRepository;

    protected String getContext() {
        return "statistics";
    }

    @RequestMapping(value={"saveStatistics.json"}, name="\u589e\u52a0\u53d1\u8d27\u5355\u7edf\u8ba1")
    @ResponseBody
    public HtmlJsonReBean saveStatistics(HttpServletRequest request, DaStatisticsDomain DaStatisticsDomain2) {
        if (null == DaStatisticsDomain2) {
            this.logger.error(CODE + ".saveStatistics", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        DaStatisticsDomain2.setTenantCode(this.getTenantCode(request));
        return this.daStatisticsServiceRepository.saveStatistics(DaStatisticsDomain2);
    }

    @RequestMapping(value={"getStatistics.json"}, name="\u83b7\u53d6\u53d1\u8d27\u5355\u7edf\u8ba1\u4fe1\u606f")
    @ResponseBody
    public DaStatisticsReDomain getStatistics(Integer statisticsId) {
        if (StringUtils.isBlank((Integer)statisticsId)) {
            this.logger.error(CODE + ".getStatistics", (Object)"param is null");
            return null;
        }
        return this.daStatisticsServiceRepository.getStatistics(statisticsId);
    }

    @RequestMapping(value={"updateStatistics.json"}, name="\u66f4\u65b0\u53d1\u8d27\u5355\u7edf\u8ba1")
    @ResponseBody
    public HtmlJsonReBean updateStatistics(HttpServletRequest request, DaStatisticsDomain DaStatisticsDomain2) {
        if (null == DaStatisticsDomain2) {
            this.logger.error(CODE + ".updateStatistics", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        DaStatisticsDomain2.setTenantCode(this.getTenantCode(request));
        return this.daStatisticsServiceRepository.updateStatistics(DaStatisticsDomain2);
    }

    @RequestMapping(value={"deleteStatistics.json"}, name="\u5220\u9664\u53d1\u8d27\u5355\u7edf\u8ba1")
    @ResponseBody
    public HtmlJsonReBean deleteStatistics(Integer statisticsId) {
        if (StringUtils.isBlank((Integer)statisticsId)) {
            this.logger.error(CODE + ".deleteStatistics", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daStatisticsServiceRepository.deleteStatistics(statisticsId);
    }

    @RequestMapping(value={"queryStatisticsPage.json"}, name="\u67e5\u8be2\u53d1\u8d27\u5355\u7edf\u8ba1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaStatisticsReDomain> queryStatisticsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.daStatisticsServiceRepository.queryStatisticsPage(param);
    }

    @RequestMapping(value={"updateStatisticsState.json"}, name="\u66f4\u65b0\u53d1\u8d27\u5355\u7edf\u8ba1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateStatisticsState(String statisticsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)statisticsId)) {
            this.logger.error(CODE + ".updateStatisticsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daStatisticsServiceRepository.updateStatisticsState(Integer.valueOf(statisticsId), dataState, oldDataState, null);
    }
}

