/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.oc.repository;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcCflowReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSettlDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcPackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.SkuDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.enumc.ContractType;
import com.qjsoft.laser.controller.facade.pm.domain.DiscountDataDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmUserOrderReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.facade.wl.repository.WlFreightTemServiceRepository;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class OcServiceRepository
extends SupperFacade {
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private WlFreightTemServiceRepository wlFreightTemServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    private static String CODE = "oc.OcServiceRepository";
    String CACHE_KEY_CFLOW = "ocProtCflow";

    public TypeBean getOcSetting(String shoppingType, String tenantCode) {
        String memo;
        OcCflowReDomain ocCflowReDomain;
        TypeBean typeBean = null;
        String json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + "00000000"));
        }
        if (StringUtils.isNotBlank((String)json) && null != (ocCflowReDomain = (OcCflowReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcCflowReDomain.class)) && StringUtils.isNotBlank((String)(memo = ocCflowReDomain.getMemo()))) {
            typeBean = (TypeBean)JsonUtil.buildNormalBinder().getJsonToObject(memo, TypeBean.class);
        }
        return typeBean;
    }

    public boolean checkPm(TypeBean typeBean) {
        if (null == typeBean) {
            return true;
        }
        return "0".equals(typeBean.getPmpay());
    }

    public boolean checkIntpay(TypeBean typeBean) {
        if (null == typeBean) {
            return true;
        }
        return "0".equals(typeBean.getIntpay());
    }

    public HtmlJsonReBean createOcOrder(List<OrderDomain> orderDomainList, String contractType, UserSession userSession, String proappCode) {
        if (ListUtil.isEmpty(orderDomainList) || null == userSession) {
            this.logger.error(CODE + ".createOcOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<OcContractDomain> ocContractDomainList = new ArrayList<OcContractDomain>();
        ArrayList<Integer> shoppingGoodsIdList = new ArrayList<Integer>();
        for (OrderDomain orderDomain : orderDomainList) {
            OcContractDomain contractDomain;
            try {
                contractDomain = this.makeContractDomain(orderDomain, contractType, userSession, proappCode);
                if (null == contractDomain) {
                    this.logger.error(CODE + ".createOcOrder.contractDomain");
                    return new HtmlJsonReBean((Object)(CODE + ".saveContract.contractDomain"));
                }
                contractDomain.setPackageList(this.makePackageDomainList(orderDomain.getPackageList(), contractDomain, shoppingGoodsIdList, orderDomain.getGiftSkuIdList()));
            }
            catch (Exception e) {
                this.logger.error(CODE + ".createOcOrder.ex", (Throwable)e);
                return new HtmlJsonReBean(CODE + ".saveContract.ex", e.getMessage());
            }
            HtmlJsonReBean htmlJsonReBean = this.calculateContract(contractDomain);
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                return htmlJsonReBean;
            }
            ocContractDomainList.add(contractDomain);
        }
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        HashMap<String, String> result = new HashMap<String, String>();
        if (ocContractDomainList.size() > 1) {
            htmlJsonReBean = this.sendBatchContractByDel(ocContractDomainList, shoppingGoodsIdList);
            result.put("contractBbillcode", htmlJsonReBean.getDataObj().toString());
        } else {
            htmlJsonReBean = this.sendContractByDel((OcContractDomain)ocContractDomainList.get(0), shoppingGoodsIdList);
            result.put("contractBillcode", htmlJsonReBean.getDataObj().toString());
        }
        htmlJsonReBean.setDataObj(result);
        return htmlJsonReBean;
    }

    public HtmlJsonReBean sendBatchContractByDel(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList) {
        PostParamMap pmap = new PostParamMap("oc.shopping.sendBatchContractByDel");
        pmap.putParamToJson("ocContractDomainList", ocContractDomainList);
        pmap.putParamToJson("shoppingGoodsIdList", shoppingGoodsIdList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public List<OcPackageDomain> makePackageDomainList(List<PackageDomain> packageList, OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList, List<SkuDomain> giftSkuIdList) throws Exception {
        if (ListUtil.isEmpty(packageList)) {
            throw new Exception("\u5305\u88f9\u4fe1\u606f\u4e3a\u7a7a");
        }
        ArrayList<OcPackageDomain> packageDomainList = new ArrayList<OcPackageDomain>();
        for (PackageDomain packageDomain : packageList) {
            OcPackageDomain ocPackageDomain = this.makePackageDomain(packageDomain, ocContractDomain, giftSkuIdList);
            packageDomainList.add(ocPackageDomain);
            if (null == shoppingGoodsIdList || null == packageDomain.getShoppingGoodsIdList()) continue;
            shoppingGoodsIdList.addAll(packageDomain.getShoppingGoodsIdList());
        }
        return packageDomainList;
    }

    private OcPackageDomain makePackageDomain(PackageDomain packageDomain, OcContractDomain ocContractDomain, List<SkuDomain> giftSkuIdList) throws Exception {
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)packageDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".makePackageDomain.ex", (Throwable)e);
            return null;
        }
        BigDecimal goodsPmoney = BigDecimal.ZERO;
        String goodsPmbillno = "";
        String pmInfo = SupDisUtil.get((String)("pm-userorder" + ocContractDomain.getMemberBcode()));
        List pmUserOrderReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(pmInfo, PmUserOrderReDomain.class);
        ArrayList<DiscountDataDomain> discountDataDomains = new ArrayList<DiscountDataDomain>();
        if (null != pmUserOrderReDomainList && pmUserOrderReDomainList.size() > 0) {
            for (PmUserOrderReDomain pmUserOrderReDomain : pmUserOrderReDomainList) {
                List discountDataDomainList;
                goodsPmoney = goodsPmoney.add(pmUserOrderReDomain.getDiscountAmount());
                goodsPmbillno = goodsPmbillno + ";" + pmUserOrderReDomain.getPromotionCode();
                String discountData = pmUserOrderReDomain.getDiscountData();
                if (!StringUtils.isNotBlank((String)discountData) || null == (discountDataDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(discountData, DiscountDataDomain.class))) continue;
                discountDataDomains.addAll(discountDataDomainList);
            }
        }
        if (ListUtil.isEmpty(ocPackageDomain.getContractGoodsList())) {
            List<OcContractGoodsDomain> goodsList = this.makeContractGoodsDomainList(packageDomain.getShoppingGoodsIdList(), packageDomain.getSkuIdList(), ocContractDomain, discountDataDomains, giftSkuIdList);
            ocPackageDomain.setContractGoodsList(goodsList);
        }
        this.makePack(ocContractDomain, ocPackageDomain, goodsPmoney, goodsPmbillno);
        return ocPackageDomain;
    }

    public OcShoppingGoodsReDomain getShoppingGoods(Integer shoppingGoodsId) {
        PostParamMap pmap = new PostParamMap("oc.shopping.getShoppingGoods");
        pmap.putParam("shoppingGoodsId", (Object)shoppingGoodsId);
        return (OcShoppingGoodsReDomain)this.htmlIBaseService.senReObject(pmap, OcShoppingGoodsReDomain.class);
    }

    public List<OcContractGoodsDomain> makeContractGoodsDomainList(List<Integer> shoppingGoodsIdList, List<SkuDomain> skuIdList, OcContractDomain ocContractDomain, List<DiscountDataDomain> discountDataDomains, List<SkuDomain> giftSkuIdList) throws Exception {
        RsResourceGoodsReDomain rsResourceGoodsReDomain;
        HashMap<String, String> map;
        RsSkuReDomain rsSkuReDomain;
        OcContractGoodsDomain contractGoodsDomain;
        if (ListUtil.isEmpty(shoppingGoodsIdList) && ListUtil.isEmpty(skuIdList)) {
            this.logger.info(CODE + ".makeContractGoodsDomainList.shoppingGoodsIdList.empty", (Object)"\u8d2d\u7269\u8f66\u53c2\u6570\u4e3a\u7a7a");
            throw new Exception("\u8d2d\u7269\u8f66\u6570\u636e\u4e3a\u7a7a");
        }
        boolean shop = true;
        shop = !ListUtil.isEmpty(shoppingGoodsIdList);
        ArrayList<OcContractGoodsDomain> contractGoodsDomainList = new ArrayList<OcContractGoodsDomain>();
        HashMap<String, BigDecimal> skuCodeDiscountMap = new HashMap<String, BigDecimal>();
        if (null != discountDataDomains && discountDataDomains.size() > 0) {
            for (DiscountDataDomain discountDataDomain : discountDataDomains) {
                skuCodeDiscountMap.put(discountDataDomain.getSkuCode(), discountDataDomain.getDiscountAmount());
            }
        }
        if (shop) {
            for (Integer id : shoppingGoodsIdList) {
                contractGoodsDomain = new OcContractGoodsDomain();
                OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.getShoppingGoods(id);
                if (ocShoppingGoodsReDomain == null) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.shoppingGoodsId", (Object)("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  " + id));
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (!ocShoppingGoodsReDomain.getMemberBcode().equals(ocContractDomain.getMemberBcode())) {
                    this.logger.error(CODE, (Object)String.format("\u8d2d\u7269\u8f66\u8d2d\u4e70\u4eba\u4e0e\u767b\u5f55\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0cshoppingGoodsId=%s,\u6240\u6709\u8005\u8d26\u53f7=%s,\u767b\u5f55\u8d26\u53f7=%s", id, ocShoppingGoodsReDomain.getMemberBcode(), ocContractDomain.getMemberBcode()));
                    throw new Exception("\u8d2d\u7269\u8f66\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(ocShoppingGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(ocShoppingGoodsReDomain.getMemberName());
                }
                if (null == ocShoppingGoodsReDomain.getGoodsSupplynum() || ocShoppingGoodsReDomain.getGoodsSupplynum().subtract(ocShoppingGoodsReDomain.getGoodsCamount()).intValue() < 0) {
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)ocShoppingGoodsReDomain);
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsCamount(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsCweight(ocShoppingGoodsReDomain.getGoodsCweight());
                contractGoodsDomain.setGoodsNum(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsCamount(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsWeight(ocShoppingGoodsReDomain.getGoodsCweight());
                if (null == ocShoppingGoodsReDomain.getPricesetRefrice()) {
                    ocShoppingGoodsReDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                contractGoodsDomain.setContractGoodsPefprice(ocShoppingGoodsReDomain.getPricesetRefrice());
                this.makeGoods(contractGoodsDomain, skuCodeDiscountMap);
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        } else {
            for (SkuDomain skuDomain : skuIdList) {
                contractGoodsDomain = new OcContractGoodsDomain();
                rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuDomain.getSkuId());
                if (rsSkuReDomain == null) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5e93\u5b58\u4e0d\u8db3");
                }
                map = new HashMap<String, String>();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsSkuReDomain);
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                contractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                contractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                if (null == rsSkuReDomain.getPricesetRefrice()) {
                    rsSkuReDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                contractGoodsDomain.setContractGoodsPefprice(rsSkuReDomain.getPricesetRefrice());
                this.makeGoods(contractGoodsDomain, skuCodeDiscountMap);
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        }
        if (null != giftSkuIdList && giftSkuIdList.size() > 0) {
            for (SkuDomain skuDomain : giftSkuIdList) {
                contractGoodsDomain = new OcContractGoodsDomain();
                rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuDomain.getSkuId());
                if (rsSkuReDomain == null) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    throw new Exception("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5e93\u5b58\u4e0d\u8db3");
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsSkuReDomain);
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                contractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                contractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                contractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPefmoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPefprice(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsAppraise(0);
                contractGoodsDomain.setRefundFlag(0);
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        }
        if (ListUtil.isEmpty(contractGoodsDomainList)) {
            this.logger.info(CODE + ".makeContractGoodsDomainList.contractGoodsDomainList.empty", (Object)"\u8d2d\u7269\u8f66\u4e3a\u7a7a");
            throw new Exception("\u8d2d\u7269\u8f66\u4e3a\u7a7a");
        }
        return contractGoodsDomainList;
    }

    public HtmlJsonReBean sendContractByDel(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        PostParamMap pmap = new PostParamMap("oc.shopping.sendContractByDel");
        pmap.putParamToJson("ocContractDomain", (Object)ocContractDomain);
        pmap.putParamToJson("shoppingGoodsIdList", shoppingGoodsIdList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean calculateContract(OcContractDomain contractDomain) {
        HtmlJsonReBean htmlJsonReBean;
        Map<String, OcContractSettlDomain> smap;
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal goodsPmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        String goodsPmbillno = "";
        for (OcPackageDomain ocPackageDomain : contractDomain.getPackageList()) {
            if (null == ocPackageDomain.getGoodsNum()) {
                ocPackageDomain.setGoodsNum(BigDecimal.ZERO);
            }
            goodsNum = goodsNum.add(ocPackageDomain.getGoodsNum());
            if (null == ocPackageDomain.getGoodsWeight()) {
                ocPackageDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            goodsWeight = goodsWeight.add(ocPackageDomain.getGoodsWeight());
            if (null == ocPackageDomain.getGoodsMoney()) {
                ocPackageDomain.setGoodsMoney(BigDecimal.ZERO);
            }
            contractInmoney = contractInmoney.add(ocPackageDomain.getGoodsMoney());
            goodsLogmoney = goodsLogmoney.add(new BigDecimal(ocPackageDomain.getPackageFare()));
            if (null == ocPackageDomain.getGoodsPmoney()) {
                ocPackageDomain.setGoodsPmoney(BigDecimal.ZERO);
            }
            goodsPmoney = goodsPmoney.add(ocPackageDomain.getGoodsPmoney());
            if (null == ocPackageDomain.getPricesetRefrice()) {
                ocPackageDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            pefMoney = pefMoney.add(ocPackageDomain.getPricesetRefrice());
            if (!StringUtils.isNotBlank((String)ocPackageDomain.getGoodsPmbillno())) continue;
            goodsPmbillno = goodsPmbillno + ";" + ocPackageDomain.getGoodsPmbillno();
        }
        if (StringUtils.isNotBlank((String)goodsPmbillno)) {
            goodsPmbillno = goodsPmbillno.substring(1);
        }
        dataBnum = goodsNum;
        dataBweight = goodsWeight;
        contractMoney = contractInmoney.subtract(goodsPmoney);
        List<OcContractSettlDomain> ocContractSettlDomainList = contractDomain.getOcContractSettlList();
        if (null == ocContractSettlDomainList) {
            ocContractSettlDomainList = new ArrayList<OcContractSettlDomain>();
        }
        if (null == (smap = this.getListToMap(ocContractSettlDomainList))) {
            smap = new HashMap<String, OcContractSettlDomain>();
        }
        String msg = "";
        if (null != goodsPmoney && goodsPmoney.compareTo(BigDecimal.ZERO) != 0) {
            OcContractSettlDomain pm = smap.get("PM");
            if (null != pm) {
                if (goodsPmoney.compareTo(pm.getContractSettlPmoney()) != 0) {
                    msg = msg + "\u4f18\u60e0\u91d1\u989d\u4e0d\u4e00\u81f4[" + goodsPmoney + "][" + pm.getContractSettlPmoney() + "];";
                }
            } else {
                OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
                ocContractSettlDomain.setContractSettlOpno(goodsPmbillno);
                ocContractSettlDomain.setContractSettlBlance("PM");
                ocContractSettlDomain.setContractSettlType("3");
                ocContractSettlDomain.setContractSettlGmoney(goodsPmoney);
                ocContractSettlDomain.setContractSettlPmoney(goodsPmoney);
                ocContractSettlDomain.setContractPmode("0");
                ocContractSettlDomainList.add(ocContractSettlDomain);
            }
        }
        if (null != (htmlJsonReBean = this.upmUpointsServiceRepository.deductible(contractMoney, contractDomain.getTenantCode(), contractDomain.getMemberBcode(), "0")) && null != htmlJsonReBean.getDataObj()) {
            Map upmMap = (Map)htmlJsonReBean.getDataObj();
            BigDecimal disamount = (BigDecimal)upmMap.get("disamount");
            Integer integral = (Integer)upmMap.get("integral");
            OcContractSettlDomain intmoney = smap.get("INT");
            if (null != intmoney) {
                if (disamount.compareTo(intmoney.getContractSettlPmoney()) != 0) {
                    msg = msg + "\u79ef\u5206\u4e0d\u4e00\u81f4[" + disamount + "][" + intmoney.getContractSettlPmoney() + "];";
                }
            } else {
                contractMoney = contractMoney.subtract(disamount);
                OcContractSettlDomain ocContractSettlDomain1 = new OcContractSettlDomain();
                ocContractSettlDomain1.setContractSettlOpno("");
                ocContractSettlDomain1.setContractSettlBlance("INT");
                ocContractSettlDomain1.setContractSettlType("3");
                ocContractSettlDomain1.setContractSettlGmoney(BigDecimal.valueOf(integral.intValue()));
                ocContractSettlDomain1.setContractSettlPmoney(disamount);
                ocContractSettlDomain1.setContractPmode("0");
                ocContractSettlDomainList.add(ocContractSettlDomain1);
            }
        }
        contractDomain.setOcContractSettlList(ocContractSettlDomainList);
        contractDomain.setPricesetRefrice(pefMoney);
        contractDomain.setGoodsNum(goodsNum);
        contractDomain.setGoodsWeight(goodsWeight);
        contractDomain.setContractInmoney(contractInmoney);
        contractDomain.setContractMoney(contractMoney);
        contractDomain.setDataBnum(dataBnum);
        contractDomain.setDataBweight(dataBweight);
        contractDomain.setDataBmoney(contractMoney.add(pefMoney));
        contractDomain.setGoodsLogmoney(goodsLogmoney);
        contractDomain.setGoodsPmoney(goodsPmoney);
        contractDomain.setGoodsPmbillno(goodsPmbillno);
        if (StringUtils.isBlank((String)msg)) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean("error", msg);
    }

    private Map<String, OcContractSettlDomain> getListToMap(List<OcContractSettlDomain> ocContractSettlDomainList) {
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            return null;
        }
        HashMap<String, OcContractSettlDomain> map = new HashMap<String, OcContractSettlDomain>();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            map.put(ocContractSettlDomain.getContractSettlBlance(), ocContractSettlDomain);
        }
        return map;
    }

    public void makePack(OcContractDomain ocContractDomain, OcPackageDomain ocPackageDomain, BigDecimal goodsPmoney, String goodsPmbillno) throws Exception {
        if (null == ocPackageDomain || null == ocContractDomain) {
            return;
        }
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal goodsPef = BigDecimal.ZERO;
        BigDecimal packageGoodsWeight = BigDecimal.ZERO;
        BigDecimal packageGoodsNum = BigDecimal.ZERO;
        for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
            if (null == ocContractGoodsDomain.getGoodsNum()) {
                ocContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            packageGoodsNum = packageGoodsNum.add(ocContractGoodsDomain.getGoodsNum());
            if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
                ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            goodsMoney = goodsMoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
            if (null == ocContractGoodsDomain.getContractGoodsPefinmoney()) {
                ocContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
            }
            goodsPef = goodsPef.add(ocContractGoodsDomain.getContractGoodsPefinmoney());
            if (null == ocContractGoodsDomain.getGoodsWeight()) {
                ocContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            packageGoodsWeight = packageGoodsWeight.add(ocContractGoodsDomain.getGoodsWeight());
        }
        ocPackageDomain.setGoodsWeight(packageGoodsWeight);
        ocPackageDomain.setGoodsNum(packageGoodsNum);
        ocPackageDomain.setWarehouseName(ocContractDomain.getWarehouseName());
        ocPackageDomain.setMemberBcode(ocContractDomain.getMemberBcode());
        ocPackageDomain.setMemberBname(ocContractDomain.getMemberBname());
        BigDecimal freightFare = this.getFreightFare(ocPackageDomain.getContractGoodsList(), ocContractDomain.getAreaCode());
        ocPackageDomain.setPackageFare(freightFare.toString());
        ocPackageDomain.setGoodsMoney(goodsMoney.add(freightFare));
        ocPackageDomain.setPricesetRefrice(goodsPef);
        ocPackageDomain.setGoodsPmoney(goodsPmoney);
        if (StringUtils.isNotBlank((String)goodsPmbillno)) {
            goodsPmbillno = goodsPmbillno.substring(1);
        }
        ocPackageDomain.setGoodsPmbillno(goodsPmbillno);
    }

    public BigDecimal getFreightFare(List<OcContractGoodsDomain> ocContractGoodsDomainList, String areaCode) throws Exception {
        String freightExpCode;
        if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
            throw new Exception("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
        }
        HashMap<String, String> skuParamMap = new HashMap<String, String>();
        HashMap<String, String> expParamMap = new HashMap<String, String>();
        HashMap<String, BigDecimal> quantityMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> weightMap = new HashMap<String, BigDecimal>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            RsSkuReDomain rsSkuReDomain;
            skuParamMap.clear();
            skuParamMap.put("skuCode", ocContractGoodsDomain.getSkuCode());
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getTenantCode())) {
                skuParamMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            }
            if ((rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(skuParamMap)) == null) {
                throw new Exception("\u5546\u54c1sku\u4fe1\u606f\u6709\u8bef" + ((Object)skuParamMap).toString());
            }
            freightExpCode = rsSkuReDomain.getFreightTemCode();
            if (StringUtils.isBlank((String)freightExpCode)) continue;
            BigDecimal cquantity = (BigDecimal)quantityMap.get(freightExpCode);
            if (cquantity == null) {
                cquantity = BigDecimal.ZERO;
            }
            cquantity = cquantity.add(ocContractGoodsDomain.getGoodsNum());
            quantityMap.put(freightExpCode, cquantity);
            BigDecimal cweight = (BigDecimal)weightMap.get(freightExpCode);
            if (cweight == null) {
                cweight = BigDecimal.ZERO;
            }
            if (ocContractGoodsDomain.getGoodsWeight() != null) {
                cweight = cweight.add(ocContractGoodsDomain.getGoodsWeight());
            }
            weightMap.put(freightExpCode, cweight);
        }
        BigDecimal freightFare = BigDecimal.ZERO;
        for (Map.Entry entry : quantityMap.entrySet()) {
            freightExpCode = (String)entry.getKey();
            expParamMap.clear();
            expParamMap.put("freightExpCode", freightExpCode);
            expParamMap.put("areaCode", areaCode);
            expParamMap.put("quantity", (String)entry.getValue());
            expParamMap.put("weight", (String)weightMap.get(freightExpCode));
            BigDecimal fare = this.wlFreightTemServiceRepository.getFreightFare(expParamMap);
            if (fare == null) continue;
            freightFare = freightFare.add(fare);
        }
        return freightFare;
    }

    public void makeGoods(OcContractGoodsDomain contractGoodsDomain, Map<String, BigDecimal> skuCodeDiscountMap) {
        if (null == contractGoodsDomain) {
            return;
        }
        BigDecimal inmoney = contractGoodsDomain.getPricesetNprice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsInmoney(inmoney);
        BigDecimal refmoney = contractGoodsDomain.getPricesetRefrice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsPefinmoney(refmoney);
        contractGoodsDomain.setContractGoodsPefmoney(refmoney);
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (null != skuCodeDiscountMap && !skuCodeDiscountMap.isEmpty()) {
            skuCodeDiscountMap.get(contractGoodsDomain.getSkuCode());
            if (null == discountAmount) {
                discountAmount = BigDecimal.ZERO;
            }
        }
        BigDecimal contractGoodsMoney = inmoney.subtract(discountAmount);
        contractGoodsDomain.setContractGoodsPrice(contractGoodsMoney.divide(contractGoodsDomain.getGoodsNum(), 2, 4));
        contractGoodsDomain.setContractGoodsMoney(contractGoodsMoney);
        contractGoodsDomain.setContractGoodsAppraise(0);
        contractGoodsDomain.setRefundFlag(0);
    }

    public OcContractDomain makeContractDomain(OrderDomain orderDomain, String contractType, UserSession userSession, String proappCode) throws Exception {
        if (null == userSession || null == orderDomain) {
            this.logger.error("OcServiceRepository.saveContract", (Object)"UserSession is null");
            return null;
        }
        OcContractDomain contractDomain = new OcContractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
        }
        catch (Exception e) {
            this.logger.error("OcServiceRepository.makeContractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)contractDomain.getContractType())) {
            if (StringUtils.isBlank((String)contractType)) {
                contractType = ContractType.CON.getCode();
            }
            contractDomain.setContractType(contractType);
        }
        this.createPackageDomainListOnOrder_temp(orderDomain);
        contractDomain.setMemberBcode(userSession.getUserPcode());
        contractDomain.setMemberBname(userSession.showUserName());
        contractDomain.setTenantCode(userSession.getTenantCode());
        contractDomain.setAppmanageIcode(proappCode);
        return contractDomain;
    }

    private List<PackageDomain> createPackageDomainListOnOrder_temp(OrderDomain orderDomain) {
        PackageDomain packageDomain;
        List<PackageDomain> packageDomainList = orderDomain.getPackageList();
        if (packageDomainList == null) {
            packageDomainList = new ArrayList<PackageDomain>();
        }
        if (packageDomainList.isEmpty()) {
            packageDomain = new PackageDomain();
            packageDomainList.add(packageDomain);
            orderDomain.setPackageList(packageDomainList);
        } else {
            packageDomain = packageDomainList.get(0);
        }
        if (StringUtils.isNotBlank((String)orderDomain.getPackageMode())) {
            packageDomain.setPackageMode(orderDomain.getPackageMode());
        } else {
            packageDomain.setPackageMode("0");
        }
        packageDomain.setShoppingGoodsIdList(orderDomain.getShoppingGoodsIdList());
        packageDomain.setSkuIdList(orderDomain.getSkuIdList());
        return packageDomainList;
    }
}

