/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.rs.repository;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.inf.domain.InfInfuencerReDomain;
import com.qjsoft.laser.controller.facade.inf.repository.InfInfuencerServiceRepository;
import com.qjsoft.laser.controller.facade.mpr.repository.MpMpriceServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.ReturnBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RsSkuServiceRepository
extends SupperFacade {
    @Autowired
    MpMpriceServiceRepository mpMpriceServiceRepository;
    @Autowired
    InfInfuencerServiceRepository infInfuencerServiceRepository;

    public HtmlJsonReBean updateSkuState(Integer skuId, Integer dataState, Integer oldDataState) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateSkuState");
        pmap.putParam("skuId", (Object)skuId);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateAhSkuList(List<RsSkuDomain> skuList) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateAhSkuList");
        pmap.putParamToJson("skuList", skuList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateAhSkuListByGoodsCode(String goodsCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateAhSkuListByGoodsCode");
        pmap.putParam("goodsCode", (Object)goodsCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateCannelSkuList(List<Integer> skuIds) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateCannelSkuList");
        pmap.putParamToJson("skuIds", skuIds);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateAuditSkuPass(List<Integer> skuIds) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateAuditSkuPass");
        pmap.putParamToJson("skuIds", skuIds);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateAuditSkuNoPass(List<Integer> skuIds) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateAuditSkuNoPass");
        pmap.putParamToJson("skuIds", skuIds);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateAuditSkuPassByGoodsCode(String goodsCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateAuditSkuPassByGoodsCode");
        pmap.putParam("goodsCode", (Object)goodsCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSkuByGoodsCode(String goodsCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateSkuByGoodsCode");
        pmap.putParam("goodsCode", (Object)goodsCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSkuGoodsNumByGoodsCode(BigDecimal goodsNum, String skuCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateSkuGoodsNumByGoodsCode");
        pmap.putParamToJson("goodsNum", (Object)goodsNum);
        pmap.putParam("skuCode", (Object)skuCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<RsSkuReDomain> queryDisAndSkuPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.sku.queryDisAndSkuPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, RsSkuReDomain.class);
    }

    public HtmlJsonReBean updateSkuSortNo(String tenantCode, String goodsCode, String skuCode, Integer sortNo) {
        PostParamMap pmap = new PostParamMap("rs.resourceGoods.updateSkuSortNo");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("goodsCode", (Object)goodsCode);
        pmap.putParam("skuCode", (Object)skuCode);
        pmap.putParam("sortNo", (Object)sortNo);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public List<RsSkuReDomain> querySkuByPntreeCode(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.sku.querySkuByPntreeCode");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.getForList(pmap, RsSkuReDomain.class);
    }

    public SupQueryResult<RsSkuReDomain> queryDisSkuPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.sku.queryDisSkuPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, RsSkuReDomain.class);
    }

    public HtmlJsonReBean saveSku(RsSkuDomain rsSkuDomain) {
        PostParamMap pmap = new PostParamMap("rs.sku.saveSku");
        pmap.putParamToJson("rsSkuDomain", (Object)rsSkuDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public RsSkuReDomain getSku(Integer skuId) {
        PostParamMap pmap = new PostParamMap("rs.sku.getSku");
        pmap.putParam("skuId", (Object)skuId);
        return (RsSkuReDomain)this.htmlIBaseService.senReObject(pmap, RsSkuReDomain.class);
    }

    public RsSkuDomain getSkuDomainByCode(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.sku.getSkuDomainByCode");
        pmap.putParamToJson("map", map);
        return (RsSkuDomain)this.htmlIBaseService.senReObject(pmap, RsSkuDomain.class);
    }

    public HtmlJsonReBean updateSku(RsSkuDomain rsSkuDomain) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateSku");
        pmap.putParamToJson("rsSkuDomain", (Object)rsSkuDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSku(Integer skuId) {
        PostParamMap pmap = new PostParamMap("rs.sku.deleteSku");
        pmap.putParam("skuId", (Object)skuId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<RsSkuReDomain> querySkuPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.sku.querySkuPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, RsSkuReDomain.class);
    }

    public RsSkuReDomain getSkuByCode(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.sku.getSkuByCode");
        pmap.putParamToJson("map", map);
        return (RsSkuReDomain)this.htmlIBaseService.senReObject(pmap, RsSkuReDomain.class);
    }

    public HtmlJsonReBean delSkuByCode(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.sku.delSkuByCode");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean saveSkuList(List<RsSkuDomain> rsSkuList) {
        PostParamMap pmap = new PostParamMap("rs.sku.saveSkuList");
        pmap.putParamToJson("rsSkuList", rsSkuList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSkuList(List<RsSkuDomain> skuList) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateSkuList");
        pmap.putParamToJson("skuList", skuList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSkuList(List<Integer> skuIds) {
        PostParamMap pmap = new PostParamMap("rs.sku.deleteskuList");
        pmap.putParamToJson("skuIds", skuIds);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean querySkuAll(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.sku.querySkuAll");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public RsSkuReDomain getSkuBySpec(List<String> spcList, String goodsCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("rs.sku.getSkuBySpec");
        pmap.putParamToJson("spcList", spcList);
        pmap.putParam("goodsCode", (Object)goodsCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return (RsSkuReDomain)this.htmlIBaseService.senReObject(pmap, RsSkuReDomain.class);
    }

    public HtmlJsonReBean updateSkuFile(String skuCode, String tenantCode, List<RsGoodsFileDomain> rsGoodsFileDomainList) {
        PostParamMap pmap = new PostParamMap("rs.sku.updateSkuFile");
        pmap.putParam("skuCode", (Object)skuCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParamToJson("rsGoodsFileDomainList", rsGoodsFileDomainList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<RsSkuReDomain> querySkuOnePage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.sku.querySkuOnePage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, RsSkuReDomain.class);
    }

    public ReturnBean queryHotSku(String userCode, String userPhone, String pageSize, String channelCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("omns.mb.sendqueryGoodsList");
        pmap.putParam("userCode", (Object)userCode);
        pmap.putParam("userPhone", (Object)userPhone);
        pmap.putParam("pageSize", (Object)pageSize);
        pmap.putParam("channelCode", (Object)channelCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return (ReturnBean)this.htmlIBaseService.senReObject(pmap, ReturnBean.class);
    }

    public void exportExcel(Map<String, Object> map, String apiRouter) {
        this.excelService.exportExcel(map, apiRouter);
    }

    public void exportComExcel(HttpServletRequest request, Map<String, Object> map, Map<String, Object> infoMap, String apiRouter) {
        this.excelService.exportComExcel(request, map, infoMap, apiRouter);
    }

    public Map<String, Object> getSkuMemPrice(String skuCode, UserSession userSession, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        PostParamMap pmap = new PostParamMap("rs.sku.getSkuByCode");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        pmap.putParamToJson("map", map);
        String json = this.htmlIBaseService.sendMesReJson(pmap);
        if (StringUtils.isBlank((String)skuCode)) {
            return null;
        }
        Map objmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(objmap);
        List relist = this.mpMpriceServiceRepository.makeMemPrice(list, userSession, channelCode, tenantCode);
        if (ListUtil.isEmpty((Collection)relist)) {
            return null;
        }
        objmap = (Map)relist.get(0);
        return objmap;
    }

    public RsSkuReDomain getSkuMemPriceReBean(String skuCode, UserSession userSession, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        PostParamMap pmap = new PostParamMap("rs.sku.getSkuByCode");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        pmap.putParamToJson("map", map);
        String json = this.htmlIBaseService.sendMesReJson(pmap);
        if (StringUtils.isBlank((String)skuCode)) {
            return null;
        }
        Map objmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(objmap);
        List relist = this.mpMpriceServiceRepository.makeMemPrice(list, userSession, channelCode, tenantCode);
        if (ListUtil.isEmpty((Collection)relist)) {
            return (RsSkuReDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson((Object)objmap), RsSkuReDomain.class);
        }
        objmap = (Map)relist.get(0);
        return (RsSkuReDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson((Object)objmap), RsSkuReDomain.class);
    }

    public RsSkuReDomain getSkuMemPriceReBean(RsSkuReDomain rsSkuReDomain, UserSession userSession, String channelCode, String tenantCode) {
        if (null == rsSkuReDomain || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if ("6".equals(rsSkuReDomain.getGoodsType()) || Integer.valueOf(rsSkuReDomain.getGoodsType()) >= 20) {
            return rsSkuReDomain;
        }
        Map objmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)rsSkuReDomain), String.class, Object.class);
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(objmap);
        List relist = this.mpMpriceServiceRepository.makeMemPrice(list, userSession, channelCode, tenantCode);
        if (ListUtil.isEmpty((Collection)relist)) {
            return rsSkuReDomain;
        }
        objmap = (Map)relist.get(0);
        return (RsSkuReDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson((Object)objmap), RsSkuReDomain.class);
    }

    public RsSkuReDomain getChannelSkuBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        PostParamMap pmap = new PostParamMap("rs.sku.getSkuBySkuNo");
        pmap.putParam("skuNo", (Object)skuNo);
        pmap.putParam("memberCode", (Object)memberCode);
        pmap.putParam("memberCcode", (Object)memberCcode);
        pmap.putParam("channelCode", (Object)channelCode);
        pmap.putParam("tenantCode", (Object)tenantCode);
        return (RsSkuReDomain)this.htmlIBaseService.senReObject(pmap, RsSkuReDomain.class);
    }

    public SupQueryResult<RsSkuReDomain> querySkuSensitPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.sku.querySkuSensitPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, RsSkuReDomain.class);
    }

    public SupQueryResult<InfInfuencerReDomain> queryInfuencerPage(Map<String, Object> map) {
        return this.infInfuencerServiceRepository.queryInfuencerPage(map);
    }

    public List<RsSkuReDomain> querySkuBomsPageToYS() {
        PostParamMap pmap = new PostParamMap("rs.sku.querySkuBomsPageToYS");
        return this.htmlIBaseService.getForList(pmap, RsSkuReDomain.class);
    }
}

