/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.inf.controller.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);
    private static ObjectMapper JSON_TO_OBJECT_MAPPER = new ObjectMapper();
    private static ObjectMapper OBJECT_TO_JSON_MAPPER;
    private static ObjectMapper OBJECT_TO_JSON_MAPPER_CONTAIN_NULL;

    private JsonUtil() {
    }

    public static <T> T json2Object(String json, Class<T> clazz) {
        try {
            return JsonUtil.json2ObjectThrowException(json, clazz);
        }
        catch (Exception e) {
            LOGGER.error("json error", (Throwable)e);
            return null;
        }
    }

    public static <T> T json2Object(String json, TypeReference typeReference) {
        try {
            return JsonUtil.json2ObjectThrowException(json, typeReference);
        }
        catch (Exception e) {
            LOGGER.error("json error", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> json2ObjectList(String json, Class<T> clazz) {
        try {
            return JsonUtil.json2ObjectListThrowException(json, clazz);
        }
        catch (Exception e) {
            LOGGER.error("json error", (Throwable)e);
            return null;
        }
    }

    public static String object2Json(Object object) {
        return JsonUtil.object2Json(object, false);
    }

    public static String object2Json(Object object, boolean containNull) {
        try {
            return JsonUtil.object2JsonThrowException(object, containNull);
        }
        catch (Exception e) {
            LOGGER.error("json error", (Throwable)e);
            return null;
        }
    }

    public static Map json2Map(String json) {
        try {
            return JsonUtil.json2MapThrowException(json);
        }
        catch (Exception e) {
            LOGGER.error("json error", (Throwable)e);
            return null;
        }
    }

    public static <T> T json2ObjectThrowException(String json, Class<T> clazz) throws Exception {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)JSON_TO_OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            LOGGER.error("json2Object error, json: {}", (Object)json, (Object)e);
            throw e;
        }
    }

    public static <T> T json2ObjectThrowException(String json, TypeReference typeReference) throws Exception {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)JSON_TO_OBJECT_MAPPER.readValue(json, typeReference);
        }
        catch (Exception e) {
            LOGGER.error("json2Object error, json: {}", (Object)json, (Object)e);
            throw e;
        }
    }

    public static <T> List<T> json2ObjectListThrowException(String json, Class<T> clazz) throws IOException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            List objects = (List)JSON_TO_OBJECT_MAPPER.readValue(json, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, clazz));
            return objects;
        }
        catch (Exception e) {
            LOGGER.error("json2ObjectList error, json: {}", (Object)json, (Object)e);
            throw e;
        }
    }

    public static String object2JsonThrowException(Object object, boolean containNull) throws Exception {
        if (object == null) {
            return "";
        }
        try {
            if (!containNull) {
                return OBJECT_TO_JSON_MAPPER.writeValueAsString(object);
            }
            return OBJECT_TO_JSON_MAPPER_CONTAIN_NULL.writeValueAsString(object);
        }
        catch (Exception e) {
            LOGGER.error("object2Json error", (Throwable)e);
            throw e;
        }
    }

    public static Map json2MapThrowException(String json) throws Exception {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (Map)JSON_TO_OBJECT_MAPPER.readValue(json, Map.class);
        }
        catch (Exception e) {
            LOGGER.error("json2Map error, json: {}", (Object)json, (Object)e);
            throw e;
        }
    }

    static {
        JSON_TO_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_TO_JSON_MAPPER_CONTAIN_NULL = new ObjectMapper();
        OBJECT_TO_JSON_MAPPER_CONTAIN_NULL.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        OBJECT_TO_JSON_MAPPER = new ObjectMapper();
        OBJECT_TO_JSON_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_TO_JSON_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

