/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.inv.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.inv.domain.InvInvlistDomain;
import com.qjsoft.laser.controller.facade.inv.domain.InvInvlistReDomain;
import com.qjsoft.laser.controller.facade.inv.domain.InvUserinvDomain;
import com.qjsoft.laser.controller.facade.inv.domain.InvUserinvReDomain;
import com.qjsoft.laser.controller.facade.inv.repository.InvInvlistServiceRepository;
import com.qjsoft.laser.controller.facade.inv.repository.InvUserinvServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/inv/invlist"}, name="\u5f00\u7968\u6d41\u6c34")
public class InvlistCon
extends SpringmvcController {
    private static String CODE = "inv.invlist.con";
    @Autowired
    private InvInvlistServiceRepository invInvlistServiceRepository;
    @Autowired
    private InvUserinvServiceRepository invUserinvServiceRepository;

    protected String getContext() {
        return "invlist";
    }

    @RequestMapping(value={"saveInvlist.json"}, name="\u589e\u52a0\u5f00\u7968\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean saveInvlist(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveInvlist", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        InvInvlistDomain invInvlistDomain = (InvInvlistDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, InvInvlistDomain.class);
        InvUserinvDomain invUserinvDomain = invInvlistDomain.getInvUserinvDomain();
        String code = null;
        if (null == invUserinvDomain.getUserinvCode() || "" == invUserinvDomain.getUserinvCode()) {
            invUserinvDomain.setMemberCode(userSession.getUserPcode());
            invUserinvDomain.setMemberName(userSession.getUserName());
            invUserinvDomain.setUserCode(userSession.getUserCode());
            invUserinvDomain.setUserName(userSession.getUserName());
            invUserinvDomain.setTenantCode(this.getTenantCode(request));
            HtmlJsonReBean htmlJsonReBean = this.invUserinvServiceRepository.saveUserinv(invUserinvDomain);
            if (null != htmlJsonReBean.getDataObj()) {
                code = htmlJsonReBean.getDataObj().toString();
                invInvlistDomain.setUserinvCode(code);
            }
        }
        invInvlistDomain.setMemberCode(userSession.getUserPcode());
        invInvlistDomain.setMemberName(userSession.getUserName());
        invInvlistDomain.setUserCode(userSession.getUserCode());
        invInvlistDomain.setUserName(userSession.getUserName());
        invInvlistDomain.setTenantCode(this.getTenantCode(request));
        return this.invInvlistServiceRepository.saveInvlist(invInvlistDomain);
    }

    @RequestMapping(value={"getInvlist.json"}, name="\u83b7\u53d6\u5f00\u7968\u6d41\u6c34\u4fe1\u606f")
    @ResponseBody
    public InvInvlistReDomain getInvlist(Integer invlistId) {
        if (StringUtils.isBlank((Integer)invlistId)) {
            this.logger.error(CODE + ".getInvlist", (Object)"param is null");
            return null;
        }
        InvInvlistReDomain invInvlistReDomain = this.invInvlistServiceRepository.getInvlist(invlistId);
        InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
        invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
        return invInvlistReDomain;
    }

    @RequestMapping(value={"updateInvlist.json"}, name="\u66f4\u65b0\u5f00\u7968\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean updateInvlist(HttpServletRequest request, InvInvlistDomain invInvlistDomain) {
        if (null == invInvlistDomain) {
            this.logger.error(CODE + ".updateInvlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        invInvlistDomain.setTenantCode(this.getTenantCode(request));
        return this.invInvlistServiceRepository.updateInvlist(invInvlistDomain);
    }

    @RequestMapping(value={"deleteInvlist.json"}, name="\u5220\u9664\u5f00\u7968\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean deleteInvlist(Integer invlistId) {
        if (StringUtils.isBlank((Integer)invlistId)) {
            this.logger.error(CODE + ".deleteInvlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.invInvlistServiceRepository.deleteInvlist(invlistId);
    }

    @RequestMapping(value={"queryInvlistPage.json"}, name="\u67e5\u8be2\u5f00\u7968\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<InvInvlistReDomain> queryInvlistPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.remove("userCode");
        param.remove("userName");
        param.put("userinvType", "2");
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult invInvlistReDomainList = this.invInvlistServiceRepository.queryInvlistPage(param);
        List invInvlistReDomainArr = invInvlistReDomainList.getList();
        if (null != invInvlistReDomainArr && invInvlistReDomainArr.size() > 0) {
            for (InvInvlistReDomain invInvlistReDomain : invInvlistReDomainArr) {
                InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
                invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
            }
        }
        return invInvlistReDomainList;
    }

    @RequestMapping(value={"queryInvlistPageOrd.json"}, name="\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u5ba1\u6838")
    @ResponseBody
    public SupQueryResult<InvInvlistReDomain> queryInvlistPageOrd(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.remove("userCode");
        param.remove("userName");
        param.put("userinvType", "3");
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult invInvlistReDomainList = this.invInvlistServiceRepository.queryInvlistPage(param);
        List invInvlistReDomainArr = invInvlistReDomainList.getList();
        if (null != invInvlistReDomainArr && invInvlistReDomainArr.size() > 0) {
            for (InvInvlistReDomain invInvlistReDomain : invInvlistReDomainArr) {
                InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
                invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
            }
        }
        return invInvlistReDomainList;
    }

    @RequestMapping(value={"updateInvlistState.json"}, name="\u66f4\u65b0\u5f00\u7968\u6d41\u6c34\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateInvlistState(String invlistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)invlistId)) {
            this.logger.error(CODE + ".updateInvlistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.invInvlistServiceRepository.updateInvlistState(Integer.valueOf(invlistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateInvlistStateOrd.json"}, name="\u5ba1\u6838\u666e\u901a\u7684\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateInvlistStateOrd(String invlistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)invlistId)) {
            this.logger.error(CODE + ".updateInvlistStateOrd", (Object)"invlistId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.invInvlistServiceRepository.updateInvlistState(Integer.valueOf(invlistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"getInvlistOrd.json"}, name="\u67e5\u770b\u666e\u901a\u53d1\u7968\u7684\u4fe1\u606f")
    @ResponseBody
    public InvInvlistReDomain getInvlistOrd(Integer invlistId) {
        if (StringUtils.isBlank((Integer)invlistId)) {
            this.logger.error(CODE + ".getInvlistOrd", (Object)"invlistId is null");
            return null;
        }
        InvInvlistReDomain invInvlistReDomain = this.invInvlistServiceRepository.getInvlist(invlistId);
        InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
        invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
        return invInvlistReDomain;
    }

    @RequestMapping(value={"queryInvlistPageTowap.json"}, name="wap\u7aef\u67e5\u770b\u53d1\u7968\u5217\u8868")
    @ResponseBody
    public SupQueryResult<InvInvlistReDomain> queryInvlistPageTowap(HttpServletRequest request, String dataState) {
        HashMap<String, String> param = new HashMap<String, String>();
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        param.put("dataState", dataState);
        SupQueryResult invInvlistReDomainList = this.invInvlistServiceRepository.queryInvlistPage(param);
        List invInvlistReDomainArr = invInvlistReDomainList.getList();
        if (null != invInvlistReDomainArr && invInvlistReDomainArr.size() > 0) {
            for (InvInvlistReDomain invInvlistReDomain : invInvlistReDomainArr) {
                InvUserinvReDomain invUserinvDomain = this.invUserinvServiceRepository.getUserinvByCode(invInvlistReDomain.getTenantCode(), invInvlistReDomain.getUserinvCode());
                invInvlistReDomain.setInvUserinvDomain((InvUserinvDomain)invUserinvDomain);
            }
        }
        return invInvlistReDomainList;
    }
}

