/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mlogin.controller;

import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.os.domain.OsOAuthEnvconfigReDomain;
import com.qjsoft.laser.controller.facade.os.domain.WeChartOpenIDBean;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthEnvconfigServiceRepository;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthLoginServiceRepository;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthThirdLoginRepository;
import com.qjsoft.laser.controller.facade.rd.repository.RdRandomListServiceRepository;
import com.qjsoft.laser.controller.facade.tm.domain.TmProappEnvBean;
import com.qjsoft.laser.controller.facade.um.domain.UmBigDataLoginDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserlogininfoDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserLogininfoServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.mlogin.bean.CmsTginfoDomain;
import com.qjsoft.laser.controller.mlogin.controller.WeChatSignUtil;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BrowTypeUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.VerifyImgUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ml/mlogin"})
public class MloginCon
extends SpringmvcController {
    private static String CODE = "ml.mlogin.con";
    @Autowired
    private RdRandomListServiceRepository rdRandomListServiceRepository;
    @Autowired
    private OsOAuthLoginServiceRepository osOAuthLoginServiceRepository;
    @Autowired
    private UserLogininfoServiceRepository userLogininfoServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private OsOAuthThirdLoginRepository osOAuthThirdLoginRepository;
    @Autowired
    private OsOAuthEnvconfigServiceRepository osOAuthEnvconfigServiceRepository;

    protected String getContext() {
        return "mlogin";
    }

    @RequestMapping(value={"noresource"})
    public String noresource(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noresource";
    }

    @RequestMapping(value={"noper"})
    public String noper(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noper";
    }

    @RequestMapping(value={"logininfo.json"})
    @ResponseBody
    public HtmlJsonReBean logininfo(HttpServletRequest request, HttpServletResponse response) {
        UserSession userSession = this.getUserSession(request);
        this.setUserSession(request, response, userSession);
        UserInfo userInfo = this.getUserInfo(request);
        return new HtmlJsonReBean((Object)userInfo);
    }

    @RequestMapping(value={"getProappinfo.json"}, name="\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u4fe1\u606f")
    @ResponseBody
    public TmProappEnvBean getProappinfo(HttpServletRequest request, HttpServletResponse response) {
        String tginfoCode;
        String cacheKey = "TmProappEnv-tenant-ProappCode";
        String proappCode = this.getProappCode(request);
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)proappCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String json = SupDisUtil.getMap((String)cacheKey, (String)(tenantCode + "-" + proappCode));
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        TmProappEnvBean tmProappEnvBean = (TmProappEnvBean)JsonUtil.buildNormalBinder().getJsonToObject(json, TmProappEnvBean.class);
        if (StringUtils.isNotBlank((String)tmProappEnvBean.getProappEnvIndexr())) {
            String oauthEnvCode = this.getOauthEnvCode(request);
            tmProappEnvBean.setProappEnvIndexr(tmProappEnvBean.getProappEnvIndexr().replace("${tenantCode}", tenantCode));
            tmProappEnvBean.setProappEnvIndexr(tmProappEnvBean.getProappEnvIndexr().replace("${proappCode}", proappCode));
            tmProappEnvBean.setProappEnvIndexr(tmProappEnvBean.getProappEnvIndexr().replace("${oauthEnvCode}", oauthEnvCode));
        }
        if (StringUtils.isNotBlank((String)(tginfoCode = this.getTginfoCode(request)))) {
            String tgjson = SupDisUtil.getMap((String)"cms_tginfo_cache", (String)(tginfoCode + "-" + tenantCode));
            CmsTginfoDomain cmsTginfoDomain = (CmsTginfoDomain)JsonUtil.buildNormalBinder().getJsonToObject(tgjson, CmsTginfoDomain.class);
            if (null != cmsTginfoDomain) {
                if (StringUtils.isNotBlank((String)cmsTginfoDomain.getTginfoName())) {
                    tmProappEnvBean.setProappEnvName(cmsTginfoDomain.getTginfoName());
                }
                if (StringUtils.isNotBlank((String)cmsTginfoDomain.getTginfoLogo())) {
                    tmProappEnvBean.setProappEnvLogo(cmsTginfoDomain.getTginfoLogo());
                }
                if (StringUtils.isNotBlank((String)cmsTginfoDomain.getTginfoIoc())) {
                    tmProappEnvBean.setProappEnvIconUrl(cmsTginfoDomain.getTginfoIoc());
                }
            }
        }
        return tmProappEnvBean;
    }

    @RequestMapping(value={"checkPlat.json"}, name="\u68c0\u6d4b\u5f53\u524d\u7528\u6237\u662f\u5426\u662f\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean checkPlat(HttpServletRequest request) {
        if (this.checkMemquaPlat(request)) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(CODE + ".checkMemquaPlat", "\u975e\u5e73\u53f0\u7528\u6237");
    }

    @RequestMapping(value={"checkMerchant.json"}, name="\u68c0\u6d4b\u5f53\u524d\u7528\u6237\u662f\u5426\u662f\u5546\u5bb6")
    @ResponseBody
    public HtmlJsonReBean checkMerchant(HttpServletRequest request) {
        if (this.checkMemquaMerchant(request)) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(CODE + ".checkMemquaPlat", "\u975e\u5546\u5bb6\u7528\u6237");
    }

    @RequestMapping(value={"loginIn.json"})
    public ResponseEntity<HtmlJsonReBean> loginIn(HttpServletRequest request, HttpServletResponse response, String loginName, String passwd, String code, String redirectURL) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        if (StringUtils.isBlank((String)loginName) || StringUtils.isBlank((String)passwd)) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null"), (MultiValueMap)headers, HttpStatus.OK);
        }
        HtmlJsonReBean htmlJsonReBean = this.login(request, response, loginName, passwd, code, redirectURL);
        return new ResponseEntity((Object)htmlJsonReBean, (MultiValueMap)headers, HttpStatus.OK);
    }

    private HtmlJsonReBean login(HttpServletRequest request, HttpServletResponse response, String loginName, String passwd, String code, String redirectURL) {
        String tginfoCode;
        String proappCode;
        if (StringUtils.isBlank((String)loginName)) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        String tenantCode = this.getTenantCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        Map result = this.osOAuthLoginServiceRepository.validateLoginMap(loginName, passwd, oauthEnvCode, proappCode = this.getProappCode(request), tginfoCode = this.getTginfoCode(request), tenantCode, null);
        if (!((Boolean)result.get("flag")).booleanValue() || null == result.get("session")) {
            this.sendLoginLog(request, loginName, tenantCode, proappCode);
            return new HtmlJsonReBean(CODE + ".loginIn.no", result.get("message").toString());
        }
        UserSession userSession = (UserSession)JsonUtil.getAllJsonUtil().getJsonToObject(result.get("session").toString(), UserSession.class);
        if (null == userSession) {
            this.sendLoginLog(request, loginName, tenantCode, proappCode);
            return new HtmlJsonReBean(CODE + ".loginIn.session", result.get("message").toString());
        }
        this.setUserSession(request, response, userSession);
        if (StringUtils.isBlank((String)redirectURL)) {
            redirectURL = userSession.getLoginIndexUrl();
        }
        if (null != userSession.getTwoUserSessionBean()) {
            this.setOrgUsercode(request, response, userSession.getTwoUserSessionBean().getUserCode());
            this.setCompanyCodeByNow(request, response, userSession.getTwoUserSessionBean().getCompanyCode());
        }
        return new HtmlJsonReBean((Object)redirectURL);
    }

    @RequestMapping(value={"microMessengerSign.json"}, name="\u5fae\u4fe1\u5206\u4eab\u7b7e\u540d")
    @ResponseBody
    public HtmlJsonReBean microMessengerSign(HttpServletRequest request, HttpServletResponse response, String access_token, String url) {
        Map<String, Object> appmap = this.getOAuthEnvconfig(request);
        if (null == appmap || appmap.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "code is null");
        }
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)access_token)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "url is null");
        }
        HtmlJsonReBean htmlJsonReBean = this.osOAuthThirdLoginRepository.microMessengerGetticket(access_token, "jsapi", this.getTenantCode(request));
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            this.logger.error(CODE + ".microMessengerSign.microMessengerLogin", htmlJsonReBean.getDataObj());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "htmlJsonReBean is null");
        }
        String json = (String)htmlJsonReBean.getDataObj();
        this.logger.info(CODE + "microMessengerSign", (Object)json);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(CODE + ".microMessengerSign.microMessengerLogin", htmlJsonReBean.getDataObj());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "json is null");
        }
        Map remap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (null == remap || remap.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "remap is null");
        }
        String ticket = (String)remap.get("ticket");
        Map<String, String> map = WeChatSignUtil.sign(ticket, url);
        if (null != map) {
            map.put("appid", (String)appmap.get("appid"));
        }
        return new HtmlJsonReBean(map);
    }

    @RequestMapping(value={"thirdLoginInfo.json"}, name="\u4e09\u65b9\u767b\u5f55")
    @ResponseBody
    public HtmlJsonReBean thirdLoginInfo(HttpServletRequest request, HttpServletResponse response, String redirectURL) {
        Map<String, Object> map = this.getOAuthEnvconfig(request);
        if (null == map || map.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "code is null");
        }
        return new HtmlJsonReBean(map);
    }

    @RequestMapping(value={"loginMicroMessenger.json"}, name="\u5fae\u4fe1\u767b\u5f55")
    @ResponseBody
    public HtmlJsonReBean loginMicroMessenger(HttpServletRequest request, HttpServletResponse response, String redirectURL) {
        String authcode = "";
        if (!StringUtils.isNotBlank((String)request.getParameter("state")) || !request.getParameter("state").equals("wx")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "code is null");
        }
        authcode = request.getParameter("code");
        WeChartOpenIDBean weChartOpenIDBean = this.getMicroMessenger(request, authcode);
        if (null == weChartOpenIDBean) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "weChartOpenIDBean is null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("userOpenid", weChartOpenIDBean.getOpenid());
        SupQueryResult nlist = this.userServiceRepository.queryUserPage(map);
        HashMap<String, String> remap = new HashMap<String, String>();
        remap.put("register", "false");
        remap.put("redirectURL", redirectURL);
        remap.put("userOpenid", weChartOpenIDBean.getOpenid());
        remap.put("access_token", weChartOpenIDBean.getAccess_token());
        if (null == nlist || null == nlist.getList() || nlist.getList().isEmpty()) {
            if ("1".equals(weChartOpenIDBean.getRegister())) {
                UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
                umUserDomainBean.setTenantCode(tenantCode);
                umUserDomainBean.setUserName(weChartOpenIDBean.getOpenid());
                umUserDomainBean.setUserOpenid(weChartOpenIDBean.getOpenid());
                umUserDomainBean.setUserinfoType(Integer.valueOf(1));
                umUserDomainBean.setUserType(Integer.valueOf(0));
                umUserDomainBean.setUserPhone(null);
                umUserDomainBean.setUserinfoCompname(weChartOpenIDBean.getOpenid());
                umUserDomainBean.setUserinfoQuality("buy");
                this.userServiceRepository.sendOpenUserinfo(umUserDomainBean);
                nlist = this.userServiceRepository.queryUserPage(map);
                if (null == nlist || null == nlist.getList() || nlist.getList().isEmpty()) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "nlist is null");
                }
                HtmlJsonReBean htmlJsonReBean = this.login(request, response, ((UmUserReDomainBean)nlist.getList().get(0)).getUserName(), null, null, redirectURL);
                if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) {
                    UmUserReDomainBean umUserReDomainBean = (UmUserReDomainBean)nlist.getList().get(0);
                    remap.put("user", (String)umUserReDomainBean);
                    return new HtmlJsonReBean(remap);
                }
            } else {
                remap.put("register", "true");
            }
        } else {
            HtmlJsonReBean htmlJsonReBean = this.login(request, response, ((UmUserReDomainBean)nlist.getList().get(0)).getUserName(), null, null, redirectURL);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) {
                UmUserReDomainBean umUserReDomainBean = (UmUserReDomainBean)nlist.getList().get(0);
                remap.put("user", (String)umUserReDomainBean);
                return new HtmlJsonReBean(remap);
            }
        }
        return new HtmlJsonReBean(remap);
    }

    @RequestMapping(value={"loginVerificationCode.json"}, name="\u624b\u673a\u9a8c\u8bc1\u7801\u767b\u5f55")
    @ResponseBody
    public ResponseEntity<HtmlJsonReBean> loginVerificationCode(HttpServletRequest request, HttpServletResponse response, String userPhone, String code, String redirectURL) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        if (StringUtils.isBlank((String)userPhone) || StringUtils.isBlank((String)code)) {
            this.logger.error(CODE + ".loginVerificationCode", (Object)"param is null");
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null"), (MultiValueMap)headers, HttpStatus.OK);
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userPhone", userPhone);
        map.put("tenantCode", tenantCode);
        List umUserList = this.userServiceRepository.queryUserPage(map).getList();
        String proappCode = this.getProappCode(request);
        String browType = BrowTypeUtil.getBrowType((String)request.getHeader("User-Agent"));
        if (null == umUserList || umUserList.size() <= 0) {
            return null;
        }
        Map result_code = this.rdRandomListServiceRepository.executeRandomValidity("0", userPhone, code, proappCode, tenantCode);
        if (!((Boolean)result_code.get("flag")).booleanValue()) {
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.no", result_code.get("message").toString()), (MultiValueMap)headers, HttpStatus.OK);
        }
        String tginfoCode = this.getTginfoCode(request);
        Map result = this.osOAuthLoginServiceRepository.validateLoginMap(userPhone, "", browType, proappCode, tginfoCode, tenantCode, null);
        if (!((Boolean)result.get("flag")).booleanValue() || null == result.get("session")) {
            this.sendLoginLog(request, userPhone, tenantCode, proappCode);
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.no", result.get("message").toString()), (MultiValueMap)headers, HttpStatus.OK);
        }
        UserSession userSession = (UserSession)JsonUtil.getAllJsonUtil().getJsonToObject(result.get("session").toString(), UserSession.class);
        if (null == userSession) {
            this.sendLoginLog(request, userPhone, tenantCode, proappCode);
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.session", result.get("message").toString()), (MultiValueMap)headers, HttpStatus.OK);
        }
        this.setUserSession(request, response, userSession);
        if (StringUtils.isBlank((String)redirectURL)) {
            redirectURL = userSession.getLoginIndexUrl();
        }
        return new ResponseEntity((Object)new HtmlJsonReBean((Object)redirectURL), (MultiValueMap)headers, HttpStatus.OK);
    }

    private Map<String, Object> getOAuthEnvconfig(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        List nlist = this.osOAuthEnvconfigServiceRepository.queryOAuthEnvconfigByEnvCode(tenantCode, this.getOauthEnvCode(request));
        if (null == nlist || nlist.isEmpty()) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (OsOAuthEnvconfigReDomain osOAuthEnvconfigReDomain : nlist) {
            map.put(osOAuthEnvconfigReDomain.getOauthEnvconfigType(), osOAuthEnvconfigReDomain.getOauthEnvconfigValue());
        }
        return map;
    }

    private WeChartOpenIDBean getMicroMessenger(HttpServletRequest request, String authcode) {
        Map<String, Object> map = this.getOAuthEnvconfig(request);
        if (null == map || map.isEmpty()) {
            return null;
        }
        String appid = (String)map.get("appid");
        String secret = (String)map.get("secret");
        String grant_type = (String)map.get("grant_type");
        String register = (String)map.get("register");
        String tenantCode = this.getTenantCode(request);
        HtmlJsonReBean htmlJsonReBean = this.osOAuthThirdLoginRepository.microMessengerLogin(appid, secret, authcode, grant_type, tenantCode);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            this.logger.error(CODE + ".getMicroMessenger.microMessengerLogin", htmlJsonReBean.getDataObj());
            return null;
        }
        String json = (String)htmlJsonReBean.getDataObj();
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(CODE + ".getMicroMessenger.microMessengerLogin", htmlJsonReBean.getDataObj());
            return null;
        }
        WeChartOpenIDBean weChartOpenIDBean = (WeChartOpenIDBean)JsonUtil.buildNormalBinder().getJsonToObject(json, WeChartOpenIDBean.class);
        if (null != weChartOpenIDBean) {
            weChartOpenIDBean.setRegister(register);
        }
        return weChartOpenIDBean;
    }

    @RequestMapping(value={"loginOrgUsercode.json"}, name="\u5207\u6362\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean loginOrgUsercode(HttpServletRequest request, HttpServletResponse response, String orgUsercode) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        if (orgUsercode.equals(userSession.getUserCode())) {
            this.setOrgUsercode(request, response, orgUsercode);
            this.setCompanyCodeByNow(request, response, userSession.getCompanyCode());
        } else if (null != userSession.getUserMap().get(orgUsercode)) {
            this.setOrgUsercode(request, response, orgUsercode);
            this.setCompanyCodeByNow(request, response, userSession.getUserSession(orgUsercode).getCompanyCode());
            this.setUserSession(request, response, userSession.getUserSession(orgUsercode));
        } else if (orgUsercode.equals(userSession.getOneUserSessionBean().getUserCode())) {
            this.setOrgUsercode(request, response, orgUsercode);
            this.setCompanyCodeByNow(request, response, userSession.getOneUserSessionBean().getCompanyCode());
            this.setUserSession(request, response, userSession.getOneUserSessionBean());
        } else {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"loginInByBigData.json"})
    public ResponseEntity<HtmlJsonReBean> loginInByBigData(HttpServletRequest request, HttpServletResponse response, UmBigDataLoginDomain umBigDataLoginDomain) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        if (StringUtils.isBlank((String)umBigDataLoginDomain.getLoginName()) || StringUtils.isBlank((String)umBigDataLoginDomain.getPasswd())) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null"), (MultiValueMap)headers, HttpStatus.OK);
        }
        String tenantCode = this.getTenantCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        String proappCode = this.getProappCode(request);
        Map result = this.osOAuthLoginServiceRepository.validateLogin(umBigDataLoginDomain.getLoginName(), umBigDataLoginDomain.getPasswd(), oauthEnvCode, proappCode, tenantCode);
        if (!((Boolean)result.get("flag")).booleanValue() || null == result.get("session")) {
            this.sendLoginLog(request, umBigDataLoginDomain.getLoginName(), tenantCode, proappCode);
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.no", result.get("message").toString()), (MultiValueMap)headers, HttpStatus.OK);
        }
        UserSession userSession = (UserSession)JsonUtil.getAllJsonUtil().getJsonToObject(result.get("session").toString(), UserSession.class);
        if (null == userSession) {
            this.sendLoginLog(request, umBigDataLoginDomain.getLoginName(), tenantCode, proappCode);
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.session", result.get("message").toString()), (MultiValueMap)headers, HttpStatus.OK);
        }
        umBigDataLoginDomain.setLoginIp(this.getClientIp(request));
        umBigDataLoginDomain.setUserCode(userSession.getUserCode());
        umBigDataLoginDomain.setTenantCode(tenantCode);
        umBigDataLoginDomain.setProappCode(proappCode);
        umBigDataLoginDomain.setPaasLabel("userLogin");
        umBigDataLoginDomain.setUserName(userSession.getUserName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("topic", "paas_user_behavior");
        map.put("bigdata", JsonUtil.buildNormalBinder().toJson((Object)umBigDataLoginDomain));
        this.userServiceRepository.sendBigDataForUser(map);
        this.setUserSession(request, response, userSession);
        String redirectURL = umBigDataLoginDomain.getRedirectURL();
        if (StringUtils.isBlank((String)redirectURL)) {
            redirectURL = userSession.getLoginIndexUrl();
        }
        return new ResponseEntity((Object)new HtmlJsonReBean((Object)redirectURL), (MultiValueMap)headers, HttpStatus.OK);
    }

    private void sendLoginLog(HttpServletRequest request, String loginName, String tenantCode, String proappCode) {
        UmUserlogininfoDomainBean umUserlogininfoDomainBean = new UmUserlogininfoDomainBean();
        umUserlogininfoDomainBean.setAppmanageIcode(proappCode);
        umUserlogininfoDomainBean.setLoginIp(this.getClientIp(request));
        umUserlogininfoDomainBean.setTenantCode(tenantCode);
        umUserlogininfoDomainBean.setUserCode(loginName);
        umUserlogininfoDomainBean.setUserName(loginName);
        try {
            this.userLogininfoServiceRepository.saveUserlogininfo(umUserlogininfoDomainBean);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @RequestMapping(value={"loginOut.json"})
    @ResponseBody
    public HtmlJsonReBean loginOut(HttpServletRequest request, HttpServletResponse response) {
        String token = this.getToken(request);
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        String tginfoCode = this.getTginfoCode(request);
        this.osOAuthLoginServiceRepository.LoginOutMap(token, oauthEnvCode, proappCode, tginfoCode, tenantCode, null);
        this.setUserSession(request, response, null);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getVerCode.img"})
    @ResponseBody
    public void getVerCode(HttpServletRequest request, HttpServletResponse response) {
        String tenantCode = this.getTenantCode(request);
        String verCode = "";
        Map result = this.rdRandomListServiceRepository.createRandom("2", request.getRemoteAddr(), ServletMain.getAppName(), tenantCode);
        if (((Boolean)result.get("flag")).booleanValue()) {
            response.setHeader("Content-Type", "image/jped");
            response.setDateHeader("expries", -1L);
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            verCode = (String)result.get("message");
            BufferedImage bufferedImage = new VerifyImgUtils(verCode).getBuffImg();
            try {
                ImageIO.write((RenderedImage)bufferedImage, "jpg", (OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                this.logger.error(CODE + ".getVerCode.write", (Throwable)e);
            }
        } else {
            this.logger.error(CODE + ".getVerCode.err", (Object)("result is " + result));
        }
    }
}

