/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mlogin.controller;

import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.os.domain.OsOAuthEnvconfigReDomain;
import com.qjsoft.laser.controller.facade.os.domain.WeChartOpenIDBean;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthEnvconfigServiceRepository;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthLoginServiceRepository;
import com.qjsoft.laser.controller.facade.os.repository.OsOAuthThirdLoginRepository;
import com.qjsoft.laser.controller.facade.rd.repository.RdRandomListServiceRepository;
import com.qjsoft.laser.controller.facade.tm.domain.TmProappEnvBean;
import com.qjsoft.laser.controller.facade.um.domain.UmBigDataLoginDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserRegBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserlogininfoDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserBaseServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserLogininfoServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.interceptor.service.BaseInterUtil;
import com.qjsoft.laser.controller.mlogin.controller.WeChatSignUtil;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.qjsoft.laser.controller.springmvc.bean.CmsTginfo;
import com.qjsoft.laser.controller.springmvc.bean.TmProappEnv;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.VerifyImgUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ml/mlogin"})
public class MloginCon
extends SpringmvcController {
    private static String CODE = "ml.mlogin.con";
    @Autowired
    private RdRandomListServiceRepository rdRandomListServiceRepository;
    @Autowired
    private OsOAuthLoginServiceRepository osOAuthLoginServiceRepository;
    @Autowired
    private UserLogininfoServiceRepository userLogininfoServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private OsOAuthThirdLoginRepository osOAuthThirdLoginRepository;
    @Autowired
    private OsOAuthEnvconfigServiceRepository osOAuthEnvconfigServiceRepository;
    @Autowired
    private UserBaseServiceRepository userBaseServiceRepository;

    protected String getContext() {
        return "mlogin";
    }

    @RequestMapping(value={"noresource"})
    public String noresource(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noresource";
    }

    @RequestMapping(value={"noper"})
    public String noper(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noper";
    }

    @RequestMapping(value={"logininfo.json"})
    @ResponseBody
    public HtmlJsonReBean logininfo(HttpServletRequest request, HttpServletResponse response) {
        UserSession userSession = this.getUserSession(request);
        this.setUserSession(request, response, userSession);
        UserInfo userInfo = this.getUserInfo(request);
        return new HtmlJsonReBean((Object)userInfo);
    }

    @RequestMapping(value={"getProappinfo.json"}, name="\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u4fe1\u606f")
    @ResponseBody
    public TmProappEnvBean getProappinfo(HttpServletRequest request, HttpServletResponse response) {
        CmsTginfo cmsTginfo;
        String tginfoCode;
        String cacheKey = "TmProappEnv-tenant-ProappCode";
        String proappCode = this.getProappCode(request);
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)proappCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".getProappinfo.param", (Object)(proappCode + "-" + tenantCode));
            return null;
        }
        TmProappEnv tmProappEnv = (TmProappEnv)SupDisUtil.getMapJson((String)cacheKey, (String)(tenantCode + "-" + proappCode), TmProappEnv.class);
        if (null == tmProappEnv) {
            this.logger.error(CODE + ".getProappinfo.TmProappEnv", (Object)(proappCode + "-" + tenantCode));
            return null;
        }
        TmProappEnvBean tmProappEnvBean = new TmProappEnvBean();
        try {
            BeanUtils.copyAllPropertys((Object)tmProappEnvBean, (Object)tmProappEnv);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".getProappinfo.e", (Object)(proappCode + "-" + tenantCode));
        }
        if (StringUtils.isNotBlank((String)tmProappEnvBean.getProappEnvIndexr()) && tmProappEnvBean.getProappEnvIndexr().indexOf("${") >= 0) {
            String oauthEnvCode = this.getOauthEnvCode(request);
            tmProappEnvBean.setProappEnvIndexr(tmProappEnvBean.getProappEnvIndexr().replace("${tenantCode}", tenantCode));
            tmProappEnvBean.setProappEnvIndexr(tmProappEnvBean.getProappEnvIndexr().replace("${proappCode}", proappCode));
            tmProappEnvBean.setProappEnvIndexr(tmProappEnvBean.getProappEnvIndexr().replace("${oauthEnvCode}", oauthEnvCode));
        }
        if (StringUtils.isNotBlank((String)(tginfoCode = this.getTginfoCode(request))) && null != (cmsTginfo = (CmsTginfo)SupDisUtil.getMapJson((String)"cms_tginfo_cache", (String)(tginfoCode + "-" + tenantCode), CmsTginfo.class))) {
            if (StringUtils.isNotBlank((String)cmsTginfo.getTginfoName())) {
                tmProappEnvBean.setProappEnvName(cmsTginfo.getTginfoName());
            }
            if (StringUtils.isNotBlank((String)cmsTginfo.getTginfoLogo())) {
                tmProappEnvBean.setProappEnvLogo(cmsTginfo.getTginfoLogo());
            }
            if (StringUtils.isNotBlank((String)cmsTginfo.getTginfoIoc())) {
                tmProappEnvBean.setProappEnvIconUrl(cmsTginfo.getTginfoIoc());
            }
        }
        return tmProappEnvBean;
    }

    @RequestMapping(value={"checkPlat.json"}, name="\u68c0\u6d4b\u5f53\u524d\u7528\u6237\u662f\u5426\u662f\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean checkPlat(HttpServletRequest request) {
        if (this.checkMemquaPlat(request)) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(CODE + ".checkMemquaPlat", "\u975e\u5e73\u53f0\u7528\u6237");
    }

    @RequestMapping(value={"checkMerchant.json"}, name="\u68c0\u6d4b\u5f53\u524d\u7528\u6237\u662f\u5426\u662f\u5546\u5bb6")
    @ResponseBody
    public HtmlJsonReBean checkMerchant(HttpServletRequest request) {
        if (this.checkMemquaMerchant(request)) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(CODE + ".checkMemquaPlat", "\u975e\u5546\u5bb6\u7528\u6237");
    }

    @RequestMapping(value={"loginIn.json"})
    public ResponseEntity<HtmlJsonReBean> loginIn(HttpServletRequest request, HttpServletResponse response, String loginName, String passwd, String code, String redirectURL) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        if (StringUtils.isBlank((String)loginName) || StringUtils.isBlank((String)passwd)) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null"), (MultiValueMap)headers, HttpStatus.OK);
        }
        HtmlJsonReBean htmlJsonReBean = this.login(request, response, loginName, passwd, code, redirectURL);
        return new ResponseEntity((Object)htmlJsonReBean, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"oauthLogin.json"}, name="\u6388\u6743\u767b\u5f55")
    @ResponseBody
    public HtmlJsonReBean oauthLogin(HttpServletRequest request, HttpServletResponse response, String accessToken, String url) {
        if (StringUtils.isBlank((String)accessToken) || StringUtils.isBlank((String)accessToken)) {
            this.logger.error(CODE + ".loginIn", (Object)"accessToken is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "accessToken is null");
        }
        HtmlJsonReBean htmlJsonReBean = this.login(request, response, accessToken, null, null, url);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"loginOauthMicroMessenger.json"}, name="\u5fae\u4fe1\u767b\u5f55+\u4e09\u65b9\u6388\u6743")
    @ResponseBody
    public HtmlJsonReBean loginOauthMicroMessenger(HttpServletRequest request, HttpServletResponse response, String accessToken, String url) {
        String authcode = "";
        if (!StringUtils.isNotBlank((String)request.getParameter("state")) || !request.getParameter("state").equals("wx")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "code is null");
        }
        authcode = request.getParameter("code");
        WeChartOpenIDBean weChartOpenIDBean = this.getMicroMessenger(request, authcode, false);
        if (null == weChartOpenIDBean) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "weChartOpenIDBean is null");
        }
        if (StringUtils.isBlank((String)weChartOpenIDBean.getOpenid())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "weChartOpenIDBean.Openid is null");
        }
        HtmlJsonReBean htmlJsonReBean = this.login(request, response, accessToken, null, null, url);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        UserSession userSession = BaseInterUtil.getSession((HttpServletRequest)request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        String tenantCode = this.getTenantCode(request);
        UmUserReDomainBean umUserReDomainBean = this.userServiceRepository.getUserByUserCode(userSession.getUserCode(), tenantCode);
        if (null == umUserReDomainBean) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "umUserReDomainBean is null");
        }
        if (!weChartOpenIDBean.getOpenid().equals(umUserReDomainBean.getUserOpenid())) {
            umUserReDomainBean.setUserOpenid(weChartOpenIDBean.getOpenid());
            this.userServiceRepository.updateUser((UmUserDomainBean)umUserReDomainBean);
        }
        return htmlJsonReBean;
    }

    private HtmlJsonReBean login(HttpServletRequest request, HttpServletResponse response, String loginName, String passwd, String code, String redirectURL) {
        String tginfoCode;
        String proappCode;
        if (StringUtils.isBlank((String)loginName)) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        String tenantCode = this.getTenantCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        UserSession userSession = this.osOAuthLoginServiceRepository.validateLoginMap(loginName, passwd, oauthEnvCode, proappCode = this.getProappCode(request), tginfoCode = this.getTginfoCode(request), tenantCode, null);
        if (null == userSession || !userSession.isFlag()) {
            this.logger.error(CODE + ".loginIn.userSession", (Object)(userSession.isFlag() + "-" + userSession.getUserCode()));
            this.sendLoginLog(request, loginName, tenantCode, proappCode);
            return new HtmlJsonReBean(CODE + ".loginIn.no", userSession.getMsg());
        }
        this.setUserSession(request, response, userSession);
        if (StringUtils.isBlank((String)redirectURL)) {
            redirectURL = userSession.getLoginIndexUrl();
        }
        if (StringUtils.isNotBlank((String)redirectURL) && redirectURL.indexOf("${") >= 0) {
            redirectURL = redirectURL.replace("${tenantCode}", tenantCode);
            redirectURL = redirectURL.replace("${proappCode}", proappCode);
            redirectURL = redirectURL.replace("${oauthEnvCode}", oauthEnvCode);
            redirectURL = redirectURL.replace("${userinfoCode}", userSession.getUserPcode());
            userSession.setLoginIndexUrl(redirectURL);
        }
        if (null != userSession.getTwoUserSessionBean()) {
            this.setOrgUsercode(request, response, userSession.getTwoUserSessionBean().getUserCode());
            this.setCompanyCodeByNow(request, response, userSession.getTwoUserSessionBean().getCompanyCode());
        }
        return new HtmlJsonReBean((Object)this.getUserInfo(request));
    }

    @RequestMapping(value={"microMessengerSign.json"}, name="\u5fae\u4fe1\u5206\u4eab\u7b7e\u540d")
    @ResponseBody
    public HtmlJsonReBean microMessengerSign(HttpServletRequest request, HttpServletResponse response, String access_token, String url) {
        Map<String, Object> appmap = this.getOAuthEnvconfig(request);
        if (null == appmap || appmap.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "code is null");
        }
        if (StringUtils.isBlank((String)url)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "url is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        if (StringUtils.isBlank((String)userSession.getOpenId())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "OpenId is null");
        }
        HtmlJsonReBean htmlJsonReBean = this.osOAuthThirdLoginRepository.microMessengerGetticket((String)appmap.get("appid"), "jsapi", userSession.getOpenId(), (String)appmap.get("secret"), this.getTenantCode(request));
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            this.logger.error(CODE + ".microMessengerSign.microMessengerLogin", htmlJsonReBean.getDataObj());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "htmlJsonReBean is null");
        }
        if (null == htmlJsonReBean.getDataObj()) {
            this.logger.error(CODE + ".microMessengerSign.microMessengerLogin");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "DataObj is null");
        }
        Map remap = (Map)JsonUtil.buildNormalBinder().getJsonToMap((String)htmlJsonReBean.getDataObj(), String.class, Object.class);
        if (null == remap || remap.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "remap is null");
        }
        String ticket = (String)remap.get("ticket");
        if (StringUtils.isBlank((String)ticket)) {
            this.logger.error(CODE + ".microMessengerSign.ticket", htmlJsonReBean.getDataObj());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "ticket is null");
        }
        Map<String, String> map = WeChatSignUtil.sign(ticket, url);
        if (null != map) {
            map.put("appid", (String)appmap.get("appid"));
        }
        return new HtmlJsonReBean(map);
    }

    @RequestMapping(value={"thirdLoginInfo.json"}, name="\u4e09\u65b9\u767b\u5f55")
    @ResponseBody
    public HtmlJsonReBean thirdLoginInfo(HttpServletRequest request, HttpServletResponse response, String redirectURL) {
        Map<String, Object> map = this.getOAuthEnvconfig(request);
        if (null == map || map.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "code is null");
        }
        return new HtmlJsonReBean(map);
    }

    @RequestMapping(value={"loginMiniProgram.json"}, name="\u5c0f\u7a0b\u5e8f\u767b\u5f55")
    @ResponseBody
    public HtmlJsonReBean loginMiniProgram(HttpServletRequest request, HttpServletResponse response, String redirectURL) {
        String authcode = "";
        if (!StringUtils.isNotBlank((String)request.getParameter("state")) || !request.getParameter("state").equals("wx")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "code is null");
        }
        authcode = request.getParameter("js_code");
        WeChartOpenIDBean weChartOpenIDBean = this.getMicroMessenger(request, authcode, true);
        return this.loginOther(weChartOpenIDBean, request, response, redirectURL);
    }

    @RequestMapping(value={"loginMicroMessenger.json"}, name="\u5fae\u4fe1\u767b\u5f55")
    @ResponseBody
    public HtmlJsonReBean loginMicroMessenger(HttpServletRequest request, HttpServletResponse response, String redirectURL) {
        String authcode = "";
        if (!StringUtils.isNotBlank((String)request.getParameter("state")) || !request.getParameter("state").equals("wx")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "code is null");
        }
        authcode = request.getParameter("code");
        WeChartOpenIDBean weChartOpenIDBean = this.getMicroMessenger(request, authcode, false);
        return this.loginOther(weChartOpenIDBean, request, response, redirectURL);
    }

    public HtmlJsonReBean loginOther(WeChartOpenIDBean weChartOpenIDBean, HttpServletRequest request, HttpServletResponse response, String redirectURL) {
        HtmlJsonReBean htmlJsonReBean;
        if (null == weChartOpenIDBean) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "weChartOpenIDBean is null");
        }
        if (StringUtils.isBlank((String)weChartOpenIDBean.getOpenid())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "weChartOpenIDBean.Openid is null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("userOpenid", weChartOpenIDBean.getOpenid());
        SupQueryResult nlist = this.userServiceRepository.queryUserPage(map);
        HashMap<String, String> remap = new HashMap<String, String>();
        remap.put("register", "false");
        remap.put("redirectURL", redirectURL);
        remap.put("userOpenid", weChartOpenIDBean.getOpenid());
        remap.put("access_token", weChartOpenIDBean.getAccess_token());
        if (null == nlist || null == nlist.getList() || nlist.getList().isEmpty()) {
            if ("1".equals(weChartOpenIDBean.getRegister())) {
                UmUserRegBean umUserRegBean = new UmUserRegBean();
                umUserRegBean.setUserName(weChartOpenIDBean.getOpenid());
                umUserRegBean.setUserinfoType(Integer.valueOf(1));
                umUserRegBean.setUserOpenid(weChartOpenIDBean.getOpenid());
                umUserRegBean.setTenantCode(tenantCode);
                HtmlJsonReBean htmlJsonReBean2 = this.userBaseServiceRepository.saveUmuser(umUserRegBean);
                if (null == htmlJsonReBean2 || !htmlJsonReBean2.isSuccess()) {
                    return htmlJsonReBean2;
                }
                nlist = this.userServiceRepository.queryUserPage(map);
                if (null == nlist || null == nlist.getList() || nlist.getList().isEmpty()) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "nlist is null");
                }
                htmlJsonReBean2 = this.login(request, response, ((UmUserReDomainBean)nlist.getList().get(0)).getUserName(), null, null, redirectURL);
                if (null != htmlJsonReBean2 && htmlJsonReBean2.isSuccess()) {
                    remap.put("userPhone", ((UmUserReDomainBean)nlist.getList().get(0)).getUserPhone());
                    remap.put("userInfo", JsonUtil.buildNormalBinder().toJson((Object)this.getUserInfo(request)));
                    return new HtmlJsonReBean(remap);
                }
                return htmlJsonReBean2;
            }
            remap.put("register", "true");
            return new HtmlJsonReBean(remap);
        }
        String name = ((UmUserReDomainBean)nlist.getList().get(0)).getUserName();
        if (StringUtils.isBlank((String)name)) {
            name = ((UmUserReDomainBean)nlist.getList().get(0)).getUserPhone();
        }
        if (null != (htmlJsonReBean = this.login(request, response, name, null, null, redirectURL)) && htmlJsonReBean.isSuccess()) {
            remap.put("userPhone", ((UmUserReDomainBean)nlist.getList().get(0)).getUserPhone());
            remap.put("userInfo", JsonUtil.buildNormalBinder().toJson((Object)this.getUserInfo(request)));
            return new HtmlJsonReBean(remap);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"loginVerificationCode.json"}, name="\u624b\u673a\u9a8c\u8bc1\u7801\u767b\u5f55")
    @ResponseBody
    public HtmlJsonReBean loginVerificationCode(HttpServletRequest request, HttpServletResponse response, String userPhone, String code) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        if (StringUtils.isBlank((String)userPhone) || StringUtils.isBlank((String)code)) {
            this.logger.error(CODE + ".loginVerificationCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        Map result_code = this.userBaseServiceRepository.checkExecuteRandomValidity("0", userPhone, code, proappCode, tenantCode, Boolean.valueOf(false));
        if (!((Boolean)result_code.get("flag")).booleanValue()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, result_code.get("message").toString());
        }
        HtmlJsonReBean htmlJsonReBean = this.login(request, response, userPhone, "", code, null);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            this.sendLoginLog(request, userPhone, tenantCode, proappCode);
            String msg = String.valueOf(htmlJsonReBean.getDataObj());
            return new HtmlJsonReBean(CODE + ".loginIn.no", msg);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getSecretKeyCodeByconfigType.json"}, name="\u83b7\u53d6\u5730\u56fe\u79d8\u94a5")
    @ResponseBody
    public HtmlJsonReBean getSecretKeyCodeByconfigType(HttpServletRequest request, String oauthEnvconfigType) {
        String tenantCode = this.getTenantCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        String proappCode = this.getProappCode(request);
        this.logger.error("======tenantCode :  " + tenantCode + "  ; oauthEnvCode : " + oauthEnvCode + "  ; proappCode : " + proappCode + " ; ======");
        List nlist = this.osOAuthEnvconfigServiceRepository.queryOAuthEnvconfigByEnvCode(tenantCode, oauthEnvCode, proappCode);
        if (null == nlist || nlist.isEmpty()) {
            this.logger.error(CODE + ".getOAuthEnvconfig.nlist", (Object)(tenantCode + "-" + oauthEnvCode + "-" + proappCode));
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (OsOAuthEnvconfigReDomain osOAuthEnvconfigReDomain : nlist) {
            map.put(osOAuthEnvconfigReDomain.getOauthEnvconfigType(), osOAuthEnvconfigReDomain.getOauthEnvconfigValue());
        }
        return new HtmlJsonReBean(map.get(oauthEnvconfigType));
    }

    private Map<String, Object> getOAuthEnvconfig(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        String proappCode = this.getProappCode(request);
        this.logger.error("======tenantCode :  " + tenantCode + "  ; oauthEnvCode : " + oauthEnvCode + "  ; proappCode : " + proappCode + " ; ======");
        List nlist = this.osOAuthEnvconfigServiceRepository.queryOAuthEnvconfigByEnvCode(tenantCode, oauthEnvCode, proappCode);
        if (null == nlist || nlist.isEmpty()) {
            this.logger.error(CODE + ".getOAuthEnvconfig.nlist", (Object)(tenantCode + "-" + oauthEnvCode + "-" + proappCode));
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (OsOAuthEnvconfigReDomain osOAuthEnvconfigReDomain : nlist) {
            map.put(osOAuthEnvconfigReDomain.getOauthEnvconfigType(), osOAuthEnvconfigReDomain.getOauthEnvconfigValue());
        }
        return map;
    }

    private WeChartOpenIDBean getMicroMessenger(HttpServletRequest request, String authcode, boolean isMiniProgram) {
        Map<String, Object> map = this.getOAuthEnvconfig(request);
        if (null == map || map.isEmpty()) {
            return null;
        }
        String appid = (String)map.get("appid");
        String secret = (String)map.get("secret");
        String grant_type = (String)map.get("grant_type");
        String register = (String)map.get("register");
        String tenantCode = this.getTenantCode(request);
        HtmlJsonReBean htmlJsonReBean = isMiniProgram ? this.osOAuthThirdLoginRepository.miniProgramLogin(appid, secret, authcode, grant_type, tenantCode) : this.osOAuthThirdLoginRepository.microMessengerLogin(appid, secret, authcode, grant_type, tenantCode);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            this.logger.error(CODE + ".getMicroMessenger.htmlJsonReBean", htmlJsonReBean.getDataObj());
            return null;
        }
        String json = (String)htmlJsonReBean.getDataObj();
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(CODE + ".getMicroMessenger.json", (Object)(appid + "-" + secret + "-" + authcode + "-" + grant_type + "-" + tenantCode));
            return null;
        }
        WeChartOpenIDBean weChartOpenIDBean = (WeChartOpenIDBean)JsonUtil.buildNormalBinder().getJsonToObject(json, WeChartOpenIDBean.class);
        if (null != weChartOpenIDBean) {
            weChartOpenIDBean.setRegister(register);
            if (StringUtils.isNotBlank((String)weChartOpenIDBean.getOpenid())) {
                SupDisUtil.setVer((String)("wechart-" + weChartOpenIDBean.getOpenid()), (String)JsonUtil.buildNormalBinder().toJson((Object)weChartOpenIDBean));
            } else {
                this.logger.error(CODE + ".getMicroMessenger.Openid", (Object)(json + "=" + appid + "-" + secret + "-" + authcode + "-" + grant_type + "-" + tenantCode));
            }
        }
        return weChartOpenIDBean;
    }

    @RequestMapping(value={"loginOrgUsercode.json"}, name="\u5207\u6362\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean loginOrgUsercode(HttpServletRequest request, HttpServletResponse response, String orgUsercode) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        if (orgUsercode.equals(userSession.getUserCode())) {
            this.setOrgUsercode(request, response, orgUsercode);
            this.setCompanyCodeByNow(request, response, userSession.getCompanyCode());
        } else if (null != userSession.getUserMap().get(orgUsercode)) {
            this.setOrgUsercode(request, response, orgUsercode);
            this.setCompanyCodeByNow(request, response, userSession.getUserSession(orgUsercode).getCompanyCode());
            this.setUserSession(request, response, userSession.getUserSession(orgUsercode));
        } else if (orgUsercode.equals(userSession.getOneUserSessionBean().getUserCode())) {
            this.setOrgUsercode(request, response, orgUsercode);
            this.setCompanyCodeByNow(request, response, userSession.getOneUserSessionBean().getCompanyCode());
            this.setUserSession(request, response, userSession.getOneUserSessionBean());
        } else {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"loginInByBigData.json"})
    public ResponseEntity<HtmlJsonReBean> loginInByBigData(HttpServletRequest request, HttpServletResponse response, UmBigDataLoginDomain umBigDataLoginDomain) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        if (StringUtils.isBlank((String)umBigDataLoginDomain.getLoginName()) || StringUtils.isBlank((String)umBigDataLoginDomain.getPasswd())) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null"), (MultiValueMap)headers, HttpStatus.OK);
        }
        String tenantCode = this.getTenantCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        String proappCode = this.getProappCode(request);
        UserSession userSession = this.osOAuthLoginServiceRepository.validateLogin(umBigDataLoginDomain.getLoginName(), umBigDataLoginDomain.getPasswd(), oauthEnvCode, proappCode, tenantCode);
        if (null == userSession || !userSession.isFlag()) {
            this.sendLoginLog(request, umBigDataLoginDomain.getLoginName(), tenantCode, proappCode);
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.no", userSession.getMsg()), (MultiValueMap)headers, HttpStatus.OK);
        }
        umBigDataLoginDomain.setLoginIp(this.getClientIp(request));
        umBigDataLoginDomain.setUserCode(userSession.getUserCode());
        umBigDataLoginDomain.setTenantCode(tenantCode);
        umBigDataLoginDomain.setProappCode(proappCode);
        umBigDataLoginDomain.setPaasLabel("userLogin");
        umBigDataLoginDomain.setUserName(userSession.getUserName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("topic", "paas_user_behavior");
        map.put("bigdata", JsonUtil.buildNormalBinder().toJson((Object)umBigDataLoginDomain));
        this.userServiceRepository.sendBigDataForUser(map);
        this.setUserSession(request, response, userSession);
        String redirectURL = umBigDataLoginDomain.getRedirectURL();
        if (StringUtils.isBlank((String)redirectURL)) {
            redirectURL = userSession.getLoginIndexUrl();
        }
        return new ResponseEntity((Object)new HtmlJsonReBean((Object)redirectURL), (MultiValueMap)headers, HttpStatus.OK);
    }

    private void sendLoginLog(HttpServletRequest request, String loginName, String tenantCode, String proappCode) {
        UmUserlogininfoDomainBean umUserlogininfoDomainBean = new UmUserlogininfoDomainBean();
        umUserlogininfoDomainBean.setAppmanageIcode(proappCode);
        umUserlogininfoDomainBean.setLoginIp(this.getClientIp(request));
        umUserlogininfoDomainBean.setTenantCode(tenantCode);
        umUserlogininfoDomainBean.setUserCode(loginName);
        umUserlogininfoDomainBean.setUserName(loginName);
        try {
            this.userLogininfoServiceRepository.saveUserlogininfo(umUserlogininfoDomainBean);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @RequestMapping(value={"loginOut.json"})
    @ResponseBody
    public HtmlJsonReBean loginOut(HttpServletRequest request, HttpServletResponse response) {
        String token = this.getToken(request);
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        String tginfoCode = this.getTginfoCode(request);
        this.osOAuthLoginServiceRepository.LoginOutMap(token, oauthEnvCode, proappCode, tginfoCode, tenantCode, null);
        this.setUserSession(request, response, null);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getVerCode.img"})
    @ResponseBody
    public void getVerCode(HttpServletRequest request, HttpServletResponse response) {
        String tenantCode = this.getTenantCode(request);
        String verCode = "";
        Map result = this.rdRandomListServiceRepository.createRandom("2", request.getRemoteAddr(), ServletMain.getAppName(), tenantCode);
        if (((Boolean)result.get("flag")).booleanValue()) {
            response.setHeader("Content-Type", "image/jped");
            response.setDateHeader("expries", -1L);
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            verCode = (String)result.get("message");
            BufferedImage bufferedImage = new VerifyImgUtils(verCode).getBuffImg();
            try {
                ImageIO.write((RenderedImage)bufferedImage, "jpg", (OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                this.logger.error(CODE + ".getVerCode.write", (Throwable)e);
            }
        } else {
            this.logger.error(CODE + ".getVerCode.err", (Object)"\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6 ");
        }
    }

    @RequestMapping(value={"checkUserTenant.json"})
    @ResponseBody
    public HtmlJsonReBean checkUserTenant(HttpServletRequest request, HttpServletResponse response, String userPhone) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userPhone", userPhone);
        param.put("tenantCode", "00000000");
        UmUserReDomainBean umUserReDomainBean = this.userServiceRepository.getUserByNameOrPhone(param);
        if (null == umUserReDomainBean) {
            return new HtmlJsonReBean("error", "\u7528\u6237\u6682\u65e0\u6570\u636e");
        }
        UmUserinfoReDomainBean umUserinfoReDomain = this.userServiceRepository.getUserinfoByCode(umUserReDomainBean.getUserPcode(), "00000000");
        if (null == umUserinfoReDomain) {
            return new HtmlJsonReBean("error", "\u7528\u6237\u6682\u65e0\u6570\u636e");
        }
        if (0 == umUserinfoReDomain.getDataState()) {
            return new HtmlJsonReBean((Object)"\u79df\u6237\u5f00\u901a\u6210\u529f");
        }
        return new HtmlJsonReBean("error", "\u79df\u6237\u5f00\u901a\u5931\u8d25");
    }

    @RequestMapping(value={"loginInByPermission.json"})
    public ResponseEntity<HtmlJsonReBean> loginInByPermission(HttpServletRequest request, HttpServletResponse response, String loginName, String passwd, String code, String redirectURL) {
        UmUserinfoReDomainBean userinfoByCode;
        UmUserinfoReDomainBean userinfoByCode2;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        if (StringUtils.isBlank((String)loginName) || StringUtils.isBlank((String)passwd)) {
            this.logger.error(CODE + ".loginInByPermission", (Object)"param is null");
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null"), (MultiValueMap)headers, HttpStatus.OK);
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", loginName);
        map.put("tenantCode", tenantCode);
        SupQueryResult umUserResult = this.userServiceRepository.queryUserPage(map);
        if (ListUtil.isNotEmpty((Collection)umUserResult.getList()) && 0 != (userinfoByCode2 = this.userServiceRepository.getUserinfoByCode(((UmUserReDomainBean)umUserResult.getList().get(0)).getUserPcode(), tenantCode)).getDataState()) {
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u8ba4\u8bc1\uff01"), (MultiValueMap)headers, HttpStatus.OK);
        }
        map.remove("userName");
        map.put("userinfoPhone", loginName);
        SupQueryResult umUserinfoResult = this.userServiceRepository.queryUserinfoPage(map);
        if (ListUtil.isNotEmpty((Collection)umUserinfoResult.getList()) && 0 != (userinfoByCode = (UmUserinfoReDomainBean)umUserinfoResult.getList().get(0)).getDataState()) {
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u8ba4\u8bc1\uff01"), (MultiValueMap)headers, HttpStatus.OK);
        }
        HtmlJsonReBean htmlJsonReBean = this.login(request, response, loginName, passwd, code, redirectURL);
        return new ResponseEntity((Object)htmlJsonReBean, (MultiValueMap)headers, HttpStatus.OK);
    }
}

