/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mlogin.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.qjsoft.laser.controller.mlogin.util.TspSignException;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import sun.misc.BASE64Encoder;

public class SignUtil {
    private static final SupperLogUtil logger = new SupperLogUtil(SignUtil.class);
    private static final ObjectMapper objectMapper;
    private static final String SKIP_FIELD = "sign";
    private static final String ENC_SHA256 = "SHA-256";
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final BASE64Encoder base64Encode;

    private static String writeValueAsString(Object value) {
        if (value == null) {
            return null;
        }
        String result = null;
        try {
            result = objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new TspSignException(e);
        }
        return result;
    }

    public static boolean checkSign(Object obj, String secretKey, String sign) throws TspSignException {
        return SignUtil.generateSign(obj, secretKey).equals(sign);
    }

    public static String generateSign(Object obj, String secretKey) throws TspSignException {
        String sign;
        if (obj == null) {
            return null;
        }
        try {
            String json = SignUtil.writeValueAsString(obj);
            logger.debug("\u52a0\u7b7e\u7684\u5b57\u7b26\u4e32:{}", (Object)json);
            Map map = (Map)objectMapper.readValue(json, Map.class);
            StringBuilder stb = SignUtil.getStringBuilder(map);
            stb.append("secretKey=").append(secretKey);
            sign = SignUtil.sha256(stb.toString().getBytes(CHARSET_UTF8));
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new TspSignException("\u751f\u6210\u7b7e\u540d\u5931\u8d25", e);
        }
        return sign;
    }

    private static StringBuilder getStringBuilder(Map<String, Object> map) {
        Object[] keyArray = map.keySet().toArray(new String[map.keySet().size()]);
        Arrays.sort(keyArray);
        StringBuilder stb = new StringBuilder();
        for (Object key : keyArray) {
            if (SKIP_FIELD.equalsIgnoreCase((String)key) || map.get(key) == null || StringUtils.isBlank((CharSequence)((String)map.get(key)))) continue;
            stb.append((String)key).append("=").append(map.get(key).toString().trim()).append("&");
        }
        return stb;
    }

    public static String sha256(byte[] src) {
        return SignUtil.hash(src, ENC_SHA256);
    }

    public static String hash(byte[] bt, String encName) {
        if (encName == null || encName.equals("")) {
            encName = ENC_SHA256;
        }
        MessageDigest md = null;
        String strDes = null;
        try {
            md = MessageDigest.getInstance(encName);
            md.update(bt);
            strDes = base64Encode.encode(md.digest()).toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        return strDes;
    }

    static {
        base64Encode = new BASE64Encoder();
        objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

