/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mlogin.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qjsoft.laser.controller.mlogin.util.SignUtil;
import com.qjsoft.laser.controller.mlogin.util.TspResultException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class TspRequestUtil {
    private static final Logger log = LoggerFactory.getLogger(TspRequestUtil.class);
    private final String SCOPE;
    private final String GRANT_TYPE;
    private final String AUTHORIZATION_PREFIX;
    private final String TSP_SERVER_CONTEXT;
    private final String API_OAUTH;
    private final String API_USERINFO;
    private RestTemplate restTemplate = new RestTemplate();
    private ObjectMapper mapper = new ObjectMapper();
    private String tmpToken;

    public TspRequestUtil() {
        this.SCOPE = "wmapi_enter_cust";
        this.GRANT_TYPE = "client_credentials";
        this.AUTHORIZATION_PREFIX = "bearer ";
        this.TSP_SERVER_CONTEXT = "/app-vehicle/";
        this.API_OAUTH = "uaa/oauth/token";
        this.API_USERINFO = "v3/user/getuserwithtoken";
    }

    private void getToken(String tspDomain, String clientId, String clientSecret) throws JsonProcessingException {
        String url = tspDomain + "/" + this.API_OAUTH;
        LinkedMultiValueMap req = new LinkedMultiValueMap();
        req.add((Object)"client_id", (Object)clientId);
        req.add((Object)"client_secret", (Object)clientSecret);
        req.add((Object)"scope", (Object)this.SCOPE);
        req.add((Object)"grant_type", (Object)this.GRANT_TYPE);
        HttpHeaders header = new HttpHeaders();
        header.set("Content-Type", "application/x-www-form-urlencoded");
        log.info("tsp token url: " + url);
        this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)req, (MultiValueMap)header), HashMap.class, new Object[0]);
        log.info("tsp token request: " + this.mapper.writeValueAsString((Object)req));
        Map response = (Map)this.restTemplate.postForObject(url, (Object)req, Map.class, new Object[0]);
        log.info("tsp token response: " + this.mapper.writeValueAsString((Object)response));
        this.tmpToken = (String)response.get("access_token");
    }

    public Map<String, String> userInfoQryByToken(String tspTokenDomain, String tspUserDomain, String clientId, String clientSecret, Map<String, Object> body) throws IOException {
        ResponseEntity resp;
        String url = tspUserDomain + this.TSP_SERVER_CONTEXT + this.API_USERINFO;
        HashMap<String, String> req = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder(clientId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String timestamp = sdf.format(new Date(System.currentTimeMillis()));
        sb.append(timestamp);
        String time = String.valueOf(System.currentTimeMillis());
        sb.append(time.substring(time.length() - 5));
        req.put("transationid", sb.toString());
        req.put("timestamp", timestamp);
        req.put("randomstr", UUID.randomUUID().toString().replaceAll("-", ""));
        String sign = SignUtil.generateSign(body, clientSecret);
        req.put("sign", sign);
        String bodyStr = this.mapper.writeValueAsString(body);
        req.put("body", bodyStr);
        req.put("appId", clientId);
        req.put("apiCode", this.API_USERINFO);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("Authorization", this.AUTHORIZATION_PREFIX + this.tmpToken);
        httpHeaders.set("Content-Type", MediaType.APPLICATION_JSON.toString());
        log.info("tsp user info url: " + url);
        log.info("tsp user info request: " + this.mapper.writeValueAsString(req));
        try {
            resp = this.restTemplate.postForEntity(url, (Object)new HttpEntity(req, (MultiValueMap)httpHeaders), Map.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().value() == 401 || e.getStatusCode().value() == 400) {
                this.getToken(tspTokenDomain, clientId, clientSecret);
                resp = this.restTemplate.postForEntity(url, (Object)new HttpEntity(req, (MultiValueMap)httpHeaders), Map.class, new Object[0]);
            }
            throw e;
        }
        log.info("tsp user info response: " + this.mapper.writeValueAsString((Object)resp));
        if (resp.getStatusCode().value() != 200) {
            throw new TspResultException("TSP\u8bf7\u6c42\u9519\u8bef");
        }
        Map respBody = (Map)resp.getBody();
        if ("200".equals(respBody.get("errorCode"))) {
            String realBody = (String)respBody.get("body");
            if (StringUtils.isEmpty((Object)realBody)) {
                throw new TspResultException("TSP\u8bf7\u6c42\u9519\u8bef");
            }
            Map result = (Map)this.mapper.readValue(realBody, Map.class);
            return result;
        }
        throw new TspResultException("TSP\u8bf7\u6c42\u9519\u8bef");
    }
}

