/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mpr.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.mpr.domain.MpMpriceConfDomain;
import com.qjsoft.laser.controller.facade.mpr.domain.MpMpriceConfReDomain;
import com.qjsoft.laser.controller.facade.mpr.domain.MpMpriceDomain;
import com.qjsoft.laser.controller.facade.mpr.domain.MpMpriceMemDomain;
import com.qjsoft.laser.controller.facade.mpr.domain.MpMpriceMemReDomain;
import com.qjsoft.laser.controller.facade.mpr.domain.MpMpriceReDomain;
import com.qjsoft.laser.controller.facade.mpr.repository.MpMpriceServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmGroupReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UmGroupServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.mpr.controller.MpMpriceComCon;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/mpr/mpMpriceBase"}, name="\u4ef7\u683c\u8bbe\u7f6e\u57fa\u7840\u670d\u52a1")
public class MpMpriceBaseCon
extends MpMpriceComCon {
    private static String CODE = "mpr.mpMpriceBase.con";
    @Autowired
    private MpMpriceServiceRepository mpMpriceServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private UmGroupServiceRepository umGroupServiceRepository;
    protected static String TYPE_PLAT = "plat";
    protected static String TYPE_BUS = "bus";
    protected static String TYPE_USER = "user";

    @Override
    protected String getContext() {
        return "mpMprice";
    }

    @RequestMapping(value={"saveMpMpriceByPlat.json"}, name="\u589e\u52a0\u4ef7\u683c\u8bbe\u7f6e(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean saveMpMpriceByPlat(HttpServletRequest request, String mpMpriceDomain) {
        return this.saveMpMpriceMain(request, mpMpriceDomain, TYPE_PLAT);
    }

    @RequestMapping(value={"queryMpMpricePageByPlat.json"}, name="\u67e5\u8be2\u4ef7\u683c\u8bbe\u7f6e\u5206\u9875\u5217\u8868\uff08\u5e73\u53f0\uff09")
    @ResponseBody
    public SupQueryResult<MpMpriceReDomain> queryMpMpricePageByPlat(HttpServletRequest request) {
        return this.queryMpMpricePage(request, TYPE_PLAT);
    }

    @RequestMapping(value={"saveMpMpriceByPlatMdk.json"}, name="\u589e\u52a0\u4ef7\u683c\u8bbe\u7f6e(\u5e73\u53f0-T)")
    @ResponseBody
    public HtmlJsonReBean saveMpMpriceByPlatMdk(HttpServletRequest request, String mpMpriceDomain) {
        return this.saveMpMpriceMain(request, mpMpriceDomain, TYPE_PLAT);
    }

    @RequestMapping(value={"getMpMpricePageByPlat.json"}, name="\u67e5\u8be2\u4ef7\u683c\u8bbe\u7f6e\u8be6\u60c5\uff08\u5e73\u53f0-T\uff09")
    @ResponseBody
    public MpMpriceReDomain getMpMpricePageByPlat(Integer mpriceId) {
        return this.mpMpriceServiceRepository.getMpMprice(mpriceId);
    }

    @RequestMapping(value={"queryMpMpricePageByPlatMdk.json"}, name="\u67e5\u8be2\u4ef7\u683c\u8bbe\u7f6e\u5206\u9875\u5217\u8868\uff08\u5e73\u53f0-T\uff09")
    @ResponseBody
    public SupQueryResult<MpMpriceReDomain> queryMpMpricePageByPlatMdk(HttpServletRequest request) {
        return this.queryMpMpricePage(request, TYPE_PLAT);
    }

    @RequestMapping(value={"saveMpMpriceByBus.json"}, name="\u589e\u52a0\u4ef7\u683c\u8bbe\u7f6e(\u8fd0\u8425)")
    @ResponseBody
    public HtmlJsonReBean saveMpMpriceByBus(HttpServletRequest request, String mpMpriceDomain) {
        return this.saveMpMpriceMain(request, mpMpriceDomain, TYPE_BUS);
    }

    @RequestMapping(value={"queryMpMpricePageByBus.json"}, name="\u67e5\u8be2\u4ef7\u683c\u8bbe\u7f6e\u5206\u9875\u5217\u8868\uff08\u8fd0\u8425\uff09")
    @ResponseBody
    public SupQueryResult<MpMpriceReDomain> queryMpMpricePageByBus(HttpServletRequest request) {
        return this.queryMpMpricePage(request, TYPE_BUS);
    }

    @RequestMapping(value={"saveMpMpriceByUser.json"}, name="\u589e\u52a0\u4ef7\u683c\u8bbe\u7f6e(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean saveMpMpriceByUser(HttpServletRequest request, String mpMpriceDomain) {
        return this.saveMpMpriceMain(request, mpMpriceDomain, TYPE_USER);
    }

    @RequestMapping(value={"queryMpMpricePageByUser.json"}, name="\u67e5\u8be2\u4ef7\u683c\u8bbe\u7f6e\u5206\u9875\u5217\u8868\uff08\u7528\u6237\uff09")
    @ResponseBody
    public SupQueryResult<MpMpriceReDomain> queryMpMpricePageByUser(HttpServletRequest request) {
        return this.queryMpMpricePage(request, TYPE_USER);
    }

    @RequestMapping(value={"openMpMpriceState.json"}, name="\u542f\u52a8\u4ef7\u683c\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean openMpMpriceState(String mpMpriceId) {
        return this.updateMpMpriceState(mpMpriceId, 1, 0);
    }

    @RequestMapping(value={"startMpMpriceState.json"}, name="\u542f\u52a8\u4ef7\u683c\u8bbe\u7f6e(\u672a\u542f\u52a8)")
    @ResponseBody
    public HtmlJsonReBean startMpMpriceState(String mpMpriceId) {
        return this.updateMpMpriceState(mpMpriceId, 2, null);
    }

    @RequestMapping(value={"restartMpMpriceState.json"}, name="\u542f\u52a8\u4ef7\u683c\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean restartMpMpriceState(String mpMpriceId) {
        return this.updateMpMpriceState(mpMpriceId, 2, -1);
    }

    @RequestMapping(value={"stoppeMpMpriceState.json"}, name="\u5173\u95ed\u4ef7\u683c\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean stoppeMpMpriceState(String mpMpriceId) {
        return this.updateMpMpriceState(mpMpriceId, -1, 2);
    }

    @RequestMapping(value={"openTMpMpriceState.json"}, name="\u542f\u52a8\u4ef7\u683c\u8bbe\u7f6e-T")
    @ResponseBody
    public HtmlJsonReBean openTMpMpriceState(String mpMpriceId) {
        return this.updateMpMpriceState(mpMpriceId, 1, 0);
    }

    @RequestMapping(value={"stoppeTMpMpriceState.json"}, name="\u5173\u95ed\u4ef7\u683c\u8bbe\u7f6e-T")
    @ResponseBody
    public HtmlJsonReBean stoppeTMpMpriceState(String mpMpriceId) {
        return this.updateMpMpriceState(mpMpriceId, -1, 2);
    }

    @RequestMapping(value={"deleteMpMpriceMemByIds.json"}, name="\u6279\u91cf\u5220\u9664\u4ef7\u683c\u8bbe\u7f6e\u7528\u6237\u8303\u56f4")
    @ResponseBody
    public HtmlJsonReBean deleteMpMpriceMemByIds(String mpMpriceMemIds) {
        if (StringUtils.isBlank((String)mpMpriceMemIds)) {
            this.logger.error(CODE + ".deleteMpMpriceMemByIds", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.mpMpriceServiceRepository.deleteMpMpriceMemByIds(this.getMpriceIdList(mpMpriceMemIds));
    }

    @RequestMapping(value={"deleteMpMpriceConfByIds.json"}, name="\u6279\u91cf\u5220\u9664\u4ef7\u683c\u8bbe\u7f6e\u5546\u54c1\u8303\u56f4")
    @ResponseBody
    public HtmlJsonReBean deleteMpMpriceConfByIds(String mpMpriceConfIds) {
        if (StringUtils.isBlank((String)mpMpriceConfIds)) {
            this.logger.error(CODE + ".deleteMpMpriceConfByIds", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.mpMpriceServiceRepository.deleteMpMpriceConfByIds(this.getMpriceIdList(mpMpriceConfIds));
    }

    @RequestMapping(value={"queryMpMpricePage.json"}, name="\u67e5\u8be2\u4ef7\u683c\u8bbe\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<MpMpriceReDomain> queryMpMpricePage(HttpServletRequest request) {
        String userPcodeStr;
        String skuNameStr;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String tenantCode = this.getTenantCode(request);
        StringBuffer mpriceCodeStr = new StringBuffer();
        String skuNoStr = null == param || null == param.get("skuNoStr") ? "" : (String)param.get("skuNoStr");
        String string = skuNameStr = null == param || null == param.get("skuNameStr") ? "" : (String)param.get("skuNameStr");
        if (StringUtils.isNotBlank((String)skuNoStr) && StringUtils.isNotBlank((String)skuNameStr)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("fuzzy", true);
            map.put("tenantCode", tenantCode);
            map.put("mpriceConfType", skuNoStr);
            map.put("mpriceConfValuen", skuNameStr);
            SupQueryResult mpMpriceConfReDomainSupQueryResult = this.mpMpriceServiceRepository.queryMpMpriceConfPage(map);
            if (ListUtil.isNotEmpty((Collection)mpMpriceConfReDomainSupQueryResult.getList())) {
                for (MpMpriceConfReDomain mpMpriceConfReDomain : mpMpriceConfReDomainSupQueryResult.getList()) {
                    mpriceCodeStr.append(mpMpriceConfReDomain.getMpriceCode() + ",");
                }
            }
        }
        String userNameStr = null == param || null == param.get("userNameStr") ? "" : (String)param.get("userNameStr");
        String string2 = userPcodeStr = null == param || null == param.get("userPcodeStr") ? "" : (String)param.get("userPcodeStr");
        if (StringUtils.isNotBlank((String)userNameStr) && StringUtils.isNotBlank((String)userPcodeStr)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("fuzzy", true);
            map.put("tenantCode", tenantCode);
            map.put("mpriceMemType", userPcodeStr);
            map.put("mpriceMemValuen", userNameStr);
            SupQueryResult mpMpriceMemReDomainSupQueryResult = this.mpMpriceServiceRepository.queryMpMpriceMemPage(map);
            if (ListUtil.isNotEmpty((Collection)mpMpriceMemReDomainSupQueryResult.getList())) {
                for (MpMpriceMemReDomain mpMpriceMemReDomain : mpMpriceMemReDomainSupQueryResult.getList()) {
                    mpriceCodeStr.append(mpMpriceMemReDomain.getMpriceCode() + ",");
                }
            }
        }
        if ((StringUtils.isNotBlank((String)skuNameStr) || StringUtils.isNotBlank((String)userNameStr)) && null != mpriceCodeStr && mpriceCodeStr.length() == 0) {
            SupQueryResult mpMpriceReDomainSupQueryResult = new SupQueryResult();
            return mpMpriceReDomainSupQueryResult;
        }
        if (mpriceCodeStr != null && mpriceCodeStr.length() > 0) {
            String mpriceCode = mpriceCodeStr.substring(0, mpriceCodeStr.length() - 1);
            param.put("mpriceCode", mpriceCode);
        }
        return this.mpMpriceServiceRepository.queryMpMpricePage(param);
    }

    @RequestMapping(value={"saveImportMprice.json"}, name="\u5bfc\u5165\u4ef7\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean saveImportMprice(HttpServletRequest request, String mpMpriceDomainStr) {
        try {
            if (null == mpMpriceDomainStr) {
                this.logger.error(CODE + ".saveMpMpriceMain.mpMpriceDomainJson", (Object)"param is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            List mpriceDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(mpMpriceDomainStr, MpMpriceDomain.class);
            UserSession userSession = this.getUserSession(request);
            if (null == userSession) {
                this.logger.error(CODE + ".saveMpMpriceMain.userSession", (Object)"userSession is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            int rowNum = 1;
            ArrayList<MpMpriceDomain> saveList = new ArrayList<MpMpriceDomain>();
            StringBuffer sb = new StringBuffer();
            ArrayList<String> mpNameMList = new ArrayList<String>();
            for (MpMpriceDomain priceDomain : mpriceDomainList) {
                if (ListUtil.isEmpty((Collection)priceDomain.getMpMpriceMemDomainList())) {
                    sb.append("\u7b2c\u3010" + rowNum + "\u3011\u884c,\u4ef7\u683c\u89c4\u5219\u3010" + priceDomain.getMpriceName() + "\u3011\u672a\u5173\u8054\u7528\u6237; \n");
                    continue;
                }
                if (ListUtil.isEmpty((Collection)priceDomain.getMpMpriceConfDomainList())) {
                    sb.append("\u7b2c\u3010" + rowNum + "\u3011\u884c,\u4ef7\u683c\u89c4\u5219\u3010" + priceDomain.getMpriceName() + "\u3011\u672a\u5173\u8054\u5546\u54c1; \n");
                    continue;
                }
                boolean flag = true;
                priceDomain.setMemberCode(this.getTeananMemberCode(request));
                priceDomain.setMemberName("\u5e73\u53f0");
                priceDomain.setTenantCode(this.getTenantCode(request));
                if (!mpNameMList.contains(priceDomain.getMpriceName())) {
                    if (!this.checkMprice("", priceDomain).isSuccess()) {
                        sb.append("\u7b2c\u3010" + rowNum + "\u3011\u884c,\u89c4\u5219\u540d\u79f0\u3010" + priceDomain.getMpriceName() + "\u3011\u5df2\u5b58\u5728; \n");
                        flag = false;
                    }
                    mpNameMList.add(priceDomain.getMpriceName());
                } else {
                    sb.append("\u7b2c\u3010" + rowNum + "\u3011\u884c,\u89c4\u5219\u540d\u79f0\u3010" + priceDomain.getMpriceName() + "\u3011\u91cd\u590d; \n");
                    flag = false;
                }
                String userName = ((MpMpriceMemDomain)priceDomain.getMpMpriceMemDomainList().get(0)).getMpriceMemValuen();
                HtmlJsonReBean reBean = this.checkMprice("member", priceDomain);
                if (!reBean.isSuccess()) {
                    sb.append("\u7b2c\u3010" + rowNum + "\u3011\u884c,\u7528\u6237\u67e5\u8be2\u5931\u8d25,\u8bf7\u68c0\u67e5\u7528\u6237\u3010" + userName + "\u3011\u662f\u5426\u5b58\u5728,\u6216\u5916\u7cfb\u7edf\u7f16\u7801\u662f\u5426\u6b63\u786e; \n");
                    flag = false;
                }
                String skuNo = ((MpMpriceConfDomain)priceDomain.getMpMpriceConfDomainList().get(0)).getMpriceConfValue();
                HtmlJsonReBean reBean1 = this.checkMprice("config", priceDomain);
                if (!reBean1.isSuccess()) {
                    sb.append("\u7b2c\u3010" + rowNum + "\u3011\u884c,\u8bf7\u68c0\u67e5\u5546\u54c1\u3010" + skuNo + "\u3011\u662f\u5426\u5b58\u5728,\u6216\u7f16\u7801\u662f\u5426\u6b63\u786e; \n");
                    flag = false;
                }
                this.logger.error(CODE + "lastmpMpriceDomain+++++mpMpriceDomain==========", (Object)JsonUtil.buildNormalBinder().toJson((Object)mpMpriceDomainStr));
                if (flag) {
                    saveList.add(priceDomain);
                }
                ++rowNum;
            }
            this.logger.error(CODE + "saveImportMprice+++++saveList==========", (Object)JsonUtil.buildNormalBinder().toJson(saveList));
            if (saveList.size() == mpriceDomainList.size()) {
                return this.mpMpriceServiceRepository.saveMpMpriceBatch(saveList);
            }
            return new HtmlJsonReBean("error", sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HtmlJsonReBean();
        }
    }

    private HtmlJsonReBean checkMprice(String type, MpMpriceDomain mpMpriceDomain) {
        this.logger.error(CODE + "checkMprice+++++mpMpriceDomain==========", (Object)JsonUtil.buildNormalBinder().toJson((Object)mpMpriceDomain));
        boolean flag = true;
        String mprName = "";
        if ("config".equals(type)) {
            if (ListUtil.isNotEmpty((Collection)mpMpriceDomain.getMpMpriceMemDomainList())) {
                MpMpriceConfDomain confDomainParam = (MpMpriceConfDomain)mpMpriceDomain.getMpMpriceConfDomainList().get(0);
                String configValue = confDomainParam.getMpriceConfValue();
                ArrayList<MpMpriceConfDomain> confDomains = new ArrayList<MpMpriceConfDomain>();
                MpMpriceConfDomain confDomain = new MpMpriceConfDomain();
                SupQueryResult skuResult = this.rsSkuServiceRepository.querySkuPage(this.getQueryMapParam("tenantCode,skuNo", new Object[]{mpMpriceDomain.getTenantCode(), configValue}));
                if (skuResult == null || ListUtil.isEmpty((Collection)skuResult.getList())) {
                    flag = false;
                } else {
                    RsSkuReDomain skuReDomain = (RsSkuReDomain)skuResult.getList().get(0);
                    confDomain.setMpriceConfDes(skuReDomain.getSkuId().toString());
                    confDomain.setMpriceConfType("skuNo");
                    confDomain.setMpriceConfTerm("=");
                    confDomain.setMpriceConfValuename(skuReDomain.getGoodsMinnum().toString());
                    confDomain.setMpriceConfValue(skuReDomain.getSkuNo());
                    confDomain.setMpriceConfValuen(skuReDomain.getGoodsName());
                    confDomain.setMpriceConfPicurl("");
                    confDomain.setMpriceConfValueno(skuReDomain.getSkuName());
                    confDomain.setMpriceConfPrice(confDomainParam.getMpriceConfPrice());
                }
                confDomains.add(confDomain);
                mpMpriceDomain.setMpMpriceConfDomainList(confDomains);
            }
        } else if ("member".equals(type)) {
            if (ListUtil.isNotEmpty((Collection)mpMpriceDomain.getMpMpriceMemDomainList())) {
                UmGroupReDomain groupResult;
                MpMpriceMemDomain memDomainParam = (MpMpriceMemDomain)mpMpriceDomain.getMpMpriceMemDomainList().get(0);
                String memValue = memDomainParam.getMpriceMemValue();
                String memType = memDomainParam.getMpriceMemType();
                ArrayList<MpMpriceMemDomain> memDomains = new ArrayList<MpMpriceMemDomain>();
                MpMpriceMemDomain memDomain = new MpMpriceMemDomain();
                if (memType.equals("userPcode")) {
                    SupQueryResult userInfoResult = this.userServiceRepository.queryUserinfoPage(this.getQueryMapParam("userinfoOcode,tenantCode", new Object[]{memValue, mpMpriceDomain.getTenantCode()}));
                    if (null == userInfoResult || ListUtil.isEmpty((Collection)userInfoResult.getList())) {
                        flag = false;
                    } else {
                        UmUserinfoReDomainBean userinfo = (UmUserinfoReDomainBean)userInfoResult.getList().get(0);
                        memDomain.setMpriceMemType("userPcode");
                        memDomain.setMpriceMemTerm("=");
                        memDomain.setMpriceMemValue(userinfo.getUserinfoCode());
                        memDomain.setMpriceMemValue1(userinfo.getUserinfoPhone());
                        memDomain.setMpriceMemValuen(userinfo.getUserinfoCompname());
                    }
                } else if (memType.equals("groupCode") && (groupResult = this.umGroupServiceRepository.getGroupByCode(mpMpriceDomain.getTenantCode(), memValue)) == null) {
                    flag = false;
                }
                memDomains.add(memDomain);
                mpMpriceDomain.setMpMpriceMemDomainList(memDomains);
            }
        } else {
            SupQueryResult mpMpriceResult = this.mpMpriceServiceRepository.queryMpMpricePage(this.getQueryMapParam("tenantCode,mpriceName", new Object[]{mpMpriceDomain.getTenantCode(), mpMpriceDomain.getMpriceName()}));
            if (null != mpMpriceResult && ListUtil.isNotEmpty((Collection)mpMpriceResult.getList())) {
                this.logger.error(CODE + ".checkMprice", (Object)"\u4ef7\u683c\u89c4\u5219\u540d\u79f0\u91cd\u590d");
                flag = false;
            }
        }
        if (flag) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean("error", "\u53c2\u6570\u68c0\u67e5\u5931\u8d25", (Object)mprName);
    }
}

