/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.org.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgGroupDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgGroupReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgGroupempReDomain;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgGroupServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/org/group"}, name="\u7fa4\u7ec4\u670d\u52a1")
public class orgGroupCon
extends SpringmvcController {
    private static String CODE = "org.group.con";
    @Autowired
    private OrgGroupServiceRepository orgGroupServiceRepository;
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;

    protected String getContext() {
        return "group";
    }

    @RequestMapping(value={"saveGroup.json"}, name="\u589e\u52a0\u7fa4\u7ec4\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveGroup(HttpServletRequest request, OrgGroupDomain orgGroupDomain) {
        if (null == orgGroupDomain) {
            this.logger.error(CODE + ".saveGroup", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orgGroupDomain.setTenantCode(this.getTenantCode(request));
        return this.orgGroupServiceRepository.saveGroup(orgGroupDomain);
    }

    @RequestMapping(value={"getGroup.json"}, name="\u83b7\u53d6\u7fa4\u7ec4\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OrgGroupReDomain getGroup(Integer groupId) {
        if (StringUtils.isBlank((Integer)groupId)) {
            this.logger.error(CODE + ".getGroup", (Object)"param is null");
            return null;
        }
        return this.orgGroupServiceRepository.getGroup(groupId);
    }

    @RequestMapping(value={"updateGroup.json"}, name="\u66f4\u65b0\u7fa4\u7ec4\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateGroup(HttpServletRequest request, OrgGroupDomain orgGroupDomain) {
        if (null == orgGroupDomain) {
            this.logger.error(CODE + ".updateGroup", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orgGroupDomain.setTenantCode(this.getTenantCode(request));
        return this.orgGroupServiceRepository.updateGroup(orgGroupDomain);
    }

    @RequestMapping(value={"deleteGroup.json"}, name="\u5220\u9664\u7fa4\u7ec4\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteGroup(Integer groupId) {
        if (StringUtils.isBlank((Integer)groupId)) {
            this.logger.error(CODE + ".deleteGroup", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgGroupServiceRepository.deleteGroup(groupId);
    }

    @RequestMapping(value={"queryGroupPage.json"}, name="\u67e5\u8be2\u7fa4\u7ec4\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrgGroupReDomain> queryGroupPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.orgGroupServiceRepository.queryGroupPage(param);
    }

    @RequestMapping(value={"queryEmployeeByGroupCode.json"}, name="\u6839\u636e\u7fa4\u7ec4Code\u67e5\u8be2\u90e8\u95e8\u4e0b\u6240\u5c5e\u5458\u5de5\u4fe1\u606f")
    @ResponseBody
    public List<OrgEmployeeReDomain> queryEmployeeByGroupCode(HttpServletRequest request, String groupCode) {
        if (StringUtils.isBlank((String)groupCode)) {
            this.logger.error(CODE + ".queryEmployeeByGroupCode", (Object)"groupCode is null");
            return null;
        }
        ArrayList<OrgEmployeeReDomain> employeeList = new ArrayList<OrgEmployeeReDomain>();
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> groupmap = new HashMap<String, String>();
        groupmap.put("groupCode", groupCode);
        groupmap.put("tenantCode", tenantCode);
        List groupempList = this.orgGroupServiceRepository.queryGroupempPage(groupmap).getList();
        if (null != groupempList) {
            for (OrgGroupempReDomain orgGroupempReDomain : groupempList) {
                HashMap<String, String> employeemap = new HashMap<String, String>();
                employeemap.put("employeeCode", orgGroupempReDomain.getEmployeeCode());
                employeemap.put("tenantCode", tenantCode);
                List orgemployeeList = this.orgEmployeeServiceRepository.queryEmployeePage(employeemap).getList();
                if (null == orgemployeeList) continue;
                OrgEmployeeReDomain employeeReDomain = (OrgEmployeeReDomain)orgemployeeList.get(0);
                employeeList.add(employeeReDomain);
            }
        }
        return employeeList;
    }

    @RequestMapping(value={"updateGroupState.json"}, name="\u66f4\u65b0\u7fa4\u7ec4\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGroupState(String groupId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)groupId)) {
            this.logger.error(CODE + ".updateGroupState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orgGroupServiceRepository.updateGroupState(Integer.valueOf(groupId), dataState, oldDataState);
    }
}

