/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pay.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.facade.pte.domain.BankHtmlForm;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtfchannelReDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtradeParticipantDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtradeBean;
import com.qjsoft.laser.controller.facade.pte.repository.PtePtradeServiceRepository;
import com.qjsoft.laser.controller.pay.bean.PayChannel;
import com.qjsoft.laser.controller.pay.bean.PayCommit;
import com.qjsoft.laser.controller.pay.bean.PayInfo;
import com.qjsoft.laser.controller.pay.facade.PayServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pte/pay"}, name="\u7528\u6237\u652f\u4ed8\u670d\u52a1")
public class PayCon
extends SpringmvcController {
    private static String CODE = "pte.pay.con";
    @Autowired
    private PtePtradeServiceRepository ptePtradeServiceRepository;
    @Autowired
    PayServiceRepository payServiceRepository;

    protected String getContext() {
        return "pay";
    }

    @RequestMapping(value={"saveOrderToPay.json"}, name="\u652f\u4ed8\u4e0b\u5355")
    @ResponseBody
    public PayInfo saveOrderToPay(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".saveOrderToPay.contractBillcode", (Object)"contractBillcode is null");
            return null;
        }
        String oauthEnvCode = this.getOauthEnvCode();
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".saveOrderToPay.oauthEnvCode", (Object)"oauthEnvCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveOrderToPay.userSession", (Object)"userSession is null");
            return null;
        }
        PayInfo payInfo = this.payServiceRepository.savePay(userSession.getUserPcode(), contractBillcode, "PAY", this.getTenantCode(request));
        if (null == payInfo) {
            return null;
        }
        List<PayChannel> payChannelList = this.payServiceRepository.getPayChannel(userSession.getUserPcode(), oauthEnvCode, this.getTenantCode(request), "PAY");
        payInfo.setPayChannelList(payChannelList);
        return payInfo;
    }

    @RequestMapping(value={"paymentCommit.json"}, name="\u652f\u4ed8\u786e\u8ba4")
    @ResponseBody
    public BankHtmlForm paymentCommit(HttpServletRequest request, String payCommitStr, String ptradeSeqno) {
        if (StringUtils.isBlank((String)ptradeSeqno) || StringUtils.isBlank((String)payCommitStr)) {
            this.logger.error(CODE + ".paymentCommit.contractBillcode", (Object)"contractBillcode is null");
            return null;
        }
        String oauthEnvCode = this.getOauthEnvCode();
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".paymentCommit.oauthEnvCode", (Object)"oauthEnvCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".paymentCommit.userSession", (Object)"userSession is null");
            return null;
        }
        List payCommitList = (List)JsonUtil.buildNormalBinder().getJsonToList(payCommitStr, PayCommit.class);
        String tenantCode = this.getTenantCode(request);
        if (null == payCommitList || payCommitList.isEmpty()) {
            return null;
        }
        Map<String, PtePtfchannelReDomain> channelMap = this.payServiceRepository.queryChannel(oauthEnvCode, tenantCode, "PAY");
        if (null == channelMap || channelMap.isEmpty()) {
            return null;
        }
        ArrayList<PtePtradeParticipantDomain> ptradeParticipantList = new ArrayList<PtePtradeParticipantDomain>();
        String fchannelMode = "0";
        for (PayCommit payCommit : payCommitList) {
            PtePtfchannelReDomain ptePtfchannelReDomain = channelMap.get(payCommit.getFchannelCode());
            if (null == ptePtfchannelReDomain) {
                return null;
            }
            PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)ptePtfchannelReDomain);
                BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)payCommit);
                ptePtradeParticipantDomain.setFchannelClassifyCode(ptePtfchannelReDomain.getFchannelType());
                fchannelMode = ptePtfchannelReDomain.getFchannelModel();
            }
            catch (Exception e) {
                this.logger.error(CODE + ".paymentCommit.e", (Throwable)e);
                return null;
            }
            ptradeParticipantList.add(ptePtradeParticipantDomain);
        }
        PtradeBean ptradeBean = new PtradeBean();
        ptradeBean.setPtradeSeqno(ptradeSeqno);
        ptradeBean.setPartList(ptradeParticipantList);
        ptradeBean.setTenantCode(tenantCode);
        ptradeBean.setFchannelMode(fchannelMode);
        BankHtmlForm bankHtmlForm = this.ptePtradeServiceRepository.sendParticipantByPtrade(ptradeBean);
        return bankHtmlForm;
    }

    @RequestMapping(value={"mockQj.json"}, name="\u652f\u4ed8mock\uff08\u5343\u5320\u652f\u4ed8\uff09")
    public void mockQj(HttpServletRequest request, HttpServletResponse response) {
        Map map = this.getQueryMapParams(request);
        Object out_trade_no = map.get("out_trade_no");
        Object tenantCode = map.get("tenantCode");
        Object notify_url = map.get("notify_url");
        Object return_url = map.get("return_url");
        HashMap mapRead = new HashMap();
        mapRead.put("seller_account_name", map.get("seller_account_name"));
        mapRead.put("total_fee", map.get("total_fee"));
        mapRead.put("subject", map.get("subject"));
        mapRead.put("seller_id", map.get("seller_id"));
        mapRead.put("partner", map.get("partner"));
        mapRead.put("seller_email", map.get("seller_email"));
        mapRead.put("out_trade_no", out_trade_no);
        StringBuffer html = new StringBuffer();
        html.append("<!DOCTYPE html>");
        html.append("<html><head><title>mock\u652f\u4ed8--\u5343\u5320</title><meta charset=\"utf-8\"></head>");
        html.append("<body>");
        String htmlStr = null;
        for (Map.Entry entry : mapRead.entrySet()) {
            htmlStr = "<label>#{map.key}</label><input type=\"text\" name=\"#{map.key}\" value=\"#{map.value}\" readonly=\"true\"/><br/>";
            htmlStr = htmlStr.replace("#{map.key}", (CharSequence)entry.getKey()).replace("#{map.value}", entry.getValue().toString());
            html.append(htmlStr);
        }
        HashMap<String, Long> mapModify = new HashMap<String, Long>();
        mapModify.put("trade_no", System.currentTimeMillis());
        for (Map.Entry entry : mapModify.entrySet()) {
            htmlStr = "<label>#{map.key}</label><input type=\"text\" name=\"#{map.key}\" value=\"#{map.value}\"/><br/>";
            htmlStr = htmlStr.replace("#{map.key}", (CharSequence)entry.getKey()).replace("#{map.value}", entry.getValue().toString());
            html.append(htmlStr);
        }
        html.append("<input type=\"submit\" value=\"\u6210\u529f\" onclick=\"ajax('TRADE_SUCCESS','#{notify_url}');\">".replace("#{notify_url}", notify_url.toString()));
        html.append("<input type=\"button\" value=\"\u5931\u8d25\" onclick=\"ajax('TRADE_FAULURE','#{notify_url}');\">".replace("#{notify_url}", notify_url.toString()));
        html.append("</body>");
        html.append("</html>");
        html.append("<script>");
        html.append("var xhr = new XMLHttpRequest();");
        html.append("var formData = new FormData();");
        html.append("formData.append('exterface', 'trade_status_sync');");
        html.append("formData.append('out_trade_no', '#{out_trade_no}');".replace("#{out_trade_no}", out_trade_no.toString()));
        html.append("formData.append('tenantCode', '#{tenantCode}');".replace("#{tenantCode}", tenantCode.toString()));
        html.append("xhr.withCredentials = true;");
        html.append("function ajax(trade_status, url) {");
        html.append("formData.append('trade_status', trade_status);");
        html.append("xhr.open('POST', url);");
        html.append("xhr.send(formData);");
        html.append("xhr.onreadystatechange = function () {");
        html.append("if (xhr.readyState==4 &&xhr.status==200) {");
        html.append("if(xhr.responseText == \"\") {");
        html.append("location.href = '#{return_url}';".replace("#{return_url}", return_url.toString()));
        html.append("}");
        html.append("}");
        html.append("}");
        html.append("}");
        html.append("</script>");
        try {
            response.getWriter().print(html.toString());
        }
        catch (IOException e) {
            this.logger.error(CODE + ".mockQj.print.ex", (Throwable)e);
        }
    }
}

