/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pay.facade;

import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtfchannelReDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtradeDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtradeReDomain;
import com.qjsoft.laser.controller.facade.pte.repository.PtePtfchannelServiceRepository;
import com.qjsoft.laser.controller.facade.pte.repository.PtePtradeServiceRepository;
import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountInfo;
import com.qjsoft.laser.controller.facade.vd.repository.VdFaccountServiceRepository;
import com.qjsoft.laser.controller.pay.bean.PayChannel;
import com.qjsoft.laser.controller.pay.bean.PayInfo;
import com.qjsoft.laser.controller.pay.bean.PteConstants;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PayServiceRepository
extends SupperFacade {
    public static final String SYS_CODE = "web.pay.PayServiceRepository";
    public static final String FCHANNELDR_PAY = "PAY";
    @Autowired
    private PtePtfchannelServiceRepository ptePtfchannelServiceRepository;
    @Autowired
    private PtePtradeServiceRepository ptePtradeServiceRepository;
    @Autowired
    private VdFaccountServiceRepository vdFaccountServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;

    public PayInfo savePay(String memberBcode, String contractBillcode, String fchannelPmodeCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        if (null == ocContractReDomain || !ocContractReDomain.getMemberBcode().equals(memberBcode)) {
            this.logger.error("web.pay.PayServiceRepository.savePay.null", (Object)(memberBcode + "=" + ((Object)map).toString()));
            return null;
        }
        if (ocContractReDomain.getDataState() != 1) {
            this.logger.error("web.pay.PayServiceRepository.savePay.contract.dataState", (Object)("\u8ba2\u5355\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8\u3002\u72b6\u6001=" + ocContractReDomain.getDataState()));
            return null;
        }
        String ptradeSeqno = ocContractReDomain.getPtradeSeqno();
        if (StringUtils.isNotBlank((String)ptradeSeqno)) {
            map.put("ptradeSeqno", ptradeSeqno);
            PtePtradeReDomain ptePtradeReDomain = this.ptePtradeServiceRepository.getPtradeByCode(map);
            if (null == ptePtradeReDomain) {
                ptradeSeqno = "";
            } else if (PteConstants.DATA_STATE_0 == ptePtradeReDomain.getDataState() || PteConstants.DATA_STATE_1 == ptePtradeReDomain.getDataState() || PteConstants.DATA_STATE_2 == ptePtradeReDomain.getDataState()) {
                if (!fchannelPmodeCode.equals(ptePtradeReDomain.getFchannelPmodeCode())) {
                    ptradeSeqno = "";
                }
            } else if (ocContractReDomain.getContractMoney().subtract(ptePtradeReDomain.getOrderAmount()).intValue() != 0) {
                ptradeSeqno = "";
            }
        }
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
            ptePtradeDomain.setOrderAmount(ocContractReDomain.getContractMoney());
            ptePtradeDomain.setPtradeType("03");
            ptePtradeDomain.setPartnerCode(ocContractReDomain.getMemberCode());
            ptePtradeDomain.setBusinessOrderno(contractBillcode);
            ptePtradeDomain.setPaymentMemo(contractBillcode);
            ptePtradeDomain.setOpuserCode(ocContractReDomain.getMemberBcode());
            ptePtradeDomain.setOpuserName(ocContractReDomain.getMemberBname());
            ptePtradeDomain.setPtradpdeCode("PAYMENT");
            ptePtradeDomain.setTenantCode(tenantCode);
            ptePtradeDomain.setMerchantCode(ocContractReDomain.getMemberCode());
            ptePtradeDomain.setFchannelPmodeCode(fchannelPmodeCode);
            ptePtradeDomain.setPaymentNotifyurl("oc.contractEngine.saveContracPay");
            ptradeSeqno = this.ptePtradeServiceRepository.sendSavePtrade(ptePtradeDomain);
            HashMap<String, String> contractTradeMap = new HashMap<String, String>();
            contractTradeMap.put("contractBillcode", ocContractReDomain.getContractBillcode());
            contractTradeMap.put("ptradeSeqno", ptradeSeqno);
            contractTradeMap.put("tenantCode", ocContractReDomain.getTenantCode());
            this.ocContractServiceRepository.updateContractPtradeSeqno(contractTradeMap);
        }
        PayInfo payInfo = new PayInfo();
        payInfo.setPtradeSeqno(ptradeSeqno);
        payInfo.setContractBillcode(contractBillcode);
        payInfo.setFchannelPmodeCode(fchannelPmodeCode);
        payInfo.setMemberBcode(memberBcode);
        payInfo.setOrderMoney(ocContractReDomain.getDataBmoney());
        return payInfo;
    }

    public Map<String, PtePtfchannelReDomain> queryChannel(String fchannelPmodeCode, String tenantCode, String fchannelDr) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fchannelPmodeCode", fchannelPmodeCode);
        map.put("tenantCode", tenantCode);
        map.put("fchannelDr", fchannelDr);
        List list = this.ptePtfchannelServiceRepository.queryPtfchannelReList(map);
        if (null == list || list.isEmpty()) {
            return null;
        }
        HashMap<String, PtePtfchannelReDomain> channelmap = new HashMap<String, PtePtfchannelReDomain>();
        for (PtePtfchannelReDomain ptePtfchannelReDomain : list) {
            channelmap.put(ptePtfchannelReDomain.getFchannelCode(), ptePtfchannelReDomain);
        }
        return channelmap;
    }

    public List<PayChannel> getPayChannel(String memberCode, String fchannelPmodeCode, String tenantCode, String fchannelDr) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)fchannelDr)) {
            return null;
        }
        String type = memberCode.substring(0, 1);
        String faccountType = "101";
        if ("2".equals(type)) {
            faccountType = "201";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fchannelPmodeCode", fchannelPmodeCode);
        map.put("tenantCode", tenantCode);
        map.put("fchannelDr", fchannelDr);
        List qlist = this.ptePtfchannelServiceRepository.queryPtfchannelReList(map);
        if (null == qlist || qlist.isEmpty()) {
            this.logger.error("web.pay.PayServiceRepository.getPayChannel.null", (Object)((Object)map).toString());
            return null;
        }
        List vdList = this.vdFaccountServiceRepository.queryOuterFaccount(memberCode, faccountType, tenantCode);
        HashMap<String, VdFaccountInfo> account = new HashMap<String, VdFaccountInfo>();
        if (null != vdList && !vdList.isEmpty()) {
            for (VdFaccountInfo v : vdList) {
                account.put(v.getFaccountType(), v);
            }
        }
        ArrayList<PayChannel> channelList = new ArrayList<PayChannel>();
        for (PtePtfchannelReDomain ptePtfchannelReDomain : qlist) {
            PayChannel payChannel;
            if ("BANK".equals(ptePtfchannelReDomain.getDicActorCode())) {
                payChannel = new PayChannel();
                try {
                    BeanUtils.copyAllPropertys((Object)payChannel, (Object)ptePtfchannelReDomain);
                }
                catch (Exception e) {
                    this.logger.error("web.pay.PayServiceRepository.getPayChannel.e", (Throwable)e);
                }
                channelList.add(payChannel);
                continue;
            }
            if (!faccountType.equals(ptePtfchannelReDomain.getFchannelType())) continue;
            payChannel = new PayChannel();
            try {
                BeanUtils.copyAllPropertys((Object)payChannel, (Object)ptePtfchannelReDomain);
                VdFaccountInfo v = (VdFaccountInfo)account.get(ptePtfchannelReDomain.getFchannelType());
                if (null != v) {
                    BeanUtils.copyAllPropertys((Object)payChannel, (Object)v);
                }
            }
            catch (Exception e) {
                this.logger.error("web.pay.PayServiceRepository.getPayChannel.e1", (Throwable)e);
            }
            channelList.add(payChannel);
        }
        return channelList;
    }
}

