/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pay.controller;

import com.alibaba.fastjson.JSONObject;
import com.qjsoft.laser.controller.pay.bean.Json;
import com.qjsoft.laser.controller.pay.bean.OAuthJsToken;
import com.qjsoft.laser.controller.pay.utils.IpUtils;
import com.qjsoft.laser.controller.pay.utils.PayUtil;
import com.qjsoft.laser.controller.pay.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.weixin4j.WeixinException;
import org.weixin4j.WeixinSupport;
import org.weixin4j.http.HttpsClient;
import org.weixin4j.http.Response;

@RequestMapping(value={"/web/pte/weixin"})
@Controller
public class WeixinController
extends WeixinSupport {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String appid = "";
    private static final String secret = "";
    private static final String grant_type = "authorization_code";

    @RequestMapping(value={"login.json"}, name="\u8fd4\u56deopenID")
    @ResponseBody
    public Map<String, Object> login(String code, HttpServletRequest request) throws WeixinException, IOException {
        if (code == null || code.equals("")) {
            throw new WeixinException("invalid null, code is null.");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String param = "?grant_type=authorization_code&appid=&secret=&js_code=" + code;
        HttpsClient http = new HttpsClient();
        Response res = http.get("https://api.weixin.qq.com/sns/jscode2session" + param);
        JSONObject jsonObj = res.asJSONObject();
        if (jsonObj != null) {
            Object errcode = jsonObj.get((Object)"errcode");
            if (errcode != null) {
                throw new WeixinException(this.getCause(Integer.parseInt(errcode.toString())));
            }
            ObjectMapper mapper = new ObjectMapper();
            OAuthJsToken oauthJsToken = (OAuthJsToken)mapper.readValue(jsonObj.toJSONString(), OAuthJsToken.class);
            this.logger.info("openid=" + oauthJsToken.getOpenid());
            ret.put("openid", oauthJsToken.getOpenid());
        }
        return ret;
    }

    @RequestMapping(value={"wxPay.json"}, name="\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8")
    @ResponseBody
    public Json wxPay(String openid, HttpServletRequest request) {
        Json json = new Json();
        try {
            String nonce_str = StringUtils.getRandomStringByLength(32);
            String body = "\u6d4b\u8bd5\u5546\u54c1\u540d\u79f0";
            String spbill_create_ip = IpUtils.getIpAddr(request);
            String orderNo = "123456789";
            String money = "1";
            Map<String, String> packageParams = new HashMap<String, String>();
            packageParams.put("appid", "wx9235763e5f3b180c ");
            packageParams.put("mch_id", "1526464211");
            packageParams.put("nonce_str", nonce_str);
            packageParams.put("body", body);
            packageParams.put("out_trade_no", orderNo);
            packageParams.put("total_fee", money);
            packageParams.put("spbill_create_ip", spbill_create_ip);
            packageParams.put("notify_url", "https://??/??/weixin/api/wxNotify");
            packageParams.put("trade_type", "JSAPI");
            packageParams.put("openid", openid);
            packageParams = PayUtil.paraFilter(packageParams);
            String prestr = PayUtil.createLinkString(packageParams);
            String mysign = PayUtil.sign(prestr, "e4ulflENkUqOKieCn3Qqq88NkGLP0X1P", "utf-8").toUpperCase();
            this.logger.info("=======================\u7b2c\u4e00\u6b21\u7b7e\u540d\uff1a" + mysign + "=====================");
            String xml = "<xml><appid>wx9235763e5f3b180c </appid><body><![CDATA[" + body + "]]></body>" + "<mch_id>" + "1526464211" + "</mch_id>" + "<nonce_str>" + nonce_str + "</nonce_str>" + "<notify_url>" + "https://??/??/weixin/api/wxNotify" + "</notify_url>" + "<openid>" + openid + "</openid>" + "<out_trade_no>" + orderNo + "</out_trade_no>" + "<spbill_create_ip>" + spbill_create_ip + "</spbill_create_ip>" + "<total_fee>" + money + "</total_fee>" + "<trade_type>" + "JSAPI" + "</trade_type>" + "<sign>" + mysign + "</sign>" + "</xml>";
            System.out.println("\u8c03\u8bd5\u6a21\u5f0f_\u7edf\u4e00\u4e0b\u5355\u63a5\u53e3 \u8bf7\u6c42XML\u6570\u636e\uff1a" + xml);
            String result = PayUtil.httpRequest("https://api.mch.weixin.qq.com/pay/unifiedorder", "POST", xml);
            System.out.println("\u8c03\u8bd5\u6a21\u5f0f_\u7edf\u4e00\u4e0b\u5355\u63a5\u53e3 \u8fd4\u56deXML\u6570\u636e\uff1a" + result);
            Map map = PayUtil.doXMLParse(result);
            String return_code = (String)map.get("return_code");
            HashMap<String, String> response = new HashMap<String, String>();
            if (return_code == "SUCCESS" || return_code.equals(return_code)) {
                String prepay_id = (String)map.get("prepay_id");
                response.put("nonceStr", nonce_str);
                response.put("package", "prepay_id=" + prepay_id);
                Long timeStamp = System.currentTimeMillis() / 1000L;
                response.put("timeStamp", timeStamp + "");
                String stringSignTemp = "appId=wx9235763e5f3b180c &nonceStr=" + nonce_str + "&package=prepay_id=" + prepay_id + "&signType=" + "MD5" + "&timeStamp=" + timeStamp;
                String paySign = PayUtil.sign(stringSignTemp, "e4ulflENkUqOKieCn3Qqq88NkGLP0X1P", "utf-8").toUpperCase();
                this.logger.info("=======================\u7b2c\u4e8c\u6b21\u7b7e\u540d\uff1a" + paySign + "=====================");
                response.put("paySign", paySign);
            }
            response.put("appid", "wx9235763e5f3b180c ");
            json.setSuccess(true);
            json.setData(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setSuccess(false);
            json.setMsg("\u53d1\u8d77\u5931\u8d25");
        }
        return json;
    }

    @RequestMapping(value={"wxNotify.json"}, name="\u5fae\u4fe1\u652f\u4ed8")
    @ResponseBody
    public void wxNotify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        String notityXml = sb.toString();
        String resXml = "";
        System.out.println("\u63a5\u6536\u5230\u7684\u62a5\u6587\uff1a" + notityXml);
        Map map = PayUtil.doXMLParse(notityXml);
        String returnCode = (String)map.get("return_code");
        if ("SUCCESS".equals(returnCode)) {
            if (PayUtil.verify(PayUtil.createLinkString(map), (String)map.get("sign"), "e4ulflENkUqOKieCn3Qqq88NkGLP0X1P", "utf-8")) {
                resXml = "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml> ";
            }
        } else {
            resXml = "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u62a5\u6587\u4e3a\u7a7a]]></return_msg></xml> ";
        }
        System.out.println(resXml);
        System.out.println("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u6570\u636e\u7ed3\u675f");
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        out.write(resXml.getBytes());
        out.flush();
        out.close();
    }
}

