/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pay.thread;

import com.alibaba.fastjson.JSON;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.da.repository.DataInDataPinganServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractEngineServiceRepository;
import com.qjsoft.laser.controller.pay.PayList;
import com.qjsoft.laser.controller.pay.bean.PayInfoVo;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class PayStateRunnableImpl
implements Runnable {
    private static final String CODE = "PayStateRunnableImpl";
    private DataInDataPinganServiceRepository dataInDataPinganServiceRepository;
    private OcContractEngineServiceRepository ocContractEngineServiceRepository;
    private SupperLogUtil logger;
    private UserSession userSession;
    private Map<String, Object> contractNoMap;
    private String paymentMemo;
    private String tenantCode;

    public PayStateRunnableImpl(DataInDataPinganServiceRepository dataInDataPinganServiceRepository, OcContractEngineServiceRepository ocContractEngineServiceRepository, SupperLogUtil logger, UserSession userSession, Map<String, Object> contractNoMap, String paymentMemo, String tenantCode) {
        this.dataInDataPinganServiceRepository = dataInDataPinganServiceRepository;
        this.ocContractEngineServiceRepository = ocContractEngineServiceRepository;
        this.logger = logger;
        this.userSession = userSession;
        this.contractNoMap = contractNoMap;
        this.paymentMemo = paymentMemo;
        this.tenantCode = tenantCode;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(3000L);
            HtmlJsonReBean htmlJsonReBean = this.dataInDataPinganServiceRepository.queryPaymentStatus(this.paymentMemo, this.tenantCode);
            if (!htmlJsonReBean.isSuccess() || htmlJsonReBean.getDataObj() == null || StringUtils.isBlank((String)htmlJsonReBean.getDataObj().toString())) {
                this.logger.error("PayStateRunnableImpl.queryPaymentStatus.error");
                return;
            }
            PayInfoVo payInfoVo = (PayInfoVo)JSON.parseObject((String)htmlJsonReBean.getDataObj().toString(), PayInfoVo.class);
            if (payInfoVo == null) {
                this.logger.error("PayStateRunnableImpl.queryPaymentStatus.payInfoVo is null");
                return;
            }
            if ("3".equals(payInfoVo.getBatchStatus())) {
                for (PayList payList : payInfoVo.getPayList()) {
                    if (!"2".equals(payList.getBusinessStatus()) || this.contractNoMap.get(payList.getOuterBusinessId()) == null || !this.contractNoMap.get(payList.getOuterBusinessId()).toString().equals(payList.getOuterBusinessId())) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("userCode", this.userSession.getUserCode());
                    map.put("userName", this.userSession.getUserName());
                    this.ocContractEngineServiceRepository.sendContractNext(payList.getOuterBusinessId(), this.tenantCode, map);
                }
            } else {
                if ("1".equals(payInfoVo.getBatchStatus())) {
                    this.logger.error("PayStateRunnableImpl.queryPaymentStatus.error.\u652f\u4ed8\u5931\u8d25", (Object)JSON.toJSONString((Object)payInfoVo));
                    return;
                }
                if ("0".equals(payInfoVo.getBatchStatus())) {
                    this.logger.error("PayStateRunnableImpl.queryPaymentStatus.error.\u652f\u4ed8\u4e2d", (Object)JSON.toJSONString((Object)payInfoVo));
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

