/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pay.wft.service;

import com.qjsoft.laser.controller.pay.wft.SwiftpassConfig;
import com.qjsoft.laser.controller.pay.wft.bean.BusinessPayBean;
import com.qjsoft.laser.controller.pay.wft.util.SignUtil;
import com.qjsoft.laser.controller.pay.wft.util.SignUtils;
import com.qjsoft.laser.controller.pay.wft.util.XmlUtils;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GateWayService {
    private static final Logger log = LoggerFactory.getLogger(GateWayService.class);
    private static final String version = "2.0";
    private static final String charset = "UTF-8";
    private static final String sign_type = "MD5";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> pay(HttpServletRequest req, HttpServletResponse resp, BusinessPayBean businessPayBean) throws ServletException, IOException {
        log.info("\u652f\u4ed8\u8bf7\u6c42...");
        SortedMap map = XmlUtils.getParameterMap(req);
        String reqUrl = SwiftpassConfig.req_url;
        String mch_id = SwiftpassConfig.mch_id;
        String notify_url = SwiftpassConfig.notify_url;
        map.put("service", "pay.weixin.jspay");
        map.put("version", version);
        map.put("charset", charset);
        map.put("sign_type", "RSA_1_256");
        map.put("is_raw", "1");
        map.put("mch_id", mch_id);
        map.put("notify_url", notify_url);
        map.put("nonce_str", String.valueOf(new Date().getTime()));
        map.put("mch_create_ip", GateWayService.getRealIpAddress(req));
        Map<String, String> params = SignUtils.paraFilter(map);
        StringBuilder buf = new StringBuilder((params.size() + 1) * 10);
        SignUtils.buildPayParams(buf, params, false);
        String preStr = buf.toString();
        String sign_type = (String)map.get("sign_type");
        map.put("sign", SignUtil.getSign(sign_type, preStr));
        map.put("is_minipg", businessPayBean.getIs_minipg());
        map.put("out_trade_no", businessPayBean.getOut_trade_no());
        map.put("body", businessPayBean.getBody());
        map.put("sub_openid", businessPayBean.getSub_openid());
        map.put("sub_appid", businessPayBean.getSub_appid());
        map.put("total_fee", businessPayBean.getTotal_fee() + "");
        log.info("reqUrl\uff1a" + reqUrl);
        log.info("\u8bf7\u6c42xml\uff1a" + XmlUtils.toXml(map));
        log.info("reqParams:" + XmlUtils.parseXML(map));
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String res = null;
        Map<String, String> resultMap = null;
        try {
            HttpPost httpPost = new HttpPost(reqUrl);
            StringEntity entityParams = new StringEntity(XmlUtils.parseXML(map), "utf-8");
            httpPost.setEntity((HttpEntity)entityParams);
            httpPost.setHeader("Content-Type", "text/xml;utf-8");
            client = HttpClients.createDefault();
            response = client.execute((HttpUriRequest)httpPost);
            if (response != null && response.getEntity() != null) {
                resultMap = XmlUtils.toMap(EntityUtils.toByteArray((HttpEntity)response.getEntity()), "utf-8");
                String reSign = resultMap.get("sign");
                sign_type = resultMap.get("sign_type");
                res = XmlUtils.toXml(resultMap);
                log.info("\u8bf7\u6c42\u7ed3\u679cresultMap\uff1a{}", resultMap);
                log.info("\u8bf7\u6c42\u7ed3\u679cres\uff1a{}", (Object)res);
                if (resultMap.containsKey("sign") && !SignUtil.verifySign(reSign, sign_type, resultMap)) {
                    res = "\u9a8c\u8bc1\u7b7e\u540d\u4e0d\u901a\u8fc7";
                } else if ("0".equals(resultMap.get("status")) && "0".equals(resultMap.get("result_code"))) {
                    String pay_info = resultMap.get("pay_info");
                    log.info("pay_info :{} ", (Object)pay_info);
                    res = "ok";
                }
            } else {
                res = "\u64cd\u4f5c\u5931\u8d25";
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            res = "\u7cfb\u7edf\u5f02\u5e38";
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if ("ok".equals(res)) {
            result = resultMap;
        } else {
            result.put("status", "500");
            result.put("msg", res);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> query(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.info("\u8ba2\u5355\u67e5\u8be2...");
        SortedMap map = XmlUtils.getParameterMap(req);
        map.put("service", "unified.trade.query");
        map.put("version", version);
        map.put("charset", charset);
        map.put("mch_id", SwiftpassConfig.mch_id);
        String key = SwiftpassConfig.key;
        String reqUrl = SwiftpassConfig.req_url;
        map.put("nonce_str", String.valueOf(new Date().getTime()));
        Map<String, String> params = SignUtils.paraFilter(map);
        StringBuilder buf = new StringBuilder((params.size() + 1) * 10);
        SignUtils.buildPayParams(buf, params, false);
        String preStr = buf.toString();
        String sign_type = (String)map.get("sign_type");
        map.put("sign", SignUtil.getSign(sign_type, preStr));
        log.info("reqUrl:" + reqUrl);
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String res = null;
        try {
            HttpPost httpPost = new HttpPost(reqUrl);
            StringEntity entityParams = new StringEntity(XmlUtils.parseXML(map), "utf-8");
            httpPost.setEntity((HttpEntity)entityParams);
            httpPost.setHeader("Content-Type", "text/xml;utf-8");
            client = HttpClients.createDefault();
            response = client.execute((HttpUriRequest)httpPost);
            if (response != null && response.getEntity() != null) {
                Map<String, String> resultMap = XmlUtils.toMap(EntityUtils.toByteArray((HttpEntity)response.getEntity()), "utf-8");
                String reSign = resultMap.get("sign");
                sign_type = resultMap.get("sign_type");
                res = XmlUtils.toXml(resultMap);
                System.out.println("\u7b7e\u540d\u65b9\u5f0f" + sign_type);
                log.info("\u8bf7\u6c42\u7ed3\u679c\uff1a" + res);
                System.out.println("\u8bf7\u6c42\u7ed3\u679c\uff1a" + res);
                if (resultMap.containsKey("sign") && !SignUtil.verifySign(reSign, sign_type, resultMap)) {
                    res = "\u9a8c\u8bc1\u7b7e\u540d\u4e0d\u901a\u8fc7";
                } else if ("0".equals(resultMap.get("status"))) {
                    if ("0".equals(resultMap.get("result_code"))) {
                        log.info("\u4e1a\u52a1\u6210\u529f\uff0c\u5728\u8fd9\u91cc\u505a\u76f8\u5e94\u7684\u903b\u8f91\u5904\u7406");
                        String trade_state = resultMap.get("trade_state");
                        log.info("trade_state : " + trade_state);
                        log.info("\u8fd9\u91cc\u5546\u6237\u9700\u8981\u540c\u6b65\u81ea\u5df1\u7684\u8ba2\u5355\u72b6\u6001\u3002\u3002\u3002");
                    } else {
                        log.info("\u4e1a\u52a1\u5931\u8d25\uff0c\u5c1d\u8bd5\u91cd\u65b0\u8bf7\u6c42\uff0c\u5e76\u67e5\u770b\u9519\u8bef\u4ee3\u7801\u63cf\u53d9");
                    }
                } else {
                    log.info("\u8fd9\u91cc\u662f\u8bf7\u6c42\u53c2\u6570\u6709\u95ee\u9898...");
                }
            } else {
                res = "\u64cd\u4f5c\u5931\u8d25!";
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            res = "\u64cd\u4f5c\u5931\u8d25";
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (res.startsWith("<")) {
            result.put("status", "200");
            result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff0c\u8bf7\u5728\u65e5\u5fd7\u6587\u4ef6\u4e2d\u67e5\u770b");
        } else {
            result.put("status", "500");
            result.put("msg", res);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> refundQuery(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.info("\u9000\u6b3e\u67e5\u8be2...");
        SortedMap map = XmlUtils.getParameterMap(req);
        map.put("service", "unified.trade.refundquery");
        map.put("version", version);
        map.put("charset", charset);
        String key = SwiftpassConfig.key;
        String reqUrl = SwiftpassConfig.req_url;
        map.put("mch_id", SwiftpassConfig.mch_id);
        map.put("nonce_str", String.valueOf(new Date().getTime()));
        Map<String, String> params = SignUtils.paraFilter(map);
        StringBuilder buf = new StringBuilder((params.size() + 1) * 10);
        SignUtils.buildPayParams(buf, params, false);
        String preStr = buf.toString();
        String sign_type = (String)map.get("sign_type");
        map.put("sign", SignUtil.getSign(sign_type, preStr));
        log.info("reqUrl:" + reqUrl);
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String res = null;
        try {
            HttpPost httpPost = new HttpPost(reqUrl);
            StringEntity entityParams = new StringEntity(XmlUtils.parseXML(map), "utf-8");
            httpPost.setEntity((HttpEntity)entityParams);
            httpPost.setHeader("Content-Type", "text/xml;utf-8");
            client = HttpClients.createDefault();
            response = client.execute((HttpUriRequest)httpPost);
            if (response != null && response.getEntity() != null) {
                Map<String, String> resultMap = XmlUtils.toMap(EntityUtils.toByteArray((HttpEntity)response.getEntity()), "utf-8");
                String reSign = resultMap.get("sign");
                sign_type = resultMap.get("sign_type");
                res = XmlUtils.toXml(resultMap);
                System.out.println("\u7b7e\u540d\u65b9\u5f0f" + sign_type);
                log.info("\u8bf7\u6c42\u7ed3\u679c\uff1a" + res);
                System.out.println("\u8bf7\u6c42\u7ed3\u679c\uff1a" + res);
                if (resultMap.containsKey("sign") && !SignUtil.verifySign(reSign, sign_type, resultMap)) {
                    res = "\u9a8c\u8bc1\u7b7e\u540d\u4e0d\u901a\u8fc7";
                }
            } else {
                res = "\u64cd\u4f5c\u5931\u8d25!";
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            res = "\u64cd\u4f5c\u5931\u8d25";
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (res.startsWith("<")) {
            result.put("status", "200");
            result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff0c\u8bf7\u5728\u65e5\u5fd7\u6587\u4ef6\u4e2d\u67e5\u770b");
        } else {
            result.put("status", "500");
            result.put("msg", res);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> refund(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.info("\u9000\u6b3e...");
        SortedMap map = XmlUtils.getParameterMap(req);
        map.put("service", "unified.trade.refund");
        map.put("version", version);
        map.put("charset", charset);
        String key = SwiftpassConfig.key;
        String reqUrl = SwiftpassConfig.req_url;
        map.put("mch_id", SwiftpassConfig.mch_id);
        map.put("op_user_id", SwiftpassConfig.mch_id);
        map.put("nonce_str", String.valueOf(new Date().getTime()));
        Map<String, String> params = SignUtils.paraFilter(map);
        StringBuilder buf = new StringBuilder((params.size() + 1) * 10);
        SignUtils.buildPayParams(buf, params, false);
        String preStr = buf.toString();
        String sign_type = (String)map.get("sign_type");
        map.put("sign", SignUtil.getSign(sign_type, preStr));
        log.info("reqUrl:" + reqUrl);
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String res = null;
        try {
            HttpPost httpPost = new HttpPost(reqUrl);
            StringEntity entityParams = new StringEntity(XmlUtils.parseXML(map), "utf-8");
            httpPost.setEntity((HttpEntity)entityParams);
            httpPost.setHeader("Content-Type", "text/xml;utf-8");
            client = HttpClients.createDefault();
            response = client.execute((HttpUriRequest)httpPost);
            if (response != null && response.getEntity() != null) {
                Map<String, String> resultMap = XmlUtils.toMap(EntityUtils.toByteArray((HttpEntity)response.getEntity()), "utf-8");
                String reSign = resultMap.get("sign");
                sign_type = resultMap.get("sign_type");
                res = XmlUtils.toXml(resultMap);
                log.info("\u7b7e\u540d\u65b9\u5f0f:{}\uff1a", (Object)sign_type);
                log.info("\u8bf7\u6c42\u7ed3\u679c:{}\uff1a", (Object)res);
                if (resultMap.containsKey("sign") && !SignUtil.verifySign(reSign, sign_type, resultMap)) {
                    res = "\u9a8c\u8bc1\u7b7e\u540d\u4e0d\u901a\u8fc7";
                }
            } else {
                res = "\u64cd\u4f5c\u5931\u8d25!";
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            res = "\u64cd\u4f5c\u5931\u8d25";
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (res.startsWith("<")) {
            result.put("status", "200");
            result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff0c\u8bf7\u5728\u65e5\u5fd7\u6587\u4ef6\u4e2d\u67e5\u770b");
        } else {
            result.put("status", "500");
            result.put("msg", res);
        }
        return result;
    }

    public static String getRealIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

