/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.promotion.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDisDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionMemDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionReDomain;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsClassServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class PromotionSupCon
extends SpringmvcController {
    private static String CODE = "pm.promotionsup.con";
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;
    @Autowired
    private RsGoodsClassServiceRepository rsGoodsClassServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    protected static String TYPE_PLAT = "plat";
    protected static String TYPE_BUS = "bus";
    protected static String TYPE_USER = "user";

    protected String getContext() {
        return "promotionsup";
    }

    protected PmPromotionReDomain getPromotionPro(HttpServletRequest request, Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    protected PmPromotionReDomain getPromotionByCodePro(HttpServletRequest request, String promotionCode) {
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".getPromotionByCode", (Object)"param is null");
            return null;
        }
        return this.pmPromotionServiceRepository.getPromotionByCode(this.getTenantCode(request), promotionCode);
    }

    protected HtmlJsonReBean updatePromotionStatePro(String promotionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), dataState, oldDataState);
    }

    protected HtmlJsonReBean deletePromotionPlus(String promotionId) {
        String[] pidStrArray;
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".deletePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String pidStr : pidStrArray = promotionId.split(",")) {
            PmPromotionReDomain promotion = this.pmPromotionServiceRepository.getPromotion(Integer.valueOf(Integer.parseInt(pidStr)));
            if (null == promotion || promotion.getDataState() != 0) {
                this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
            }
            this.pmPromotionServiceRepository.deletePromotion(Integer.valueOf(Integer.parseInt(pidStr)));
        }
        return new HtmlJsonReBean();
    }

    protected HtmlJsonReBean promotionStateStart(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(1), Integer.valueOf(3));
    }

    protected HtmlJsonReBean promotionStateStop(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(3), Integer.valueOf(1));
    }

    protected SupQueryResult<PmPromotionReDomain> promotionPageAll(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    protected SupQueryResult<PmPromotionReDomain> promotionPage(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode, Integer promotionOrgin) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
            if (null != promotionOrgin) {
                param.put("promotionOrgin", promotionOrgin);
            }
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    protected PmPromotionReDomain getPromotionplus(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error(CODE + ".getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionId);
        return pmPromotionReDomain;
    }

    protected HtmlJsonReBean updatePromotionPlus(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updatePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain.getPromotionId()) {
            this.logger.error(CODE + ".updatePromotion.PromotionId", (Object)"promotionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getUserName());
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionDomain.getPromotionId());
        if (null == pmPromotionReDomain || pmPromotionReDomain.getDataState() != 0) {
            this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        return this.pmPromotionServiceRepository.updatePromotion(promotionDomain);
    }

    protected HtmlJsonReBean savePromotionPlus(HttpServletRequest request, String paramStr, String channelCode, String memberCode, String pbCode) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        promotionDomain.setPbCode(pbCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            ArrayList<PmPromotionDisDomain> pmPromotionDisLists = new ArrayList<PmPromotionDisDomain>();
            PmPromotionDisDomain pmPromotionDisDomain = new PmPromotionDisDomain();
            pmPromotionDisDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            pmPromotionDisDomain.setChannelName(userSession.getUserName());
            pmPromotionDisDomain.setMemberCode(userSession.getUserPcode());
            pmPromotionDisDomain.setMemberName(userSession.getUserName());
            pmPromotionDisLists.add(pmPromotionDisDomain);
            promotionDomain.setPmPromotionDisList(pmPromotionDisLists);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            ArrayList<PmPromotionMemDomain> pmPromotionMemlists = new ArrayList<PmPromotionMemDomain>();
            PmPromotionMemDomain pmPromotionMemDomain = new PmPromotionMemDomain();
            pmPromotionMemDomain.setMemberCode(userSession.getUserPcode());
            pmPromotionMemDomain.setMemberName(userSession.getUserName());
            pmPromotionMemlists.add(pmPromotionMemDomain);
            promotionDomain.setPmPromotionMemList(pmPromotionMemlists);
        }
        promotionDomain.setAppmanageIcode(this.getProappCode(request));
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getMerberCompname());
        return this.pmPromotionServiceRepository.savePromotion(promotionDomain);
    }

    protected SupQueryResult<RsSkuReDomain> querySkuMotherPage(HttpServletRequest request, String type, String userMemberCode) {
        Map param = null;
        if (StringUtils.isBlank((String)type) && StringUtils.isNotBlank((String)userMemberCode) && null != (param = this.assemMapParam(request))) {
            param.put("memberCode", userMemberCode);
        }
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            param = this.checkMemquaPlat(request) ? this.getPlatMemberCodeQueryMapParams(request) : this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_PLAT.equals(type)) {
            param = this.getPlatMemberCodeQueryMapParams(request);
        } else if (TYPE_BUS.equals(type)) {
            param = this.getBusMemberCodeQueryMapParams(request);
        } else if (TYPE_USER.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        }
        if (null != param && null != param.get("goodsClassParentcode") && StringUtils.isNotBlank((String)param.get("goodsClassParentcode").toString())) {
            List classList = this.rsGoodsClassServiceRepository.getGoodsClass((String)param.get("goodsClassParentcode"), (String)param.get("goodsClassType"), this.getNowChannel(request), this.getTenantCode(request));
            if (ListUtil.isNotEmpty((Collection)classList)) {
                String classtreeCode = "";
                for (String string : classList) {
                    if (StringUtils.isNotBlank((String)classtreeCode)) {
                        classtreeCode = classtreeCode + ",";
                    }
                    classtreeCode = classtreeCode + string;
                }
                param.put("classtreeCode", classtreeCode);
            } else {
                return null;
            }
        }
        return this.querySkuMain(param);
    }

    protected SupQueryResult<RsSkuReDomain> querySkuMain(Map<String, Object> param) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }
}

