/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.promotion.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.es.domain.AccurateQueryDomain;
import com.qjsoft.laser.controller.facade.es.domain.ReturnBean;
import com.qjsoft.laser.controller.facade.es.domain.SearchDomain;
import com.qjsoft.laser.controller.facade.es.domain.SortDomain;
import com.qjsoft.laser.controller.facade.es.repository.SearchengineServiceRepository;
import com.qjsoft.laser.controller.facade.pm.domain.PmCheckBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDisDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionInDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionMemDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PromotionConstants;
import com.qjsoft.laser.controller.facade.pm.domain.SkuBean;
import com.qjsoft.laser.controller.facade.pm.domain.UserBean;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionConditionServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionCouponServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionDiscountServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsClasstreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsPntreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pm/promotion"}, name="\u8425\u9500\u670d\u52a1")
public class PromotionCon
extends SpringmvcController {
    private static String CODE = "pm.promotion.con";
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;
    @Autowired
    private RsBrandServiceRepository rsBrandServiceRepository;
    @Autowired
    private RsPntreeServiceRepository rsPntreeServiceRepository;
    @Autowired
    private RsClasstreeServiceRepository rsClasstreeServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private PmPromotionCouponServiceRepository pmPromotionCouponServiceRepository;
    @Autowired
    private PmPromotionConditionServiceRepository pmPromotionConditionServiceRepository;
    @Autowired
    private PmPromotionDiscountServiceRepository pmPromotionDiscountServiceRepository;
    @Autowired
    private SearchengineServiceRepository searchengineServiceRepository;
    public static final Integer ORGIN_0 = 0;
    public static final Integer ORGIN_1 = 1;
    public static final Integer ORGIN_2 = 2;

    protected String getContext() {
        return "promotion";
    }

    @RequestMapping(value={"updatePromotionStateAudit.json"}, name="\u5ba1\u6838\u6ee1\u51cf\u8425\u9500\u670d\u52a1\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateAudit(String promotionId, String memo) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionStateAudit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(4), Integer.valueOf(0));
    }

    @RequestMapping(value={"updatePromotionStateNoAudit.json"}, name="\u5ba1\u6838\u6ee1\u51cf\u8425\u9500\u670d\u52a1\u62d2\u7edd")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateNoAudit(String promotionId, String memo) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionStateNoAudit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(5), Integer.valueOf(0));
    }

    @RequestMapping(value={"savePromotion.json"}, name="\u589e\u52a0\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotion(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionFullGift.json"}, name="\u589e\u52a0\u6ee1\u8d60\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionFullGift(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionFullReduction.json"}, name="\u589e\u52a0\u6ee1\u51cf\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionFullReduction(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionFullDiscount.json"}, name="\u589e\u52a0\u6ee1\u6298\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionFullDiscount(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionDiscount.json"}, name="\u589e\u52a0\u6298\u6263\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionDiscount(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionCasheQuivalent.json"}, name="\u589e\u52a0\u4ee3\u91d1\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionCasheQuivalent(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, null);
    }

    @RequestMapping(value={"savePromotionYunying.json"}, name="\u8fd0\u8425\u589e\u52a0\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionYunying(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, "channelCode", null);
    }

    @RequestMapping(value={"savePromotionMem.json"}, name="\u5546\u5bb6\u589e\u52a0\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean savePromotionMem(HttpServletRequest request, String paramStr) {
        return this.savePromotionPlus(request, paramStr, null, "memberCode");
    }

    private HtmlJsonReBean savePromotionPlus(HttpServletRequest request, String paramStr, String channelCode, String memberCode) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".savePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".savePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (StringUtils.isNotBlank((String)channelCode)) {
            ArrayList<PmPromotionDisDomain> pmPromotionDisLists = new ArrayList<PmPromotionDisDomain>();
            PmPromotionDisDomain pmPromotionDisDomain = new PmPromotionDisDomain();
            pmPromotionDisDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            pmPromotionDisDomain.setChannelName(userSession.getUserName());
            pmPromotionDisDomain.setMemberCode(userSession.getUserPcode());
            pmPromotionDisDomain.setMemberName(userSession.getUserName());
            pmPromotionDisLists.add(pmPromotionDisDomain);
            promotionDomain.setPmPromotionDisList(pmPromotionDisLists);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            ArrayList<PmPromotionMemDomain> pmPromotionMemlists = new ArrayList<PmPromotionMemDomain>();
            PmPromotionMemDomain pmPromotionMemDomain = new PmPromotionMemDomain();
            pmPromotionMemDomain.setMemberCode(userSession.getUserPcode());
            pmPromotionMemDomain.setMemberName(userSession.getUserName());
            pmPromotionMemlists.add(pmPromotionMemDomain);
            promotionDomain.setPmPromotionMemList(pmPromotionMemlists);
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getMerberCompname());
        promotionDomain.setAppmanageIcode(this.getProappCode(request));
        return this.pmPromotionServiceRepository.savePromotion(promotionDomain);
    }

    @RequestMapping(value={"getPromotion.json"}, name="\u83b7\u53d6\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotion(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionFullGift.json"}, name="\u83b7\u53d6\u6ee1\u8d60\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionFullGift(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionFullReduction.json"}, name="\u83b7\u53d6\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionFullReduction(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionFullDiscount.json"}, name="\u83b7\u53d6\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionFullDiscount(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionDiscount.json"}, name="\u83b7\u53d6\u6298\u6263\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionDiscount(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionCasheQuivalent.json"}, name="\u83b7\u53d6\u4ee3\u91d1\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionCasheQuivalent(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"getPromotionByCode.json"}, name="\u83b7\u53d6\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotionByCode(HttpServletRequest request, String promotionCode) {
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".getPromotionByCode", (Object)"param is null");
            return null;
        }
        return this.pmPromotionServiceRepository.getPromotionByCode(this.getTenantCode(request), promotionCode);
    }

    private PmPromotionReDomain getPromotionplus(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error(CODE + ".getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionId);
        return pmPromotionReDomain;
    }

    @RequestMapping(value={"updatePromotion.json"}, name="\u66f4\u65b0\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotion(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    @RequestMapping(value={"updatePromotionFullDiscount.json"}, name="\u66f4\u65b0\u6ee1\u6298\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionFullDiscount(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    @RequestMapping(value={"updatePromotionFullGift.json"}, name="\u66f4\u65b0\u6ee1\u8d60\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionFullGift(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    @RequestMapping(value={"updatePromotionFullReduction.json"}, name="\u66f4\u65b0\u6ee1\u51cf\u6298\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionFullReduction(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    @RequestMapping(value={"updatePromotionDiscount.json"}, name="\u66f4\u65b0\u6298\u6263\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionDiscount(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    @RequestMapping(value={"updatePromotionCasheQuivalent.json"}, name="\u66f4\u65b0\u4ee3\u91d1\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updatePromotionCasheQuivalent(HttpServletRequest request, String paramStr) {
        return this.updatePromotionPlus(request, paramStr);
    }

    private HtmlJsonReBean updatePromotionPlus(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updatePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain.getPromotionId()) {
            this.logger.error(CODE + ".updatePromotion.PromotionId", (Object)"promotionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getUserName());
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionDomain.getPromotionId());
        if (null == pmPromotionReDomain || pmPromotionReDomain.getDataState() == 1 || pmPromotionReDomain.getDataState() == 2 || pmPromotionReDomain.getDataState() == 3) {
            this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        return this.pmPromotionServiceRepository.updatePromotion(promotionDomain);
    }

    @RequestMapping(value={"deletePromotion.json"}, name="\u5220\u9664\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePromotion(String promotionId) {
        return this.deletePromotionPlus(promotionId);
    }

    @RequestMapping(value={"deletePromotionFullGift.json"}, name="\u5220\u9664\u6ee1\u8d60\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePromotionFullGift(String promotionId) {
        return this.deletePromotionPlus(promotionId);
    }

    @RequestMapping(value={"deletePromotionFullDiscount.json"}, name="\u5220\u9664\u6ee1\u6298\u8425\u9500\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deletePromotionFullDiscount(String promotionId) {
        return this.deletePromotionPlus(promotionId);
    }

    private HtmlJsonReBean deletePromotionPlus(String promotionId) {
        String[] pidStrArray;
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".deletePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String pidStr : pidStrArray = promotionId.split(",")) {
            PmPromotionReDomain promotion = this.pmPromotionServiceRepository.getPromotion(Integer.valueOf(Integer.parseInt(pidStr)));
            if (null == promotion || promotion.getDataState() == 1 || promotion.getDataState() == 2 || promotion.getDataState() == 3) {
                this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
            }
            this.pmPromotionServiceRepository.deletePromotion(Integer.valueOf(Integer.parseInt(pidStr)));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryPromotionAllPage.json"}, name="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u53d1\u5e03\u6240\u6709\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionAllPage(HttpServletRequest request) {
        return this.promotionPage(request, null, null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionChannelPage.json"}, name="\u67e5\u8be2\u6240\u6709\u6e20\u9053\u63a8\u9001\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionChannelPage(HttpServletRequest request) {
        return this.promotionPage(request, null, null, null, ORGIN_1);
    }

    @RequestMapping(value={"queryPromotionCenterPage.json"}, name="\u67e5\u8be2\u6240\u6709\u4e2d\u95f4\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionCenterPage(HttpServletRequest request) {
        return this.promotionPage(request, null, null, null, ORGIN_2);
    }

    @RequestMapping(value={"queryPromotioPage.json"}, name="\u67e5\u8be2\u6240\u6709\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotioPage(HttpServletRequest request) {
        return this.promotionPage(request, null, null, null, null);
    }

    @RequestMapping(value={"queryPromotionPage.json"}, name="\u67e5\u8be2\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPage(HttpServletRequest request) {
        return this.promotionPage(request, "0002", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageFullDiscount.json"}, name="\u67e5\u8be2\u6ee1\u6298\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageFulldiscount(HttpServletRequest request) {
        return this.promotionPage(request, "0006", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageCasheQuivalent.json"}, name="\u67e5\u8be2\u4ee3\u91d1\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageCasheQuivalent(HttpServletRequest request) {
        return this.promotionPage(request, "0003", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageFullGift.json"}, name="\u67e5\u8be2\u6ee1\u8d60\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageFullGift(HttpServletRequest request) {
        return this.promotionPage(request, "0001", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageFullReduction.json"}, name="\u67e5\u8be2\u6ee1\u51cf\u5377\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageFullReduction(HttpServletRequest request) {
        return this.promotionPage(request, "0004", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageDiscount.json"}, name="\u67e5\u8be2\u6298\u6263\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageDiscount(HttpServletRequest request) {
        return this.promotionPage(request, "0005", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageFreeShipping.json"}, name="\u67e5\u8be2\u5305\u90ae\u8425\u9500\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageFreeShipping(HttpServletRequest request) {
        return this.promotionPage(request, null, null, null, ORGIN_0);
    }

    private SupQueryResult<PmPromotionReDomain> promotionPage(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode, Integer promotionOrgin) {
        Map param = this.assemMapMemberParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return null;
        }
        if (null != param) {
            param.put("memberCode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
            if (null != promotionOrgin) {
                param.put("promotionOrgin", promotionOrgin);
            }
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    @RequestMapping(value={"updatePromotionState.json"}, name="\u66f4\u65b0\u8425\u9500\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePromotionState(String promotionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), dataState, oldDataState);
    }

    @RequestMapping(value={"updatePromotionStateStop.json"}, name="\u6ee1\u51cf\u8425\u9500\u670d\u52a1\u7ec8\u6b62")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStop(String promotionId) {
        return this.promotionStateStop(promotionId);
    }

    @RequestMapping(value={"updatePromotionStateStopDiscount.json"}, name="\u6298\u6263\u8425\u9500\u670d\u52a1\u7ec8\u6b62")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStopDiscount(String promotionId) {
        return this.promotionStateStop(promotionId);
    }

    @RequestMapping(value={"updatePromotionStateStopCasheQuivalent.json"}, name="\u4ee3\u91d1\u8425\u9500\u670d\u52a1\u7ec8\u6b62")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStopCasheQuivalent(String promotionId) {
        return this.promotionStateStop(promotionId);
    }

    private HtmlJsonReBean promotionStateStop(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(3), Integer.valueOf(1));
    }

    @RequestMapping(value={"updatePromotionStateStart.json"}, name="\u6ee1\u51cf\u8425\u9500\u670d\u52a1\u5f00\u59cb")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStart(String promotionId) {
        return this.promotionStateStart(promotionId);
    }

    @RequestMapping(value={"updatePromotionStateStartDiscount.json"}, name="\u6298\u6263\u8425\u9500\u670d\u52a1\u5f00\u59cb")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStartDiscount(String promotionId) {
        return this.promotionStateStart(promotionId);
    }

    @RequestMapping(value={"updatePromotionStateStartCasheQuivalent.json"}, name="\u4ee3\u91d1\u8425\u9500\u670d\u52a1\u5f00\u59cb")
    @ResponseBody
    public HtmlJsonReBean updatePromotionStateStartCasheQuivalent(String promotionId) {
        return this.promotionStateStart(promotionId);
    }

    private HtmlJsonReBean promotionStateStart(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(1), Integer.valueOf(3));
    }

    @RequestMapping(value={"queryPromotionListByGoodsCode.json"}, name="\u83b7\u53d6\u8425\u9500\u6d3b\u52a8\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public List<PmPromotionInDomain> queryPromotionListByGoodsCode(HttpServletRequest request, SkuBean skuBean) {
        if (null == (skuBean = this.makeSkuBean(request, skuBean))) {
            return null;
        }
        return this.pmPromotionServiceRepository.queryPromotionPmBySku(skuBean);
    }

    private SkuBean makeSkuBean(HttpServletRequest request, SkuBean skuBean) {
        if (null == skuBean) {
            this.logger.error(CODE + ".queryPromotionListByGoodsCode.param", (Object)"param is null");
            return null;
        }
        skuBean.setTenantCode(this.getTenantCode(request));
        skuBean.setMemberCcode(this.getMemberCcode(request));
        PmCheckBean pmCheckBean = new PmCheckBean();
        pmCheckBean.setChannelCode(this.getNowChannel(request));
        pmCheckBean.setProappCode(this.getProappCode(request));
        pmCheckBean.setTenantCode(skuBean.getTenantCode());
        UserSession userSession = this.getUserSession(request);
        if (null != userSession) {
            UserBean userBean = new UserBean();
            userBean.setMemberCode(userSession.getUserPcode());
            userBean.setMemberName(userSession.getMerberCompname());
            userBean.setProappCode(userSession.getProappCode());
            userBean.setTenantCode(userSession.getTenantCode());
            userBean.setUserCode(userSession.getUserCode());
            userBean.setUserName(userSession.getUserName());
            HashMap<String, Object> userMap = new HashMap<String, Object>();
            userBean.setUserMap(userMap);
            userMap.put("areaCode", userSession.getAreaCode());
            userMap.put("groupCode", userSession.getGroupCode());
            userMap.put("userinfoType", userSession.getUserinfoType());
            userMap.put("userinfoLevel", userSession.getUserinfoLevel());
            userMap.put("provinceCode", userSession.getProvinceCode());
            pmCheckBean.setUserBean(userBean);
        }
        skuBean.setPmCheckBean(pmCheckBean);
        return skuBean;
    }

    @RequestMapping(value={"queryCouponListBySkuCode.json"}, name="\u83b7\u53d6\u4f18\u60e0\u5238\u5217\u8868(\u53ef\u4ee5\u4e0d\u7528\u4f20skuCode\u548c\u767b\u5f55)")
    @ResponseBody
    public List<PmPromotionInDomain> queryCouponListBySkuCode(HttpServletRequest request, SkuBean skuBean) {
        if (null == (skuBean = this.makeSkuBean(request, skuBean))) {
            return null;
        }
        return this.pmPromotionServiceRepository.queryPromotionConBySku(skuBean);
    }

    private List<String> getStr(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        str = str.substring(1, str.length() - 1);
        List<String> strsToList1 = Arrays.asList(str.split("\\|"));
        return strsToList1;
    }

    public static void main(String[] args) {
        String str = "|2a|b2|c3|";
        str = str.substring(1, str.length() - 1);
        List<String> strsToList1 = Arrays.asList(str.split("\\|"));
        System.out.println(strsToList1);
    }

    @RequestMapping(value={"getPmPromotionInfo.json"}, name="\u83b7\u53d6\u8425\u9500\u4fe1\u606f")
    @ResponseBody
    public PmPromotionInDomain getPmPromotionInfo(HttpServletRequest request, String promotionCode) {
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".getPmPromotionInfo", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String cacheKey = promotionCode + "-" + tenantCode;
        PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)SupDisUtil.getMapJson((String)"pm-promotion", (String)cacheKey, PmPromotionInDomain.class);
        return pmPromotionInDomain;
    }

    @RequestMapping(value={"getPromotionGoods.json"}, name="\u83b7\u53d6\u53c2\u4e0e\u8425\u9500\u7684\u5546\u54c1\u5217\u8868")
    @ResponseBody
    public SupQueryResult<Map<String, Object>> getPromotionGoods(HttpServletRequest request, String promotionCode) {
        String channelCode;
        String str;
        List<String> strList;
        String memberCcode;
        AccurateQueryDomain accurateQueryDomain;
        String str2;
        List<String> strList2;
        String searchParam;
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".getPromotionGoods", (Object)"param is null");
            return null;
        }
        Map map = this.assemMapParam(request);
        String tenantCode = this.getTenantCode(request);
        String cacheKey = promotionCode + "-" + tenantCode;
        PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)SupDisUtil.getMapJson((String)"pm-promotion", (String)cacheKey, PmPromotionInDomain.class);
        if (null == pmPromotionInDomain) {
            return null;
        }
        ArrayList<AccurateQueryDomain> accurateQueryList = new ArrayList<AccurateQueryDomain>();
        String proappCode = this.getProappCode(request);
        if (null != pmPromotionInDomain.getPromotionTer() && pmPromotionInDomain.getPromotionTer() == 1) {
            String promotionTerstr = pmPromotionInDomain.getPromotionTerstr();
            if (StringUtils.isBlank((String)promotionTerstr)) {
                this.logger.error(CODE + ".promotionCode.promotionTerstr", (Object)"param is null");
                return null;
            }
            if (promotionTerstr.indexOf("|" + proappCode + "|") < 0) {
                this.logger.error(CODE + ".promotionCode.proappCode", (Object)(proappCode + ":" + promotionTerstr));
                return null;
            }
        }
        if (StringUtils.isNotBlank((String)(searchParam = (String)map.get("searchParam")))) {
            try {
                searchParam = URLDecoder.decode(searchParam, "UTF-8");
            }
            catch (Exception e) {
                this.logger.error(CODE + ".find.searchParam", (Throwable)e);
            }
        }
        if (null != pmPromotionInDomain.getPromotionDis() && pmPromotionInDomain.getPromotionDis() == 1 && ListUtil.isNotEmpty(strList2 = this.getStr(str2 = pmPromotionInDomain.getChannelCode()))) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("channelCode");
            accurateQueryDomain.setAccurateFieldValues(strList2);
            accurateQueryList.add(accurateQueryDomain);
        }
        if (StringUtils.isNotBlank((String)(memberCcode = this.getMemberCcode(request)))) {
            AccurateQueryDomain accurateQueryDomain2 = new AccurateQueryDomain();
            accurateQueryDomain2.setAccurateField("memberCcode.keyword");
            accurateQueryDomain2.setAccurateFieldValue(memberCcode);
            accurateQueryList.add(accurateQueryDomain2);
        }
        if (null != pmPromotionInDomain.getPromotionMem() && pmPromotionInDomain.getPromotionMem() == 1 && ListUtil.isNotEmpty(strList = this.getStr(str = pmPromotionInDomain.getPpmemMemcode()))) {
            AccurateQueryDomain accurateQueryDomain3 = new AccurateQueryDomain();
            accurateQueryDomain3.setAccurateField("memberCode");
            accurateQueryDomain3.setAccurateFieldValues(strList);
            accurateQueryList.add(accurateQueryDomain3);
        }
        if (null != pmPromotionInDomain.getRangeType() && pmPromotionInDomain.getRangeType().intValue() != PromotionConstants.RANGE_TYPE_0.intValue()) {
            str = pmPromotionInDomain.getRangeCode();
            strList = this.getStr(str);
            String codeName = "";
            if (pmPromotionInDomain.getRangeType().intValue() != PromotionConstants.RANGE_TYPE_1.intValue()) {
                if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_2.intValue()) {
                    codeName = "pntreeCode";
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_3.intValue()) {
                    codeName = "brandCode";
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_4.intValue()) {
                    codeName = "classtreeCode";
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_5.intValue()) {
                    codeName = "skuNo";
                }
            }
            if (ListUtil.isNotEmpty(strList)) {
                AccurateQueryDomain accurateQueryDomain4 = new AccurateQueryDomain();
                accurateQueryDomain4.setAccurateField(codeName);
                accurateQueryDomain4.setAccurateFieldValues(strList);
                accurateQueryList.add(accurateQueryDomain4);
            }
        }
        if (StringUtils.isNotBlank((String)(channelCode = this.getNowChannel(request)))) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("channelCode");
            accurateQueryDomain.setAccurateFieldValue(channelCode);
            accurateQueryList.add(accurateQueryDomain);
        }
        SearchDomain searchDomain = new SearchDomain();
        HashMap<String, String> smap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)searchParam)) {
            smap.put("skuName", searchParam);
            smap.put("goodsName", searchParam);
            smap.put("brandName", searchParam);
            smap.put("goodsProperty", searchParam);
        }
        searchDomain.setBoolMap(smap);
        searchDomain.setBoolMap(smap);
        searchDomain.setBizType("sku");
        if (StringUtils.isNotBlank((String)((String)map.get("bizType"))) && map.get("bizType").equals("goods")) {
            searchDomain.setBizType("goods");
        }
        searchDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, Integer> pageMap = new HashMap<String, Integer>();
        Integer page = (Integer)map.get("page");
        Integer rows = (Integer)map.get("rows");
        int page1 = StringUtils.isBlank((Integer)page) ? 1 : page;
        int rows1 = StringUtils.isBlank((Integer)rows) ? 10 : rows;
        pageMap.put("page", page1);
        pageMap.put("rows", rows1);
        searchDomain.setPageMap(pageMap);
        searchDomain.setAccurateQueryList(accurateQueryList);
        if (null != map.get("minPrice") && StringUtils.isNotBlank((String)((String)map.get("minPrice")))) {
            searchDomain.setMinPrice(Double.valueOf((String)map.get("minPrice")));
        }
        if (null != map.get("maxPrice") && StringUtils.isNotBlank((String)((String)map.get("maxPrice")))) {
            searchDomain.setMaxPrice(Double.valueOf((String)map.get("maxPrice")));
        }
        String sortField = (String)map.get("sortField");
        String order = (String)map.get("order");
        if (StringUtils.isNotBlank((String)sortField)) {
            SortDomain sortDomain = new SortDomain();
            sortDomain.setSortField(sortField);
            if (StringUtils.isBlank((String)order)) {
                order = "desc";
            }
            sortDomain.setOrder(order);
            searchDomain.setSortDomain(sortDomain);
        }
        SupQueryResult queryResult = new SupQueryResult();
        ReturnBean returnBean = this.searchengineServiceRepository.find(searchDomain);
        if (null == returnBean) {
            return queryResult;
        }
        queryResult.setList(returnBean.getSourcelist());
        SupPageTools supPageTools = new SupPageTools();
        supPageTools.setRecordCount(returnBean.getCount());
        supPageTools.setPageSize(rows1);
        supPageTools.setPageNo(page1);
        queryResult.setPageTools(supPageTools);
        queryResult.setTotal((long)returnBean.getCount());
        return queryResult;
    }

    @RequestMapping(value={"queryCouponList.json"}, name="\u83b7\u53d6\u6240\u6709\u4f18\u60e0\u5238")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryCouponList(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("dataState", 1);
            param.put("promotionInType", "1");
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    @RequestMapping(value={"querySkuByPromotionRange.json"}, name="\u67e5\u8be2\u4f18\u60e0\u5238\u5bf9\u5e94\u7684\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuByPromotionRange(String tenantCode, String promotionCode, String orderStr) {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".querySkuByPromotionRange", (Object)"tenantCode is null");
            return null;
        }
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".querySkuByPromotionRange", (Object)"promotionCode is null");
            return null;
        }
        PmPromotionInDomain pmPromotionIn = (PmPromotionInDomain)SupDisUtil.getMapJson((String)"pm-promotion", (String)(promotionCode + "-" + tenantCode), PmPromotionInDomain.class);
        if (null == pmPromotionIn) {
            this.logger.error(CODE + "querySkuByPromotionRange.pmPromotionIn", (Object)(promotionCode + "-" + tenantCode));
            return null;
        }
        if (StringUtils.isBlank((String)pmPromotionIn.getRangeCode())) {
            this.logger.error(CODE + "querySkuByPromotionRange.rangeCode", (Object)(promotionCode + "-" + tenantCode));
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("fuzzy", false);
        map.put("order", true);
        map.put("orderStr", orderStr);
        String[] codeStr = pmPromotionIn.getRangeCode().split("\\,");
        if (5 == pmPromotionIn.getRangeType()) {
            map.put("skuCodeStr", Arrays.asList(codeStr));
        } else {
            map.put("goodsCodeStr", Arrays.asList(codeStr));
        }
        SupQueryResult rsSkuReDomainSupQueryResult = this.rsSkuServiceRepository.querySkuPage(map);
        if (null == rsSkuReDomainSupQueryResult) {
            this.logger.error(CODE + "querySkuByPromotionRange.RsSkuReDomain", map);
            return null;
        }
        return rsSkuReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryPromotionPageGroupBuying.json"}, name="\u67e5\u8be2\u56e2\u8d2d\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageGroupBuying(HttpServletRequest request) {
        return this.promotionPage(request, "0008", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageSeckill.json"}, name="\u67e5\u8be2\u79d2\u6740\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageSeckill(HttpServletRequest request) {
        return this.promotionPage(request, "0007", null, null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageAssemble.json"}, name="\u67e5\u8be2\u62fc\u56e2\u6bcd\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageAssemble(HttpServletRequest request) {
        return this.promotionPage(request, "0011", "0", null, ORGIN_0);
    }

    @RequestMapping(value={"queryPromotionPageAssembles.json"}, name="\u67e5\u8be2\u62fc\u56e2\u5b50\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageAssembles(HttpServletRequest request) {
        return this.promotionPage(request, "0011", "1", null, ORGIN_0);
    }

    @RequestMapping(value={"getPromotions.json"}, name="\u83b7\u53d6\u6ee1\u51cf\u6d3b\u52a8\u8425\u9500\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PmPromotionReDomain getPromotions(Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    @RequestMapping(value={"queryPromotionPageAssembleForPc.json"}, name="\u67e5\u8be2\u62fc\u56e2\u5b50\u670d\u52a1\u5206\u9875\u5217\u8868-pc")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryPromotionPageAssembleForPc(HttpServletRequest request, String promotionPcode) {
        if (StringUtils.isBlank((String)promotionPcode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("pbCode", "0011");
            param.put("promotionType", "1");
            param.put("promotionPcode", promotionPcode);
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    @RequestMapping(value={"loadPromotionIn.json"}, name="\u751f\u6548\u6d3b\u52a8\u52a0\u8f7d\u7f13\u5b58")
    @ResponseBody
    public HtmlJsonReBean loadPromotionIn() {
        return this.pmPromotionServiceRepository.loadPromotionIn();
    }

    @RequestMapping(value={"queryActivityRelatedList.json"}, name="\u83b7\u53d6\u6240\u6709\u5173\u8054\u6d3b\u52a8\u5238")
    @ResponseBody
    public SupQueryResult<PmPromotionReDomain> queryActivityRelatedList(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("dataState", 1);
            param.put("activityRelated", "1");
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }
}

