/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wo.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.prb.domain.PrbAuctionDomain;
import com.qjsoft.laser.controller.facade.prb.domain.PrbAuctionFileDomain;
import com.qjsoft.laser.controller.facade.prb.domain.PrbAuctionReDomain;
import com.qjsoft.laser.controller.facade.prb.repository.PrbAuctionServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.helper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/prb/Auction"}, name="\u91c7\u8d2d\u9700\u6c42")
public class PrbAuctionCon
extends SpringmvcController {
    private static String CODE = "prb.Auction.con";
    @Autowired
    private PrbAuctionServiceRepository prbAuctionServiceRepository;

    protected String getContext() {
        return "Auction";
    }

    @RequestMapping(value={"saveAuction.json"}, name="\u589e\u52a0\u91c7\u8d2d\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean saveAuction(HttpServletRequest request, String prbAuctionDomainStr) {
        if (null == prbAuctionDomainStr) {
            this.logger.error(CODE + ".saveAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAuction", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PrbAuctionDomain prbAuctionDomain = (PrbAuctionDomain)JsonUtil.buildNormalBinder().getJsonToObject(prbAuctionDomainStr, PrbAuctionDomain.class);
        prbAuctionDomain.setMemberBcode(userSession.getUserPcode());
        prbAuctionDomain.setMemberBcode(userSession.getCompanyCode());
        prbAuctionDomain.setTenantCode(this.getTenantCode(request));
        return this.prbAuctionServiceRepository.saveAuction(prbAuctionDomain);
    }

    @RequestMapping(value={"getAuction.json"}, name="\u83b7\u53d6\u91c7\u8d2d\u9700\u6c42\u4fe1\u606f")
    @ResponseBody
    public PrbAuctionReDomain getAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"param is null");
            return null;
        }
        return this.prbAuctionServiceRepository.getAuction(auctionId);
    }

    @RequestMapping(value={"getAuctionByCode.json"}, name="\u83b7\u53d6\u91c7\u8d2d\u9700\u6c42\u4fe1\u606f\u8be6\u60c5")
    @ResponseBody
    public PrbAuctionReDomain getAuctionByCode(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuction", (Object)"param is null");
            return null;
        }
        return this.prbAuctionServiceRepository.getAuctionByCode(this.getTenantCode(request), auctionCode);
    }

    @RequestMapping(value={"updateAuction.json"}, name="\u66f4\u65b0\u91c7\u8d2d\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean updateAuction(HttpServletRequest request, PrbAuctionDomain prbAuctionDomain) {
        if (null == prbAuctionDomain) {
            this.logger.error(CODE + ".updateAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        prbAuctionDomain.setTenantCode(this.getTenantCode(request));
        return this.prbAuctionServiceRepository.updateAuction(prbAuctionDomain);
    }

    @RequestMapping(value={"deleteAuction.json"}, name="\u5220\u9664\u91c7\u8d2d\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.prbAuctionServiceRepository.deleteAuction(auctionId);
    }

    @RequestMapping(value={"queryAuctionPage.json"}, name="\u67e5\u8be2\u91c7\u8d2d\u9700\u6c42\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PrbAuctionReDomain> queryAuctionPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.prbAuctionServiceRepository.queryAuctionPage(param);
    }

    @RequestMapping(value={"updateAuctionState.json"}, name="\u66f4\u65b0\u91c7\u8d2d\u9700\u6c42\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionState(String auctionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.prbAuctionServiceRepository.updateAuctionState(Integer.valueOf(auctionId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveAuctionFileBatch.json"}, name="\u91c7\u8d2d\u5546\u4e0a\u4f20\u6587\u4ef6")
    @ResponseBody
    public HtmlJsonReBean saveAuctionFileBatch(HttpServletRequest request, String prbAuctionFileDomainStr) {
        if (StringUtil.isBlank((String)prbAuctionFileDomainStr)) {
            this.logger.error(CODE + ".saveAuctionEnrollfileBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".prbAuctionFileDomainStr", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List prbAuctionFileDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(prbAuctionFileDomainStr, PrbAuctionFileDomain.class);
        if (ListUtil.isNotEmpty((Collection)prbAuctionFileDomainList)) {
            for (PrbAuctionFileDomain prbAuctionFileDomain : prbAuctionFileDomainList) {
                prbAuctionFileDomain.setMemberBcode(userSession.getUserPcode());
                prbAuctionFileDomain.setMemberBname(userSession.getMerberCompname());
                prbAuctionFileDomain.setTenantCode(tenantCode);
            }
        } else {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, prbAuctionFileDomainStr);
        }
        return this.prbAuctionServiceRepository.saveAuctionFileBatch(prbAuctionFileDomainList);
    }

    @RequestMapping(value={"updatePrbAuctionAuditByCode.json"}, name="\u5e73\u53f0\u5ba1\u6838\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updatePrbAuctionAuditByCode(HttpServletRequest request, String auctionCode, Integer auctionAudit, Integer oldauctionAudit, String auctionAuremark, String dataPicpath) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".updatePrbAuctionAuditByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        map.put("dataPicpath", dataPicpath);
        return this.prbAuctionServiceRepository.updatePrbAuctionAuditByCode(tenantCode, auctionCode, auctionAudit, oldauctionAudit, map);
    }

    @RequestMapping(value={"queryAuctionPageComForC.json"}, name="\u67e5\u8be2\u91c7\u8d2d\u9700\u6c42\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PrbAuctionReDomain> queryAuctionPageComForC(HttpServletRequest request) {
        Map param = this.getMemberBcodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.prbAuctionServiceRepository.queryAuctionPage(param);
    }

    @RequestMapping(value={"saveAuctionFile.json"}, name="\u91c7\u8d2d\u5546\u4e0a\u4f20\u5408\u540c\u6587\u4ef6")
    @ResponseBody
    public HtmlJsonReBean saveAuctionFile(HttpServletRequest request, String prbAuctionFileDomainStr) {
        if (StringUtil.isBlank((String)prbAuctionFileDomainStr)) {
            this.logger.error(CODE + ".saveAuctionFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".prbAuctionFileDomainStr", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PrbAuctionFileDomain prbAuctionFileDomain = (PrbAuctionFileDomain)JsonUtil.buildNormalBinder().getJsonToObject(prbAuctionFileDomainStr, PrbAuctionFileDomain.class);
        prbAuctionFileDomain.setMemberBname(userSession.getMerberCompname());
        prbAuctionFileDomain.setMemberBcode(userSession.getUserPcode());
        prbAuctionFileDomain.setAuctionFileType("3");
        prbAuctionFileDomain.setTenantCode(tenantCode);
        return this.prbAuctionServiceRepository.saveAuctionFile(prbAuctionFileDomain);
    }
}

