/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pro.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectFileDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectFileReDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectReDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectSpecDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectSpecReDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectValueDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectValueReDomain;
import com.qjsoft.laser.controller.facade.pro.repository.ProProjectServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPropertiesValueDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecValueDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/pro/project"}, name="\u9879\u76ee")
public class ProjectCon
extends SpringmvcController {
    private static String CODE = "pro.project.con";
    @Autowired
    private ProProjectServiceRepository proProjectServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private FileServiceRepository fileServiceRepository;

    protected String getContext() {
        return "project";
    }

    @RequestMapping(value={"saveProject.json"}, name="\u589e\u52a0\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean saveProject(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveProject", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ProProjectDomain proProjectDomain = (ProProjectDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, ProProjectDomain.class);
        proProjectDomain.setCompanyCode(this.getCompanyCode(request));
        if (null == proProjectDomain.getProProjectFileDomainList() || proProjectDomain.getProProjectFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == proProjectDomain.getProProjectSpecDomainList() || proProjectDomain.getProProjectSpecDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.specList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ProProjectSpecDomain projectSpec : proProjectDomain.getProProjectSpecDomainList()) {
            projectSpec.setSpecValueBillno(proProjectDomain.getProjectOcode());
        }
        if (null == proProjectDomain.getProProjectValueDomainList() || proProjectDomain.getProProjectValueDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.valueList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        proProjectDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectServiceRepository.saveProject(proProjectDomain);
    }

    @RequestMapping(value={"getProject.json"}, name="\u83b7\u53d6\u9879\u76ee\u4fe1\u606f")
    @ResponseBody
    public ProProjectReDomain getProject(Integer projectId) {
        if (StringUtils.isBlank((Integer)projectId)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        return this.proProjectServiceRepository.getProject(projectId);
    }

    @RequestMapping(value={"queryProjectBycode.json"}, name="\u6839\u636e\u5458\u5de5Code\u67e5\u8be2\u9879\u76ee\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectBycode(HttpServletRequest request, String employeeCode) {
        Map map = this.assemMapParam(request);
        if (StringUtils.isBlank((String)employeeCode)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        map.put("employeeCode", employeeCode);
        return this.proProjectServiceRepository.queryProjectPage(map);
    }

    @RequestMapping(value={"queryProjectFileBycode.json"}, name="\u83b7\u53d6\u9879\u76ee\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectFileReDomain> queryProjectFileBycode(HttpServletRequest request, String projectCode) {
        Map map = this.assemMapParam(request);
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        map.put("projectCode", projectCode);
        return this.proProjectServiceRepository.queryProjectFilePage(map);
    }

    @RequestMapping(value={"queryProjectSpecBycode.json"}, name="\u83b7\u53d6\u9879\u76ee\u89c4\u683c\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectSpecReDomain> queryProjectSpecBycode(HttpServletRequest request, String projectCode) {
        Map map = this.assemMapParam(request);
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        map.put("projectCode", projectCode);
        return this.proProjectServiceRepository.queryProjectSpecPage(map);
    }

    @RequestMapping(value={"queryProjectValueBycode.json"}, name="\u83b7\u53d6\u9879\u76ee\u5c5e\u6027\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectValueReDomain> queryProjectValueBycode(HttpServletRequest request, String projectCode) {
        Map map = this.assemMapParam(request);
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        map.put("projectCode", projectCode);
        return this.proProjectServiceRepository.queryProjectValuePage(map);
    }

    @RequestMapping(value={"updateProject.json"}, name="\u66f4\u65b0\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean updateProject(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateProject", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ProProjectDomain proProjectDomain = (ProProjectDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, ProProjectDomain.class);
        proProjectDomain.setCompanyCode(this.getCompanyCode(request));
        if (null == proProjectDomain.getProProjectFileDomainList() || proProjectDomain.getProProjectFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateProject.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == proProjectDomain.getProProjectSpecDomainList() || proProjectDomain.getProProjectSpecDomainList().size() == 0) {
            this.logger.error(CODE + ".updateProject.specList", (Object)"SpecList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ProProjectSpecDomain projectSpec : proProjectDomain.getProProjectSpecDomainList()) {
            projectSpec.setSpecValueBillno(proProjectDomain.getProjectOcode());
        }
        if (null == proProjectDomain.getProProjectValueDomainList() || proProjectDomain.getProProjectValueDomainList().size() == 0) {
            this.logger.error(CODE + ".updateProject.valueList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        proProjectDomain.setCompanyCode(this.getCompanyCode(request));
        proProjectDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectServiceRepository.updateProject(proProjectDomain);
    }

    @RequestMapping(value={"deleteProject.json"}, name="\u5220\u9664\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean deleteProject(Integer projectId) {
        if (StringUtils.isBlank((Integer)projectId)) {
            this.logger.error(CODE + ".deleteProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectServiceRepository.deleteProject(projectId);
    }

    @RequestMapping(value={"queryProjectPage.json"}, name="\u67e5\u8be2\u9879\u76ee\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectServiceRepository.queryProjectPage(param);
    }

    @RequestMapping(value={"updateProjectState.json"}, name="\u66f4\u65b0\u9879\u76ee\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProjectState(String projectId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)projectId)) {
            this.logger.error(CODE + ".updateProjectState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectServiceRepository.updateProjectState(Integer.valueOf(projectId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryProjectFilePage.json"}, name="\u9879\u76ee\u9644\u4ef6\u5206\u9875\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<ProProjectFileReDomain> queryProjectFilePage(HttpServletRequest request, String projectCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("projectCode", projectCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectServiceRepository.queryProjectFilePage(param);
    }

    @RequestMapping(value={"saveProjectFile.json"}, name="\u9879\u76ee\u9644\u4ef6\u65b0\u589e")
    @ResponseBody
    public HtmlJsonReBean saveProjectFile(HttpServletRequest request, ProProjectFileDomain proProjectFileDomain) {
        if (null == proProjectFileDomain) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectFileDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectServiceRepository.saveProjectFile(proProjectFileDomain);
    }

    private void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    @RequestMapping(value={"updateProjectShelfState.json"}, name="\u9879\u76ee\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateProjectShelfState(HttpServletRequest request, String projectId) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)projectId)) {
            this.logger.error(CODE + ".updateProjectShelfState", (Object)"param is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        ProProjectReDomain proProjectReDomain = this.proProjectServiceRepository.getProjectReDomain(Integer.valueOf(projectId));
        if (null == proProjectReDomain) {
            this.logger.error(CODE + ".updateProjectShelfState", (Object)"proProjectReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "proProjectReDomain");
        }
        map.put("goodsOrigin", "4");
        map.put("goodsNo", proProjectReDomain.getProjectCode());
        map.put("tenantCode", proProjectReDomain.getTenantCode());
        SupQueryResult rsList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
        if (null == rsList || null == rsList.getRows() || rsList.getRows().isEmpty()) {
            RsResourceGoodsDomain rsResourceGoodsDomain = this.make(request, proProjectReDomain);
            ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
            goodsList.add(rsResourceGoodsDomain);
            this.rsResourceGoodsServiceRepository.savePassResourceGoodsBatch(goodsList);
        }
        return this.proProjectServiceRepository.updateProjectReleaseByCode(proProjectReDomain.getTenantCode(), proProjectReDomain.getProjectCode(), Integer.valueOf(1), Integer.valueOf(0));
    }

    private RsResourceGoodsDomain make(HttpServletRequest request, ProProjectReDomain proProjectReDomain) {
        List ProProjectValueList;
        List ProProjectDomainSpecList;
        if (null == proProjectReDomain || null == request) {
            return null;
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsName(proProjectReDomain.getProjectName());
        rsResourceGoodsDomain.setGoodsNo(proProjectReDomain.getProjectCode());
        rsResourceGoodsDomain.setPntreeCode(proProjectReDomain.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(proProjectReDomain.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(proProjectReDomain.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(proProjectReDomain.getClasstreeName());
        rsResourceGoodsDomain.setPricesetBaseprice(proProjectReDomain.getProjectMinprice());
        rsResourceGoodsDomain.setPricesetMakeprice(proProjectReDomain.getProjectMaxprice());
        rsResourceGoodsDomain.setBrandCode(proProjectReDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(proProjectReDomain.getBrandName());
        rsResourceGoodsDomain.setGoodsOrigin("4");
        rsResourceGoodsDomain.setPricesetMakeshow("1");
        rsResourceGoodsDomain.setPartsnameWeightunit("\u5428");
        rsResourceGoodsDomain.setGoodsWeight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsNum(new BigDecimal("99999"));
        this.makeChannel(rsResourceGoodsDomain, request);
        List proProjectFileDomainList = proProjectReDomain.getProProjectFileDomainList();
        if (!CollectionUtils.isEmpty((Collection)proProjectFileDomainList)) {
            ArrayList<RsGoodsFileDomain> rsGoodsFileList = new ArrayList<RsGoodsFileDomain>();
            for (ProProjectFileDomain proProjectFile : proProjectFileDomainList) {
                RsGoodsFileDomain rsGoodsFile = new RsGoodsFileDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)rsGoodsFile, (Object)proProjectFile);
                    rsGoodsFileList.add(rsGoodsFile);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".getPayChannel.e", (Throwable)e);
                }
            }
            rsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileList);
        }
        if (!CollectionUtils.isEmpty((Collection)(ProProjectDomainSpecList = proProjectReDomain.getProProjectSpecDomainList()))) {
            ArrayList<RsSpecValueDomain> RsSpecValueList = new ArrayList<RsSpecValueDomain>();
            for (ProProjectSpecDomain ProProjectSpec : ProProjectDomainSpecList) {
                RsSpecValueDomain RsSpecValue = new RsSpecValueDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)RsSpecValue, (Object)ProProjectSpec);
                    RsSpecValueList.add(RsSpecValue);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".getPayChannel.e", (Throwable)e);
                }
            }
            rsResourceGoodsDomain.setRsSpecValueDomainList(RsSpecValueList);
        }
        if (!CollectionUtils.isEmpty((Collection)(ProProjectValueList = proProjectReDomain.getProProjectValueDomainList()))) {
            ArrayList<RsPropertiesValueDomain> RsPropertiesValueList = new ArrayList<RsPropertiesValueDomain>();
            for (ProProjectValueDomain ProProjectValue : ProProjectValueList) {
                RsPropertiesValueDomain RsPropertiesValue = new RsPropertiesValueDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)RsPropertiesValue, (Object)ProProjectValue);
                    RsPropertiesValueList.add(RsPropertiesValue);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".getPayChannel.e", (Throwable)e);
                }
            }
            rsResourceGoodsDomain.setRsPropertiesValueDomainList(RsPropertiesValueList);
        }
        return rsResourceGoodsDomain;
    }

    @RequestMapping(value={"updateProjectLowerState.json"}, name="\u9879\u76ee\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateProjectLowerState(HttpServletRequest request, String projectCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".updateProjectState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        map.put("goodsOrigin", "4");
        map.put("goodsNo", projectCode);
        map.put("tenantCode", tenantCode);
        this.rsResourceGoodsServiceRepository.delResourceGoodsByCode(map);
        return this.proProjectServiceRepository.updateProjectReleaseByCode(tenantCode, projectCode, Integer.valueOf(0), Integer.valueOf(1));
    }

    @RequestMapping(value={"queryProjectPageByUserCodeForC.json"}, name="C\u7aef\u67e5\u8be2\u9879\u76ee\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectPageByUserCodeForC(HttpServletRequest request, String userCode) {
        Map param = this.assemMapParam(request);
        if (StringUtils.isBlank((String)userCode)) {
            this.logger.error(CODE + ".queryProjectPageByUserCodeForC", (Object)"param is null");
            return null;
        }
        if (null != param) {
            param.put("custrelCode", userCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectServiceRepository.queryProjectPage(param);
    }

    @RequestMapping(value={"queryProjectFilePageByProjectCodeForC.json"}, name="C\u7aef\u67e5\u8be2\u9879\u76ee\u9644\u4ef6\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectFileReDomain> queryProjectFilePageByProjectCodeForC(HttpServletRequest request, String projectFileType, String projectCode) {
        Map param = this.assemMapParam(request);
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".queryProjectFilePageByProjectCodeForC", (Object)"param is null");
            return null;
        }
        if (StringUtils.isBlank((String)projectFileType)) {
            this.logger.error(CODE + ".queryProjectFilePageByProjectCodeForC", (Object)"param is null");
            return null;
        }
        if (null != param) {
            param.put("projectFileType", projectFileType);
            param.put("projectCode", projectCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectServiceRepository.queryProjectFilePage(param);
    }

    @RequestMapping(value={"updateProjectStartState.json"}, name="\u9879\u76ee\u5f00\u59cb\u5b9e\u65bd")
    @ResponseBody
    public HtmlJsonReBean updateProjectStartState(HttpServletRequest request, String projectCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".updateProjectStartState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        return this.proProjectServiceRepository.updateProjectReleaseByCode(tenantCode, projectCode, Integer.valueOf(1), Integer.valueOf(2));
    }

    @RequestMapping(value={"updateProjectOverState.json"}, name="\u9879\u76ee\u5b8c\u6210")
    @ResponseBody
    public HtmlJsonReBean updateProjectOverState(HttpServletRequest request, String projectCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".updateProjectOverState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        return this.proProjectServiceRepository.updateProjectReleaseByCode(tenantCode, projectCode, Integer.valueOf(2), Integer.valueOf(4));
    }

    @RequestMapping(value={"uploadGoodsFileForB.json"}, name="B\u7aef\u4e0a\u4f20\u5546\u54c1\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFileForB(HttpServletRequest request, MultipartFile file, String fileSort) {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFile", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileServiceRepository.saveFile(file, tenantCode, fileSort);
    }

    @RequestMapping(value={"saveProjectFileForB.json"}, name="B\u7aef\u9879\u76ee\u9644\u4ef6\u65b0\u589e")
    @ResponseBody
    public HtmlJsonReBean saveProjectFileForB(HttpServletRequest request, List<ProProjectFileDomain> proProjectFileDomainList) {
        if (null == proProjectFileDomainList) {
            this.logger.error(CODE + ".saveProjectFileForB", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectServiceRepository.saveProjectFileBatch(proProjectFileDomainList);
    }

    @RequestMapping(value={"queryProjectPageByUserCodeForB.json"}, name="B\u7aef\u67e5\u8be2\u9879\u76ee\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectPageByUserCodeForB(HttpServletRequest request, String userCode) {
        Map param = this.assemMapParam(request);
        if (StringUtils.isBlank((String)userCode)) {
            this.logger.error(CODE + ".queryProjectPageByUserCodeForB", (Object)"param is null");
            return null;
        }
        if (null != param) {
            param.put("employeeCode", userCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectServiceRepository.queryProjectPage(param);
    }
}

