/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pro.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectTaskDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectTaskReDomain;
import com.qjsoft.laser.controller.facade.pro.repository.ProProjectTaskServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pro/projectTask"}, name="\u9879\u76ee\u4efb\u52a1")
public class ProjectTaskCon
extends SpringmvcController {
    private static String CODE = "pro.projectTask.con";
    @Autowired
    private ProProjectTaskServiceRepository proProjectTaskServiceRepository;

    protected String getContext() {
        return "projectTask";
    }

    @RequestMapping(value={"saveProjectTask.json"}, name="\u589e\u52a0\u9879\u76ee\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveProjectTask(HttpServletRequest request, ProProjectTaskDomain proProjectTaskDomain) {
        if (null == proProjectTaskDomain) {
            this.logger.error(CODE + ".saveProjectTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectTaskDomain.setTenantCode(this.getTenantCode(request));
        UserSession userSession = this.getUserSession(request);
        proProjectTaskDomain.setProjectEpcode(userSession.getUserCode());
        return this.proProjectTaskServiceRepository.saveProjectTask(proProjectTaskDomain);
    }

    @RequestMapping(value={"getProjectTask.json"}, name="\u83b7\u53d6\u9879\u76ee\u4efb\u52a1\u4fe1\u606f")
    @ResponseBody
    public ProProjectTaskReDomain getProjectTask(Integer projectTaskId) {
        if (StringUtils.isBlank((Integer)projectTaskId)) {
            this.logger.error(CODE + ".getProjectTask", (Object)"param is null");
            return null;
        }
        return this.proProjectTaskServiceRepository.getProjectTask(projectTaskId);
    }

    @RequestMapping(value={"updateProjectTask.json"}, name="\u66f4\u65b0\u9879\u76ee\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateProjectTask(HttpServletRequest request, ProProjectTaskDomain proProjectTaskDomain) {
        if (null == proProjectTaskDomain) {
            this.logger.error(CODE + ".updateProjectTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectTaskDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectTaskServiceRepository.updateProjectTask(proProjectTaskDomain);
    }

    @RequestMapping(value={"deleteProjectTask.json"}, name="\u5220\u9664\u9879\u76ee\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteProjectTask(Integer projectTaskId) {
        if (StringUtils.isBlank((Integer)projectTaskId)) {
            this.logger.error(CODE + ".deleteProjectTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectTaskServiceRepository.deleteProjectTask(projectTaskId);
    }

    @RequestMapping(value={"queryProjectTaskPage.json"}, name="\u67e5\u8be2\u9879\u76ee\u4efb\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectTaskReDomain> queryProjectTaskPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectTaskServiceRepository.queryProjectTaskPage(param);
    }

    @RequestMapping(value={"queryProjectByCode.json"}, name="\u83b7\u53d6\u5f53\u524d\u4efb\u52a1\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectTaskReDomain> queryProjectByCode(HttpServletRequest request, String projectCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("projectCode", projectCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectTaskServiceRepository.queryProjectTaskPage(param);
    }

    @RequestMapping(value={"updateProjectTaskState.json"}, name="\u66f4\u65b0\u9879\u76ee\u4efb\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProjectTaskState(String projectTaskId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)projectTaskId)) {
            this.logger.error(CODE + ".updateProjectTaskState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectTaskServiceRepository.updateProjectTaskState(Integer.valueOf(projectTaskId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveProjectTaskForB.json"}, name="B\u7aef\u589e\u52a0\u9879\u76ee\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveProjectTaskForB(HttpServletRequest request, ProProjectTaskDomain proProjectTaskDomain) {
        if (null == proProjectTaskDomain) {
            this.logger.error(CODE + ".saveProjectTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectTaskDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectTaskServiceRepository.saveProjectTask(proProjectTaskDomain);
    }

    @RequestMapping(value={"queryProjectTaskPageForB.json"}, name="B\u7aef\u67e5\u8be2\u9879\u76ee\u4efb\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectTaskReDomain> queryProjectTaskPageForB(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectTaskServiceRepository.queryProjectTaskPage(param);
    }

    @RequestMapping(value={"takeTaskForB.json"}, name="\u63a5\u53d7\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean takeTaskForB(String projectTaskId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)projectTaskId)) {
            this.logger.error(CODE + ".updateProjectTaskState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        dataState = 1;
        oldDataState = 0;
        return this.proProjectTaskServiceRepository.updateProjectTaskState(Integer.valueOf(projectTaskId), dataState, oldDataState);
    }

    @RequestMapping(value={"completedTaskForB.json"}, name="\u5b8c\u6210\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean completedTaskForB(String projectTaskId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)projectTaskId)) {
            this.logger.error(CODE + ".updateProjectTaskState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        dataState = 2;
        oldDataState = 1;
        return this.proProjectTaskServiceRepository.updateProjectTaskState(Integer.valueOf(projectTaskId), dataState, oldDataState);
    }

    @RequestMapping(value={"auditTaskForB.json"}, name="\u5ba1\u6838\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean auditTaskForB(String projectTaskId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)projectTaskId)) {
            this.logger.error(CODE + ".updateProjectTaskState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        dataState = 3;
        oldDataState = 2;
        return this.proProjectTaskServiceRepository.updateProjectTaskState(Integer.valueOf(projectTaskId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryAssignmentProjectTaskPageForB.json"}, name="B\u7aef\u67e5\u8be2\u5206\u6d3e\u9879\u76ee\u4efb\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectTaskReDomain> queryAssignmentProjectTaskPageForB(HttpServletRequest request, String userCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("projectEpcode", userCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectTaskServiceRepository.queryProjectTaskPage(param);
    }

    @RequestMapping(value={"queryAcceptProjectTaskPageForB.json"}, name="B\u7aef\u67e5\u8be2\u63a5\u53d7\u9879\u76ee\u4efb\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectTaskReDomain> queryAcceptProjectTaskPageForB(HttpServletRequest request, String userCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("employeeCode", userCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectTaskServiceRepository.queryProjectTaskPage(param);
    }
}

