/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc.filter;

import com.qjsoft.laser.controller.springmvc.filter.CacheHttpServletResponseWrapper;
import com.qjsoft.laser.controller.springmvc.filter.ResponseContent;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheFilter
implements Filter {
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final long MAX_AGE_NO_INIT = 0L;
    public static final long MAX_AGE_TIME = 0L;
    public static final String REQUEST_FILTERED = "cache_filter_" + CacheFilter.class.getName();
    public final Map<String, ResponseContent> cache = new ConcurrentHashMap<String, ResponseContent>();
    public final Map<String, Long> expiresCache = new ConcurrentHashMap<String, Long>();
    public static final long LAST_MODIFIED_INITIAL = -1L;
    public static final long EXPIRES_ON = 1L;
    private int time = 3600;
    public long lastModified = -1L;
    public long expires = 1L;
    public long cacheControlMaxAge = -60L;

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        ResponseContent responseContent;
        HttpServletRequest request = (HttpServletRequest)req;
        if (this.isFilteredBefore((ServletRequest)request)) {
            chain.doFilter((ServletRequest)request, res);
            return;
        }
        request.setAttribute(REQUEST_FILTERED, (Object)Boolean.TRUE);
        String key = this.getCacheKey(request);
        Long expire = this.expiresCache.get(key);
        if (expire != null && (long)(expire.intValue() + this.time * 1000) < System.currentTimeMillis() && (responseContent = this.cache.get(key)) != null) {
            responseContent.writeTo(res);
            return;
        }
        boolean isCache = false;
        if (isCache) {
            CacheHttpServletResponseWrapper cacheResponse = new CacheHttpServletResponseWrapper((HttpServletResponse)res, (long)this.time * 1000L, this.lastModified, this.expires, this.cacheControlMaxAge);
            chain.doFilter((ServletRequest)request, (ServletResponse)cacheResponse);
            cacheResponse.flushBuffer();
            if ("text/html".equals(cacheResponse.getContentType())) {
                this.cache.put(key, cacheResponse.getContent());
                this.expiresCache.put(key, System.currentTimeMillis());
            }
        } else {
            chain.doFilter((ServletRequest)request, res);
        }
    }

    private String getCacheKey(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder(request.getServletPath());
        if (!StringUtils.isEmpty((String)request.getQueryString())) {
            builder.append("_").append(request.getQueryString());
        }
        return builder.toString();
    }

    public boolean isFilteredBefore(ServletRequest request) {
        return request.getAttribute(REQUEST_FILTERED) != null;
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

