/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc.view;

import com.qjsoft.laser.controller.springmvc.annotation.Layout;
import com.qjsoft.laser.controller.springmvc.authlogin.RequestUtil;
import com.qjsoft.laser.controller.springmvc.local.HandlerMethodLocal;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerView;

public class FreeMarkerExtView
extends FreeMarkerView {
    public static final String FRAME_BODY_KEY = "fragmentData";

    protected void doRender(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        SimpleHash fmModel = this.buildTemplateModel(model, request, response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering FreeMarker template [" + this.getUrl() + "] in FreeMarkerView '" + this.getBeanName() + "'"));
        }
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Template template = null;
        String tenantCode = RequestUtil.getTenantCodeByURL(request, response);
        if (StringUtils.isNotBlank((String)tenantCode)) {
            template = this.getTemplate(locale, tenantCode);
            fmModel.put("ftlmode", (Object)this.getDdftlmode(tenantCode));
        } else {
            template = this.getTemplate(locale);
        }
        Template frameTemplate = this.getFrameTemplate(locale);
        String status = String.valueOf(response.getStatus());
        if (StringUtils.isNotBlank((String)status) && !status.startsWith("4") && !status.startsWith("5") && frameTemplate != null) {
            StringWriter sw = new StringWriter();
            template.process(model, (Writer)sw);
            fmModel.put(FRAME_BODY_KEY, (Object)sw.toString());
            template = frameTemplate;
        }
        this.processTemplate(template, fmModel, response);
        HandlerMethodLocal.remove();
    }

    private Template getFrameTemplate(Locale locale) throws IOException {
        HandlerMethod handler = HandlerMethodLocal.get();
        String templateName = null;
        if (handler != null) {
            Layout layout = handler.getMethod().getAnnotation(Layout.class);
            if (layout == null) {
                layout = handler.getBean().getClass().getAnnotation(Layout.class);
            }
            if (layout != null) {
                templateName = "frame" + File.separator + layout.frameName() + "." + layout.suffix();
            }
        }
        if (StringUtils.isNotBlank(templateName)) {
            return this.getTemplate(templateName, locale);
        }
        return null;
    }

    protected Template getTemplate(Locale locale) throws IOException {
        return this.getTemplate(this.getUrl(), locale);
    }

    protected Template getTemplate(Locale locale, String tenantCode) throws IOException {
        String ftlmode = this.getDdftlmode(tenantCode);
        String url = this.getUrl();
        if (StringUtils.isNotBlank((String)ftlmode)) {
            url = url.replace(".ftl", ftlmode + ".ftl");
        }
        return this.getTemplate(url, locale);
    }

    protected Template getTemplate(String name, Locale locale) throws IOException {
        return this.getEncoding() != null ? this.getConfiguration().getTemplate(name, locale, this.getEncoding()) : this.getConfiguration().getTemplate(name, locale);
    }

    public String getDdftlmode(String tenantCode) {
        String url = this.getUrl();
        String context = url.substring(0, url.indexOf("."));
        String key = tenantCode + "-ftlmode-" + context + "-" + ServletMain.getAppName();
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
    }
}

