/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc;

import com.qjsoft.laser.controller.common.enumc.MemQua;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.service.HtmlIBaseService;
import com.qjsoft.laser.controller.core.auth.AuthBean;
import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.supcontroller.SupController;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.interceptor.bean.AuthThreadLocal;
import com.qjsoft.laser.controller.interceptor.bean.InterBean;
import com.qjsoft.laser.controller.interceptor.service.BaseInterUtil;
import com.qjsoft.laser.controller.springmvc.bean.CmsTginfo;
import com.qjsoft.laser.controller.springmvc.bean.DisChannel;
import com.qjsoft.laser.controller.springmvc.bean.TmProappEnv;
import com.qjsoft.laser.controller.springmvc.bean.TmTenant;
import com.qjsoft.laser.controller.springmvc.local.GlobalHandlerMethodLocal;
import com.qjsoft.laser.controller.springmvc.local.HandlerMethodLocal;
import com.yqbsoft.laser.service.suppercore.SupperSysException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.VfinOpenConstants;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;

public abstract class SpringmvcController
extends SupController {
    @Autowired
    public HtmlIBaseService htmlIBaseService;
    private Object UUIDLock = new Object();

    protected abstract String getContext();

    protected Map<String, Object> getQueryMapParams(HttpServletRequest request) {
        Map result = HtmlUtil.getParameterMap((HttpServletRequest)request);
        result.put("tenantCode", this.getTenantCode(request));
        return result;
    }

    protected boolean checkMemquaPlat(HttpServletRequest request) {
        return this.checkMemqua(request, MemQua.PLAT.getCode());
    }

    protected String getTeananMemberCode(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        return memberCode;
    }

    protected String getManageMember(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String memberCode = userSession.getUserinfoParentCode();
        if (StringUtils.isBlank((String)memberCode)) {
            String tenantCode = userSession.getTenantCode();
            if (StringUtils.isBlank((String)tenantCode)) {
                return null;
            }
            memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        }
        return memberCode;
    }

    protected String getChannel(HttpServletRequest request) {
        String memberCode = this.getManageMember(request);
        if (StringUtils.isBlank((String)memberCode)) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String json = SupDisUtil.getMap((String)"DisChannel-memberCode", (String)(memberCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        DisChannel disChannel = (DisChannel)JsonUtil.buildNormalBinder().getJsonToObject(json, DisChannel.class);
        if (null == disChannel) {
            return null;
        }
        return disChannel.getChannelCode() + "," + disChannel.getChannelName();
    }

    protected String getNowChannel(HttpServletRequest request) {
        String channelCode = this.getTginfoChannel(request);
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = this.getProappChannel(request);
        }
        return channelCode;
    }

    protected String getProappChannel(HttpServletRequest request) {
        String proappCode = this.getProappCode(request);
        if (StringUtils.isBlank((String)proappCode)) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String json = SupDisUtil.getMap((String)"TmProappEnv-tenant-ProappCode", (String)(tenantCode + "-" + proappCode));
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        TmProappEnv tmProappEnv = (TmProappEnv)JsonUtil.buildNormalBinder().getJsonToObject(json, TmProappEnv.class);
        if (null == tmProappEnv) {
            return null;
        }
        return tmProappEnv.getChannelCode();
    }

    protected String getTginfoChannel(HttpServletRequest request) {
        String tginfoCode = this.getTginfoCode(request);
        if (StringUtils.isBlank((String)tginfoCode)) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String json = SupDisUtil.getMap((String)"cms_tginfo_cache", (String)(tginfoCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        CmsTginfo tginfo = (CmsTginfo)JsonUtil.buildNormalBinder().getJsonToObject(json, CmsTginfo.class);
        if (null == tginfo) {
            return null;
        }
        return tginfo.getChannelCode();
    }

    protected String getCompanyCode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String userinfoCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        String json = SupDisUtil.getMap((String)"OrgEmployee-userCode", (String)(userSession.getUserCode() + "-" + userinfoCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        return json;
    }

    protected void setOrgUsercode(HttpServletRequest request, HttpServletResponse response, String orgUsercode) {
        BaseInterUtil.putOrgUsercodeHeader((HttpServletRequest)request, (HttpServletResponse)response, (String)orgUsercode);
    }

    protected String getCompanyCodeByNow(HttpServletRequest request, HttpServletResponse response) {
        String json = this.getCompanyCode(request);
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        String companyCode = BaseInterUtil.getSessionCompany((HttpServletRequest)request, (HttpServletResponse)response);
        if (StringUtils.isBlank((String)companyCode)) {
            if (json.indexOf(",") < 0) {
                return json;
            }
            return null;
        }
        if (json.indexOf(companyCode) >= 0) {
            return companyCode;
        }
        return null;
    }

    protected boolean setCompanyCodeByNow(HttpServletRequest request, HttpServletResponse response, String companyCode) {
        String json = this.getCompanyCode(request);
        if (StringUtils.isBlank((String)json)) {
            return false;
        }
        if (json.indexOf(companyCode) < 0) {
            return false;
        }
        BaseInterUtil.setSessionCompany((HttpServletRequest)request, (HttpServletResponse)response, (String)companyCode);
        return true;
    }

    protected boolean checkMemquaMerchant(HttpServletRequest request) {
        return this.checkMemqua(request, MemQua.MERCHANT.getCode());
    }

    protected boolean checkMemqua(HttpServletRequest request, String quality) {
        if (StringUtils.isBlank((String)quality) || null == request) {
            return false;
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return false;
        }
        String userinfoQuality = userSession.getUserinfoQuality();
        if (StringUtils.isBlank((String)userinfoQuality)) {
            return false;
        }
        return userinfoQuality.indexOf(quality) >= 0;
    }

    protected Map<String, Object> getMemberBcodeQueryMapParams(HttpServletRequest request) {
        Map result = HtmlUtil.buildPageMap((HttpServletRequest)request);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return result;
        }
        result.put("memberBcode", userSession.getUserPcode());
        return result;
    }

    protected Map<String, Object> getMemberCodeQueryMapParams(HttpServletRequest request) {
        Map result = HtmlUtil.buildPageMap((HttpServletRequest)request);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return result;
        }
        result.put("memberCode", userSession.getUserPcode());
        return result;
    }

    protected Map<String, Object> getPageQueryMapParams(HttpServletRequest request) {
        Map result = HtmlUtil.buildPageMap((HttpServletRequest)request);
        result.put("tenantCode", this.getTenantCode(request));
        return result;
    }

    protected String getMerchantCode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        return userSession.getUserPcode();
    }

    protected String getViewName(String viewName) {
        return this.getContext() + "/" + viewName;
    }

    public UserSession getUserSession(HttpServletRequest request) {
        return BaseInterUtil.getSession((HttpServletRequest)request);
    }

    public UserInfo getUserInfo(HttpServletRequest request) {
        UserSession userSession = BaseInterUtil.getSession((HttpServletRequest)request);
        if (null == userSession) {
            return null;
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setTicketTokenid(userSession.getTicketTokenid());
        userInfo.setMerberCompname(userSession.getMerberCompname());
        userInfo.setUserCode(userSession.getUserCode());
        userInfo.setUserId(userSession.getUserId());
        userInfo.setUserImgurl(userSession.getUserImgurl());
        userInfo.setUserMsg(userSession.getUserMsg());
        userInfo.setUserName(userSession.getUserName());
        userInfo.setUserNickname(userSession.getUserNickname());
        userInfo.setUserRelname(userSession.getUserRelname());
        userInfo.setUserType(userSession.getUserType());
        userInfo.setCompanyCode(userSession.getCompanyCode());
        userInfo.setEmpType(userSession.getEmpType());
        userInfo.setEmpTypecode(userSession.getEmpTypecode());
        return userInfo;
    }

    public String getUrlPath(HttpServletRequest request) {
        if (null == request) {
            return "";
        }
        AuthBean authBean = AuthThreadLocal.getAuthBean((HttpServletRequest)request);
        if (null != authBean && null != authBean.getResBean()) {
            return authBean.getResBean().getUrlPath();
        }
        return "";
    }

    public String getPermissionListName(HttpServletRequest request) {
        if (null == request) {
            return "";
        }
        AuthBean authBean = AuthThreadLocal.getAuthBean((HttpServletRequest)request);
        if (null != authBean && null != authBean.getResBean()) {
            return authBean.getPermissonList().getPermissionListName();
        }
        return "";
    }

    public String getTenantCode(HttpServletRequest request) {
        return BaseInterUtil.getTenantCode((HttpServletRequest)request);
    }

    public String getProappCode(HttpServletRequest request) {
        return BaseInterUtil.getProappCode((HttpServletRequest)request);
    }

    public String getTginfoCode(HttpServletRequest request) {
        return BaseInterUtil.getTginfoCode((HttpServletRequest)request);
    }

    protected String getParamEncode(HttpServletRequest request, String str) throws UnsupportedEncodingException {
        return new String(new String(request.getParameter(str).getBytes("iso-8859-1"), "UTF-8"));
    }

    protected String makeDescode(String str) throws UnsupportedEncodingException {
        return new String(new String(str.getBytes("UTF-8"), "iso-8859-1"));
    }

    protected Map<String, Object> assemMapParam(HttpServletRequest request) {
        HashMap<String, Object> resultMap = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == resultMap) {
            resultMap = new HashMap<String, Object>();
        }
        resultMap.put("tenantCode", this.getTenantCode(request));
        return resultMap;
    }

    protected Map<String, Object> assemMapMemberParam(HttpServletRequest request) {
        Map<String, Object> resultMap = this.assemMapParam(request);
        if (null == resultMap) {
            resultMap = new HashMap<String, Object>();
        }
        if (null != resultMap) {
            resultMap.put("memberCode", this.getMerchantCode(request));
        }
        return resultMap;
    }

    protected Map<String, Object> assemMapBuyParam(HttpServletRequest request) {
        Map<String, Object> resultMap = this.assemMapParam(request);
        if (null == resultMap) {
            resultMap = new HashMap<String, Object>();
        }
        if (null != resultMap) {
            resultMap.put("memberBcode", this.getMerchantCode(request));
        }
        return resultMap;
    }

    protected Map<String, Object> makeMapParam(HttpServletRequest request) {
        HashMap<String, Object> resultMap = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == resultMap) {
            resultMap = new HashMap<String, Object>();
        }
        if (null != resultMap) {
            String tenantCode = this.getTenantCode(request);
            String proappCode = this.getProappCode(request);
            if (!"00000000".equals(tenantCode) || !"000".equals(proappCode)) {
                resultMap.put("tenantCode", tenantCode);
                resultMap.put("proappCode", proappCode);
            }
        }
        return resultMap;
    }

    public String getFtlTempPath(HttpServletRequest request) {
        String context = this.getUrlPath(request);
        if (StringUtils.isBlank((String)context)) {
            context = this.getContext();
        }
        if (StringUtils.isNotBlank((String)context) && !"/".equals(context.substring(context.length() - 1))) {
            context = context + "/";
        }
        return context;
    }

    public SupPageTools buildPage(SupPageTools supPageTools, HttpServletRequest request) {
        String page = request.getParameter("page");
        String rows = request.getParameter("rows");
        if (StringUtils.isBlank((String)page)) {
            return supPageTools;
        }
        Integer pageNo = Integer.parseInt(page);
        if (StringUtils.isBlank((String)rows)) {
            rows = "30";
        }
        supPageTools.setStartRow(Integer.parseInt(rows) * (pageNo - 1));
        return supPageTools;
    }

    public String getTenantCodeself(String userPcode) {
        PostParamMap pmap = new PostParamMap("tm.tenant.queryTenantPage");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantOpuser", userPcode);
        map.put("order", true);
        pmap.putParamToJson("map", map);
        SupQueryResult queryResult = this.htmlIBaseService.sendReSupObject(pmap, TmTenant.class);
        if (queryResult != null && queryResult.getList() != null && !queryResult.getList().isEmpty()) {
            return ((TmTenant)queryResult.getList().get(0)).getTenantCode();
        }
        return null;
    }

    protected void setUserSession(HttpServletRequest request, HttpServletResponse response, UserSession userSession) {
        BaseInterUtil.putSession((HttpServletRequest)request, (HttpServletResponse)response, (UserSession)userSession);
        this.setToken(request, response, null == userSession ? null : userSession.getTicketTokenid());
    }

    protected String getToken(HttpServletRequest request) {
        return BaseInterUtil.getToKen((HttpServletRequest)request);
    }

    protected void setToken(HttpServletRequest request, HttpServletResponse response, String token) {
        BaseInterUtil.putTokenCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)token);
    }

    protected String getRequestservice(HttpServletRequest request) {
        return BaseInterUtil.getRequestservice((HttpServletRequest)request, (String)BaseInterUtil.getTenantCode((HttpServletRequest)request));
    }

    @ExceptionHandler(value={Exception.class})
    public String exception(HttpServletRequest request, HttpServletResponse response, Exception e) {
        String[] produces;
        this.logger.error((Throwable)e);
        request.setAttribute("path_servername", (Object)BaseInterUtil.getRequestservice((HttpServletRequest)request, (String)BaseInterUtil.getTenantCode((HttpServletRequest)request)));
        request.setAttribute("sysAppContextPath", (Object)request.getContextPath());
        HandlerMethod viewHandler = HandlerMethodLocal.get();
        HandlerMethod globalHandler = GlobalHandlerMethodLocal.get();
        boolean randerView = true;
        if (viewHandler == null) {
            randerView = false;
        } else if (globalHandler != null && globalHandler.getMethodAnnotation(ResponseBody.class) != null) {
            randerView = false;
        }
        if (randerView) {
            request.setAttribute("ex", (Object)e.getMessage());
            if (e instanceof NullPointerException) {
                return "/404";
            }
            if (e instanceof SupperSysException) {
                return "/500";
            }
            return "/500";
        }
        String contextType = "text/html;charset=UTF-8";
        if (globalHandler != null && (produces = ((RequestMapping)globalHandler.getMethodAnnotation(RequestMapping.class)).produces()) != null && produces.length > 0 && (contextType = produces[0]).indexOf("charset") < 0) {
            contextType = contextType + ";charset=UTF-8";
        }
        String str = JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonReBean("error", e.getMessage()));
        response.setHeader("Content-type", contextType);
        try {
            response.getOutputStream().write(str.getBytes());
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public static StringWriter getTemplateContent(Map<String, Object> map, String content) throws IOException, TemplateException {
        Configuration cfg = new Configuration();
        cfg.setClassicCompatible(true);
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate(VfinOpenConstants.FREEMAKER_STR_KEY, content);
        cfg.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        cfg.setDefaultEncoding("UTF-8");
        Template template = cfg.getTemplate(VfinOpenConstants.FREEMAKER_STR_KEY);
        StringWriter writer = new StringWriter();
        template.process(map, (Writer)writer);
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createUUIDString() {
        Object object = this.UUIDLock;
        synchronized (object) {
            return UUID.randomUUID().toString().replace("-", "");
        }
    }

    protected <P> Map<String, P> getQueryMapParam(String keyStr, Object ... values) {
        if (StringUtils.isBlank((String)keyStr)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] keys = keyStr.split(",");
        boolean isSubMap = false;
        for (int i = 0; i < keys.length; ++i) {
            String k = keys[i];
            if (k.contains(":")) {
                isSubMap = true;
                result.put(k.split(":")[0], JsonUtil.buildNormalBinder().toJson(this.getSubMap(keys, values, i)));
                continue;
            }
            if (isSubMap || values[i] == null) continue;
            if (this.isBaseType(values[i])) {
                result.put(k, values[i]);
                continue;
            }
            result.put(k, JsonUtil.buildNormalBinder().toJson(values[i]));
        }
        return result;
    }

    private boolean isBaseType(Object obj) {
        return obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof Character;
    }

    private <P> Map<String, P> getSubMap(String[] keys, Object[] values, Integer start) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(keys[start].split(":")[1], values[start]);
        for (int i = start + 1; i < keys.length; ++i) {
            String key = keys[i];
            if (key.contains(":")) {
                return result;
            }
            result.put(key, values[i]);
        }
        return result;
    }

    protected String getAllPathUrl(HttpServletRequest request, String tenantCode) {
        return BaseInterUtil.getRequestservice((HttpServletRequest)request, (String)BaseInterUtil.getTenantCode((HttpServletRequest)request)) + request.getContextPath();
    }

    protected String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    protected String getOauthEnvCode(HttpServletRequest request) {
        InterBean interBean = AuthThreadLocal.getInterBean((HttpServletRequest)request);
        if (null != interBean && null != interBean.getOauthEnvCode()) {
            return interBean.getOauthEnvCode();
        }
        return "";
    }
}

