/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc;

import com.qjsoft.laser.controller.common.bean.FmFileDomainBean;
import com.qjsoft.laser.controller.common.bean.FmFileReDomainBean;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.util.ExportExcelUtlis;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.qjsoft.laser.controller.springmvc.bean.FmUsermfileDomain;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.ImageUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public abstract class SpringmvnNewController
extends SpringmvcController {
    protected final SupperLogUtil logger = new SupperLogUtil(SpringmvnNewController.class);
    private static final ExecutorService pool = Executors.newFixedThreadPool(2);
    private static String ui_page = "page";
    private static String ui_rows = "rows";
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";

    protected abstract List<Map<String, Object>> makeExcelData(String var1, String var2, String var3);

    public void exportFileZip(HttpServletRequest request, Map<Object, List<String>> listMap, Map<String, Object> paramMap, Map<String, Object> fileMap) {
        String fileName;
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(fileMap) || MapUtil.isEmpty(listMap)) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
            return;
        }
        String fileType = null == fileMap.get("fileType") ? "" : fileMap.get("fileType").toString();
        String string = fileName = null == fileMap.get("fileName") ? "" : fileMap.get("fileName").toString();
        if (StringUtils.isBlank((String)fileType) || StringUtils.isBlank((String)fileName)) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
            return;
        }
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        String userCode = (String)paramMap.get("userCode");
        String tempPath = request.getSession().getServletContext().getRealPath("/") + "../../temp/";
        String tempFlag = "";
        Set<Object> keySet = listMap.keySet();
        ArrayList<String> imageList = new ArrayList<String>();
        for (Object key : keySet) {
            List<String> fileList = listMap.get(key);
            for (int i = 0; i < fileList.size(); ++i) {
                tempFlag = tempPath + keySet + "-" + i + "." + fileType;
                for (String file : fileList) {
                    byte[] bytes = file.getBytes();
                    ImageUtils.writeImageToDisk((byte[])bytes, (String)tempFlag);
                    imageList.add(tempFlag);
                }
            }
        }
        this.logger.error("SpringmvnNewController.exportComExcel.imageList", (Object)JsonUtil.buildNormalBinder().toJson(imageList));
        byte[] bytes = null;
        try {
            ImageUtils.toZip(imageList, (String)(tempPath + fileName + ".zip"), (boolean)true);
            bytes = ExportExcelUtlis.InputStreamByteArray((String)(tempPath + fileName + ".zip"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
    }

    private void updateTaskStatus(String taskId, int progress, String message) {
        String statusKey = "export_task_" + taskId;
        HashMap<String, String> status = new HashMap<String, String>();
        status.put("progress", String.valueOf(progress));
        status.put("message", message);
        status.put("timestamp", String.valueOf(System.currentTimeMillis()));
        SupDisUtil.set((String)statusKey, (String)JsonUtil.buildNormalBinder().toJson(status), (int)86400);
    }

    public void exportComExcel(HttpServletRequest request, final Map<String, Object> paramMap, final Map<String, Object> infoMap, final String apiRouter, final String excelTemplate) {
        final String tempPath = this.prepareTempFilePath(request);
        if (StringUtils.isBlank((String)tempPath)) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"tempPath is blank");
            return;
        }
        pool.execute(new Runnable(){

            @Override
            public void run() {
                SpringmvnNewController.this.exportComExcelInAsync(tempPath, paramMap, infoMap, apiRouter, excelTemplate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportComExcelInAsync(String tempPath, Map<String, Object> paramMap, Map<String, Object> infoMap, String apiRouter, String excelTemplate) {
        FileOutputStream outputStream;
        SXSSFWorkbook workbook;
        block36: {
            block34: {
                block35: {
                    if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(infoMap) || StringUtils.isBlank((String)apiRouter)) {
                        this.logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
                        return;
                    }
                    FmUsermfileDomain exportInfo = this.prepareExportInfo(paramMap, infoMap);
                    if (exportInfo == null) {
                        this.logger.error("\u5bfc\u51faExcel\u5931\u8d25", (Object)"exportInfo is error");
                        return;
                    }
                    List<Map<String, Object>> headMapList = this.headMapList(infoMap);
                    ArrayList<String> excelHeader = new ArrayList<String>();
                    ArrayList<String> exceldataName = new ArrayList<String>();
                    for (Map<String, Object> map : headMapList) {
                        String showName = map.get("showName").toString();
                        String dataName = map.get("dataName").toString();
                        excelHeader.add(showName);
                        exceldataName.add(dataName);
                    }
                    String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
                    String[] dataNames = exceldataName.toArray(new String[exceldataName.size()]);
                    if (headers == null || headers.length == 0) {
                        this.updateTaskStatus(exportInfo.getUsermfileCode(), -1, "\u5931\u8d25:headers is null");
                        this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
                        return;
                    }
                    workbook = null;
                    outputStream = null;
                    try {
                        this.updateTaskStatus(exportInfo.getUsermfileCode(), 5, "\u51c6\u5907\u6570\u636e");
                        this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), 1, null);
                        workbook = new SXSSFWorkbook(100);
                        workbook.setCompressTempFiles(true);
                        SXSSFSheet sheet = workbook.createSheet(exportInfo.getUsermfileUrlname());
                        this.createHeaderRow(workbook, sheet, headers);
                        SupQueryResult<Object> queryResult = this.queryCount(paramMap, apiRouter);
                        if (null == queryResult) {
                            this.logger.error("SpringmvnNewController.queryResult", (Object)"queryResult is blank");
                            this.updateTaskStatus(exportInfo.getUsermfileCode(), -1, "\u5931\u8d25:queryResult is null");
                            this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
                            return;
                        }
                        if (queryResult.getTotal() <= 0L) {
                            this.logger.error("SpringmvnNewController.queryResult.getTotal()<=0", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
                            this.updateTaskStatus(exportInfo.getUsermfileCode(), -1, "\u5931\u8d25:\u67e5\u8be2\u6570\u636e\u603b\u6761\u6570\u4e3a0");
                            this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
                            return;
                        }
                        int totalRows = this.writeDataToSheet(workbook, sheet, dataNames, paramMap, apiRouter, excelTemplate, exportInfo.getUsermfileCode(), queryResult.getTotal());
                        if (totalRows == 0) {
                            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"No data to export");
                            this.updateTaskStatus(exportInfo.getUsermfileCode(), -1, "\u5931\u8d25: No data to export");
                            this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
                            return;
                        }
                        File tempFile = new File(tempPath = tempPath + exportInfo.getUsermfileUrlname() + "." + exportInfo.getMfileCtype());
                        File parentDir = tempFile.getParentFile();
                        if (!parentDir.exists() && !parentDir.mkdirs()) {
                            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"Failed to create temp directory");
                            this.updateTaskStatus(exportInfo.getUsermfileCode(), -1, "\u5931\u8d25: Failed to create temp directory");
                            this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
                            this.closeQuietly(outputStream);
                            if (workbook == null) break block34;
                            break block35;
                        }
                        outputStream = new FileOutputStream(tempPath);
                        workbook.write((OutputStream)outputStream);
                        outputStream.flush();
                        byte[] bytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
                        FmFileReDomainBean fileReDomainBean = this.saveExcel(bytes, exportInfo.getUsermfileUrlname(), exportInfo.getUserCode(), exportInfo.getMfileCtype(), exportInfo.getTenantCode());
                        this.updateTaskStatus(exportInfo.getUsermfileCode(), 100, "\u5b8c\u6210");
                        this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), 2, null != fileReDomainBean ? fileReDomainBean.getFileUrl() : null);
                        this.closeQuietly(outputStream);
                        break block36;
                    }
                    catch (Exception e) {
                        this.logger.error("SpringmvnNewController.exportComExcel", (Object)"Exception during export", (Throwable)e);
                        this.updateTaskStatus(exportInfo.getUsermfileCode(), -1, "\u5931\u8d25: " + e.getMessage());
                        this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
                        return;
                    }
                }
                try {
                    workbook.dispose();
                }
                catch (Exception e) {
                    this.logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error disposing workbook", (Throwable)e);
                }
            }
            if (tempPath == null) return;
            this.deleteTempFile(tempPath);
            return;
        }
        if (workbook != null) {
            try {
                workbook.dispose();
            }
            catch (Exception e) {
                this.logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error disposing workbook", (Throwable)e);
            }
        }
        if (tempPath == null) return;
        this.deleteTempFile(tempPath);
        return;
        finally {
            this.closeQuietly(outputStream);
            if (workbook != null) {
                try {
                    workbook.dispose();
                }
                catch (Exception e) {
                    this.logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error disposing workbook", (Throwable)e);
                }
            }
            if (tempPath != null) {
                this.deleteTempFile(tempPath);
            }
        }
    }

    private List<Map<String, Object>> headMapList(Map<String, Object> infoMap) {
        Object headMap = infoMap.get("headMap");
        if (null == headMap) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMap", (Object)(" =:= " + infoMap));
            return null;
        }
        List headMapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(headMap), Map.class);
        if (ListUtil.isEmpty((Collection)headMapList)) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMapList", (Object)(" is null " + JsonUtil.buildNormalBinder().toJson(headMap)));
            return null;
        }
        return headMapList;
    }

    private void createHeaderRow(SXSSFWorkbook workbook, SXSSFSheet sheet, String[] headers) {
        SXSSFRow row = sheet.createRow(0);
        CellStyle headerStyle = this.createHeaderStyle(workbook);
        for (int i = 0; i < headers.length; ++i) {
            SXSSFCell cell = row.createCell(i);
            cell.setCellValue(headers[i]);
            cell.setCellStyle(headerStyle);
            sheet.trackColumnForAutoSizing(i);
        }
    }

    private CellStyle createHeaderStyle(SXSSFWorkbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName("\u4eff\u5b8b_GB2312");
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        style.setFont(font);
        return style;
    }

    private int writeDataToSheet(SXSSFWorkbook workbook, SXSSFSheet sheet, String[] dataNames, Map<String, Object> paramMap, String apiRouter, String excelTemplate, String taskId, long total) {
        int totalRows = 0;
        int page = null == paramMap.get("page") ? 1 : Integer.valueOf(paramMap.get("page").toString());
        CellStyle dataStyle = this.createDataStyle(workbook);
        String api = apiRouter;
        if (null != paramMap.get("sendParamMap")) {
            api = JsonUtil.buildNonDefaultBinder().toJson(paramMap);
        }
        while (true) {
            paramMap.put("page", page);
            SpringmvnNewController.makePage(paramMap);
            PostParamMap pmap = new PostParamMap(apiRouter);
            pmap.putParamToJson("map", paramMap);
            String json = this.htmlIBaseService.sendMesReJson(pmap);
            List<Map<String, Object>> fromDataList = this.makeExcelData(json, api, excelTemplate);
            if (ListUtil.isEmpty(fromDataList)) break;
            for (Map<String, Object> dataMap : fromDataList) {
                SXSSFRow row = sheet.createRow(totalRows + 1);
                for (int i = 0; i < dataNames.length; ++i) {
                    SXSSFCell cell = row.createCell(i);
                    String beanName = dataNames[i];
                    String value = "";
                    if (StringUtils.isNotBlank((String)beanName)) {
                        String string = value = null == dataMap.get(beanName) ? "" : String.valueOf(dataMap.get(beanName));
                        if ("null".equals(value)) {
                            value = "";
                        }
                    }
                    cell.setCellValue(value);
                    cell.setCellStyle(dataStyle);
                }
                if (++totalRows % 100 != 0) continue;
                try {
                    sheet.flushRows(100);
                }
                catch (IOException e) {
                    this.logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error flushing rows", (Throwable)e);
                }
            }
            int progress = (int)((long)(totalRows * 95) / total) + 5;
            if (progress >= 99) {
                progress = 99;
            }
            this.updateTaskStatus(taskId, progress, String.format("\u5bfc\u51fa\u4e2d %d/%d", progress, 100));
            ++page;
        }
        this.logger.info("SpringmvnNewController.exportComExcel", (Object)("No more data at page " + page));
        for (int i = 0; i < dataNames.length; ++i) {
            sheet.autoSizeColumn(i);
        }
        return totalRows;
    }

    public static void main(String[] args) {
        System.out.println(String.format("\u5bfc\u51fa\u4e2d %d/%d", 11, 12));
    }

    private CellStyle createDataStyle(SXSSFWorkbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName("\u4eff\u5b8b_GB2312");
        font.setFontHeightInPoints((short)10);
        style.setFont(font);
        return style;
    }

    private String prepareTempFilePath(HttpServletRequest request) {
        if (request == null) {
            this.logger.error("SpringmvnNewController.prepareTempFilePath", (Object)"request is null");
            return null;
        }
        if (request.getSession() == null) {
            this.logger.error("SpringmvnNewController.prepareTempFilePath", (Object)"request.getSession() is null");
            return null;
        }
        if (request.getSession().getServletContext() == null) {
            this.logger.error("SpringmvnNewController.prepareTempFilePath", (Object)"request.getSession().getServletContext() is null");
            return null;
        }
        return request.getSession().getServletContext().getRealPath("/") + "../../temp/";
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error closing stream", (Throwable)e);
            }
        }
    }

    private void deleteTempFile(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            this.logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error deleting temp file", (Throwable)e);
        }
    }

    private FmFileReDomainBean saveExcel(byte[] bytes, String fileName, String userCode, String fileType, String tenantCode) {
        if (bytes == null || bytes.length <= 0 || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveExcel", (Object)(bytes.length + "-" + fileName + "-" + userCode + "-" + "-" + fileType + "-" + tenantCode));
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileOwner(userCode);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileContext(bytes);
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])bytes));
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(fileName);
        fileBean.setSize(Long.valueOf(1L));
        return this.saveFile(fileBean, tenantCode, "FILE_11", (FmFileDomainBean)fmFileReDomainBean);
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"param is null");
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"Exception", (Throwable)e);
            return null;
        }
        return fmFileReDomainBean;
    }

    private FmUsermfileDomain prepareExportInfo(Map<String, Object> paramMap, Map<String, Object> infoMap) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String fileName = infoMap.get("fileName") != null ? infoMap.get("fileName").toString() : "export";
            fileName = sdf.format(new Date()) + "-" + fileName;
            FmUsermfileDomain fmUsermfileDomain = new FmUsermfileDomain();
            fmUsermfileDomain.setTenantCode((String)paramMap.get("tenantCode"));
            fmUsermfileDomain.setUserCode(infoMap.get("userCode").toString());
            fmUsermfileDomain.setUsermfileUrlname(fileName);
            fmUsermfileDomain.setMfileCtype("xls");
            fmUsermfileDomain.setMfileType("1");
            fmUsermfileDomain.setMfileSort("FILE_11");
            fmUsermfileDomain.setUsermfileWhere(JsonUtil.buildNonDefaultBinder().toJson(paramMap));
            HtmlJsonReBean htmlJsonReBean = this.saveUsermfile(fmUsermfileDomain);
            if (htmlJsonReBean.isSuccess()) {
                fmUsermfileDomain.setUsermfileCode(htmlJsonReBean.getDataObj().toString());
                return fmUsermfileDomain;
            }
        }
        catch (Exception e) {
            this.logger.error("\u51c6\u5907\u5bfc\u51fa\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return null;
    }

    public static void makePage(Map<String, Object> map) {
        String rows;
        String page;
        if (null == map || map.isEmpty()) {
            return;
        }
        String string = page = null == map.get(ui_page) ? "1" : map.get(ui_page).toString();
        if (null == page) {
            return;
        }
        if (StringUtils.isBlank((String)page)) {
            page = "1";
        }
        String string2 = rows = null == map.get(ui_rows) ? "0" : map.get(ui_rows).toString();
        if (StringUtils.isBlank((String)rows) || "0".equals(rows)) {
            rows = "10";
        }
        map.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
        map.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
        map.put(ui_rows, Long.valueOf(rows).intValue());
        map.put(ui_page, Long.valueOf(page).intValue());
    }

    public SupQueryResult<Object> queryCount(Map<String, Object> paramMap, String apiRouter) {
        paramMap.put(dao_startRow, 0);
        paramMap.put(dao_endRow, 0);
        paramMap.put(ui_rows, 0);
        PostParamMap pmap = new PostParamMap(apiRouter);
        pmap.putParamToJson("map", paramMap);
        return this.htmlIBaseService.sendReSupObject(pmap, Object.class);
    }

    public HtmlJsonReBean saveUsermfile(FmUsermfileDomain fmUsermfileDomain) {
        PostParamMap pmap = new PostParamMap("fm.file.saveUsermfile");
        pmap.putParamToJson("fmUsermfileDomain", (Object)fmUsermfileDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateUsermfileListStateByCode(String tenantCode, String usermfileListCode, Integer dataState, String url) {
        PostParamMap pmap = new PostParamMap("fm.file.updateUsermfileStateByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("usermfileCode", (Object)usermfileListCode);
        pmap.putParam("dataState", (Object)dataState);
        if (StringUtils.isNotBlank((String)url)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("usermfileUrl", url);
            pmap.putParamToJson("map", map);
        }
        return this.htmlIBaseService.sendMesReBean(pmap);
    }
}

