/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc;

import com.qjsoft.laser.controller.common.bean.FmFileDomainBean;
import com.qjsoft.laser.controller.common.bean.FmFileReDomainBean;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.util.ExportExcelUtlis;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.facade.cm.domain.CmChannelClearReDomain;
import com.qjsoft.laser.controller.facade.cm.repository.CmChannelClearServiceRepository;
import com.qjsoft.laser.controller.facade.fm.domain.FmFchannelDomainBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFchannelReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FchannelServiceRepository;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.ul.domain.UlLevelListReDomain;
import com.qjsoft.laser.controller.facade.ul.domain.UlLevelUpointsReDomain;
import com.qjsoft.laser.controller.facade.ul.repository.UlLevelServiceRepository;
import com.qjsoft.laser.controller.facade.ul.repository.UlLevelUllistServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.upm.domain.UpmUpointsReDomain;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.qjsoft.laser.controller.springmvc.excelTemplate.DataExcel;
import com.qjsoft.laser.controller.springmvc.excelTemplate.OrderExcel;
import com.qjsoft.laser.controller.springmvc.excelTemplate.StoreExcel;
import com.qjsoft.laser.controller.springmvc.thread.ThreadPoolFactory;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.ImageUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SpringmvnNewController
extends SpringmvcController {
    private static String ui_page = "page";
    private static String ui_rows = "rows";
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";
    @Autowired
    private FchannelServiceRepository fchannelServiceRepository;
    @Autowired
    private FileServiceRepository fileServiceRepository;
    @Autowired
    private CmChannelClearServiceRepository cmChannelClearServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private UlLevelServiceRepository ulLevelServiceRepository;
    @Autowired
    private UlLevelUllistServiceRepository ulLevelUllistServiceRepository;
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;

    protected abstract List<Map<String, Object>> makeExcelData(String var1, String var2, String var3);

    public void exportFileZip(HttpServletRequest request, Map<Object, List<String>> listMap, Map<String, Object> paramMap, Map<String, Object> fileMap) {
        String fileName;
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(fileMap) || MapUtil.isEmpty(listMap)) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
            return;
        }
        String fileType = null == fileMap.get("fileType") ? "" : fileMap.get("fileType").toString();
        String string = fileName = null == fileMap.get("fileName") ? "" : fileMap.get("fileName").toString();
        if (StringUtils.isBlank((String)fileType) || StringUtils.isBlank((String)fileName)) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
            return;
        }
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        String userCode = (String)paramMap.get("userCode");
        String tempPath = request.getSession().getServletContext().getRealPath("/") + "../../temp/";
        String tempFlag = "";
        Set<Object> keySet = listMap.keySet();
        ArrayList<String> imageList = new ArrayList<String>();
        for (Object key : keySet) {
            List<String> fileList = listMap.get(key);
            for (int i = 0; i < fileList.size(); ++i) {
                tempFlag = tempPath + keySet + "-" + i + "." + fileType;
                for (String file : fileList) {
                    byte[] bytes = file.getBytes();
                    ImageUtils.writeImageToDisk((byte[])bytes, (String)tempFlag);
                    imageList.add(tempFlag);
                }
            }
        }
        this.logger.error("SpringmvnNewController.exportComExcel.imageList", (Object)JsonUtil.buildNormalBinder().toJson(imageList));
        byte[] bytes = null;
        try {
            ImageUtils.toZip(imageList, (String)(tempPath + fileName + ".zip"), (boolean)true);
            bytes = ExportExcelUtlis.InputStreamByteArray((String)(tempPath + fileName + ".zip"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportComExcel(HttpServletRequest request, Map<String, Object> paramMap, Map<String, Object> infoMap, String apiRouter, String excelTemplate) {
        String json;
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(infoMap) || StringUtils.isBlank((String)apiRouter)) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
            return;
        }
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        if (null == infoMap.get("userCode")) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"userCode is null");
            return;
        }
        String userCode = (String)infoMap.get("userCode");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        long timeMillis = System.currentTimeMillis();
        String formatData = sdf.format(timeMillis);
        String fileName = null == infoMap.get("fileName") ? "" : (String)infoMap.get("fileName");
        String endDate = null == infoMap.get("endDate") ? "" : (String)infoMap.get("endDate");
        String startDate = null == infoMap.get("startDate") ? "" : (String)infoMap.get("startDate");
        fileName = StringUtils.isEmpty((String)excelTemplate) && excelTemplate.equals("lr") ? startDate + "-" + endDate + "-" + fileName : formatData + "-" + fileName;
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = infoMap.get("headMap");
        if (null == headMap) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMap", (Object)(" =:= " + infoMap));
            return;
        }
        List headMapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(headMap), Map.class);
        if (ListUtil.isEmpty((Collection)headMapList)) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMapList", (Object)(" is null " + JsonUtil.buildNormalBinder().toJson(headMap)));
            return;
        }
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            HSSFCellStyle setBorder = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setFontHeightInPoints((short)10);
            font.setBoldweight((short)700);
            setBorder.setFont(font);
            cell.setCellStyle(setBorder);
        }
        int index = 0;
        int page = null == paramMap.get("page") ? 1 : Integer.valueOf(paramMap.get("page").toString());
        while (true) {
            paramMap.put("page", page);
            SpringmvnNewController.makePage(paramMap);
            PostParamMap pmap = new PostParamMap(apiRouter);
            pmap.putParamToJson("map", paramMap);
            json = this.htmlIBaseService.sendMesReJson(pmap);
            List<Map<String, Object>> fromDataList = this.makeExcelData(json, apiRouter, excelTemplate);
            if (ListUtil.isEmpty(fromDataList)) break;
            ArrayList<String[]> dataList = new ArrayList<String[]>();
            ArrayList<String> data = null;
            for (Map<String, Object> map : fromDataList) {
                data = new ArrayList<String>();
                for (Map map1 : headMapList) {
                    String beanName = map1.get("dataName").toString();
                    String value = "";
                    if (StringUtils.isNotBlank((String)beanName)) {
                        String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                        if ("null".equals(value)) {
                            value = "";
                        }
                    }
                    data.add(value);
                }
                String[] array = data.toArray(new String[data.size()]);
                dataList.add(array);
            }
            try {
                ExportExcelUtlis.exportExcel((HSSFSheet)sheet, (HSSFRow)row, (String[])headers, dataList, (String)"yyyy-MM-dd HH:mm:ss", (int)index);
            }
            catch (Exception e) {
                this.logger.error("SpringmvnNewController.exportComExcel.exportExcel", (Object)"Exception");
                return;
            }
            index += dataList.size();
            ++page;
        }
        this.logger.error("SpringmvnNewController.exportComExcel.fromDataList", (Object)json);
        String fileType = "xls";
        String tempPath = request.getSession().getServletContext().getRealPath("/") + "../../temp/" + fileName + "." + fileType;
        if (StringUtils.isBlank((String)tempPath)) {
            this.logger.error("SpringmvnNewController.exportComExcel.tempPath", (Object)tempPath);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(tempPath);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            this.logger.error("SpringmvnNewController.exportComExcel.close", (Throwable)e);
            return;
        }
        finally {
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {}
            }
        }
        byte[] bytes = null;
        try {
            bytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.InputStreamByteArray", (Object)"Exception");
            return;
        }
        this.logger.info("\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u4e4b\u524d\u7684\u6587\u4ef6\u540d\u79f0===" + fileName);
        this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
    }

    private void saveExcel(byte[] bytes, String fileName, String userCode, String fileType, String tenantCode) {
        if (bytes == null || bytes.length <= 0 || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveExcel", (Object)(bytes.length + "-" + fileName + "-" + userCode + "-" + "-" + fileType + "-" + tenantCode));
            return;
        }
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileOwner(userCode);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileContext(bytes);
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])bytes));
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(fileName);
        fileBean.setSize(Long.valueOf(1L));
        this.logger.error("====saveExcel.fmFileReDomainBean===", (Object)JsonUtil.buildNonNullBinder().toJson((Object)fmFileReDomainBean));
        this.saveFile(fileBean, tenantCode, "FILE_11", (FmFileDomainBean)fmFileReDomainBean);
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"param is null");
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            this.logger.error("\u3002SpringmvnNewController\u3002fileBeanList.filename=========", (Object)("===" + ((FileBean)fileBeanList.get(0)).getOriginalFilename()));
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"Exception", (Throwable)e);
            return null;
        }
        return fmFileReDomainBean;
    }

    public static void makePage(Map<String, Object> map) {
        String rows;
        String page;
        if (null == map || map.isEmpty()) {
            return;
        }
        String string = page = null == map.get(ui_page) ? "1" : map.get(ui_page).toString();
        if (null == page) {
            return;
        }
        if (StringUtils.isBlank((String)page)) {
            page = "1";
        }
        String string2 = rows = null == map.get(ui_rows) ? "0" : map.get(ui_rows).toString();
        if (StringUtils.isBlank((String)rows) || "0".equals(rows)) {
            rows = "10";
        }
        map.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
        map.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
        map.put(ui_rows, Long.valueOf(rows).intValue());
        map.put(ui_page, Long.valueOf(page).intValue());
    }

    public void exportExcelAsy(final Map<String, Object> paramMap, final HttpServletRequest request, final String fileName, final String apiCode) {
        ThreadPoolExecutor exService = ThreadPoolFactory.createStoreToDepartThreadPoo();
        exService.execute(new Runnable(){

            @Override
            public void run() {
                SpringmvnNewController.this.makeDefPage(paramMap);
                String excelTemplate = null == paramMap || null == paramMap.get("excelTemplate") ? "" : (String)paramMap.get("excelTemplate");
                UserSession userSession = SpringmvnNewController.this.getUserSession(request);
                if (null == userSession) {
                    SpringmvnNewController.this.logger.error("pringNewMvc.querySkuOneExcel.userSession.null");
                    return;
                }
                String userCode = null == userSession ? "" : userSession.getUserCode();
                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                List headMap = SpringmvnNewController.this.getHeadMap(excelTemplate);
                if (ListUtil.isEmpty((Collection)headMap)) {
                    SpringmvnNewController.this.logger.error("springNewMvc.querySkuOneExcel.headMap.null");
                    return;
                }
                infoMap.put("headMap", headMap);
                infoMap.put("userCode", userCode);
                infoMap.put("fileName", fileName);
                long sysTime = System.currentTimeMillis();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
                long timeMillis = System.currentTimeMillis();
                String formatData = sdf.format(timeMillis);
                FmFchannelDomainBean fmFchannelDomainBean = new FmFchannelDomainBean();
                fmFchannelDomainBean.setTenantCode(SpringmvnNewController.this.getTenantCode(request));
                fmFchannelDomainBean.setFchannelName(formatData + "-" + fileName);
                fmFchannelDomainBean.setFileSort("FILE_IMPORT");
                fmFchannelDomainBean.setFchannelType(Integer.valueOf(-1));
                fmFchannelDomainBean.setFchannelUrl("excel\u5bfc\u5165\u4e2d");
                fmFchannelDomainBean.setFchannelUser(userSession.getUserPcode());
                fmFchannelDomainBean.setFchannelPath(String.valueOf(sysTime));
                SpringmvnNewController.this.logger.info("SpringNewMvc..querySkuOneExcelByFileName.fmFchannelDomainBean", (Object)fmFchannelDomainBean.toString());
                SpringmvnNewController.this.fileServiceRepository.saveFchannel(fmFchannelDomainBean);
                SpringmvnNewController.this.logger.info("SpringNewMvc.querySkuOneExcel.param:", (Object)(paramMap + "=:=" + infoMap + "======" + fileName));
                try {
                    SpringmvnNewController.this.exportComExcelByFileName(request, paramMap, infoMap, apiCode, excelTemplate, fileName);
                }
                catch (Exception e) {
                    SpringmvnNewController.this.logger.error("SpringNewMvc.querySkuOneExcel.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                }
                SpringmvnNewController.this.logger.info("SpringNewMvc.querySkuOneExcel.exportComExcelByFileName.end:", (Object)JsonUtil.buildNormalBinder().toJson((Object)fmFchannelDomainBean));
                if (null != fmFchannelDomainBean) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("fchannelPath", fmFchannelDomainBean.getFchannelPath());
                    map.put("tenantCode", fmFchannelDomainBean.getTenantCode());
                    map.put("fileSort", fmFchannelDomainBean.getFileSort());
                    map.put("fchannelUser", fmFchannelDomainBean.getFchannelUser());
                    SupQueryResult result = SpringmvnNewController.this.fileServiceRepository.queryFchannelPage(map);
                    SpringmvnNewController.this.logger.info("SpringNewMvc.querySkuOneExcelByFileName.", (Object)JsonUtil.buildNormalBinder().toJson((Object)result));
                    if (null != result && ListUtil.isNotEmpty((Collection)result.getList())) {
                        FmFchannelReDomainBean fmFchannelReDomainBean = (FmFchannelReDomainBean)result.getList().get(0);
                        SpringmvnNewController.this.fchannelServiceRepository.deleteFchannel(fmFchannelReDomainBean.getFchannelId());
                    }
                }
            }
        });
    }

    private List<Map<String, Object>> getHeadMap(String excelTemplate) {
        if (StringUtils.isEmpty((String)excelTemplate)) {
            this.logger.error("SpringmvnNewController.getHeadMap=====.null");
            return null;
        }
        this.logger.error("SpringmvnNewController.getHeadMap=====" + excelTemplate);
        List<Map<String, Object>> infoMap = null;
        if ("order".equals(excelTemplate)) {
            infoMap = OrderExcel.covertOrderHeadExcelParam();
        }
        if ("refund".equals(excelTemplate)) {
            infoMap = OrderExcel.covertOrderRefoundExcelParam();
        }
        if ("payIn".equals(excelTemplate)) {
            infoMap = OrderExcel.covertOrderPointsExcel();
        }
        if ("payOut".equals(excelTemplate)) {
            infoMap = OrderExcel.covertReOrdPayExcelParam();
        }
        if ("user".equals(excelTemplate)) {
            infoMap = StoreExcel.covertUserExcel();
        }
        if ("coupon".equals(excelTemplate)) {
            infoMap = DataExcel.covertCouponExcel();
        }
        if ("pmUser".equals(excelTemplate)) {
            infoMap = DataExcel.covertPromotionExcel();
        }
        if ("upm".equals(excelTemplate)) {
            infoMap = DataExcel.covertUpmExcel();
        }
        if ("underActive".equals(excelTemplate)) {
            infoMap = DataExcel.underActiveExcel();
        }
        if ("activeList".equals(excelTemplate)) {
            infoMap = DataExcel.covertActiveExcel();
        }
        return infoMap;
    }

    private List<Map<String, Object>> doDateInd(List<Map<String, Object>> fromDataList, String excelTemplate) {
        if (ListUtil.isEmpty(fromDataList)) {
            return fromDataList;
        }
        List<Map<String, Object>> dateMapList = null;
        dateMapList = "user".equals(excelTemplate) ? this.doDateUserInd(fromDataList) : fromDataList;
        return dateMapList;
    }

    private List<Map<String, Object>> doDateUserInd(List<Map<String, Object>> fromDataList) {
        for (Map<String, Object> fromData : fromDataList) {
            if (fromData.containsKey("userinfoDiscode")) {
                String userinfoDisname = String.valueOf(fromData.get("userinfoDisname"));
                if ("null".equals(userinfoDisname) || StringUtils.isEmpty((String)userinfoDisname)) {
                    fromData.put("userinfoDiscode", "\u76f4\u63a5\u6ce8\u518c");
                } else {
                    fromData.put("userinfoDiscode", "\u9080\u8bf7\u6ce8\u518c");
                }
            } else {
                fromData.put("userinfoDiscode", "\u76f4\u63a5\u6ce8\u518c");
            }
            if (!fromData.containsKey("dataState")) continue;
            if (String.valueOf(fromData.get("dataState")).equals("0")) {
                fromData.put("dataState", "\u542f\u7528");
                continue;
            }
            fromData.put("dataState", "\u505c\u7528");
        }
        return fromDataList;
    }

    private List<Map<String, Object>> makeFromDataList(String excelTemplate, HttpServletRequest request) {
        List<Map<String, Object>> jsonToList = new ArrayList<Map<String, Object>>();
        if ("payOut".equals(excelTemplate)) {
            Map<String, Object> param = this.assemMapParam(request);
            if (null != param) {
                param.put("order", true);
                param.put("fuzzy", true);
                param.put("dicPaypdCode", "PD09");
            }
            ArrayList<CmChannelClearReDomain> resultList = new ArrayList<CmChannelClearReDomain>();
            SupQueryResult cmChannelClearReDomainSupQueryResult = this.cmChannelClearServiceRepository.querychannelClearPage(param);
            if (ListUtil.isNotEmpty((Collection)cmChannelClearReDomainSupQueryResult.getList())) {
                HashMap<String, String> map = new HashMap<String, String>();
                HashMap paramStr = new HashMap();
                for (CmChannelClearReDomain cmChannelClearReDomain : cmChannelClearReDomainSupQueryResult.getList()) {
                    map.put("contractBillcode", cmChannelClearReDomain.getPaymentOrderMemo());
                    map.put("tenantCode", this.getTenantCode(request));
                    OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractModelByCodes(map);
                    if (null == ocContractReDomain) {
                        this.logger.error("makeFromDataList.payOutExcel.ocContractReDomain.null", (Object)((Object)map).toString());
                        continue;
                    }
                    cmChannelClearReDomain.setRefundMoney(ocContractReDomain.getRefundMoney());
                    cmChannelClearReDomain.setMemberName(ocContractReDomain.getMemberName());
                    cmChannelClearReDomain.setUserName(ocContractReDomain.getUserName());
                    resultList.add(cmChannelClearReDomain);
                }
            }
            String str = JsonUtil.buildNormalBinder().toJson(resultList);
            jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(str, Map.class);
        } else if ("payIn".equals(excelTemplate)) {
            SupQueryResult cmChannelClearReDomainSupQueryResult;
            Map<String, Object> param = this.assemMapParam(request);
            if (null != param) {
                param.put("order", true);
                param.put("fuzzy", true);
                param.put("dicPaypdCode", "PD01");
            }
            if (ListUtil.isNotEmpty((Collection)(cmChannelClearReDomainSupQueryResult = this.cmChannelClearServiceRepository.querychannelClearPage(param)).getList())) {
                HashMap<String, String> paramStr = new HashMap<String, String>();
                ArrayList<CmChannelClearReDomain> resultList = new ArrayList<CmChannelClearReDomain>();
                List jsonToList1 = null;
                for (CmChannelClearReDomain cmChannelClearReDomain : cmChannelClearReDomainSupQueryResult.getList()) {
                    if (1 == cmChannelClearReDomain.getChannelClearCallstate()) {
                        cmChannelClearReDomain.setOrderBankseq(null);
                    }
                    paramStr.put("userPcode", cmChannelClearReDomain.getOpuserCode());
                    paramStr.put("tenantCode", this.getTenantCode(request));
                    SupQueryResult umUserReDomainBeanSupQueryResult = this.userServiceRepository.queryUserPage(paramStr);
                    for (UmUserReDomainBean umu : umUserReDomainBeanSupQueryResult.getList()) {
                        cmChannelClearReDomain.setUserName(umu.getUserName());
                    }
                    if (ListUtil.isNotEmpty((Collection)umUserReDomainBeanSupQueryResult.getList())) {
                        cmChannelClearReDomain.setUmUserReDomainBeanList(umUserReDomainBeanSupQueryResult.getList());
                    }
                    this.logger.error("=================umUserReDomainBeanSupQueryResult.getList()======", (Object)umUserReDomainBeanSupQueryResult.getList());
                    resultList.add(cmChannelClearReDomain);
                    String str = JsonUtil.buildNormalBinder().toJson(resultList);
                    jsonToList1 = (List)JsonUtil.buildNormalBinder().getJsonToList(str, Map.class);
                }
            }
            ArrayList<CmChannelClearReDomain> data = new ArrayList<CmChannelClearReDomain>();
            if (cmChannelClearReDomainSupQueryResult.getList().size() > 0) {
                String strDateFormat = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat sdf = new SimpleDateFormat(strDateFormat);
                List list = cmChannelClearReDomainSupQueryResult.getList();
                for (CmChannelClearReDomain cmChannelClearReDomain : list) {
                    Date gmtCreate = cmChannelClearReDomain.getGmtCreate();
                    Integer dataState = cmChannelClearReDomain.getDataState();
                    if (gmtCreate != null) {
                        String format = sdf.format(gmtCreate);
                        cmChannelClearReDomain.setExfaccountAname(format);
                    }
                    if (dataState != null) {
                        if (0 == dataState) {
                            cmChannelClearReDomain.setFaccountBranch("\u5931\u8d25");
                        } else if (1 == dataState) {
                            cmChannelClearReDomain.setFaccountBranch("\u652f\u4ed8\u4e2d");
                        } else if (2 == dataState) {
                            cmChannelClearReDomain.setFaccountBranch("\u6210\u529f");
                        }
                    }
                    data.add(cmChannelClearReDomain);
                }
            }
            jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(data), Map.class);
        } else if ("user".equals(excelTemplate)) {
            HashMap<String, Object> dateMap = null;
            Map<String, Object> map = this.assemMapParam(request);
            this.logger.error("springmvcNew.map", (Object)map.toString());
            SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(map);
            if (null == umUserinfoReDomainBeanSupQueryResult || ListUtil.isEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList())) {
                jsonToList = new ArrayList();
            } else {
                HashMap<String, String> userMap = new HashMap<String, String>();
                userMap.put("tenantCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanSupQueryResult.getList().get(0)).getTenantCode());
                HashMap<String, String> levelMap = new HashMap<String, String>();
                levelMap.put("tenantCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanSupQueryResult.getList().get(0)).getTenantCode());
                SupQueryResult levelSupQueryResult = this.ulLevelServiceRepository.queryUlLevelListPage(levelMap);
                List levelList = null;
                levelList = null == levelSupQueryResult || ListUtil.isEmpty((Collection)levelSupQueryResult.getList()) ? new ArrayList() : levelSupQueryResult.getList();
                HashMap<String, String> upmMap = new HashMap<String, String>();
                upmMap.put("tenantCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanSupQueryResult.getList().get(0)).getTenantCode());
                for (UmUserinfoReDomainBean umUserinfoReDomainBean : umUserinfoReDomainBeanSupQueryResult.getList()) {
                    dateMap = new HashMap<String, Object>();
                    userMap.put("userPcode", umUserinfoReDomainBean.getUserinfoCode());
                    SupQueryResult supQueryResult = this.userServiceRepository.queryUserPage(userMap);
                    if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) continue;
                    UmUserReDomainBean umUserReDomainBean = (UmUserReDomainBean)supQueryResult.getList().get(0);
                    dateMap.put("userinfoId", umUserinfoReDomainBean.getUserinfoId());
                    dateMap.put("userinfoPhone", umUserReDomainBean.getUserName());
                    dateMap.put("userinfoCompname", umUserReDomainBean.getUserNickname());
                    dateMap.put("userBirthday", umUserReDomainBean.getUserBirthday());
                    dateMap.put("gmtCreate", umUserReDomainBean.getGmtCreate());
                    dateMap.put("userinfoDisname", umUserinfoReDomainBean.getUserinfoDisname());
                    dateMap.put("userinfoLevel", this.doLevel(levelList, umUserinfoReDomainBean.getUserinfoCode(), umUserinfoReDomainBean.getTenantCode()));
                    upmMap.put("memberCode", umUserinfoReDomainBean.getUserinfoCode());
                    SupQueryResult upmSupQueryResult = this.upmUpointsServiceRepository.queryUpointsPage(upmMap);
                    BigDecimal upm = null;
                    upm = null == upmSupQueryResult || ListUtil.isEmpty((Collection)upmSupQueryResult.getList()) ? new BigDecimal(0) : ((UpmUpointsReDomain)upmSupQueryResult.getList().get(0)).getUpointsNum();
                    dateMap.put("partnerType", upm);
                    dateMap.put("userinfoDiscode", umUserinfoReDomainBean.getUserinfoDiscode());
                    dateMap.put("dataState", umUserinfoReDomainBean.getDataState());
                    jsonToList.add(dateMap);
                }
            }
        }
        this.logger.error("jsonToList\u3002sizse", (Object)jsonToList.size());
        return jsonToList;
    }

    private String doLevel(List<UlLevelListReDomain> levelList, String userinfoCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("memberCode", userinfoCode);
        SupQueryResult supQueryResult = this.ulLevelUllistServiceRepository.queryUlLevelUpointsPage(map);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            return "\u7b49\u7ea7\u4e0d\u660e\u786e";
        }
        BigDecimal levelNum = ((UlLevelUpointsReDomain)supQueryResult.getList().get(0)).getLevelNum();
        for (UlLevelListReDomain ulLevelListReDomain : levelList) {
            BigDecimal levelListStart = new BigDecimal(ulLevelListReDomain.getLevelListStart());
            BigDecimal levelListEnd = new BigDecimal(ulLevelListReDomain.getLevelListEnd());
            if (levelNum.subtract(levelListStart).compareTo(BigDecimal.ZERO) < 0 || levelListEnd.subtract(levelNum).compareTo(BigDecimal.ZERO) <= 0) continue;
            return ulLevelListReDomain.getLevelListName();
        }
        return "\u7b49\u7ea7\u4e0d\u660e\u786e";
    }

    public void exportExcelByData(final HttpServletRequest request, final String fileName, final String excelTemplate, final List<Map<String, Object>> fromDataList) {
        ThreadPoolExecutor exService = ThreadPoolFactory.createStoreToDepartThreadPoo();
        exService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UserSession userSession = SpringmvnNewController.this.getUserSession(request);
                if (null == userSession) {
                    SpringmvnNewController.this.logger.error("========SpringmvnNewController.exportComExcel.data.userSession.null");
                    return;
                }
                List dateMapList = null;
                dateMapList = null == fromDataList ? SpringmvnNewController.this.makeFromDataList(excelTemplate, request) : SpringmvnNewController.this.doDateInd(fromDataList, excelTemplate);
                String tenantCode = userSession.getTenantCode();
                String userCode = userSession.getUserCode();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                long timeMillis = System.currentTimeMillis();
                String formatData = sdf.format(timeMillis);
                FmFchannelDomainBean fmFchannelDomainBean = new FmFchannelDomainBean();
                fmFchannelDomainBean.setTenantCode(SpringmvnNewController.this.getTenantCode(request));
                fmFchannelDomainBean.setFchannelName(formatData + "-" + fileName);
                fmFchannelDomainBean.setFileSort("FILE_IMPORT");
                fmFchannelDomainBean.setFchannelType(Integer.valueOf(-1));
                fmFchannelDomainBean.setFchannelUrl("excel\u5bfc\u5165\u4e2d");
                fmFchannelDomainBean.setFchannelUser(userSession.getUserPcode());
                fmFchannelDomainBean.setFchannelPath(String.valueOf(timeMillis));
                SpringmvnNewController.this.logger.info("exportExcelByData.querySkuOneExcelByFileName.fmFchannelDomainBean", (Object)fmFchannelDomainBean.toString());
                SpringmvnNewController.this.fileServiceRepository.saveFchannel(fmFchannelDomainBean);
                SpringmvnNewController.this.logger.info("exportExcelByData\u3002SpringNewMvc.querySkuOneExcel.param:", (Object)("save.success.=====" + fileName));
                ArrayList<String> excelHeader = new ArrayList<String>();
                List headMapList = SpringmvnNewController.this.getHeadMap(excelTemplate);
                if (ListUtil.isEmpty((Collection)headMapList)) {
                    SpringmvnNewController.this.logger.error("exportExcelByData.SpringmvnNewController.exportComExcel.headMapList", (Object)" is null ");
                    return;
                }
                for (Map map : headMapList) {
                    String showName = map.get("showName").toString();
                    excelHeader.add(showName);
                }
                String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFSheet sheet = workbook.createSheet(fileName);
                HSSFRow row = sheet.createRow(0);
                for (short i = 0; i < headers.length; i = (short)(i + 1)) {
                    HSSFCell cell = row.createCell(i);
                    HSSFRichTextString text = new HSSFRichTextString(headers[i]);
                    cell.setCellValue((RichTextString)text);
                    HSSFCellStyle setBorder = workbook.createCellStyle();
                    HSSFFont font = workbook.createFont();
                    font.setFontName("\u4eff\u5b8b_GB2312");
                    font.setFontHeightInPoints((short)10);
                    font.setBold(true);
                    setBorder.setFont(font);
                    cell.setCellStyle(setBorder);
                }
                ArrayList<String[]> dataList = new ArrayList<String[]>();
                ArrayList<String> data = null;
                for (Map map : dateMapList) {
                    data = new ArrayList<String>();
                    for (Map map1 : headMapList) {
                        String beanName = map1.get("dataName").toString();
                        String value = "";
                        if (StringUtils.isNotBlank((String)beanName)) {
                            String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                            if ("null".equals(value)) {
                                value = "";
                            }
                        }
                        data.add(value);
                    }
                    String[] array = data.toArray(new String[data.size()]);
                    dataList.add(array);
                }
                try {
                    ExportExcelUtlis.exportExcel((HSSFSheet)sheet, (HSSFRow)row, (String[])headers, dataList, (String)"yyyy-MM-dd HH:mm:ss", (int)0);
                }
                catch (Exception e) {
                    SpringmvnNewController.this.logger.error("exportExcelByData.SpringmvnNewController.exportComExcel.exportExcel", (Object)"Exception");
                    return;
                }
                String fileType = "xls";
                String tempPath = "/tmp/" + fileName + "." + fileType;
                if (StringUtils.isBlank((String)tempPath)) {
                    SpringmvnNewController.this.logger.error("exportExcelByData.SpringmvnNewController.exportComExcel.tempPath", (Object)tempPath);
                    return;
                }
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(tempPath);
                    workbook.write((OutputStream)outputStream);
                    outputStream.flush();
                }
                catch (IOException e) {
                    SpringmvnNewController.this.logger.error("exportExcelByData.SpringmvnNewController.exportComExcel.close", (Throwable)e);
                    return;
                }
                finally {
                    if (null != outputStream) {
                        try {
                            ((OutputStream)outputStream).close();
                        }
                        catch (IOException e) {}
                    }
                }
                byte[] bytes = null;
                try {
                    bytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
                }
                catch (Exception e) {
                    SpringmvnNewController.this.logger.error("exportExcelByData.SpringmvnNewController.exportComExcel.InputStreamByteArray", (Object)"Exception");
                    return;
                }
                SpringmvnNewController.this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
                if (null != fmFchannelDomainBean) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("fchannelPath", fmFchannelDomainBean.getFchannelPath());
                    map.put("tenantCode", fmFchannelDomainBean.getTenantCode());
                    map.put("fileSort", fmFchannelDomainBean.getFileSort());
                    map.put("fchannelUser", fmFchannelDomainBean.getFchannelUser());
                    SupQueryResult result = SpringmvnNewController.this.fileServiceRepository.queryFchannelPage(map);
                    SpringmvnNewController.this.logger.info("exportExcelByData.SpringNewMvc.querySkuOneExcelByFileName.", (Object)JsonUtil.buildNormalBinder().toJson((Object)result));
                    if (null != result && ListUtil.isNotEmpty((Collection)result.getList())) {
                        FmFchannelReDomainBean fmFchannelReDomainBean = (FmFchannelReDomainBean)result.getList().get(0);
                        SpringmvnNewController.this.fileServiceRepository.deleteFchannel(fmFchannelReDomainBean.getFchannelId());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportComExcelByFileName(HttpServletRequest request, Map<String, Object> paramMap, Map<String, Object> infoMap, String apiRouter, String excelTemplate, String fileName) {
        String json;
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(infoMap) || StringUtils.isBlank((String)apiRouter) || StringUtils.isBlank((String)fileName)) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
            return;
        }
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        if (null == infoMap.get("userCode")) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"userCode is null");
            return;
        }
        String userCode = (String)infoMap.get("userCode");
        this.logger.error("=====SpringMvxNewController.fileName=====", (Object)fileName);
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = infoMap.get("headMap");
        List headMapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(headMap), Map.class);
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            HSSFCellStyle setBorder = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setFontHeightInPoints((short)10);
            font.setBoldweight((short)700);
            setBorder.setFont(font);
            cell.setCellStyle(setBorder);
        }
        int index = 0;
        int page = null == paramMap.get("page") ? 1 : Integer.valueOf(paramMap.get("page").toString());
        this.logger.error("====SpringmvnNewController.paramMap=======", paramMap);
        while (true) {
            this.logger.error("====SpringmvnNewController\u3002time=====.t1", (Object)System.currentTimeMillis());
            paramMap.put("page", page);
            SpringmvnNewController.makePage(paramMap);
            PostParamMap pmap = new PostParamMap(apiRouter);
            pmap.putParamToJson("map", paramMap);
            json = this.htmlIBaseService.sendMesReJson(pmap);
            List<Map<String, Object>> fromDataList = this.makeExcelData(json, apiRouter, excelTemplate);
            if (ListUtil.isEmpty(fromDataList)) break;
            ArrayList<String[]> dataList = new ArrayList<String[]>();
            ArrayList<String> data = null;
            for (Map<String, Object> map : fromDataList) {
                data = new ArrayList<String>();
                for (Map map1 : headMapList) {
                    String beanName = map1.get("dataName").toString();
                    String value = "";
                    if (StringUtils.isNotBlank((String)beanName)) {
                        String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                        if ("null".equals(value)) {
                            value = "";
                        }
                    }
                    data.add(value);
                }
                String[] array = data.toArray(new String[data.size()]);
                dataList.add(array);
            }
            try {
                ExportExcelUtlis.exportExcel((HSSFSheet)sheet, (HSSFRow)row, (String[])headers, dataList, (String)"yyyy-MM-dd HH:mm:ss", (int)index);
            }
            catch (Exception e) {
                this.logger.error("SpringmvnNewController.exportComExcel.exportExcel", (Object)"Exception");
                return;
            }
            index += dataList.size();
            ++page;
            this.logger.error("====SpringmvnNewController\u3002time=====.t2", (Object)System.currentTimeMillis());
        }
        this.logger.error("SpringmvnNewController.exportComExcel.fromDataList", (Object)json);
        String fileType = "xls";
        String tempPath = "/tmp/" + fileName + "." + fileType;
        if (StringUtils.isBlank((String)tempPath)) {
            this.logger.error("SpringmvnNewController.exportComExcel.tempPath", (Object)tempPath);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(tempPath);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            this.logger.error("SpringmvnNewController.exportComExcel.close", (Throwable)e);
            return;
        }
        finally {
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {}
            }
        }
        byte[] bytes = null;
        try {
            bytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.InputStreamByteArray", (Throwable)e);
            return;
        }
        this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
    }
}

