/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc.filter;

import com.qjsoft.laser.controller.springmvc.filter.XssHttpServletRequestWrapper;
import com.yqbsoft.laser.service.suppercore.supper.ObjectService;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;

public class XssFilter
extends ObjectService
implements Filter {
    private static boolean IS_INCLUDE_RICH_TEXT = false;
    public List<String> excludes = new ArrayList<String>();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse resp;
        HttpServletRequest req;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("xss filter is open");
        }
        if (this.handleExcludeURL(req = (HttpServletRequest)request, resp = (HttpServletResponse)response)) {
            filterChain.doFilter(request, response);
            return;
        }
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request, IS_INCLUDE_RICH_TEXT);
        filterChain.doFilter((ServletRequest)xssRequest, response);
    }

    private boolean handleExcludeURL(HttpServletRequest request, HttpServletResponse response) {
        if (this.excludes == null || this.excludes.isEmpty()) {
            return false;
        }
        String url = request.getServletPath();
        for (String pattern : this.excludes) {
            Pattern p = Pattern.compile("^" + pattern);
            Matcher m = p.matcher(url);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String temp;
        String isIncludeRichText;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("xss filter init~~~~~~~~~~~~");
        }
        if (StringUtils.isNotBlank((String)(isIncludeRichText = filterConfig.getInitParameter("isIncludeRichText")))) {
            IS_INCLUDE_RICH_TEXT = BooleanUtils.toBoolean((String)isIncludeRichText);
        }
        if ((temp = filterConfig.getInitParameter("excludes")) != null) {
            String[] url = temp.split(",");
            for (int i = 0; url != null && i < url.length; ++i) {
                this.excludes.add(url[i]);
            }
        }
    }

    public void destroy() {
    }
}

