/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc.filter;

import com.qjsoft.laser.controller.core.auth.AuthCheck;
import com.yqbsoft.laser.service.suppercore.supper.ObjectService;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RequestFilter
extends ObjectService
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        AuthCheck authCheck = new AuthCheck();
        authCheck.setMethod(httpServletRequest.getMethod());
        String url = httpServletRequest.getServletPath();
        authCheck.setUrl(url);
        authCheck.setContextPath(httpServletRequest.getContextPath());
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public class BodyReaderHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final byte[] body;

        public BodyReaderHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
            super(request);
            String sessionStream = this.getBodyString((ServletRequest)request);
            this.body = sessionStream.getBytes(Charset.forName("UTF-8"));
            RequestFilter.this.logger.debug("\u4fdd\u5b58\u7684\u6d41" + sessionStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getBodyString(ServletRequest request) {
            StringBuilder sb = new StringBuilder();
            InputStream inputStream = null;
            BufferedReader reader = null;
            try {
                inputStream = this.cloneInputStream(request.getInputStream());
                reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return sb.toString();
        }

        public InputStream cloneInputStream(ServletInputStream inputStream) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            try {
                int len;
                while ((len = inputStream.read(buffer)) > -1) {
                    byteArrayOutputStream.write(buffer, 0, len);
                }
                byteArrayOutputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }

        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
            return new ServletInputStream(){

                public int read() throws IOException {
                    return bais.read();
                }
            };
        }
    }
}

