/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.springmvc.filter;

import com.qjsoft.laser.controller.springmvc.filter.XssHttpServletRequestWrapper;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class XssFilter
extends OncePerRequestFilter {
    private String exclude = null;
    private Pattern pattern = null;

    public void setExclude(String exclude) {
        this.exclude = exclude;
        this.pattern = Pattern.compile(this.getRegStr(exclude));
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.logger.error((Object)"XssFilter---\u8fdb\u5165\u68c0\u6d4b\uff01\uff01\uff01");
        String requestURI = request.getRequestURI();
        if (StringUtils.isNotBlank((CharSequence)requestURI)) {
            requestURI = requestURI.replace(request.getContextPath(), "");
        }
        if (this.pattern.matcher(requestURI).matches()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            XssHttpServletRequestWrapper xssHttpServletRequestWrapper = new XssHttpServletRequestWrapper(request, true);
            filterChain.doFilter((ServletRequest)xssHttpServletRequestWrapper, (ServletResponse)response);
        }
    }

    private String getRegStr(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            Object[] excludes = str.split(",");
            int length = excludes.length;
            for (int i = 0; i < length; ++i) {
                String tmpExclude = excludes[i];
                tmpExclude = tmpExclude.replace("\\", "\\\\").replace(".", "\\.").replace("*", ".*");
                tmpExclude = "^" + tmpExclude + "$";
                excludes[i] = tmpExclude;
            }
            return StringUtils.join((Object[])excludes, (String)"|");
        }
        return str;
    }
}

