/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.st.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.st.domain.StSalequotaListDomain;
import com.qjsoft.laser.controller.facade.st.domain.StSalequotaListReDomain;
import com.qjsoft.laser.controller.facade.st.repository.StSalequotaListServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.qjsoft.laser.controller.st.controller.domain.RestrictVo;
import com.yqbsoft.laser.service.suppercore.SupperApiException;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/st/stSalequotaList"}, name="\u5546\u54c1\u9650\u989d\u4f7f\u7528\u660e\u7ec6")
public class StSalequotaListCon
extends SpringmvcController {
    private static String CODE = "st.stSalequotaList.con";
    @Autowired
    private StSalequotaListServiceRepository stSalequotaListServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;

    protected String getContext() {
        return "stSalequotaList";
    }

    @RequestMapping(value={"saveAndUpdateRsSkuRestrictNum.json"}, name="\u589e\u52a0\u5546\u54c1\u6570\u91cf\u8d2d\u4e70\u9650\u8d2d")
    @ResponseBody
    public RestrictVo saveRsSkuRestrictNum(HttpServletRequest request, String paramStr) {
        StSalequotaListReDomain reDomain;
        if (StringUtils.isBlank((String)paramStr)) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String salequotaListCode = null;
        RestrictVo restrictVo = new RestrictVo();
        StSalequotaListDomain stSalequotaListDomain = (StSalequotaListDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, StSalequotaListDomain.class);
        if (stSalequotaListDomain.getSalequotaListId() != null) {
            reDomain = this.stSalequotaListServiceRepository.getSalequotaList(stSalequotaListDomain.getSalequotaListId());
            if (reDomain == null) {
                return null;
            }
        } else {
            HashMap<String, String> rsMap = new HashMap<String, String>();
            rsMap.put("skuCode", stSalequotaListDomain.getSalequotaValue());
            rsMap.put("tenantCode", tenantCode);
            SupQueryResult queryResult = this.rsSkuServiceRepository.querySkuPage(rsMap);
            if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                for (RsSkuReDomain rsSkuReDomain : queryResult.getList()) {
                    stSalequotaListDomain.setSalequotaUpro(rsSkuReDomain.getSkuCode() + rsSkuReDomain.getChannelCode());
                    stSalequotaListDomain.setSalequotaUproname(rsSkuReDomain.getMemberBname());
                    stSalequotaListDomain.setSalequotaUprovalue(rsSkuReDomain.getMemberBcode());
                    stSalequotaListDomain.setSalequotaSpro("skuNo");
                    stSalequotaListDomain.setSalequotaName(rsSkuReDomain.getSkuName());
                    stSalequotaListDomain.setSalequotaValue(rsSkuReDomain.getSkuCode());
                    stSalequotaListDomain.setTenantCode(tenantCode);
                    HtmlJsonReBean htmlJsonReBean = this.stSalequotaListServiceRepository.saveSalequotaList(stSalequotaListDomain);
                    if (!htmlJsonReBean.isSuccess() || htmlJsonReBean.getDataObj() == null || !StringUtils.isNotBlank((String)htmlJsonReBean.getDataObj().toString())) continue;
                    if (StringUtils.isBlank(salequotaListCode)) {
                        salequotaListCode = htmlJsonReBean.getDataObj().toString();
                    }
                    rsSkuReDomain.setSkuRestrictType(stSalequotaListDomain.getSalequotaType());
                    rsSkuReDomain.setSkuRestrictCode(htmlJsonReBean.getDataObj().toString());
                    HtmlJsonReBean jsonReBean = this.rsSkuServiceRepository.updateSku((RsSkuDomain)rsSkuReDomain);
                    if (jsonReBean.isSuccess()) continue;
                    throw new SupperApiException("error", "\u5b58\u5728\u66f4\u65b0SKU\u9650\u8d2d\u5931\u8d25:" + rsSkuReDomain.getChannelName() + rsSkuReDomain.getSkuCode());
                }
            }
        }
        reDomain = this.stSalequotaListServiceRepository.getSalequotaListByCode(tenantCode, salequotaListCode);
        try {
            BeanUtils.copyAllPropertys((Object)restrictVo, (Object)reDomain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return restrictVo;
    }

    @RequestMapping(value={"saveStSalequotaList.json"}, name="\u589e\u52a0\u5546\u54c1\u9650\u989d\u4f7f\u7528\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveStSalequotaList(HttpServletRequest request, String stSalequotaListDomainjson) {
        if (null == stSalequotaListDomainjson) {
            this.logger.error(CODE + ".saveStSalequotaList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        StSalequotaListDomain stSalequotaListDomain = (StSalequotaListDomain)JsonUtil.buildNormalBinder().getJsonToObject(stSalequotaListDomainjson, StSalequotaListDomain.class);
        stSalequotaListDomain.setTenantCode(this.getTenantCode(request));
        return this.stSalequotaListServiceRepository.saveSalequotaList(stSalequotaListDomain);
    }

    @RequestMapping(value={"getStSalequotaList.json"}, name="\u83b7\u53d6\u5546\u54c1\u9650\u989d\u4f7f\u7528\u660e\u7ec6\u4fe1\u606f")
    @ResponseBody
    public StSalequotaListReDomain getStSalequotaList(Integer salequotaListId) {
        if (StringUtils.isBlank((Integer)salequotaListId)) {
            this.logger.error(CODE + ".getStSalequotaList", (Object)"param is null");
            return null;
        }
        return this.stSalequotaListServiceRepository.getSalequotaList(salequotaListId);
    }

    @RequestMapping(value={"updateStSalequotaList.json"}, name="\u66f4\u65b0\u5546\u54c1\u9650\u989d\u4f7f\u7528\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean updateStSalequotaList(HttpServletRequest request, String stSalequotaListDomainjson) {
        if (null == stSalequotaListDomainjson) {
            this.logger.error(CODE + ".saveStSalequotaList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        StSalequotaListDomain stSalequotaListDomain = (StSalequotaListDomain)JsonUtil.buildNormalBinder().getJsonToObject(stSalequotaListDomainjson, StSalequotaListDomain.class);
        stSalequotaListDomain.setTenantCode(this.getTenantCode(request));
        return this.stSalequotaListServiceRepository.updateSalequotaList(stSalequotaListDomain);
    }

    @RequestMapping(value={"deleteStSalequotaList.json"}, name="\u5220\u9664\u5546\u54c1\u9650\u989d\u4f7f\u7528\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean deleteStSalequotaList(Integer salequotaListId) {
        if (StringUtils.isBlank((Integer)salequotaListId)) {
            this.logger.error(CODE + ".deleteStSalequotaList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.stSalequotaListServiceRepository.deleteSalequotaList(salequotaListId);
    }

    @RequestMapping(value={"queryStSalequotaListPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u9650\u989d\u4f7f\u7528\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<StSalequotaListReDomain> queryStSalequotaListPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.stSalequotaListServiceRepository.querySalequotaListPage(param);
    }

    @RequestMapping(value={"updateStSalequotaListState.json"}, name="\u66f4\u65b0\u5546\u54c1\u9650\u989d\u4f7f\u7528\u660e\u7ec6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateStSalequotaListState(String salequotaListId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)salequotaListId)) {
            this.logger.error(CODE + ".updateStSalequotaListState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.stSalequotaListServiceRepository.updateSalequotaListState(Integer.valueOf(salequotaListId), dataState, oldDataState, null);
    }
}

