/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.ta.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ta.domain.TaTransferaDomain;
import com.qjsoft.laser.controller.facade.ta.domain.TaTransferaListReDomain;
import com.qjsoft.laser.controller.facade.ta.domain.TaTransferaReDomain;
import com.qjsoft.laser.controller.facade.ta.repository.TaTransferaServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ta/Transfera"}, name="\u8f6c\u8d26\u670d\u52a1")
public class TransferaCon
extends SpringmvcController {
    private static String CODE = "ta.Transfera.con";
    @Autowired
    private TaTransferaServiceRepository taTransferaServiceRepository;

    protected String getContext() {
        return "Transfera";
    }

    @RequestMapping(value={"saveTransfera.json"}, name="\u589e\u52a0\u8f6c\u8d26\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveTransfera(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateProject", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        TaTransferaDomain taTransferaDomain = (TaTransferaDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, TaTransferaDomain.class);
        taTransferaDomain.setTenantCode(this.getTenantCode(request));
        List taTransferaListDomainList = taTransferaDomain.getTaTransferaListDomainList();
        if (null == taTransferaListDomainList || taTransferaListDomainList.size() == 0) {
            this.logger.error(CODE + ".updateProject.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8f6c\u8d26\u6d3e\u53d1\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taTransferaServiceRepository.saveTransfera(taTransferaDomain);
    }

    @RequestMapping(value={"getTransfera.json"}, name="\u83b7\u53d6\u8f6c\u8d26\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public TaTransferaReDomain getTransfera(Integer transferaId) {
        if (StringUtils.isBlank((Integer)transferaId)) {
            this.logger.error(CODE + ".getTransfera", (Object)"param is null");
            return null;
        }
        return this.taTransferaServiceRepository.getTransfera(transferaId);
    }

    @RequestMapping(value={"getTransferaListByCode.json"}, name="\u83b7\u53d6\u8f6c\u8d26\u8f6c\u5165\u5217\u8868")
    @ResponseBody
    public TaTransferaListReDomain getTransferaListByCode(HttpServletRequest request, String transferaListCode) {
        if (StringUtils.isBlank((String)transferaListCode)) {
            this.logger.error(CODE + ".getTransfera", (Object)"param is null");
            return null;
        }
        return this.taTransferaServiceRepository.getTransferaListByCode(this.getTenantCode(request), transferaListCode);
    }

    @RequestMapping(value={"updateTransfera.json"}, name="\u66f4\u65b0\u8f6c\u8d26\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateTransfera(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateProject", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        TaTransferaDomain taTransferaDomain = (TaTransferaDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, TaTransferaDomain.class);
        taTransferaDomain.setTenantCode(this.getTenantCode(request));
        List taTransferaListDomainList = taTransferaDomain.getTaTransferaListDomainList();
        if (null == taTransferaListDomainList || taTransferaListDomainList.size() == 0) {
            this.logger.error(CODE + ".updateProject.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8f6c\u8d26\u6d3e\u53d1\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taTransferaServiceRepository.updateTransfera(taTransferaDomain);
    }

    @RequestMapping(value={"deleteTransfera.json"}, name="\u5220\u9664\u8f6c\u8d26\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteTransfera(Integer transferaId) {
        if (StringUtils.isBlank((Integer)transferaId)) {
            this.logger.error(CODE + ".deleteTransfera", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.taTransferaServiceRepository.deleteTransfera(transferaId);
    }

    @RequestMapping(value={"queryTransferaPage.json"}, name="\u67e5\u8be2\u8f6c\u8d26\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TaTransferaReDomain> queryTransferaPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.taTransferaServiceRepository.queryTransferaPage(param);
    }

    @RequestMapping(value={"queryTransferaPageRev .json"}, name="\u67e5\u8be2\u8f6c\u8d26\u670d\u52a1\u5ba1\u6838\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TaTransferaReDomain> queryTransferaPageRev(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("dataState", 1);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.taTransferaServiceRepository.queryTransferaPage(param);
    }

    @RequestMapping(value={"queryTransferaPageSuc .json"}, name="\u67e5\u8be2\u8f6c\u8d26\u670d\u52a1\u5f85\u6267\u884c\u5206\u9875\u5217\u8868\uff08\u5ba1\u6838\u6210\u529f\uff09")
    @ResponseBody
    public SupQueryResult<TaTransferaReDomain> queryTransferaPageSuc(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("dataState", 2);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.taTransferaServiceRepository.queryTransferaPage(param);
    }

    @RequestMapping(value={"updateTransferaState.json"}, name="\u66f4\u65b0\u8f6c\u8d26\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateTransferaState(String transferaId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)transferaId)) {
            this.logger.error(CODE + ".updateTransferaState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.taTransferaServiceRepository.updateTransferaState(Integer.valueOf(transferaId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateTransferaStateSub.json"}, name="\u8f6c\u8d26\u63d0\u4ea4\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean updateTransferaStateSub(HttpServletRequest request, String transferaCode) {
        if (StringUtils.isBlank((String)transferaCode)) {
            this.logger.error(CODE + ".updateTransferaState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.taTransferaServiceRepository.updateTransferaStateByCode(this.getTenantCode(request), transferaCode, Integer.valueOf(1), Integer.valueOf(0));
    }

    @RequestMapping(value={"updateTransferaStateExam.json"}, name="\u8f6c\u8d26\u5ba1\u6838\u6210\u529f")
    @ResponseBody
    public HtmlJsonReBean updateTransferaStateExams(HttpServletRequest request, String transferaCode) {
        if (StringUtils.isBlank((String)transferaCode)) {
            this.logger.error(CODE + ".updateTransferaState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.taTransferaServiceRepository.updateTransferaStateByCode(this.getTenantCode(request), transferaCode, Integer.valueOf(2), Integer.valueOf(1));
    }

    @RequestMapping(value={"updateTransferaStateExamf.json"}, name="\u8f6c\u8d26\u5ba1\u6838\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateTransferaStateExamf(HttpServletRequest request, String transferaCode) {
        if (StringUtils.isBlank((String)transferaCode)) {
            this.logger.error(CODE + ".updateTransferaState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.taTransferaServiceRepository.updateTransferaStateByCode(this.getTenantCode(request), transferaCode, Integer.valueOf(-1), Integer.valueOf(1));
    }

    @RequestMapping(value={"updateTransferaStateImp.json"}, name="\u6267\u884c\u8f6c\u8d26")
    @ResponseBody
    public HtmlJsonReBean updateTransferaStateImp(HttpServletRequest request, String transferaCode) {
        if (StringUtils.isBlank((String)transferaCode)) {
            this.logger.error(CODE + ".updateTransferaState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.taTransferaServiceRepository.updateTransferaStateByCode(this.getTenantCode(request), transferaCode, Integer.valueOf(3), Integer.valueOf(2));
    }
}

