/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.tk.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.tk.domain.TkTaskDomain;
import com.qjsoft.laser.controller.facade.tk.domain.TkTaskReDomain;
import com.qjsoft.laser.controller.facade.tk.repository.TkTaskServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/tk/task"}, name="\u4efb\u52a1")
public class TaskCon
extends SpringmvcController {
    private static String CODE = "tk.task.con";
    @Autowired
    private TkTaskServiceRepository tkTaskServiceRepository;

    protected String getContext() {
        return "task";
    }

    @RequestMapping(value={"saveTask.json"}, name="\u589e\u52a0\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveTask(HttpServletRequest request, TkTaskDomain tkTaskDomain) {
        if (null == tkTaskDomain) {
            this.logger.error(CODE + ".saveTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        tkTaskDomain.setTenantCode(this.getTenantCode(request));
        return this.tkTaskServiceRepository.saveTask(tkTaskDomain);
    }

    @RequestMapping(value={"getTask.json"}, name="\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f")
    @ResponseBody
    public TkTaskReDomain getTask(Integer taskId) {
        if (StringUtils.isBlank((Integer)taskId)) {
            this.logger.error(CODE + ".getTask", (Object)"param is null");
            return null;
        }
        return this.tkTaskServiceRepository.getTask(taskId);
    }

    @RequestMapping(value={"updateTask.json"}, name="\u66f4\u65b0\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateTask(HttpServletRequest request, TkTaskDomain tkTaskDomain) {
        if (null == tkTaskDomain) {
            this.logger.error(CODE + ".updateTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        tkTaskDomain.setTenantCode(this.getTenantCode(request));
        return this.tkTaskServiceRepository.updateTask(tkTaskDomain);
    }

    @RequestMapping(value={"deleteTask.json"}, name="\u5220\u9664\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteTask(Integer taskId) {
        if (StringUtils.isBlank((Integer)taskId)) {
            this.logger.error(CODE + ".deleteTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tkTaskServiceRepository.deleteTask(taskId);
    }

    @RequestMapping(value={"queryTaskPage.json"}, name="\u67e5\u8be2\u4efb\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TkTaskReDomain> queryTaskPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tkTaskServiceRepository.queryTaskPage(param);
    }

    @RequestMapping(value={"getTaskBytaskOpcode.json"}, name="\u66f4\u5177\u6765\u6e90CODE\u83b7\u53d6\u4efb\u52a1\u5355")
    @ResponseBody
    public TkTaskReDomain getTaskBytaskOpcode(HttpServletRequest request, String taskOpcode) {
        if (StringUtils.isBlank((String)taskOpcode)) {
            this.logger.error(CODE + ".getTaskBytaskOpcode", (Object)"taskOpcode is null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", this.getTenantCode(request));
        param.put("taskOpcode", taskOpcode);
        SupQueryResult tkTaskReDomainSupQueryResult = this.tkTaskServiceRepository.queryTaskPage(param);
        if (null == tkTaskReDomainSupQueryResult || ListUtil.isEmpty((Collection)tkTaskReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".getTaskBytaskOpcode.tkTaskReDomainSupQueryResult", (Object)"tkTaskReDomainSupQueryResult is null");
            return null;
        }
        return (TkTaskReDomain)tkTaskReDomainSupQueryResult.getList().get(0);
    }

    @RequestMapping(value={"updateIssueTask.json"}, name="\u5206\u53d1\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateIssueTask(HttpServletRequest request, String tkTaskDomainStr) {
        if (StringUtils.isBlank((String)tkTaskDomainStr)) {
            this.logger.error(CODE + ".updateTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        TkTaskDomain jsonToObject = (TkTaskDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(tkTaskDomainStr, TkTaskDomain.class);
        if (null == jsonToObject) {
            this.logger.error(CODE + ".updateTask.jsonToObject", (Object)"jsonToObject is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "jsonToObject is null");
        }
        jsonToObject.setTenantCode(this.getTenantCode(request));
        this.tkTaskServiceRepository.updateTask(jsonToObject);
        return this.tkTaskServiceRepository.updateTaskState(jsonToObject.getTaskId(), Integer.valueOf(1), Integer.valueOf(0), null);
    }

    @RequestMapping(value={"updateTaskStateComplete.json"}, name="\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210")
    @ResponseBody
    public HtmlJsonReBean updateTaskStateComplete(String taskId) {
        if (StringUtils.isBlank((String)taskId)) {
            this.logger.error(CODE + ".updateTaskState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tkTaskServiceRepository.updateTaskState(Integer.valueOf(taskId), Integer.valueOf(2), Integer.valueOf(1), null);
    }
}

