/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.ul.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ul.domain.UlLevelDomain;
import com.qjsoft.laser.controller.facade.ul.domain.UlLevelListDomain;
import com.qjsoft.laser.controller.facade.ul.domain.UlLevelListReDomain;
import com.qjsoft.laser.controller.facade.ul.domain.UlLevelReDomain;
import com.qjsoft.laser.controller.facade.ul.repository.UlLevelServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ul/ulLevel"}, name="\u7b49\u7ea7\u8bbe\u7f6e")
public class UlLevelCon
extends SpringmvcController {
    private static String CODE = "ul.ulLevel.con";
    @Autowired
    private UlLevelServiceRepository ulLevelServiceRepository;

    protected String getContext() {
        return "ulLevel";
    }

    @RequestMapping(value={"saveUlLevel.json"}, name="\u589e\u52a0\u7b49\u7ea7\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveUlLevel(HttpServletRequest request, String ulLevelJson) {
        if (null == ulLevelJson) {
            this.logger.error(CODE + ".ulLevelJson", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UlLevelDomain ulLevelDomain = (UlLevelDomain)JsonUtil.buildNormalBinder().getJsonToObject(ulLevelJson, UlLevelDomain.class);
        if (null == ulLevelDomain) {
            this.logger.error(CODE + ".ulLevelDomain", (Object)"ulLevelDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".saveUlLevel", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        ulLevelDomain.setMemberCode(userSession.getUserPcode());
        ulLevelDomain.setMemberName(userSession.getMerberCompname());
        ulLevelDomain.setTenantCode(this.getTenantCode(request));
        ulLevelDomain.setLevelSort("0");
        ulLevelDomain.setLevelType("0");
        return this.ulLevelServiceRepository.saveUlLevel(ulLevelDomain);
    }

    @RequestMapping(value={"getUlLevelByTenantCode.json"}, name="\u901a\u8fc7\u5e73\u53f0\u83b7\u53d6\u7b49\u7ea7\u8bbe\u7f6e\u4fe1\u606f")
    @ResponseBody
    public UlLevelReDomain getUlLevelByTenantCode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".saveUlLevel", (Object)"userSession is null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fuzzy", false);
        map.put("tenantCode", this.getTenantCode(request));
        map.put("levelType", "0");
        map.put("levelSort", "0");
        UlLevelReDomain ulLevelReDomain = null;
        SupQueryResult ulLevelReDomainList = this.ulLevelServiceRepository.queryUlLevelPage(map);
        if (null != ulLevelReDomainList && ListUtil.isNotEmpty((Collection)ulLevelReDomainList.getList())) {
            ulLevelReDomain = (UlLevelReDomain)ulLevelReDomainList.getList().get(0);
        }
        if (null != ulLevelReDomain) {
            map.remove("levelType");
            map.remove("levelSort");
            map.put("levelCode", ulLevelReDomain.getLevelCode());
            SupQueryResult ulLevelList = this.ulLevelServiceRepository.queryUlLevelListPage(map);
            if (null != ulLevelList && ListUtil.isNotEmpty((Collection)ulLevelList.getList())) {
                ulLevelReDomain.setUlLevelListReDomainList(ulLevelList.getList());
            }
        }
        return ulLevelReDomain;
    }

    @RequestMapping(value={"getUlLevel.json"}, name="\u83b7\u53d6\u7b49\u7ea7\u8bbe\u7f6e\u4fe1\u606f")
    @ResponseBody
    public UlLevelReDomain getUlLevel(Integer ulLevelId) {
        if (StringUtils.isBlank((Integer)ulLevelId)) {
            this.logger.error(CODE + ".getUlLevel", (Object)"param is null");
            return null;
        }
        return this.ulLevelServiceRepository.getUlLevel(ulLevelId);
    }

    @RequestMapping(value={"updateUlLevel.json"}, name="\u66f4\u65b0\u7b49\u7ea7\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateUlLevel(HttpServletRequest request, UlLevelDomain ulLevelDomain) {
        if (null == ulLevelDomain) {
            this.logger.error(CODE + ".updateUlLevel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ulLevelDomain.setTenantCode(this.getTenantCode(request));
        return this.ulLevelServiceRepository.updateUlLevel(ulLevelDomain);
    }

    @RequestMapping(value={"deleteUlLevel.json"}, name="\u5220\u9664\u7b49\u7ea7\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteUlLevel(Integer ulLevelId) {
        if (StringUtils.isBlank((Integer)ulLevelId)) {
            this.logger.error(CODE + ".deleteUlLevel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ulLevelServiceRepository.deleteUlLevel(ulLevelId);
    }

    @RequestMapping(value={"queryUlLevelPage.json"}, name="\u67e5\u8be2\u7b49\u7ea7\u8bbe\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UlLevelReDomain> queryUlLevelPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ulLevelServiceRepository.queryUlLevelPage(param);
    }

    @RequestMapping(value={"updateUlLevelState.json"}, name="\u542f\u52a8\u7b49\u7ea7\u8bbe\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateUlLevelState(String ulLevelId) {
        if (StringUtils.isBlank((String)ulLevelId)) {
            this.logger.error(CODE + ".updateUlLevelState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ulLevelServiceRepository.updateUlLevelState(Integer.valueOf(ulLevelId), Integer.valueOf(1), Integer.valueOf(0), null);
    }

    @RequestMapping(value={"stoppeUlLevelState.json"}, name="\u505c\u6b62\u7b49\u7ea7\u8bbe\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean stoppeUlLevelState(String ulLevelId) {
        if (StringUtils.isBlank((String)ulLevelId)) {
            this.logger.error(CODE + ".updateUlLevelState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ulLevelServiceRepository.updateUlLevelState(Integer.valueOf(ulLevelId), Integer.valueOf(0), Integer.valueOf(1), null);
    }

    @RequestMapping(value={"saveUlLevelList.json"}, name="\u589e\u52a0\u7b49\u7ea7\u8bbe\u7f6e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveUlLevelList(HttpServletRequest request, UlLevelListDomain ulLevelListDomain) {
        if (null == ulLevelListDomain) {
            this.logger.error(CODE + ".saveUlLevelList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ulLevelListDomain.setTenantCode(this.getTenantCode(request));
        return this.ulLevelServiceRepository.saveUlLevelList(ulLevelListDomain);
    }

    @RequestMapping(value={"getUlLevelList.json"}, name="\u83b7\u53d6\u7b49\u7ea7\u8bbe\u7f6e\u660e\u7ec6\u4fe1\u606f")
    @ResponseBody
    public UlLevelListReDomain getUlLevelList(Integer ulLevelListId) {
        if (StringUtils.isBlank((Integer)ulLevelListId)) {
            this.logger.error(CODE + ".getUlLevelList", (Object)"param is null");
            return null;
        }
        return this.ulLevelServiceRepository.getUlLevelList(ulLevelListId);
    }

    @RequestMapping(value={"updateUlLevelList.json"}, name="\u66f4\u65b0\u7b49\u7ea7\u8bbe\u7f6e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean updateUlLevelList(HttpServletRequest request, UlLevelListDomain ulLevelListDomain) {
        if (null == ulLevelListDomain) {
            this.logger.error(CODE + ".updateUlLevelList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ulLevelListDomain.setTenantCode(this.getTenantCode(request));
        return this.ulLevelServiceRepository.updateUlLevelList(ulLevelListDomain);
    }

    @RequestMapping(value={"deleteUlLevelList.json"}, name="\u5220\u9664\u7b49\u7ea7\u8bbe\u7f6e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean deleteUlLevelList(Integer ulLevelListId) {
        if (StringUtils.isBlank((Integer)ulLevelListId)) {
            this.logger.error(CODE + ".deleteUlLevelList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ulLevelServiceRepository.deleteUlLevelList(ulLevelListId);
    }

    @RequestMapping(value={"queryUlLevelListPage.json"}, name="\u67e5\u8be2\u7b49\u7ea7\u8bbe\u7f6e\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UlLevelListReDomain> queryUlLevelListPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ulLevelServiceRepository.queryUlLevelListPage(param);
    }

    @RequestMapping(value={"updateUlLevelListState.json"}, name="\u5f00\u542f\u7b49\u7ea7\u8bbe\u7f6e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean updateUlLevelListState(String ulLevelListId) {
        if (StringUtils.isBlank((String)ulLevelListId)) {
            this.logger.error(CODE + ".updateUlLevelListState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ulLevelServiceRepository.updateUlLevelListState(Integer.valueOf(ulLevelListId), Integer.valueOf(1), Integer.valueOf(0), null);
    }

    @RequestMapping(value={"stoppeUlLevelListState.json"}, name="\u505c\u6b62\u7b49\u7ea7\u8bbe\u7f6e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean stoppeUlLevelListState(String ulLevelListId) {
        if (StringUtils.isBlank((String)ulLevelListId)) {
            this.logger.error(CODE + ".updateUlLevelListState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ulLevelServiceRepository.updateUlLevelListState(Integer.valueOf(ulLevelListId), Integer.valueOf(0), Integer.valueOf(1), null);
    }
}

