/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.ur.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingReDomain;
import com.qjsoft.laser.controller.facade.dd.repository.DdFalgSettingServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.ur.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.ur.domain.UrOrderUserDomain;
import com.qjsoft.laser.controller.facade.ur.domain.UrUserrightsDomain;
import com.qjsoft.laser.controller.facade.ur.domain.UrUserrightsGoodsDomain;
import com.qjsoft.laser.controller.facade.ur.domain.UrUserrightsGoodsReDomain;
import com.qjsoft.laser.controller.facade.ur.domain.UrUserrightsListDomain;
import com.qjsoft.laser.controller.facade.ur.domain.UrUserrightsListReDomain;
import com.qjsoft.laser.controller.facade.ur.domain.UrUserrightsReDomain;
import com.qjsoft.laser.controller.facade.ur.repository.UrUserrightsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ur/userrights"}, name="\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
public class UserrightsCon
extends SpringmvcController {
    private static String CODE = "ur.userrights.con";
    @Autowired
    private UrUserrightsServiceRepository urUserrightsServiceRepository;
    @Autowired
    private DdFalgSettingServiceRepository ddFalgSettingServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;

    protected String getContext() {
        return "userrights";
    }

    @RequestMapping(value={"saveUserrights.json"}, name="\u589e\u52a0\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveUserrights(HttpServletRequest request, UrUserrightsDomain urUserrightsDomain) {
        if (null == urUserrightsDomain) {
            this.logger.error(CODE + ".saveUserrights", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        urUserrightsDomain.setTenantCode(this.getTenantCode(request));
        return this.urUserrightsServiceRepository.saveUserrights(urUserrightsDomain);
    }

    @RequestMapping(value={"updateUserrights.json"}, name="\u66f4\u65b0\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateUserrights(HttpServletRequest request, UrUserrightsDomain urUserrightsDomain) {
        if (null == urUserrightsDomain) {
            this.logger.error(CODE + ".updateUserrights", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        urUserrightsDomain.setTenantCode(this.getTenantCode(request));
        return this.urUserrightsServiceRepository.updateUserrights(urUserrightsDomain);
    }

    @RequestMapping(value={"queryUserrightsPage.json"}, name="\u67e5\u8be2\u7528\u6237\u6743\u76ca\u8bbe\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UrUserrightsReDomain> queryUserrightsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.urUserrightsServiceRepository.queryUserrightsPage(param);
    }

    @RequestMapping(value={"updateUserrightsState.json"}, name="\u542f\u7528\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateUserrightsState(String userrightsId) {
        if (StringUtils.isBlank((String)userrightsId)) {
            this.logger.error(CODE + ".updateUserrightsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.urUserrightsServiceRepository.updateUserrightsState(Integer.valueOf(userrightsId), Integer.valueOf(0), Integer.valueOf(-1));
    }

    @RequestMapping(value={"stoppedUserrightsState.json"}, name="\u505c\u7528\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean stoppedUserrightsState(String userrightsId) {
        if (StringUtils.isBlank((String)userrightsId)) {
            this.logger.error(CODE + ".stoppedUserrightsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.urUserrightsServiceRepository.updateUserrightsState(Integer.valueOf(userrightsId), Integer.valueOf(-1), Integer.valueOf(0));
    }

    @RequestMapping(value={"queryUserrightsGoodsPage.json"}, name="\u67e5\u8be2\u7528\u6237\u6743\u76ca\u5bf9\u5e94\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryUserrightsGoodsPage(HttpServletRequest request) {
        SupQueryResult userrightsGoodsList;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userrightsGoodsList = this.urUserrightsServiceRepository.queryUserrightsGoodsPage(param)) || userrightsGoodsList.getList().size() <= 0) {
            return null;
        }
        SupQueryResult skuList = this.rsSkuServiceRepository.querySkuPage(param);
        if (null == skuList || skuList.getList().isEmpty()) {
            return null;
        }
        HashMap<String, String> userrightsGoodsmap = new HashMap<String, String>();
        for (UrUserrightsGoodsReDomain urUserrightsGoodsReDomain : userrightsGoodsList.getList()) {
            if (!StringUtils.isNotBlank((String)urUserrightsGoodsReDomain.getUserrightsGoodsOpcode())) continue;
            userrightsGoodsmap.put(urUserrightsGoodsReDomain.getUserrightsGoodsOpcode(), urUserrightsGoodsReDomain.getUserrightsGoodsOpcode());
        }
        ArrayList<RsSkuReDomain> rsSkuList = new ArrayList<RsSkuReDomain>();
        for (RsSkuReDomain rsSkuReDomain : skuList.getList()) {
            if (!StringUtils.isNotBlank((String)((String)userrightsGoodsmap.get(rsSkuReDomain.getSkuCode())))) continue;
            rsSkuList.add(rsSkuReDomain);
        }
        skuList.setList(rsSkuList);
        skuList.setRows(rsSkuList);
        skuList.setTotal((long)rsSkuList.size());
        return skuList;
    }

    @RequestMapping(value={"queryUserrightsGoodsPageByMemberGrade.json"}, name="\u67e5\u8be2\u7528\u6237\u6743\u76ca\u9002\u7528\u5bf9\u8c61\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UrUserrightsGoodsReDomain> queryUserrightsGoodsPageByMemberGrade(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.urUserrightsServiceRepository.queryUserrightsGoodsPage(param);
    }

    @RequestMapping(value={"queryMemberGradeByQY.json"}, name="\u67e5\u8be2\u4f1a\u5458\u7b49\u7ea7")
    @ResponseBody
    public List<DdFalgSettingReDomain> queryMemberGradeByQY(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flagSettingScope", "memberScope");
        map.put("flagSettingType", "memberGrade");
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ddFalgSettingServiceRepository.queryFalgSettingPage(map);
        if (qlist == null) {
            return null;
        }
        return qlist.getRows();
    }

    @RequestMapping(value={"saveUserrightsGoodsBatch.json"}, name="\u6279\u91cf\u6dfb\u52a0\u7528\u6237\u6743\u76ca\u5bf9\u5e94\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveUserrightsGoodsBatch(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveUserrightsGoodsBatch", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List userrightsGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, UrUserrightsGoodsDomain.class);
        UrUserrightsGoodsDomain userrightsGoodsDomain = (UrUserrightsGoodsDomain)userrightsGoodsList.get(0);
        HashMap<String, String> ugMap = new HashMap<String, String>();
        ugMap.put("userrightsCode", userrightsGoodsDomain.getUserrightsCode());
        ugMap.put("tenantCode", tenantCode);
        SupQueryResult urUserrightsGoodsList = this.urUserrightsServiceRepository.queryUserrightsGoodsPage(ugMap);
        if (null != urUserrightsGoodsList && urUserrightsGoodsList.getList().size() > 0) {
            for (UrUserrightsGoodsReDomain userrightsGoods : urUserrightsGoodsList.getList()) {
                this.urUserrightsServiceRepository.deleteUserrightsGoodsByCode(tenantCode, userrightsGoods.getUserrightsGoodsCode());
            }
        }
        for (UrUserrightsGoodsDomain urUserrightsGoodsDomain : userrightsGoodsList) {
            urUserrightsGoodsDomain.setTenantCode(tenantCode);
        }
        return this.urUserrightsServiceRepository.saveUserrightsGoodsBatch(userrightsGoodsList);
    }

    @RequestMapping(value={"saveUserrightsList.json"}, name="\u6dfb\u52a0\u8bbe\u7f6e\u9002\u7528\u5bf9\u8c61")
    @ResponseBody
    public HtmlJsonReBean saveUserrightsList(HttpServletRequest request, String params) {
        if (StringUtils.isBlank((String)params)) {
            this.logger.error(CODE + ".saveUserrightsList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List userrightsList = (List)JsonUtil.buildNormalBinder().getJsonToList(params, UrUserrightsListDomain.class);
        String tenantCode = this.getTenantCode(request);
        UrUserrightsListDomain rightsList = (UrUserrightsListDomain)userrightsList.get(0);
        HashMap<String, String> ugMap = new HashMap<String, String>();
        ugMap.put("userrightsCode", rightsList.getUserrightsCode());
        ugMap.put("tenantCode", tenantCode);
        SupQueryResult urUserrightsList = this.urUserrightsServiceRepository.queryUserrightsListPage(ugMap);
        if (null != urUserrightsList && urUserrightsList.getList().size() > 0) {
            for (UrUserrightsListReDomain userrightsList1 : urUserrightsList.getList()) {
                this.urUserrightsServiceRepository.deleteUserrightsListByCode(tenantCode, userrightsList1.getUserrightsListCode());
            }
        }
        for (UrUserrightsListDomain urUserrightsListDomain : userrightsList) {
            urUserrightsListDomain.setTenantCode(tenantCode);
        }
        return this.urUserrightsServiceRepository.saveUserrightsListBatch(userrightsList);
    }

    @RequestMapping(value={"updateUserrightsList.json"}, name="\u4fee\u6539\u8bbe\u7f6e\u9002\u7528\u5bf9\u8c61")
    @ResponseBody
    public HtmlJsonReBean updateUserrightsList(UrUserrightsListDomain urUserrightsListDomain) {
        if (null == urUserrightsListDomain) {
            this.logger.error(CODE + ".updateUserrightsList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.urUserrightsServiceRepository.updateUserrightsList(urUserrightsListDomain);
    }

    @RequestMapping(value={"queryUserrightsListPage.json"}, name="\u67e5\u8be2\u8bbe\u7f6e\u9002\u7528\u5bf9\u8c61")
    @ResponseBody
    public SupQueryResult<UrUserrightsListReDomain> queryUserrightsListPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.urUserrightsServiceRepository.queryUserrightsListPage(param);
    }

    @RequestMapping(value={"deleteUserrights.json"}, name="\u5220\u9664\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteUserrights(Integer userrightsId) {
        if (StringUtils.isBlank((Integer)userrightsId)) {
            this.logger.error(CODE + ".deleteUserrights", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.urUserrightsServiceRepository.deleteUserrights(userrightsId);
    }

    @RequestMapping(value={"getUserrights.json"}, name="\u83b7\u53d6\u7528\u6237\u6743\u76ca\u8bbe\u7f6e\u4fe1\u606f")
    @ResponseBody
    public UrUserrightsReDomain getUserrights(Integer userrightsId) {
        if (StringUtils.isBlank((Integer)userrightsId)) {
            this.logger.error(CODE + ".getUserrights", (Object)"param is null");
            return null;
        }
        return this.urUserrightsServiceRepository.getUserrights(userrightsId);
    }

    @RequestMapping(value={"getTotalDiscountPrice.json"}, name="\u7528\u6237\u6743\u76ca\u5dee\u4ef7\u8ba1\u7b97")
    @ResponseBody
    public HtmlJsonReBean getTotalDiscountPrice(HttpServletRequest request, String rsSkuListStr) {
        this.logger.info("----------- rsSkuListStr -----------", (Object)rsSkuListStr);
        if (StringUtils.isBlank((String)rsSkuListStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param rsSkuListStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getTotalDiscountPrice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String userinfoCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".getTotalDiscountPrice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UrOrderUserDomain urOrderUserDomain = new UrOrderUserDomain();
        urOrderUserDomain.setUserCode(userinfoCode);
        urOrderUserDomain.setTenantCode(tenantCode);
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        List rsSkuList = (List)JsonUtil.buildNormalBinder().getJsonToList(rsSkuListStr, RsSkuDomain.class);
        this.logger.info("----------- rsSkuList -----------", (Object)rsSkuList);
        try {
            this.logger.info("----------- totalDiscountPrice -----------", (Object)this.urUserrightsServiceRepository.getTotalDiscountPrice(urOrderUserDomain, rsSkuList));
            htmlJsonReBean.setDataObj((Object)this.urUserrightsServiceRepository.getTotalDiscountPrice(urOrderUserDomain, rsSkuList));
        }
        catch (Exception e) {
            htmlJsonReBean = new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "error", (Object)0);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"commitOrder.json"}, name="\u7528\u6237\u786e\u8ba4\u4e0b\u5355\u64cd\u4f5c", produces={"application/json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean commitOrder(HttpServletRequest request, String rsSkuListStr, OrderDomain orderDomain) {
        if (StringUtils.isBlank((String)rsSkuListStr) || null == orderDomain) {
            this.logger.error(CODE + ".commitOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param rsSkuListStr or ormOrder is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getTotalDiscountPrice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        String userinfoCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".getTotalDiscountPrice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        List rsSkuList = (List)JsonUtil.buildNormalBinder().getJsonToList(rsSkuListStr, RsSkuDomain.class);
        UrOrderUserDomain urOrderUserDomain = new UrOrderUserDomain();
        urOrderUserDomain.setUserCode(userinfoCode);
        urOrderUserDomain.setTenantCode(tenantCode);
        this.logger.info("----------- urOrderUserDomain -----------", (Object)urOrderUserDomain);
        HtmlJsonReBean htmlJsonReBean = this.urUserrightsServiceRepository.commitOrder(urOrderUserDomain, rsSkuList, orderDomain);
        return htmlJsonReBean;
    }
}

