/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.resources;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsUnitDomain;
import cn.com.qj.bff.domain.rs.RsUnitReDomain;
import cn.com.qj.bff.service.rs.RsUnitService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/unit"}, name="\u5546\u54c1\u670d\u52a1(\u5355\u4f4d\u7ef4\u62a4)")
public class UnitCon
extends SpringmvcController {
    private static String CODE = "rs.unit.con";
    @Autowired
    private RsUnitService rsUnitService;

    @Override
    protected String getContext() {
        return "unit";
    }

    @RequestMapping(value={"saveUnit.json"}, name="\u589e\u52a0\u5546\u54c1\u670d\u52a1(\u5355\u4f4d\u7ef4\u62a4)")
    @ResponseBody
    public HtmlJsonReBean saveUnit(HttpServletRequest request, RsUnitDomain rsUnitDomain) {
        if (null == rsUnitDomain) {
            this.logger.error(CODE + ".saveUnit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        rsUnitDomain.setMemberCode(userSession.getUserPcode());
        rsUnitDomain.setMemberName(userSession.getUserName());
        rsUnitDomain.setTenantCode(this.getTenantCode(request));
        rsUnitDomain.setChannelCode(this.getNowChannel(request));
        return this.rsUnitService.saveUnit(rsUnitDomain);
    }

    @RequestMapping(value={"getUnit.json"}, name="\u83b7\u53d6\u5546\u54c1\u670d\u52a1(\u5355\u4f4d\u7ef4\u62a4)\u4fe1\u606f")
    @ResponseBody
    public RsUnitReDomain getUnit(Integer unitId) {
        if (StringUtils.isBlank((Integer)unitId)) {
            this.logger.error(CODE + ".getUnit", (Object)"param is null");
            return null;
        }
        return this.rsUnitService.getUnit(unitId);
    }

    @RequestMapping(value={"updateUnit.json"}, name="\u66f4\u65b0\u5546\u54c1\u670d\u52a1(\u5355\u4f4d\u7ef4\u62a4)")
    @ResponseBody
    public HtmlJsonReBean updateUnit(HttpServletRequest request, RsUnitDomain rsUnitDomain) {
        if (null == rsUnitDomain) {
            this.logger.error(CODE + ".updateUnit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsUnitDomain.setTenantCode(this.getTenantCode(request));
        rsUnitDomain.setChannelCode(this.getNowChannel(request));
        return this.rsUnitService.updateUnit(rsUnitDomain);
    }

    @RequestMapping(value={"deleteUnit.json"}, name="\u5220\u9664\u5546\u54c1\u670d\u52a1(\u5355\u4f4d\u7ef4\u62a4)")
    @ResponseBody
    public HtmlJsonReBean deleteUnit(Integer unitId) {
        if (StringUtils.isBlank((Integer)unitId)) {
            this.logger.error(CODE + ".deleteUnit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsUnitService.deleteUnit(unitId);
    }

    @RequestMapping(value={"queryUnitPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u670d\u52a1(\u5355\u4f4d\u7ef4\u62a4)\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsUnitReDomain> queryUnitPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsUnitService.queryUnitPage(param);
    }

    @RequestMapping(value={"updateUnitState.json"}, name="\u66f4\u65b0\u5546\u54c1\u670d\u52a1(\u5355\u4f4d\u7ef4\u62a4)\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateUnitState(String unitId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)unitId)) {
            this.logger.error(CODE + ".updateUnitState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsUnitService.updateUnitState(Integer.valueOf(unitId), dataState, oldDataState, null);
    }
}

