/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.reb;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.mh.ActiveDomain;
import cn.com.qj.bff.domain.mh.ActiveRebateDomain;
import cn.com.qj.bff.domain.reb.RebPointsDomain;
import cn.com.qj.bff.domain.reb.RebPointsGoodsDomain;
import cn.com.qj.bff.domain.reb.RebPointsGoodsReDomain;
import cn.com.qj.bff.domain.reb.RebPointsReDomain;
import cn.com.qj.bff.domain.reb.RebPointsRuleDomain;
import cn.com.qj.bff.domain.reb.RebPointsRuleReDomain;
import cn.com.qj.bff.domain.reb.RebPointsUsersDomain;
import cn.com.qj.bff.domain.reb.RebPointsUsersReDomain;
import cn.com.qj.bff.service.mh.ExService;
import cn.com.qj.bff.service.nm.NmNoService;
import cn.com.qj.bff.service.reb.RebPointsGoodsService;
import cn.com.qj.bff.service.reb.RebPointsService;
import cn.com.qj.bff.service.reb.RebPointsUsersService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/reb/points"}, name="\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
public class RebPointsCon
extends SpringmvcController {
    private static String CODE = "reb.points.con";
    @Autowired
    private RebPointsService rebPointsService;
    @Autowired
    RebPointsGoodsService rebPointsGoodsService;
    @Autowired
    RebPointsUsersService rebPointsUsersService;
    @Autowired
    NmNoService nmNoService;
    @Autowired
    ExService exService;

    @Override
    protected String getContext() {
        return "points";
    }

    @RequestMapping(value={"savePoints.json"}, name="\u589e\u52a0\u8fd4\u5229\u5f00\u542f")
    @ResponseBody
    public HtmlJsonReBean savePoints(HttpServletRequest request, String rebPointsDomainStr) {
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".savePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        String maxBillNumber = this.nmNoService.createMaxBillNumber(null, "RebPoints", "rebPoints", this.getTenantCode(request));
        String rebPointsCode = "FL" + DateUtils.getDateString((Date)new Date(), (String)"yyyyMMdd") + maxBillNumber.substring(maxBillNumber.length() - 4);
        rebPointsDomain.setPointsCode(rebPointsCode);
        rebPointsDomain.setTenantCode(this.getTenantCode(request));
        rebPointsDomain.setMemberName(this.getUserSession(request).getUserName());
        HtmlJsonReBean htmlJsonReBean = this.rebPointsService.savePoints(rebPointsDomain);
        List<RebPointsGoodsDomain> rebPointsGoodsDomainList = rebPointsDomain.getRebPointsGoodsDomainList();
        for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsGoodsDomainList) {
            rebPointsGoodsDomain.setPointsCode(rebPointsCode);
            rebPointsGoodsDomain.setTenantCode(rebPointsDomain.getTenantCode());
        }
        if (CollectionUtils.isNotEmpty(rebPointsGoodsDomainList)) {
            this.rebPointsGoodsService.savePointsGoodsBatch(rebPointsGoodsDomainList);
        }
        List<RebPointsUsersDomain> rebPointsUsersDomainList = rebPointsDomain.getRebPointsUsersDomainList();
        for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainList) {
            rebPointsUsersDomain.setPointsCode(rebPointsCode);
            rebPointsUsersDomain.setTenantCode(rebPointsDomain.getTenantCode());
        }
        if (CollectionUtils.isNotEmpty(rebPointsUsersDomainList)) {
            this.rebPointsUsersService.saveRebPointsUsersBatch(rebPointsUsersDomainList);
        }
        htmlJsonReBean = this.exService.sendActiveToOa(this.createActive(rebPointsDomain));
        return htmlJsonReBean;
    }

    private ActiveDomain createActive(RebPointsDomain rebPointsDomain) {
        ActiveDomain activeDomain = new ActiveDomain();
        Date date = new Date();
        activeDomain.setApplyDate(date);
        activeDomain.setApplyDepart(rebPointsDomain.getPointsUserqua());
        activeDomain.setApplyPerson(rebPointsDomain.getMemberName());
        activeDomain.setBrandName(rebPointsDomain.getFchannelClassifyName());
        activeDomain.setStartTime(rebPointsDomain.getPointsStartdate());
        activeDomain.setEndTime(rebPointsDomain.getPointsEstartdate());
        activeDomain.setTenantCode(rebPointsDomain.getTenantCode());
        activeDomain.setGrantType("\u8fd4\u5229");
        ActiveRebateDomain activeRebate = new ActiveRebateDomain();
        activeRebate.setRebPointsGoodsDomainList(rebPointsDomain.getRebPointsGoodsDomainList());
        activeRebate.setRebPointsUsersDomainList(rebPointsDomain.getRebPointsUsersDomainList());
        activeRebate.setRebType(rebPointsDomain.getPointsDatetype());
        activeRebate.setComplianceRebType(rebPointsDomain.getPointsDatatype());
        activeDomain.setActiveRebate(activeRebate);
        return activeDomain;
    }

    @RequestMapping(value={"getPoints.json"}, name="\u83b7\u53d6\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u4fe1\u606f")
    @ResponseBody
    public RebPointsReDomain getPoints(Integer pointsId) {
        SupQueryResult<RebPointsUsersReDomain> rebPointsUsersReDomainSupQueryResult;
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".getPoints", (Object)"param is null");
            return null;
        }
        RebPointsReDomain points = this.rebPointsService.getPoints(pointsId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", points.getTenantCode());
        map.put("pointsCode", points.getPointsCode());
        SupQueryResult<RebPointsGoodsReDomain> rebPointsGoodsReDomainSupQueryResult = this.rebPointsGoodsService.queryPointsGoodsPage(map);
        if (rebPointsGoodsReDomainSupQueryResult != null && CollectionUtils.isNotEmpty((Collection)rebPointsGoodsReDomainSupQueryResult.getList())) {
            ArrayList<RebPointsGoodsDomain> rebPointsGoodsDomainList = new ArrayList<RebPointsGoodsDomain>();
            try {
                BeanUtils.copyAllPropertys(rebPointsGoodsDomainList, (Object)rebPointsGoodsReDomainSupQueryResult.getList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            points.setRebPointsGoodsDomainList(rebPointsGoodsDomainList);
        }
        if ((rebPointsUsersReDomainSupQueryResult = this.rebPointsUsersService.queryPointsUsersPage(map)) != null && CollectionUtils.isNotEmpty((Collection)rebPointsUsersReDomainSupQueryResult.getList())) {
            ArrayList<RebPointsUsersDomain> rebPointsUsersDomainList = new ArrayList<RebPointsUsersDomain>();
            try {
                BeanUtils.copyAllPropertys(rebPointsUsersDomainList, (Object)rebPointsUsersReDomainSupQueryResult.getList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            points.setRebPointsUsersDomainList(rebPointsUsersDomainList);
        }
        return points;
    }

    @RequestMapping(value={"updatePoints.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean updatePoints(HttpServletRequest request, String rebPointsDomainStr) {
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".updatePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        rebPointsDomain.setTenantCode(this.getTenantCode(request));
        return this.rebPointsService.updatePoints(rebPointsDomain);
    }

    @RequestMapping(value={"deletePoints.json"}, name="\u5220\u9664\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean deletePoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".deletePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebPointsService.deletePoints(pointsId);
    }

    @RequestMapping(value={"queryPointsPage.json"}, name="\u67e5\u8be2\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebPointsReDomain> queryPointsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebPointsService.queryPointsPage(param);
    }

    @RequestMapping(value={"updatePointsState.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePointsState(String pointsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".updatePointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebPointsService.updatePointsState(Integer.valueOf(pointsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryPointsPageStr.json"}, name="\u67e5\u8be2\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebPointsReDomain> queryPointsPageStr(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebPointsService.queryPointsPage(param);
    }

    @RequestMapping(value={"updatePointsStr.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean updatePointsStr(HttpServletRequest request, String rebPointsDomainStr) {
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".updatePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        rebPointsDomain.setTenantCode(this.getTenantCode(request));
        if (CollectionUtils.isNotEmpty(rebPointsDomain.getRebPointsUsersDomainList())) {
            for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsDomain.getRebPointsUsersDomainList()) {
                this.rebPointsUsersService.updateRebPointsUsers(rebPointsUsersDomain);
            }
        }
        if (CollectionUtils.isNotEmpty(rebPointsDomain.getRebPointsGoodsDomainList())) {
            for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsDomain.getRebPointsGoodsDomainList()) {
                this.rebPointsGoodsService.updatePointsGoods(rebPointsGoodsDomain);
            }
        }
        return this.rebPointsService.updatePoints(rebPointsDomain);
    }

    @RequestMapping(value={"queryPointsRulePage.json"}, name="\u67e5\u8be2\u8fd4\u5229\u8bbe\u7f6e\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<RebPointsRuleReDomain> queryPointsRulePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebPointsService.queryPointsRulePage(param);
    }

    @RequestMapping(value={"updatePointsRule.json"}, name="\u4fee\u6539\u8fd4\u5229\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updatePointsRule(HttpServletRequest request, String rebPointsRuleDomainStr) {
        if (StringUtils.isBlank((String)rebPointsRuleDomainStr)) {
            this.logger.error(CODE + ".updatePointsRule", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsRuleDomain rebPointsRuleDomain = (RebPointsRuleDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsRuleDomainStr, RebPointsRuleDomain.class);
        rebPointsRuleDomain.setTenantCode(this.getTenantCode(request));
        return this.rebPointsService.updatePointsRule(rebPointsRuleDomain);
    }
}

