/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.util.ExportExcelUtlis;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.cm.CmChannelClearReDomain;
import cn.com.qj.bff.domain.ct.CtCustrelEmpReDomain;
import cn.com.qj.bff.domain.ct.CtCustrelReDomain;
import cn.com.qj.bff.domain.da.DaOpsumOrderlistReDomain;
import cn.com.qj.bff.domain.dd.DdFalgSettingReDomain;
import cn.com.qj.bff.domain.dis.DisChannelReDomain;
import cn.com.qj.bff.domain.fm.FmFileDomainBean;
import cn.com.qj.bff.domain.fm.FmFileReDomainBean;
import cn.com.qj.bff.domain.oc.ContractType;
import cn.com.qj.bff.domain.oc.OcBusinessDimensionDomain;
import cn.com.qj.bff.domain.oc.OcCflowPprocessReDomain;
import cn.com.qj.bff.domain.oc.OcClinckDataDomain;
import cn.com.qj.bff.domain.oc.OcClinicRankingDomain;
import cn.com.qj.bff.domain.oc.OcClinicReportDomain;
import cn.com.qj.bff.domain.oc.OcClorstDataStatisticsDomain;
import cn.com.qj.bff.domain.oc.OcCommissionStatisticsDomain;
import cn.com.qj.bff.domain.oc.OcConsumeBigData;
import cn.com.qj.bff.domain.oc.OcContractAndPackageReDomain;
import cn.com.qj.bff.domain.oc.OcContractDomain;
import cn.com.qj.bff.domain.oc.OcContractEditDomain;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractGoodsReDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcContractSettlDomain;
import cn.com.qj.bff.domain.oc.OcContractSubReDomain;
import cn.com.qj.bff.domain.oc.OcDentalReportDomain;
import cn.com.qj.bff.domain.oc.OcDistributorEmployeeReportDomain;
import cn.com.qj.bff.domain.oc.OcPackageDomain;
import cn.com.qj.bff.domain.oc.OcPackageReDomain;
import cn.com.qj.bff.domain.oc.OcRefundReDomain;
import cn.com.qj.bff.domain.oc.OrderDomain;
import cn.com.qj.bff.domain.oc.PackageDomain;
import cn.com.qj.bff.domain.oc.PackageExpressDomain;
import cn.com.qj.bff.domain.oc.SkuDomain;
import cn.com.qj.bff.domain.oc.TypeBean;
import cn.com.qj.bff.domain.order.ExcelExportTemplate;
import cn.com.qj.bff.domain.order.FareBean;
import cn.com.qj.bff.domain.order.MatrixToImageWriter;
import cn.com.qj.bff.domain.org.OrgCompanyReDomain;
import cn.com.qj.bff.domain.org.OrgDepartReDomain;
import cn.com.qj.bff.domain.org.OrgEmployeeReDomain;
import cn.com.qj.bff.domain.org.OrgUserBean;
import cn.com.qj.bff.domain.pm.PmContractGoodsDomain;
import cn.com.qj.bff.domain.pm.PmPromotionDiscountDomain;
import cn.com.qj.bff.domain.pm.PmPromotionDiscountlistDomain;
import cn.com.qj.bff.domain.pm.PmPromotionRangelistReDomain;
import cn.com.qj.bff.domain.pm.PmPromotionReDomain;
import cn.com.qj.bff.domain.pm.PmUserCouponReDomain;
import cn.com.qj.bff.domain.pte.PteBalanceamtReDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuOneDomain;
import cn.com.qj.bff.domain.rs.RsSkuOnelistDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.sg.SgSendgoodsDomain;
import cn.com.qj.bff.domain.sg.SgSendgoodsGoodsReDomain;
import cn.com.qj.bff.domain.sg.SgSendgoodsReDomain;
import cn.com.qj.bff.domain.st.GoodsDomain;
import cn.com.qj.bff.domain.st.SalequotaGoods;
import cn.com.qj.bff.domain.um.UmGroupListReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoQuaReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.domain.vd.VdFaccountInfo;
import cn.com.qj.bff.service.cm.CmChannelClearService;
import cn.com.qj.bff.service.ct.CtCustrelService;
import cn.com.qj.bff.service.da.DaOpsumOrderlistService;
import cn.com.qj.bff.service.dd.DdFalgSettingService;
import cn.com.qj.bff.service.dis.DisChannelService;
import cn.com.qj.bff.service.oc.OcCflowPprocessService;
import cn.com.qj.bff.service.oc.OcContractEngineService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.oc.OcContractSubService;
import cn.com.qj.bff.service.oc.OcRefundService;
import cn.com.qj.bff.service.oc.OcShoppingService;
import cn.com.qj.bff.service.org.OrgCompanyService;
import cn.com.qj.bff.service.org.OrgDepartService;
import cn.com.qj.bff.service.org.OrgEmployeeService;
import cn.com.qj.bff.service.pm.PmPromotionRangelistService;
import cn.com.qj.bff.service.pm.PmPromotionService;
import cn.com.qj.bff.service.pte.PteBalanceamtService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsSkuOneService;
import cn.com.qj.bff.service.sg.SgSendgoodsService;
import cn.com.qj.bff.service.st.StSalequotaService;
import cn.com.qj.bff.service.um.UmGroupService;
import cn.com.qj.bff.service.um.UmUserinfoQuaService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.service.vd.VdFaccountOuterService;
import cn.com.qj.bff.service.vd.VdFaccountService;
import cn.com.qj.bff.springmvc.SpringmvnNewController;
import cn.com.qj.bff.springmvc.excelTemplate.OrderExcel;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.beans.factory.annotation.Autowired;

public class ContractComCon
extends SpringmvnNewController {
    private static String CODE = "oc.contractcom.con";
    @Autowired
    protected OcContractService ocContractService;
    @Autowired
    private OcShoppingService ocShoppingService;
    @Autowired
    protected OcContractEngineService ocContractEngineService;
    @Autowired
    private OcContractSubService ocContractSubService;
    @Autowired
    private CtCustrelService ctCustrelService;
    @Autowired
    private OrgEmployeeService orgEmployeeService;
    @Autowired
    private OrgCompanyService orgCompanyService;
    @Autowired
    private OcCflowPprocessService ocCflowPprocessService;
    @Autowired
    private PmPromotionService pmPromotionService;
    @Autowired
    private PmPromotionRangelistService pmPromotionRangelistService;
    @Autowired
    private UserService userService;
    @Autowired
    private OcRefundService ocRefundService;
    @Autowired
    private VdFaccountOuterService vdFaccountOuterService;
    @Autowired
    private VdFaccountService vdFaccountService;
    @Autowired
    private DaOpsumOrderlistService daOpsumOrderlistService;
    @Autowired
    private PteBalanceamtService pteBalanceamtService;
    @Autowired
    private DdFalgSettingService ddFalgSettingService;
    @Autowired
    private SgSendgoodsService sgSendgoodsService;
    @Autowired
    private UmUserinfoQuaService umUserinfoQuaService;
    @Autowired
    private StSalequotaService stSalequotaService;
    @Autowired
    private RsSkuOneService rsSkuOneService;
    @Autowired
    private CmChannelClearService cmChannelClearService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private DisChannelService disChannelService;
    @Autowired
    private OrgDepartService orgDepartService;
    UmGroupService umGroupService;

    @Override
    protected String getContext() {
        return "contractcom";
    }

    public String getEmp(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        String employeeCode = userSession.getEmployeeCode();
        if (StringUtils.isNotBlank((String)employeeCode)) {
            return employeeCode;
        }
        SupQueryResult<OrgEmployeeReDomain> qemp = this.orgEmployeeService.queryEmployeePage(this.getQueryMapParam("userCode,userinfoCode,tenantCode", userSession.getUserCode(), userSession.getUserPcode(), userSession.getTenantCode()));
        if (null == qemp || ListUtil.isEmpty((Collection)qemp.getList())) {
            return null;
        }
        return ((OrgEmployeeReDomain)qemp.getList().get(0)).getEmployeeCode();
    }

    public String getDep(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyService.getEmpByUserCode(userSession.getUserCode(), userSession.getCompanyCode(), userSession.getTenantCode());
        if (null == orgUserBean) {
            return null;
        }
        return orgUserBean.getDepartCode();
    }

    public String getCom(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode())) {
            return userSession.getCompanyCode();
        }
        OrgUserBean orgUserBean = this.orgCompanyService.getEmpByUserCode(userSession.getUserCode(), userSession.getCompanyCode(), userSession.getTenantCode());
        if (null == orgUserBean) {
            return null;
        }
        return orgUserBean.getCompanyCode();
    }

    public HtmlJsonReBean saveExContractGoodsCom(HttpServletRequest request, String orderGoodsDomainStr) {
        if (StringUtils.isBlank((String)orderGoodsDomainStr)) {
            this.logger.error(CODE + ".saveExContractGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List ocContractGoodsDomainList = JsonUtil.buildNormalBinder().getJsonToList(orderGoodsDomainStr, OcContractGoodsDomain.class);
        if (ListUtil.isEmpty((Collection)ocContractGoodsDomainList)) {
            this.logger.error(CODE + ".saveExContractGoodsCom.ocContractGoodsDomainList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            ocContractGoodsDomain.setTenantCode(this.getTenantCode(request));
        }
        HtmlJsonReBean htmlJsonReBean = this.ocContractService.saveExContractGoods(ocContractGoodsDomainList);
        return htmlJsonReBean;
    }

    protected HtmlJsonReBean createOrder(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        long s1 = System.currentTimeMillis();
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".createOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        this.logger.debug(CODE + ".createOrder.orderDomainList.11", (Object)JsonUtil.buildNormalBinder().toJson((Object)orderDomainList));
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)((OrderDomain)orderDomainList.get(0)).getContractType())) {
            if (StringUtils.isBlank((String)contractType)) {
                contractType = ContractType.CON.getCode();
            }
            ((OrderDomain)orderDomainList.get(0)).setContractType(contractType);
        }
        if (StringUtils.isBlank((String)contractType)) {
            contractType = ((OrderDomain)orderDomainList.get(0)).getContractType();
        }
        TypeBean typeBean = this.ocShoppingService.getOcSetting(contractType, userSession.getTenantCode());
        long s2 = System.currentTimeMillis();
        this.logger.error(CODE + ".createOrder.time2-1", (Object)(s2 - s1));
        OrgUserBean orgUserBean = null;
        try {
            if (StringUtils.isNotBlank((String)memberBcode)) {
                orgUserBean = this.getOrgUserBean(memberBcode, userSession, this.getCompanyCode(request), userSession.getTenantCode(), orderDomainList, typeBean);
            } else if (this.ocShoppingService.checkOrg(typeBean)) {
                orgUserBean = this.getOrgUserBean(userSession.getUserPcode(), userSession, null, userSession.getTenantCode(), orderDomainList, typeBean);
            }
        }
        catch (Exception e) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
        }
        long s3 = System.currentTimeMillis();
        this.logger.error(CODE + ".createOrder.time3-2", (Object)(s3 - s2));
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getEmployeeCode())) {
            orgUserBean.setEmployeeCode(((OrderDomain)orderDomainList.get(0)).getEmployeeCode());
            orgUserBean.setEmployeeName(((OrderDomain)orderDomainList.get(0)).getEmployeeName());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartCode())) {
            orgUserBean.setDepartCode(((OrderDomain)orderDomainList.get(0)).getDepartCode());
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartShortname())) {
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getCompanyCode())) {
            orgUserBean.setCompanyCode(((OrderDomain)orderDomainList.get(0)).getCompanyCode());
            orgUserBean.setCompanyShortname(((OrderDomain)orderDomainList.get(0)).getCompanyShortname());
        }
        this.makeChannel(orderDomainList, request);
        HtmlJsonReBean ocOrder = this.ocShoppingService.createOcOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, contractProperty, this.ocShoppingService.getPmCheckBean(this.getPmChannel(request), this.getProappCode(request), this.getTenantCode(request), null == orgUserBean ? userSession.getUserPcode() : orgUserBean.getMemberBcode(), null == orgUserBean ? userSession.getMerberCompname() : orgUserBean.getMemberBname(), userSession.getUserName(), ((OrderDomain)orderDomainList.get(0)).getContractPmode(), userSession));
        long s6 = System.currentTimeMillis();
        this.logger.error(CODE + ".createOrder.time6-1", (Object)(s6 - s1));
        return ocOrder;
    }

    public OrgUserBean getOrgUserBean(String memberBcode, UserSession userSession, String companyCode, String tenantCode, List<OrderDomain> orderDomainList, TypeBean typeBean) throws Exception {
        if (null == userSession || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = null;
        String userCode = userSession.getUserCode();
        if (StringUtils.isNotBlank((String)companyCode)) {
            orgUserBean = this.orgCompanyService.getEmpByUserCode(userCode, companyCode, tenantCode);
        }
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            SupQueryResult<CtCustrelEmpReDomain> qcust;
            HashMap<String, String> bmap = new HashMap<String, String>();
            if (this.ocShoppingService.checkOrgemp(typeBean)) {
                for (OrderDomain orderDomain : orderDomainList) {
                    for (PackageDomain packageDomain : orderDomain.getPackageList()) {
                        for (OcContractGoodsDomain ocContractGoodsDomain : packageDomain.getContractGoodsList()) {
                            UmUserinfoReDomainBean umUserinfoReDomainBean;
                            if (!StringUtils.isNotBlank((String)ocContractGoodsDomain.getMemberMcode()) || null == (umUserinfoReDomainBean = this.userService.getUserinfoByCode(ocContractGoodsDomain.getMemberMcode(), tenantCode))) continue;
                            bmap.put(umUserinfoReDomainBean.getDepartCode(), umUserinfoReDomainBean.getDepartCode());
                        }
                    }
                }
            }
            if (null != (qcust = this.ctCustrelService.queryCustrelEmpPage(this.getQueryMapParam("userinfoCode,tenantCode", memberBcode, tenantCode))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
                CtCustrelEmpReDomain ctCustrelEmpReDomain = (CtCustrelEmpReDomain)qcust.getList().get(0);
                orgUserBean.setCustrelCode(((CtCustrelEmpReDomain)qcust.getList().get(0)).getCustrelCode());
                orgUserBean.setMemberBname(((CtCustrelEmpReDomain)qcust.getList().get(0)).getCustrelName());
                orgUserBean.setCompanyCode(ctCustrelEmpReDomain.getCompanyCode());
                orgUserBean.setEmployeeCode(ctCustrelEmpReDomain.getEmployeeCode());
                orgUserBean.setEmployeeName(ctCustrelEmpReDomain.getEmployeeName());
                orgUserBean.setDepartCode(ctCustrelEmpReDomain.getDepartCode());
                orgUserBean.setDepartShortname(ctCustrelEmpReDomain.getDepartName());
                orgUserBean.setCompanyShortname(ctCustrelEmpReDomain.getCompanyShortname());
                if (MapUtil.isNotEmpty(bmap)) {
                    HashMap<String, String> depMap = new HashMap<String, String>();
                    for (CtCustrelEmpReDomain ctCustrelEmpReDomain1 : qcust.getList()) {
                        depMap.put(ctCustrelEmpReDomain1.getDepartCode(), ctCustrelEmpReDomain1.getDepartCode());
                    }
                    for (String key : bmap.keySet()) {
                        if (!StringUtils.isBlank((String)((String)depMap.get(key)))) continue;
                        throw new Exception("\u9500\u552e\u4ee3\u8868\u4e0d\u5b58\u5728");
                    }
                }
            } else if (this.ocShoppingService.checkOrgemp(typeBean)) {
                throw new Exception("\u9500\u552e\u4ee3\u8868\u4e0d\u5b58\u5728");
            }
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode()) && !userSession.getCompanyCode().equals(orgUserBean.getCompanyCode())) {
            orgUserBean.setCompanyCode(userSession.getCompanyCode());
            orgUserBean.setCompanyShortname(userSession.getCompanyShortname());
        }
        return orgUserBean;
    }

    protected HtmlJsonReBean createOrder(HttpServletRequest request, String orderDomainStr, String contractType) {
        return this.createOrder(request, orderDomainStr, contractType, null, "0");
    }

    protected HtmlJsonReBean createOrderpc(HttpServletRequest request, String orderDomainStr, String contractType) {
        return this.createOrderpc(request, orderDomainStr, contractType, null, "0");
    }

    private void makeChannel(List<OrderDomain> orderDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(orderDomainList) || null == request) {
            this.logger.error(CODE + ".makeChannel.null");
            return;
        }
        String goodsClass = "";
        String channelName = "";
        String channelCode = this.getProappChannel(request);
        if (StringUtils.isBlank((String)channelCode)) {
            DisChannel disChannel;
            List<PackageDomain> packageDomains = orderDomainList.get(0).getPackageList();
            List<OcContractGoodsDomain> contractGoodsDomains = null;
            if (ListUtil.isNotEmpty(packageDomains)) {
                contractGoodsDomains = packageDomains.get(0).getContractGoodsList();
            }
            if (ListUtil.isNotEmpty(contractGoodsDomains)) {
                for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsDomains) {
                    if (StringUtils.isNotBlank((String)channelCode) && StringUtils.isNotBlank((String)channelName) || !StringUtils.isNotBlank((String)ocContractGoodsDomain.getContractGoodsGtype()) || !"0".equals(ocContractGoodsDomain.getContractGoodsGtype())) continue;
                    channelCode = ocContractGoodsDomain.getChannelCode();
                    channelName = ocContractGoodsDomain.getChannelName();
                    goodsClass = ocContractGoodsDomain.getGoodsClass();
                }
            }
            if (StringUtils.isBlank((String)channelCode) && null != (disChannel = this.getChannelModel(channelCode = this.getNowChannel(request), request))) {
                channelName = disChannel.getChannelName();
                goodsClass = disChannel.getGoodsClass();
            }
        } else {
            DisChannel disChannel = this.getChannelModel(channelCode, request);
            if (null != disChannel) {
                channelName = disChannel.getChannelName();
                goodsClass = disChannel.getGoodsClass();
            }
        }
        for (OrderDomain orderDomain : orderDomainList) {
            orderDomain.setChannelCode(channelCode);
            orderDomain.setChannelName(channelName);
            orderDomain.setGoodsClass(goodsClass);
        }
    }

    public OcContractReDomain getContractCom(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContractCom", (Object)"param is null");
            return null;
        }
        return this.ocContractService.getContract(Integer.valueOf(contractId));
    }

    public HtmlJsonReBean updateContractCom(HttpServletRequest request, OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error(CODE + ".updateContractCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractService.updateContract(ocContractDomain);
    }

    public HtmlJsonReBean deleteContractCom(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".deleteContractCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractService.deleteContract(Integer.valueOf(contractId));
    }

    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsPageCom(HttpServletRequest request, Map<String, Object> param) {
        return this.ocContractService.queryContractGoodsPage(param);
    }

    public OcContractReDomain getContractByCodeCom(HttpServletRequest request, Map<String, Object> param) {
        return this.ocContractService.getContractByCode(param);
    }

    public String queryForFreightSum(HttpServletRequest request, Map<String, Object> param) {
        return this.ocContractService.queryForFreightSum(param);
    }

    public HtmlJsonReBean updateContractSubMoneyCom(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error(CODE + ".updateContractSubMoneyCom", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractService.updateContractSubMoney(contractId, subMoney, remark);
    }

    public HtmlJsonReBean syncContractStateCom(HttpServletRequest request, String contractBillcode) {
        return this.getContrant(request, contractBillcode, OcContractService.dataState_no, OcContractService.dataState_1);
    }

    public HtmlJsonReBean syncContractBatchStateCom(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        SupQueryResult<OcContractReDomain> qlist = this.ocContractService.queryContractPage(map);
        if (null == qlist || null == qlist.getRows()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u6570\u636e\u4e3a\u7a7a");
        }
        Integer errDataState = OcContractService.dataState_no;
        Integer newDataState = OcContractService.dataState_1;
        boolean flag = true;
        for (OcContractReDomain OcContractReDomain2 : qlist.getRows()) {
            HtmlJsonReBean htmlJsonReBean = this.getContrant(request, OcContractReDomain2.getContractBillcode(), errDataState, newDataState);
            if (null == htmlJsonReBean || htmlJsonReBean.isSuccess()) continue;
            flag = false;
        }
        if (flag) {
            return new HtmlJsonReBean((Object)"ok");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5931\u8d25");
    }

    public HtmlJsonReBean syncContractPayStateCom(HttpServletRequest request, String contractBillcode, String contractSubCode) {
        if (StringUtils.isNotBlank((String)contractSubCode)) {
            return this.getContrantSub(request, contractBillcode, contractSubCode, OcContractService.dataState_no, OcContractService.dataState_1);
        }
        return this.getContrant(request, contractBillcode, OcContractService.dataState_no, OcContractService.dataState_2);
    }

    public HtmlJsonReBean syncContractBatchPayStateCom(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        SupQueryResult<OcContractReDomain> qlist = this.ocContractService.queryContractPage(map);
        if (null == qlist || null == qlist.getRows()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u6570\u636e\u4e3a\u7a7a");
        }
        Integer errDataState = OcContractService.dataState_no;
        Integer newDataState = OcContractService.dataState_2;
        boolean flag = true;
        for (OcContractReDomain OcContractReDomain2 : qlist.getRows()) {
            HtmlJsonReBean htmlJsonReBean = this.getContrant(request, OcContractReDomain2.getContractBillcode(), errDataState, newDataState);
            if (null == htmlJsonReBean || htmlJsonReBean.isSuccess()) continue;
            flag = false;
        }
        if (flag) {
            return new HtmlJsonReBean((Object)"ok");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5931\u8d25");
    }

    public HtmlJsonReBean getContrantSub(HttpServletRequest request, String contractBillcode, String contractSubCode, Integer errDataState, Integer newDataState) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractSubCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        long currentTime = System.currentTimeMillis();
        long expireMillis = 10000L;
        String DisKey = "ocContractSub-state-" + contractSubCode + tenantCode;
        Integer dataState = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.checkDataState(errDataState, newDataState, DisKey, map);
        if (null != htmlJsonReBean) {
            return htmlJsonReBean;
        }
        while (!this.checkErrorDataState(dataState, errDataState, newDataState) && !this.checkOkDataState(dataState, errDataState, newDataState)) {
            if (System.currentTimeMillis() - currentTime > 10000L) {
                OcContractSubReDomain ocContractSubReDomain = this.ocContractSubService.getContractSubByCode(tenantCode, contractSubCode);
                if (ocContractSubReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractSubCode));
                    break;
                }
                dataState = ocContractSubReDomain.getDataState();
                this.logger.debug(CODE + ".syncContractState.expire", (Object)("\u4e0b\u5355\u5904\u7406\u8d85\u65f6\uff1a" + contractBillcode + ",\u6570\u636e\u5e93\u72b6\u6001\uff1a" + dataState));
                if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                    OcContractReDomain contractReDomain = this.ocContractService.getContractModelByCodes(map);
                    if (contractReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                        break;
                    }
                    if (!this.checkOkDataState(contractReDomain.getDataState(), errDataState, newDataState)) break;
                    return new HtmlJsonReBean(this.getContract(contractReDomain));
                }
                if (dataState == null || dataState.intValue() != errDataState.intValue()) break;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.logger.error(CODE + ".syncContractState.sleep.ex", (Throwable)e);
            }
            try {
                String str = SupDisUtil.getRemot((String)DisKey);
                if (StringUtils.isNotBlank((String)str)) {
                    dataState = Integer.valueOf(str);
                } else {
                    OcContractSubReDomain ocContractSubReDomain = this.ocContractSubService.getContractSubByCode(tenantCode, contractSubCode);
                    if (ocContractSubReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractSubCode));
                        break;
                    }
                    dataState = ocContractSubReDomain.getDataState();
                }
            }
            catch (NumberFormatException e) {
                this.logger.error(CODE, (Object)("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + contractBillcode));
                continue;
            }
            if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                OcContractReDomain contractReDomain = this.ocContractService.getContractOneByCode(map);
                if (contractReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                    break;
                }
                this.sendOrderBigData(contractReDomain);
                dataState = contractReDomain.getDataState();
                if (!this.checkOkDataState(dataState, errDataState, newDataState)) continue;
                return new HtmlJsonReBean(this.getContract(contractReDomain));
            }
            if (!this.checkErrorDataState(dataState, errDataState, newDataState)) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        return new HtmlJsonReBean("-2", "\u8ba2\u5355\u72b6\u6001\u672a\u53d8\u5316", (Object)"no");
    }

    public HtmlJsonReBean getContrant(HttpServletRequest request, String contractBillcode, Integer errDataState, Integer newDataState) {
        for (int i = 0; i < 10; ++i) {
            this.logger.debug(CODE + ".getContrant", (Object)"==========================================================================");
        }
        this.logger.debug(CODE + ".getContrant", (Object)("contractBillcode->" + contractBillcode));
        if (StringUtils.isBlank((String)contractBillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        long currentTime = System.currentTimeMillis();
        long expireMillis = 30000L;
        String DisKey = "ocContract-state-" + contractBillcode + tenantCode;
        Integer dataState = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.checkDataState(errDataState, newDataState, DisKey, map);
        if (null != htmlJsonReBean) {
            return htmlJsonReBean;
        }
        OcContractReDomain contractReDomain = null;
        while (!this.checkErrorDataState(dataState, errDataState, newDataState) && !this.checkOkDataState(dataState, errDataState, newDataState)) {
            contractReDomain = null;
            if (System.currentTimeMillis() - currentTime > 30000L) {
                contractReDomain = this.ocContractService.getContractModelByCodes(map);
                if (contractReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                    break;
                }
                dataState = contractReDomain.getDataState();
                this.logger.debug(CODE + ".syncContractState.expire", (Object)("\u4e0b\u5355\u5904\u7406\u8d85\u65f6\uff1a" + contractBillcode + ",\u6570\u636e\u5e93\u72b6\u6001\uff1a" + dataState));
                if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                    this.logger.error(CODE, (Object)("\u627e\u5230\u8ba2\u5355\u72b6\u60011\uff1a" + dataState + "=" + newDataState));
                    return new HtmlJsonReBean(this.getContract(contractReDomain));
                }
                if (!this.checkErrorDataState(dataState, errDataState, newDataState)) break;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.logger.error(CODE + ".syncContractState.sleep.ex", (Throwable)e);
            }
            try {
                String str = SupDisUtil.getRemot((String)DisKey);
                if (StringUtils.isNotBlank((String)str) && !"null".equals(str)) {
                    dataState = Integer.valueOf(str);
                } else {
                    contractReDomain = this.ocContractService.getContractModelByCodes(map);
                    if (contractReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                        break;
                    }
                    dataState = contractReDomain.getDataState();
                }
            }
            catch (NumberFormatException e) {
                this.logger.debug(CODE, (Object)("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + contractBillcode));
                continue;
            }
            if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                if (null == contractReDomain) {
                    contractReDomain = this.ocContractService.getContractOneByCode(map);
                }
                if (contractReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                    break;
                }
                this.logger.debug(CODE, (Object)("\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + dataState + "=" + newDataState));
                dataState = contractReDomain.getDataState();
                if (!this.checkOkDataState(dataState, errDataState, newDataState)) continue;
                return new HtmlJsonReBean(this.getContract(contractReDomain));
            }
            if (!this.checkErrorDataState(dataState, errDataState, newDataState)) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        this.logger.debug(CODE, (Object)("\u627e\u5230\u8ba2\u5355\u72b6\u60011\uff1a" + dataState + "=" + errDataState + "=" + newDataState));
        if (this.checkOkDataState(dataState, errDataState, newDataState)) {
            return new HtmlJsonReBean(this.getContract(contractReDomain));
        }
        return new HtmlJsonReBean("-2", "\u8ba2\u5355\u72b6\u6001\u672a\u53d8\u5316", (Object)"no");
    }

    public Map<String, Object> getContract(OcContractReDomain contractReDomain) {
        if (null == contractReDomain) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractReDomain.getContractBillcode());
        map.put("contractBbillcode", contractReDomain.getContractBbillcode());
        map.put("contractType", contractReDomain.getContractType());
        map.put("contractBlance", contractReDomain.getContractBlance());
        map.put("contractPmode", contractReDomain.getContractPmode());
        map.put("contractPaygmoney", contractReDomain.getContractPayamoney());
        map.put("dataBmoney", contractReDomain.getDataBmoney());
        return map;
    }

    public void sendOrderBigData(OcContractReDomain contractReDomain) {
    }

    public HtmlJsonReBean checkDataState(Integer errDataState, Integer newDataState, String DisKey, Map<String, Object> map) {
        String str = SupDisUtil.getRemot((String)DisKey);
        Integer dataState = null;
        OcContractReDomain contractReDomain = null;
        if (StringUtils.isNotBlank((String)str) && !"null".equals(str)) {
            dataState = Integer.valueOf(str);
        } else {
            contractReDomain = this.ocContractService.getContractModelByCodes(map);
            if (contractReDomain == null) {
                return null;
            }
            dataState = contractReDomain.getDataState();
        }
        if (this.checkErrorDataState(dataState, errDataState, newDataState)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        if (this.checkOkDataState(dataState, errDataState, newDataState)) {
            if (null == contractReDomain) {
                contractReDomain = this.ocContractService.getContractModelByCodes(map);
            }
            if (contractReDomain == null) {
                this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + map.toString()));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
            }
            if (this.checkOkDataState(contractReDomain.getDataState(), errDataState, newDataState)) {
                return new HtmlJsonReBean(this.getContract(contractReDomain));
            }
        }
        return null;
    }

    public boolean checkErrorDataState(Integer dataState, Integer errDataState, Integer newDataState) {
        this.logger.debug(CODE + ".checkErrorDataState", (Object)"=============================");
        this.logger.debug(CODE + ".checkErrorDataState", (Object)("dataState=>" + dataState));
        this.logger.debug(CODE + ".checkErrorDataState", (Object)("errDataState=>" + errDataState));
        return dataState != null && dataState.intValue() == errDataState.intValue();
    }

    public boolean checkOkDataState(Integer dataState, Integer errDataState, Integer newDataState) {
        if (OcContractService.dataState_2.intValue() == newDataState.intValue() && dataState != null && (dataState.intValue() == newDataState.intValue() || dataState == newDataState + 1 || dataState == newDataState + 2 || dataState.intValue() == OcContractService.dataState_30.intValue())) {
            return true;
        }
        return dataState != null && (dataState.intValue() == newDataState.intValue() || dataState == newDataState + 1);
    }

    public HtmlJsonReBean checkContractPayCom(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".checkContractPay", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractOneByCode(map);
        if (null == ocContractReDomain || OcContractService.dataState_2.intValue() != ocContractReDomain.getDataState().intValue() && OcContractService.dataState_30.intValue() != ocContractReDomain.getDataState().intValue()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return new HtmlJsonReBean();
    }

    public HtmlJsonReBean updateShippedPackageExpressCom(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            this.logger.error(CODE + ".updateShippedPackageExpressCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updatePackage(request, packageId, packageExpress);
    }

    public HtmlJsonReBean updatePackage(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)packageExpress);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".updatePackage.ex", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5904\u7406\u5f02\u5e38");
        }
        ocPackageDomain.setPackageId(packageId);
        ocPackageDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractService.updatePackage(ocPackageDomain);
    }

    public HtmlJsonReBean sendContractNextCom(HttpServletRequest request, Integer contractId, Integer dateState, boolean buy) {
        if (null == contractId || null == dateState) {
            this.logger.error(CODE + ".sendContractNextCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null);
        }
        OcContractReDomain contract = this.ocContractService.getContract(contractId);
        if (contract == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (buy && !this.getUserSession(request).getUserPcode().equals(contract.getMemberBcode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "user");
        }
        if (dateState != contract.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        return this.sendContractNext(request, contract.getContractBillcode());
    }

    public HtmlJsonReBean sendContractPay(HttpServletRequest request, Integer dateState, OcContractSettlDomain ocContractSettlDomain) {
        if (null == ocContractSettlDomain) {
            this.logger.error(CODE + ".sendContractPay", null);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null);
        }
        OcContractReDomain contract = this.ocContractService.getContractOneByCode(this.getQueryMapParam("contractBillcode,tenantCode", ocContractSettlDomain.getContractBillcode(), ocContractSettlDomain.getTenantCode()));
        if (contract == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (dateState != contract.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        return this.ocContractEngineService.sendSaveOffPayOk(ocContractSettlDomain);
    }

    public HtmlJsonReBean sendContractPayBatch(HttpServletRequest request, Integer dateState, List<OcContractSettlDomain> ocContractSettlDomainList) {
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            this.logger.error(CODE + ".sendContractPayBatch", null);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null);
        }
        return this.ocContractEngineService.sendSaveOffPayOkBatch(ocContractSettlDomainList);
    }

    public HtmlJsonReBean sendContractNextCom(HttpServletRequest request, String contractBillcode, Integer dateState, boolean buy) {
        String tenantCode;
        Map<String, Object> getContractMap;
        OcContractReDomain contract;
        if (StringUtils.isBlank((String)contractBillcode) || null == dateState) {
            this.logger.debug(CODE + ".sendContractNextCom", (Object)"param is null");
        }
        if ((contract = this.ocContractService.getContractOneByCode(getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", contractBillcode, tenantCode = this.getTenantCode(request)))) == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (buy && !this.getUserSession(request).getUserPcode().equals(contract.getMemberBcode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "user");
        }
        if (dateState != contract.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        return this.sendContractNext(request, contractBillcode);
    }

    public HtmlJsonReBean calculateFreightFareBatchCom(HttpServletRequest request, String paramStr, String memberBcode) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List fareBeanList = JsonUtil.buildNormalBinder().getJsonToList(paramStr, FareBean.class);
        if (ListUtil.isEmpty((Collection)fareBeanList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        String areaCode = null;
        String shoppingGoodsIdStr = null;
        String skuIdStr = null;
        BigDecimal fare = new BigDecimal(0);
        BigDecimal fare_temp = new BigDecimal(0);
        HtmlJsonReBean htmlJsonReBean = null;
        for (FareBean fareBean : fareBeanList) {
            areaCode = fareBean.getAreaCode();
            if (StringUtils.isNotBlank((String)fareBean.getShoppingGoodsIdStr())) {
                shoppingGoodsIdStr = fareBean.getShoppingGoodsIdStr();
            } else {
                skuIdStr = fareBean.getSkuIdStr();
            }
            htmlJsonReBean = this.calculateFreightFareCom(request, shoppingGoodsIdStr, skuIdStr, areaCode, memberBcode);
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                this.logger.error(CODE + ".calculateFreightFareBatch", (Object)"param is null");
                return htmlJsonReBean;
            }
            fare_temp = (BigDecimal)htmlJsonReBean.getDataObj();
            fare = fare.add(fare_temp);
        }
        return new HtmlJsonReBean((Object)fare);
    }

    public HtmlJsonReBean calculateFreightFareCom(HttpServletRequest request, String shoppingGoodsIdStr, String skuIdStr, String areaCode, String memberBcode) {
        BigDecimal fare;
        if (StringUtils.isBlank((String)shoppingGoodsIdStr) && StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".calculateFreightFare", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List shoppingGoodsIdList = null;
        List skuIdList = null;
        if (StringUtils.isNotBlank((String)shoppingGoodsIdStr)) {
            shoppingGoodsIdList = JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        } else {
            skuIdList = JsonUtil.buildNormalBinder().getJsonToList(skuIdStr, SkuDomain.class);
            if (null == skuIdList || skuIdList.isEmpty()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
            }
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setMemberBcode(StringUtils.isBlank((String)memberBcode) ? userSession.getUserPcode() : memberBcode);
        ocContractDomain.setTenantCode(this.getTenantCode(request));
        try {
            fare = this.ocContractService.getFreightFare(this.ocContractService.makeContractGoodsDomainList("", shoppingGoodsIdList, skuIdList, ocContractDomain, null), areaCode);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".calculateFreightFare.ex", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
        }
        this.logger.debug(CODE + ".calculateFreightFare.json" + fare);
        return new HtmlJsonReBean((Object)fare);
    }

    protected HtmlJsonReBean sendContractNext(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> map = this.getQueryMapParams(request);
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, map);
    }

    public HtmlJsonReBean caExistenceCom(HttpServletRequest request, String contractBillcode, String CallbackURL) throws Exception {
        if (StringUtils.isBlank((String)CallbackURL)) {
            this.logger.debug(CODE + ".CaExistenceCom", (Object)("CallbackURL is===-===" + contractBillcode));
        }
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.debug(CODE + ".CaExistenceCom", (Object)("contractBillcode is==-===" + contractBillcode));
        }
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        String tenanrCode = this.getTenantCode(request);
        return this.ocContractService.CaFollowupoperation(contractBillcode, userCode, CallbackURL, tenanrCode);
    }

    protected OcContractReDomain queryContractPageComes(HttpServletRequest request, String fileName, Map<String, Object> param) {
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            String userCode;
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            UserSession userSession = this.getUserSession(request);
            String string = userCode = null == userSession ? "" : userSession.getUserCode();
            if ("dimension".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertDimensionOrderHeadExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            this.logger.debug(CODE + ".queryContractPageComse.1111", (Object)(param + "=:=" + infoMap + excelTemplate));
            try {
                this.exportComExcel(request, param, infoMap, "oc.contract.getContractByCode", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryContractPageComsee.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.ocContractService.getContractByCode(param);
    }

    protected SupQueryResult<OcContractReDomain> queryContractPageCom(HttpServletRequest request, String fileName, Map<String, Object> param) {
        this.makeDefPage(param);
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u8ba2\u5355\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("fileName", fileName);
            if (StringUtils.isNotBlank((String)excelTemplate) && "ag".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderNewHeadExcelParam());
            } else if ("ms".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderMsHeadExcelParam());
            } else if ("retailer".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxHeadExcelParam());
            } else if ("retailerDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxDetaiHeadExcelParam());
            } else if ("pg".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgHeadExcelParam());
            } else if ("pgDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgDetailHeadExcelParam());
            } else if ("retailerPackets".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderRetailerPacketsExcelParam());
            } else if ("retailerPacketsDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertRetailerPacketsDetailExcelParam());
            } else if ("pt".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertScantlingOrderHeadExcelParam());
            } else if ("ptD".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertScantlingOrderHeadExcelParam());
            } else if ("dimensionGoods".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertDimensionGoodsOrderHeadExcelParam());
            } else if ("FreightOrderExport".equals(excelTemplate)) {
                infoMap.put("headMap", OrderExcel.covertFreightOrderExcelParam());
            } else if ("OrderExport".equals(excelTemplate)) {
                infoMap.put("headMap", OrderExcel.covertOrderRetailerOldPgExcelParam());
            } else if ("OcContractPreSaleExport".equals(excelTemplate)) {
                infoMap.put("fileName", "OcContractPreSaleExport");
                infoMap.put("headMap", ExcelExportTemplate.covertOcContractPreSaleExportExcelParam());
            } else if ("PreSaleReportExport".equals(excelTemplate)) {
                infoMap.put("fileName", "PreSaleReportExport");
                infoMap.put("headMap", ExcelExportTemplate.covertPreSaleReportExportExcelParam());
            } else {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderHeadExcelParam());
            }
            infoMap.put("userCode", userCode);
            this.logger.debug(CODE + ".queryContractPageCom.1111", (Object)(param + "=:=" + infoMap));
            try {
                this.exportComExcel(request, param, infoMap, "oc.contract.queryContractPageReDomain", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryContractPageCom.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        this.logger.error(CODE + ".queryContractPageCom.query", (Object)param.toString());
        return this.ocContractService.queryContractPageReDomain(param);
    }

    protected SupQueryResult<OcContractAndPackageReDomain> queryContractPageAndPackage(HttpServletRequest request, String fileName, Map<String, Object> param) {
        this.makeDefPage(param);
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u8ba2\u5355\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("fileName", fileName);
            if (StringUtils.isNotBlank((String)excelTemplate) && "ag".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderNewHeadExcelParam());
            } else if ("ms".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderMsHeadExcelParam());
            } else if ("retailer".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxHeadExcelParam());
            } else if ("retailerDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxDetaiHeadExcelParam());
            } else if ("pg".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgHeadExcelParam());
            } else if ("pgDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgDetailHeadExcelParam());
            } else if ("retailerPackets".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderRetailerPacketsExcelParam());
            } else if ("retailerPacketsDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertRetailerPacketsDetailExcelParam());
            } else if ("pt".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertScantlingOrderHeadExcelParam());
            } else if ("ptD".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertScantlingOrderHeadExcelParam());
            } else if ("dimensionGoods".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertDimensionGoodsOrderHeadExcelParam());
            } else if ("FreightOrderExport".equals(excelTemplate)) {
                infoMap.put("headMap", OrderExcel.covertFreightOrderExcelParam());
            } else if ("OrderExport".equals(excelTemplate)) {
                infoMap.put("headMap", OrderExcel.covertOrderRetailerOldPgExcelParam());
            } else if ("OcContractPreSaleExport".equals(excelTemplate)) {
                infoMap.put("fileName", "OcContractPreSaleExport");
                infoMap.put("headMap", ExcelExportTemplate.covertOcContractPreSaleExportExcelParam());
            } else if ("PreSaleReportExport".equals(excelTemplate)) {
                infoMap.put("fileName", "PreSaleReportExport");
                infoMap.put("headMap", ExcelExportTemplate.covertPreSaleReportExportExcelParam());
            } else {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderHeadExcelParam());
            }
            infoMap.put("userCode", userCode);
            this.logger.debug(CODE + ".queryContractPageCom.1111", (Object)(param + "=:=" + infoMap));
            try {
                this.exportComExcel(request, param, infoMap, "oc.contract.queryContractPageReDomain", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryContractPageCom.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        this.logger.error(CODE + ".queryContractPageCom.query", (Object)param.toString());
        SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPageReDomain(param);
        SupQueryResult ocContractAndPackageReDomainSupQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractAndPackageReDomainSupQueryResult, ocContractReDomainSupQueryResult);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".queryContractAndPackgePage.ToCopyError", (Object)"\u590d\u5236\u9519\u8bef\uff01", (Throwable)e);
            return null;
        }
        for (int i = 0; i < ocContractReDomainSupQueryResult.getList().size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contractBillcode", ((OcContractAndPackageReDomain)ocContractAndPackageReDomainSupQueryResult.getList().get(i)).getContractBillcode());
            map.put("tenantCode", tenantCode);
            SupQueryResult<OcPackageReDomain> ocPackageReDomainSupQueryResult = this.ocContractService.queryPackagePage(map);
            if (ocPackageReDomainSupQueryResult.getList().size() == 0) continue;
            ((OcContractAndPackageReDomain)ocContractAndPackageReDomainSupQueryResult.getList().get(i)).setOcPackageDomain((OcPackageDomain)ocPackageReDomainSupQueryResult.getList().get(0));
        }
        return ocContractAndPackageReDomainSupQueryResult;
    }

    protected SupQueryResult<OcContractReDomain> queryContractPageNewCom(HttpServletRequest request, String fileName, Map<String, Object> param) {
        this.makeDefPage(param);
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u8ba2\u5355\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("fileName", fileName);
            if (StringUtils.isNotBlank((String)excelTemplate) && "ag".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderNewHeadExcelParam());
            } else if ("ms".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderMsHeadExcelParam());
            } else if ("retailer".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxHeadExcelParam());
            } else if ("retailerDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxDetaiHeadExcelParam());
            } else if ("customercustomer".equals(excelTemplate)) {
                infoMap.put("headMap", OrderExcel.covertOrderRetailerOldPgExcelParam());
            } else if ("pg".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgHeadExcelParam());
            } else if ("pgDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgDetailHeadExcelParam());
            } else if ("retailerPackets".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderRetailerPacketsExcelParam());
            } else if ("retailerPacketsDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertRetailerPacketsDetailExcelParam());
            } else if ("pt".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertScantlingOrderHeadExcelParam());
            } else if ("ptD".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertScantlingOrderHeadExcelParam());
            } else if ("dimensionGoods".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertDimensionGoodsOrderHeadExcelParam());
            } else if ("FreightOrderExport".equals(excelTemplate)) {
                infoMap.put("headMap", OrderExcel.covertFreightOrderExcelParam());
            } else if ("OrderExport".equals(excelTemplate)) {
                infoMap.put("headMap", OrderExcel.covertOrderRetailerOldPgExcelParam());
            } else if ("OcContractPreSaleExport".equals(excelTemplate)) {
                infoMap.put("fileName", "OcContractPreSaleExport");
                infoMap.put("headMap", ExcelExportTemplate.covertOcContractPreSaleExportExcelParam());
            } else if ("PreSaleReportExport".equals(excelTemplate)) {
                infoMap.put("fileName", "PreSaleReportExport");
                infoMap.put("headMap", ExcelExportTemplate.covertPreSaleReportExportExcelParam());
            } else {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderHeadExcelParam());
            }
            infoMap.put("userCode", userCode);
            this.logger.error(CODE + ".queryContractPageCom.query", (Object)param.toString());
            param.put("excelTemplate", excelTemplate);
            this.exportExcelAsy(param, request, fileName, "oc.contract.queryContractPageReDomain");
            return new SupQueryResult();
        }
        this.logger.error(CODE + ".queryContractPageCom.query", (Object)param.toString());
        return this.ocContractService.queryContractNewPageReDomain(param);
    }

    @Override
    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        ArrayList<Map<String, Object>> mapList;
        block97: {
            List ocContractReDomainList;
            block119: {
                SupQueryResult supQueryResult;
                block118: {
                    block117: {
                        block116: {
                            block115: {
                                block114: {
                                    block113: {
                                        block112: {
                                            block111: {
                                                block110: {
                                                    block109: {
                                                        block108: {
                                                            block107: {
                                                                block106: {
                                                                    block105: {
                                                                        block104: {
                                                                            block103: {
                                                                                block102: {
                                                                                    block101: {
                                                                                        block100: {
                                                                                            block99: {
                                                                                                block98: {
                                                                                                    block96: {
                                                                                                        supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
                                                                                                        ocContractReDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), OcContractReDomain.class);
                                                                                                        if (ListUtil.isEmpty((Collection)ocContractReDomainList)) {
                                                                                                            return null;
                                                                                                        }
                                                                                                        this.logger.error("ContractComCon.makeExcelData.makeExcelData", (Object)ocContractReDomainList.size());
                                                                                                        mapList = new ArrayList<Map<String, Object>>();
                                                                                                        if (!StringUtils.isBlank((String)excelTemplate)) break block96;
                                                                                                        for (OcContractReDomain oc : ocContractReDomainList) {
                                                                                                            List<OcContractGoodsDomain> goodsList = oc.getGoodsList();
                                                                                                            boolean flag = false;
                                                                                                            if (ListUtil.isNotEmpty(goodsList)) {
                                                                                                                for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                                                                                                                    Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomain);
                                                                                                                    if (!flag) {
                                                                                                                        Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                                                                        Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                                                                                                                        objectDetailToMap.putAll(stringObjectMap);
                                                                                                                        flag = true;
                                                                                                                    }
                                                                                                                    mapList.add(objectDetailToMap);
                                                                                                                }
                                                                                                                continue;
                                                                                                            }
                                                                                                            Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                                                            Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                                                                                                            mapList.add(stringObjectMap);
                                                                                                        }
                                                                                                        break block97;
                                                                                                    }
                                                                                                    if (!"ag".equals(excelTemplate)) break block98;
                                                                                                    for (OcContractReDomain oc : ocContractReDomainList) {
                                                                                                        List<OcContractGoodsDomain> goodsList = oc.getGoodsList();
                                                                                                        Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                                                        Map<String, Object> stringObjectMap = this.coverOrderStateStr(objectToMap);
                                                                                                        Map<String, Object> stringObjectMapStr = this.coverOrderUser(oc.getMemberBcode(), oc.getTenantCode());
                                                                                                        Map<String, Object> stringObjectMapStr1 = this.covercontractPayamoneyStr(stringObjectMap);
                                                                                                        objectToMap.putAll(stringObjectMap);
                                                                                                        objectToMap.putAll(stringObjectMapStr);
                                                                                                        objectToMap.putAll(stringObjectMapStr1);
                                                                                                        if (ListUtil.isNotEmpty(goodsList)) {
                                                                                                            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                                                                                                                Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomain);
                                                                                                                objectDetailToMap.putAll(objectToMap);
                                                                                                                mapList.add(objectDetailToMap);
                                                                                                            }
                                                                                                            continue;
                                                                                                        }
                                                                                                        mapList.add(objectToMap);
                                                                                                    }
                                                                                                    break block97;
                                                                                                }
                                                                                                if (!"ol".equals(excelTemplate)) break block99;
                                                                                                for (OcContractReDomain oc : ocContractReDomainList) {
                                                                                                    List<OcContractGoodsDomain> goodsList = oc.getGoodsList();
                                                                                                    Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                                                    Map<String, Object> stringObjectMap = this.covOrderState(objectToMap);
                                                                                                    Map<String, Object> stringObjectMapStr = this.coverOrderUser(oc.getMemberBcode(), oc.getTenantCode());
                                                                                                    Map<String, Object> stringObjectMapStr1 = this.covercontractPayamoneyStr(stringObjectMap);
                                                                                                    objectToMap.putAll(stringObjectMap);
                                                                                                    objectToMap.putAll(stringObjectMapStr);
                                                                                                    objectToMap.putAll(stringObjectMapStr1);
                                                                                                    if (ListUtil.isNotEmpty(goodsList)) {
                                                                                                        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                                                                                                            Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomain);
                                                                                                            objectDetailToMap.putAll(objectToMap);
                                                                                                            mapList.add(objectDetailToMap);
                                                                                                        }
                                                                                                        continue;
                                                                                                    }
                                                                                                    mapList.add(objectToMap);
                                                                                                }
                                                                                                break block97;
                                                                                            }
                                                                                            if (!"sc".equals(excelTemplate)) break block100;
                                                                                            for (OcContractReDomain oc : ocContractReDomainList) {
                                                                                                List<OcContractGoodsDomain> goodsList = oc.getGoodsList();
                                                                                                Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                                                Map<String, Object> stringObjectMap = this.coverOrderStateStr(objectToMap);
                                                                                                objectToMap.putAll(stringObjectMap);
                                                                                                if (ListUtil.isNotEmpty(goodsList)) {
                                                                                                    HashMap<String, Object> param = new HashMap<String, Object>();
                                                                                                    for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                                                                                                        PmPromotionReDomain pmPromotionReDomain;
                                                                                                        List<PmPromotionDiscountDomain> pmPromotionDiscountList;
                                                                                                        HashMap<String, BigDecimal> paramStr = new HashMap<String, BigDecimal>();
                                                                                                        Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomain);
                                                                                                        param.put("promotionName", ocContractGoodsDomain.getGoodsProperty2());
                                                                                                        param.put("tenantCode", ocContractGoodsDomain.getTenantCode());
                                                                                                        SupQueryResult<PmPromotionReDomain> pmPromotionReDomainSupQueryResult = this.pmPromotionService.queryPromotionPage(param);
                                                                                                        if (ListUtil.isNotEmpty((Collection)pmPromotionReDomainSupQueryResult.getList()) && ListUtil.isNotEmpty(pmPromotionDiscountList = (pmPromotionReDomain = (PmPromotionReDomain)pmPromotionReDomainSupQueryResult.getList().get(0)).getPmPromotionDiscountList())) {
                                                                                                            PmPromotionDiscountDomain pmPromotionDiscountDomain = pmPromotionDiscountList.get(0);
                                                                                                            List<PmPromotionDiscountlistDomain> pmPromotionDiscountlistList = pmPromotionDiscountDomain.getPmPromotionDiscountlistList();
                                                                                                            for (PmPromotionDiscountlistDomain mPromotionDiscountlistDomain : pmPromotionDiscountlistList) {
                                                                                                                BigDecimal sum = ocContractGoodsDomain.getGoodsNum().multiply(new BigDecimal(mPromotionDiscountlistDomain.getDiscountAmount())).divide(new BigDecimal(100));
                                                                                                                paramStr.put(mPromotionDiscountlistDomain.getPpdlOpname(), sum);
                                                                                                            }
                                                                                                        }
                                                                                                        objectDetailToMap.putAll(paramStr);
                                                                                                        objectDetailToMap.putAll(objectToMap);
                                                                                                        mapList.add(objectDetailToMap);
                                                                                                    }
                                                                                                    continue;
                                                                                                }
                                                                                                mapList.add(objectToMap);
                                                                                            }
                                                                                            break block97;
                                                                                        }
                                                                                        if (!"xs".equals(excelTemplate)) break block101;
                                                                                        HashMap<String, ArrayList<OcContractGoodsDomain>> NameMap = new HashMap<String, ArrayList<OcContractGoodsDomain>>();
                                                                                        HashMap<String, Map<String, Object>> ocMap = new HashMap<String, Map<String, Object>>();
                                                                                        for (Object oc : ocContractReDomainList) {
                                                                                            Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson(oc), String.class, Object.class);
                                                                                            Map<String, Object> stringObjectMap = this.coverOrderStateStr(objectToMap);
                                                                                            objectToMap.putAll(stringObjectMap);
                                                                                            ocMap.put(((OcContractDomain)oc).getContractBillcode(), stringObjectMap);
                                                                                            List<OcContractGoodsDomain> goodsList = ((OcContractDomain)oc).getGoodsList();
                                                                                            if (!ListUtil.isNotEmpty(goodsList)) continue;
                                                                                            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                                                                                                List<OcContractGoodsDomain> ocContractGoodsDomainNameList = (List)NameMap.get(ocContractGoodsDomain.getGoodsName());
                                                                                                if (null == ocContractGoodsDomainNameList) {
                                                                                                    ocContractGoodsDomainNameList = new ArrayList<OcContractGoodsDomain>();
                                                                                                    NameMap.put(ocContractGoodsDomain.getGoodsName(), (ArrayList<OcContractGoodsDomain>)ocContractGoodsDomainNameList);
                                                                                                }
                                                                                                ocContractGoodsDomainNameList.add(ocContractGoodsDomain);
                                                                                            }
                                                                                        }
                                                                                        HashMap<String, BigDecimal> paramSum = new HashMap<String, BigDecimal>();
                                                                                        if (null == NameMap || NameMap.isEmpty()) break block97;
                                                                                        for (String name : NameMap.keySet()) {
                                                                                            List ocContractGoodsDomainList = (List)NameMap.get(name);
                                                                                            if (!ListUtil.isNotEmpty((Collection)ocContractGoodsDomainList)) continue;
                                                                                            BigDecimal sum = BigDecimal.ZERO;
                                                                                            for (OcContractGoodsDomain ocContractGoodsDomains : ocContractGoodsDomainList) {
                                                                                                Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomains);
                                                                                                Map objectToMap = (Map)ocMap.get(ocContractGoodsDomains.getContractBillcode());
                                                                                                objectDetailToMap.putAll(objectToMap);
                                                                                                mapList.add(objectDetailToMap);
                                                                                                BigDecimal goodsCamountSum = ocContractGoodsDomains.getGoodsCamount();
                                                                                                if (null == goodsCamountSum) {
                                                                                                    goodsCamountSum = BigDecimal.ZERO;
                                                                                                }
                                                                                                sum = sum.add(goodsCamountSum);
                                                                                                paramSum.put(name, sum);
                                                                                            }
                                                                                            OcContractGoodsDomain ocContractGoodsDomains = new OcContractGoodsDomain();
                                                                                            ocContractGoodsDomains.setGoodsName("\u54c1\u9879\u5408\u8ba1:");
                                                                                            BigDecimal bigDecimal = (BigDecimal)paramSum.get(name);
                                                                                            if (null == bigDecimal) {
                                                                                                bigDecimal = BigDecimal.ZERO;
                                                                                            }
                                                                                            ocContractGoodsDomains.setGoodsCamount(bigDecimal);
                                                                                            Map<String, Object> objectDetailToMap1 = this.covertMap(ocContractGoodsDomains);
                                                                                            mapList.add(objectDetailToMap1);
                                                                                        }
                                                                                        break block97;
                                                                                    }
                                                                                    if (!"ms".equals(excelTemplate)) break block102;
                                                                                    HashMap<String, ArrayList<OcContractGoodsDomain>> NameMap = new HashMap<String, ArrayList<OcContractGoodsDomain>>();
                                                                                    HashMap<String, Map<String, Object>> ocMap = new HashMap<String, Map<String, Object>>();
                                                                                    for (Object oc : ocContractReDomainList) {
                                                                                        Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson(oc), String.class, Object.class);
                                                                                        Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                                                                                        objectToMap.putAll(stringObjectMap);
                                                                                        ocMap.put(((OcContractDomain)oc).getContractBillcode(), stringObjectMap);
                                                                                        List<OcContractGoodsDomain> goodsList = ((OcContractDomain)oc).getGoodsList();
                                                                                        if (!ListUtil.isNotEmpty(goodsList)) continue;
                                                                                        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                                                                                            List<OcContractGoodsDomain> ocContractGoodsDomainNameList = (List)NameMap.get(ocContractGoodsDomain.getGoodsName());
                                                                                            if (null == ocContractGoodsDomainNameList) {
                                                                                                ocContractGoodsDomainNameList = new ArrayList<OcContractGoodsDomain>();
                                                                                                NameMap.put(ocContractGoodsDomain.getGoodsName(), (ArrayList<OcContractGoodsDomain>)ocContractGoodsDomainNameList);
                                                                                            }
                                                                                            ocContractGoodsDomainNameList.add(ocContractGoodsDomain);
                                                                                        }
                                                                                    }
                                                                                    HashMap paramSum = new HashMap();
                                                                                    if (null == NameMap || NameMap.isEmpty()) break block97;
                                                                                    for (String name : NameMap.keySet()) {
                                                                                        List ocContractGoodsDomainList = (List)NameMap.get(name);
                                                                                        if (!ListUtil.isNotEmpty((Collection)ocContractGoodsDomainList)) continue;
                                                                                        BigDecimal sum = BigDecimal.ZERO;
                                                                                        for (OcContractGoodsDomain ocContractGoodsDomains : ocContractGoodsDomainList) {
                                                                                            Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomains);
                                                                                            Map objectToMap = (Map)ocMap.get(ocContractGoodsDomains.getContractBillcode());
                                                                                            objectDetailToMap.putAll(objectToMap);
                                                                                            mapList.add(objectDetailToMap);
                                                                                            BigDecimal goodsCamountSum = ocContractGoodsDomains.getGoodsCamount();
                                                                                            if (null == goodsCamountSum) {
                                                                                                goodsCamountSum = BigDecimal.ZERO;
                                                                                            }
                                                                                            sum = sum.add(goodsCamountSum);
                                                                                            paramSum.put(name, sum);
                                                                                        }
                                                                                        OcContractGoodsDomain ocContractGoodsDomains = new OcContractGoodsDomain();
                                                                                        ocContractGoodsDomains.setGoodsName("\u54c1\u9879\u5408\u8ba1:");
                                                                                        Object bigDecimal = (BigDecimal)paramSum.get(name);
                                                                                        if (null == bigDecimal) {
                                                                                            bigDecimal = BigDecimal.ZERO;
                                                                                        }
                                                                                        ocContractGoodsDomains.setGoodsCamount((BigDecimal)bigDecimal);
                                                                                    }
                                                                                    break block97;
                                                                                }
                                                                                if (!"pg".equals(excelTemplate)) break block103;
                                                                                for (OcContractReDomain oc : ocContractReDomainList) {
                                                                                    Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                                    Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                                                                                    mapList.add(stringObjectMap);
                                                                                }
                                                                                break block97;
                                                                            }
                                                                            if (!"pgDetail".equals(excelTemplate) && !"retailerDetail".equals(excelTemplate) && !"retailer".equals(excelTemplate)) break block104;
                                                                            for (OcContractReDomain oc : ocContractReDomainList) {
                                                                                BigDecimal dataBmoney;
                                                                                Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                                List<OcContractSettlDomain> ocContractSettlDomains = this.ocContractService.queryContractSettlByContractCode("796758877233610836", oc.getContractBillcode());
                                                                                List ocContractSettlDomainList = ocContractSettlDomains.stream().filter(item -> item.getContractSettlBlance().equals("REB")).collect(Collectors.toList());
                                                                                Map<String, Object> stringObjectMap = this.coverOrderStatePgMh(objectToMap);
                                                                                BigDecimal bigDecimal = dataBmoney = null == oc.getDataBmoney() || oc.getDataBmoney().equals(BigDecimal.ZERO) ? BigDecimal.ZERO : oc.getDataBmoney();
                                                                                if (ListUtil.isEmpty(ocContractSettlDomainList)) {
                                                                                    stringObjectMap.put("aa", dataBmoney);
                                                                                } else {
                                                                                    BigDecimal contractSettlGmoney = null == ((OcContractSettlDomain)ocContractSettlDomainList.get(0)).getContractSettlGmoney() || ((OcContractSettlDomain)ocContractSettlDomainList.get(0)).getContractSettlGmoney().equals(BigDecimal.ZERO) ? BigDecimal.ZERO : ((OcContractSettlDomain)ocContractSettlDomainList.get(0)).getContractSettlGmoney();
                                                                                    stringObjectMap.put("aa", dataBmoney.subtract(contractSettlGmoney));
                                                                                }
                                                                                mapList.add(stringObjectMap);
                                                                            }
                                                                            break block97;
                                                                        }
                                                                        if (!"customercustomer".equals(excelTemplate)) break block105;
                                                                        for (OcContractReDomain oc : ocContractReDomainList) {
                                                                            List<OcContractGoodsDomain> goodsList = oc.getGoodsList();
                                                                            String contractPmode = "";
                                                                            String goodsSupplierName = "";
                                                                            Date PaymentTime = null;
                                                                            List<OcContractSettlDomain> ocContractSettlList = oc.getOcContractSettlList();
                                                                            if (ListUtil.isNotEmpty(ocContractSettlList)) {
                                                                                for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
                                                                                    if (StringUtils.isNotBlank((String)ocContractSettlDomain.getContractSettlBlance()) && ocContractSettlDomain.getContractSettlBlance().equals("VD")) {
                                                                                        contractPmode = contractPmode + "\u4f59\u989d\u652f\u4ed8:" + ocContractSettlDomain.getContractSettlGmoney() + ",";
                                                                                        PaymentTime = oc.getGmtCreate();
                                                                                        continue;
                                                                                    }
                                                                                    if (StringUtils.isNotBlank((String)ocContractSettlDomain.getContractSettlBlance()) && ocContractSettlDomain.getContractSettlBlance().equals("CRP")) {
                                                                                        contractPmode = contractPmode + "\u6388\u4fe1\u652f\u4ed8:" + ocContractSettlDomain.getContractSettlGmoney() + ",";
                                                                                        PaymentTime = oc.getGmtCreate();
                                                                                        continue;
                                                                                    }
                                                                                    if (StringUtils.isNotBlank((String)ocContractSettlDomain.getContractSettlBlance()) && ocContractSettlDomain.getContractSettlBlance().equals("CAS")) {
                                                                                        HashMap<String, Object> map = new HashMap<String, Object>();
                                                                                        map.put("businessOrderno", oc.getContractBillcode());
                                                                                        map.put("tenantCode", oc.getTenantCode());
                                                                                        SupQueryResult<CmChannelClearReDomain> cmChannelClearReDomainSupQueryResult = this.cmChannelClearService.querychannelClearPage(map);
                                                                                        if (!ListUtil.isNotEmpty((Collection)cmChannelClearReDomainSupQueryResult.getList())) continue;
                                                                                        for (CmChannelClearReDomain cmChannelClearReDomain : cmChannelClearReDomainSupQueryResult.getList()) {
                                                                                            if (StringUtils.isNotBlank((String)cmChannelClearReDomain.getFchannelCode()) && cmChannelClearReDomain.getFchannelCode().equals("ylcashier")) {
                                                                                                contractPmode = contractPmode + "\u94f6\u8054\u7f51\u4ed8\u901a:" + cmChannelClearReDomain.getOrderAmount() + ",";
                                                                                                PaymentTime = cmChannelClearReDomain.getGmtCreate();
                                                                                                continue;
                                                                                            }
                                                                                            if (!StringUtils.isNotBlank((String)cmChannelClearReDomain.getFchannelCode()) || !cmChannelClearReDomain.getFchannelCode().equals("ylwallet")) continue;
                                                                                            contractPmode = contractPmode + "\u94f6\u8054\u94b1\u5305:" + cmChannelClearReDomain.getOrderAmount() + ",";
                                                                                            PaymentTime = cmChannelClearReDomain.getGmtCreate();
                                                                                        }
                                                                                        continue;
                                                                                    }
                                                                                    if (StringUtils.isNotBlank((String)ocContractSettlDomain.getContractSettlBlance()) && ocContractSettlDomain.getContractSettlBlance().equals("PMV")) {
                                                                                        if (StringUtils.isBlank((String)goodsSupplierName)) {
                                                                                            goodsSupplierName = ocContractSettlDomain.getContractSettlOpemo() + ",";
                                                                                            continue;
                                                                                        }
                                                                                        goodsSupplierName = goodsSupplierName + ocContractSettlDomain.getContractSettlOpemo() + ",";
                                                                                        continue;
                                                                                    }
                                                                                    if (StringUtils.isNotBlank((String)ocContractSettlDomain.getContractSettlBlance()) && ocContractSettlDomain.getContractSettlBlance().equals("PMP")) {
                                                                                        if (StringUtils.isBlank((String)goodsSupplierName)) {
                                                                                            goodsSupplierName = ocContractSettlDomain.getContractSettlOpemo() + ",";
                                                                                            continue;
                                                                                        }
                                                                                        goodsSupplierName = goodsSupplierName + ocContractSettlDomain.getContractSettlOpemo() + ",";
                                                                                        continue;
                                                                                    }
                                                                                    if (!StringUtils.isNotBlank((String)ocContractSettlDomain.getContractSettlBlance()) || !ocContractSettlDomain.getContractSettlBlance().equals("PM")) continue;
                                                                                    if (StringUtils.isBlank((String)goodsSupplierName)) {
                                                                                        goodsSupplierName = ocContractSettlDomain.getContractSettlOpemo() + ",";
                                                                                        continue;
                                                                                    }
                                                                                    goodsSupplierName = goodsSupplierName + ocContractSettlDomain.getContractSettlOpemo() + ",";
                                                                                }
                                                                            }
                                                                            String sendgoodsCode = "";
                                                                            HashMap<String, Object> SgSendgoodsMap = new HashMap<String, Object>();
                                                                            SgSendgoodsMap.put("contractBillcode", oc.getContractBillcode());
                                                                            SgSendgoodsMap.put("tenantCode", oc.getTenantCode());
                                                                            SupQueryResult<SgSendgoodsReDomain> sgSendgoodsReDomainSupQueryResult = this.sgSendgoodsService.querySendgoodsPage(SgSendgoodsMap);
                                                                            if (ListUtil.isNotEmpty((Collection)sgSendgoodsReDomainSupQueryResult.getList())) {
                                                                                for (Object sgSendgoodsReDomain : sgSendgoodsReDomainSupQueryResult.getList()) {
                                                                                    if (StringUtils.isBlank((String)sendgoodsCode)) {
                                                                                        sendgoodsCode = ((SgSendgoodsDomain)sgSendgoodsReDomain).getSendgoodsCode() + ",";
                                                                                        continue;
                                                                                    }
                                                                                    sendgoodsCode = sendgoodsCode + ((SgSendgoodsDomain)sgSendgoodsReDomain).getSendgoodsCode() + ",";
                                                                                }
                                                                            }
                                                                            boolean flag = false;
                                                                            if (ListUtil.isNotEmpty(goodsList)) {
                                                                                Object sgSendgoodsReDomain;
                                                                                sgSendgoodsReDomain = goodsList.iterator();
                                                                                while (sgSendgoodsReDomain.hasNext()) {
                                                                                    OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)sgSendgoodsReDomain.next();
                                                                                    Map<String, Object> objectDetailToMap = this.covertMapWtite(ocContractGoodsDomain);
                                                                                    if (!flag) {
                                                                                        Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                                        Map<String, Object> stringObjectMap = this.coverOrderStatePg(objectToMap);
                                                                                        objectDetailToMap.putAll(stringObjectMap);
                                                                                    }
                                                                                    HashMap<String, Object> map = new HashMap<String, Object>();
                                                                                    map.put("userinfoCode", oc.getMemberBcode());
                                                                                    map.put("tenantCode", oc.getTenantCode());
                                                                                    SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult = this.userService.queryUserinfoPage(map);
                                                                                    if (ListUtil.isNotEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList())) {
                                                                                        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUserinfoReDomainBeanSupQueryResult.getList().get(0);
                                                                                        objectDetailToMap.put("userinfoOcode", umUserinfoReDomainBean.getUserinfoOcode());
                                                                                        objectDetailToMap.put("userinfoCompname", umUserinfoReDomainBean.getUserinfoCompname());
                                                                                    }
                                                                                    objectDetailToMap.put("contractPmode", contractPmode);
                                                                                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                                                                    if (null != PaymentTime) {
                                                                                        objectDetailToMap.put("PaymentTime", sdf.format(PaymentTime));
                                                                                    }
                                                                                    objectDetailToMap.put("goodsCamount", ocContractGoodsDomain.getGoodsCamount());
                                                                                    objectDetailToMap.put("sendgoodsCode", sendgoodsCode);
                                                                                    if (StringUtils.isNotBlank((String)oc.getMemberGname())) {
                                                                                        objectDetailToMap.put("OrderSource", oc.getMemberGname());
                                                                                    } else {
                                                                                        objectDetailToMap.put("OrderSource", "\u524d\u53f0");
                                                                                    }
                                                                                    BigDecimal contractGoodsPrice = ocContractGoodsDomain.getContractGoodsPrice();
                                                                                    if (null == contractGoodsPrice) {
                                                                                        contractGoodsPrice = BigDecimal.ZERO;
                                                                                    }
                                                                                    BigDecimal contractSendnumMoney = BigDecimal.ZERO;
                                                                                    BigDecimal contractSendnum = ocContractGoodsDomain.getContractGoodsSendnum();
                                                                                    if (null == contractSendnum) {
                                                                                        contractSendnum = BigDecimal.ZERO;
                                                                                    }
                                                                                    if (oc.getContractType().equals("85") || oc.getContractType().equals("86")) {
                                                                                        goodsSupplierName = goodsSupplierName + oc.getGoodsSupplierName();
                                                                                    }
                                                                                    contractSendnumMoney = contractGoodsPrice.multiply(contractSendnum);
                                                                                    contractGoodsPrice = ocContractGoodsDomain.getPricesetNprice().subtract(contractGoodsPrice);
                                                                                    objectDetailToMap.put("pricesetPrefprice", contractGoodsPrice.setScale(2, 5));
                                                                                    objectDetailToMap.put("contractSendnum", contractSendnum);
                                                                                    objectDetailToMap.put("contractSendnumMoney", contractSendnumMoney.setScale(2, 5));
                                                                                    objectDetailToMap.put("goodsSupplierName", goodsSupplierName);
                                                                                    objectDetailToMap.put("departShortname", oc.getDepartShortname());
                                                                                    objectDetailToMap.put("skuNo", ocContractGoodsDomain.getSkuNo());
                                                                                    mapList.add(objectDetailToMap);
                                                                                }
                                                                                continue;
                                                                            }
                                                                            Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                            Map<String, Object> stringObjectMap = this.coverOrderStatePg(objectToMap);
                                                                            mapList.add(stringObjectMap);
                                                                        }
                                                                        break block97;
                                                                    }
                                                                    if (!"retailerPackets".equals(excelTemplate) && !"retailerPacketsDetail".equals(excelTemplate)) break block106;
                                                                    for (OcContractReDomain occ : ocContractReDomainList) {
                                                                        List<OcContractGoodsDomain> occList = occ.getGoodsList();
                                                                        boolean flags = false;
                                                                        if (ListUtil.isNotEmpty(occList)) {
                                                                            for (OcContractGoodsDomain ocContractGoodsDomain : occList) {
                                                                                Map<String, Object> objectDetailToMap = this.covertMapWtite(ocContractGoodsDomain);
                                                                                if (!flags) {
                                                                                    Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)occ), String.class, Object.class);
                                                                                    Map<String, Object> stringObjectMap = this.coverOrderStatePg(objectToMap);
                                                                                    objectDetailToMap.putAll(stringObjectMap);
                                                                                    flags = true;
                                                                                }
                                                                                mapList.add(objectDetailToMap);
                                                                            }
                                                                            continue;
                                                                        }
                                                                        Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)occ), String.class, Object.class);
                                                                        Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                                                                        mapList.add(stringObjectMap);
                                                                    }
                                                                    break block97;
                                                                }
                                                                if (!"pt".equals(excelTemplate)) break block107;
                                                                for (OcContractReDomain oc : ocContractReDomainList) {
                                                                    List<OcContractGoodsDomain> goodsList = oc.getGoodsList();
                                                                    boolean flag = false;
                                                                    if (ListUtil.isNotEmpty(goodsList)) {
                                                                        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                                                                            Map<String, Object> objectDetailToMap = this.covertMapWtite(ocContractGoodsDomain);
                                                                            if (!flag) {
                                                                                Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                                Map<String, Object> stringObjectMap = this.coverOrderStatePt(objectToMap);
                                                                                objectDetailToMap.putAll(stringObjectMap);
                                                                                flag = true;
                                                                            }
                                                                            mapList.add(objectDetailToMap);
                                                                        }
                                                                        continue;
                                                                    }
                                                                    Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                    Map<String, Object> stringObjectMap = this.coverOrderStatePt(objectToMap);
                                                                    mapList.add(stringObjectMap);
                                                                }
                                                                break block97;
                                                            }
                                                            if (!"ptD".equals(excelTemplate)) break block108;
                                                            for (OcContractReDomain oc : ocContractReDomainList) {
                                                                List<OcContractGoodsDomain> goodsList = oc.getGoodsList();
                                                                boolean flag = false;
                                                                if (ListUtil.isNotEmpty(goodsList)) {
                                                                    for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                                                                        Map<String, Object> objectDetailToMap = this.covertMapWtite(ocContractGoodsDomain);
                                                                        if (!flag) {
                                                                            Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                            Map<String, Object> stringObjectMap = this.coverOrderStatePtD(objectToMap);
                                                                            objectDetailToMap.putAll(stringObjectMap);
                                                                            flag = true;
                                                                        }
                                                                        mapList.add(objectDetailToMap);
                                                                    }
                                                                    continue;
                                                                }
                                                                Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                                Map<String, Object> stringObjectMap = this.coverOrderStatePtD(objectToMap);
                                                                mapList.add(stringObjectMap);
                                                            }
                                                            break block97;
                                                        }
                                                        if (!"dimensionGoods".equals(excelTemplate) && !"dimension".equals(excelTemplate)) break block109;
                                                        for (OcContractReDomain occ : ocContractReDomainList) {
                                                            List<OcContractGoodsDomain> occList = occ.getGoodsList();
                                                            boolean flags = false;
                                                            if (ListUtil.isNotEmpty(occList)) {
                                                                for (OcContractGoodsDomain ocContractGoodsDomain : occList) {
                                                                    Map<String, Object> objectDetailToMap = this.covertMapWtite(ocContractGoodsDomain);
                                                                    if (!flags) {
                                                                        Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)occ), String.class, Object.class);
                                                                        Map<String, Object> stringObjectMap = this.coverOrderStateDimension(objectToMap);
                                                                        objectDetailToMap.putAll(stringObjectMap);
                                                                        flags = true;
                                                                    }
                                                                    mapList.add(objectDetailToMap);
                                                                }
                                                                continue;
                                                            }
                                                            Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)occ), String.class, Object.class);
                                                            Map<String, Object> stringObjectMap = this.coverOrderStateDimension(objectToMap);
                                                            mapList.add(stringObjectMap);
                                                        }
                                                        break block97;
                                                    }
                                                    if (!"FreightOrderExport".equals(excelTemplate)) break block110;
                                                    for (OcContractReDomain oc : ocContractReDomainList) {
                                                        HashMap<String, Object> map = new HashMap<String, Object>();
                                                        map.put("userinfoCode", oc.getMemberBcode());
                                                        map.put("userinfoQuaKey", "FreightSettings");
                                                        map.put("tenantCode", oc.getTenantCode());
                                                        SupQueryResult<UmUserinfoQuaReDomain> userinfoQua = this.umUserinfoQuaService.queryUserinfoQuaPage(map);
                                                        if (userinfoQua != null && ListUtil.isNotEmpty((Collection)userinfoQua.getList())) {
                                                            UmUserinfoQuaReDomain umUserinfoQuaReDomain = (UmUserinfoQuaReDomain)userinfoQua.getList().get(0);
                                                            BigDecimal freightMax = new BigDecimal(umUserinfoQuaReDomain.getUserinfoQuaVaule1());
                                                            oc.setFreightSettings(umUserinfoQuaReDomain.getUserinfoQuaVaule());
                                                            if (freightMax.compareTo(oc.getDataBmoney()) == 1) {
                                                                BigDecimal freightValue = new BigDecimal(umUserinfoQuaReDomain.getUserinfoQuaVaule());
                                                                oc.setGoodsLogmoney(oc.getDataBmoney().multiply(freightValue).divide(new BigDecimal(100)));
                                                            }
                                                        }
                                                        Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                        String relationContract = "";
                                                        if (ListUtil.isNotEmpty(oc.getGoodsList())) {
                                                            for (OcContractGoodsDomain goods : oc.getGoodsList()) {
                                                                if (!StringUtils.isNotBlank((String)goods.getGoodsCode())) continue;
                                                                HashMap<String, Object> sgMap = new HashMap<String, Object>();
                                                                sgMap.put("sendgoodsCode", goods.getGoodsCode());
                                                                sgMap.put("tenantCode", goods.getTenantCode());
                                                                SupQueryResult<SgSendgoodsReDomain> sgSendgoodsReDomain = this.sgSendgoodsService.querySendgoodsReDomainPage(sgMap);
                                                                this.logger.error(CODE + "======getContractByCodeForFreight===22222===", (Object)(JsonUtil.buildNonDefaultBinder().toJson(sgSendgoodsReDomain) + "======sgMap======" + ((Object)sgMap).toString()));
                                                                if (!ListUtil.isNotEmpty((Collection)sgSendgoodsReDomain.getList())) continue;
                                                                for (SgSendgoodsReDomain sgSendgoodsReDomain1 : sgSendgoodsReDomain.getList()) {
                                                                    relationContract = relationContract + sgSendgoodsReDomain1.getContractBillcode() + ",";
                                                                }
                                                            }
                                                        }
                                                        objectToMap.put("relationContract", relationContract);
                                                        Map<String, Object> stringObjectMap = this.coverFreightOrderState(objectToMap, oc);
                                                        mapList.add(stringObjectMap);
                                                    }
                                                    break block97;
                                                }
                                                if (!"OrderInfoExport".equals(excelTemplate)) break block111;
                                                for (OcContractReDomain oc : ocContractReDomainList) {
                                                    Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                    Map<String, Object> stringObjectMap = this.coverOrderInfoState(objectToMap, oc);
                                                    mapList.add(stringObjectMap);
                                                }
                                                break block97;
                                            }
                                            if (!"ykOrderListExport".equals(excelTemplate)) break block112;
                                            for (OcContractReDomain oc : ocContractReDomainList) {
                                                if (ListUtil.isNotEmpty(oc.getGoodsList())) {
                                                    for (OcContractGoodsDomain ocContractGoodsDomain : oc.getGoodsList()) {
                                                        Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                        Map<String, Object> stringObjectMap = this.coverOrderInfoListStateToYg(objectToMap, oc, ocContractGoodsDomain);
                                                        mapList.add(stringObjectMap);
                                                    }
                                                    continue;
                                                }
                                                Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                mapList.add(objectToMap);
                                            }
                                            break block97;
                                        }
                                        if (!"ykYsOrderListExport".equals(excelTemplate)) break block113;
                                        for (OcContractReDomain oc : ocContractReDomainList) {
                                            if (!ListUtil.isNotEmpty(oc.getGoodsList())) continue;
                                            for (OcContractGoodsDomain ocContractGoodsDomain : oc.getGoodsList()) {
                                                Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                Map<String, Object> stringObjectMap = this.coverOrderInfoStateToYgYs(objectToMap, oc, ocContractGoodsDomain);
                                                mapList.add(stringObjectMap);
                                            }
                                        }
                                        break block97;
                                    }
                                    if (!"FreightDetailsExport".equals(excelTemplate)) break block114;
                                    for (OcContractReDomain oc : ocContractReDomainList) {
                                        Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                        List<Map<String, Object>> stringObjectMap = this.coverFreightDetails(objectToMap, oc);
                                        mapList.addAll(stringObjectMap);
                                    }
                                    break block97;
                                }
                                if (!"OcContractPreSaleExport".equals(excelTemplate)) break block115;
                                for (OcContractReDomain oc : ocContractReDomainList) {
                                    Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                    List<Map<String, Object>> stringObjectMap = this.coverOcContractPreSaleExport(objectToMap, oc);
                                    mapList.addAll(stringObjectMap);
                                }
                                break block97;
                            }
                            if (!"PreSaleReportExport".equals(excelTemplate)) break block116;
                            for (OcContractReDomain oc : ocContractReDomainList) {
                                Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                Map<String, Object> stringObjectMap = this.coverPreSaleReportExport(objectToMap, oc);
                                this.logger.error("coverPreSaleReportExport.stringObjectMap====", (Object)JsonUtil.buildNormalBinder().toJson(stringObjectMap));
                                mapList.add(stringObjectMap);
                            }
                            break block97;
                        }
                        if (!"ykAdvanceContract".equals(excelTemplate)) break block117;
                        List ocContractReDomains = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), OcContractReDomain.class);
                        for (OcContractReDomain oc : ocContractReDomains) {
                            BigDecimal contractMoney = oc.getDataBmoney().multiply(new BigDecimal(0.3).setScale(2, 4));
                            oc.setAdvanceMoney(contractMoney);
                            UmUserinfoReDomainBean userinfoByCode = this.userService.getUserinfoByCode(oc.getMemberBcode(), oc.getTenantCode());
                            if (null != userinfoByCode) {
                                oc.setMemberCode(userinfoByCode.getUserinfoPhone());
                            }
                            Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                            mapList.add(objectToMap);
                        }
                        break block97;
                    }
                    if (!"statement".equals(excelTemplate)) break block118;
                    Map resultMap = JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
                    List resultList = JsonUtil.buildNormalBinder().getJsonToListByMap(JsonUtil.buildNormalBinder().toJson((Object)resultMap.getOrDefault("list", "[]")), Object.class);
                    if (ListUtil.isEmpty((Collection)resultList)) {
                        return null;
                    }
                    if (!"exterp.contract.queryStatement".equals(apiRouter)) break block97;
                    mapList.addAll(resultList);
                    break block97;
                }
                if (!"userDateBill".equals(excelTemplate)) break block119;
                if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() == 0) break block97;
                mapList.addAll(supQueryResult.getList());
                break block97;
            }
            if ("OcContractReportFrom".equals(excelTemplate)) {
                this.logger.error("ContractComCon.makeExcelData.makeExcelData.OcContractReportFrom");
                for (OcContractReDomain oc : ocContractReDomainList) {
                    Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                    mapList.add(this.coverOcContractReportFrom(objectToMap, oc));
                }
            }
        }
        return mapList;
    }

    private Map<String, Object> coverOcContractReportFrom(Map<String, Object> objectToMap, OcContractReDomain oc) {
        BigDecimal goodsLogmoney;
        if (null == objectToMap || null == oc) {
            return null;
        }
        BigDecimal goodsPinprice = null == oc.getGoodsPinprice() ? BigDecimal.ZERO : oc.getGoodsPinprice();
        BigDecimal goodsCamount = null == oc.getGoodsNum() ? BigDecimal.ZERO : oc.getGoodsNum();
        BigDecimal dataBnum = null == oc.getDataBnum() ? BigDecimal.ZERO : oc.getDataBnum();
        BigDecimal bigDecimal = goodsLogmoney = null == oc.getGoodsLogmoney() ? BigDecimal.ZERO : oc.getGoodsLogmoney();
        if (StringUtils.equals((CharSequence)oc.getDdTypeCurrency(), (CharSequence)"1")) {
            objectToMap.put("ddTypeCurrency", "\u662f");
        } else {
            objectToMap.put("ddTypeCurrency", "\u5426");
        }
        objectToMap.put("contractGoodsPinprice", goodsCamount.multiply(goodsPinprice));
        objectToMap.put("contractGoodsLogmoney", dataBnum.multiply(goodsLogmoney));
        Integer dataState = oc.getDataState();
        switch (dataState) {
            case 2: {
                objectToMap.put("dataState", "\u5f85\u53d1\u8d27\u7533\u8bf7");
                break;
            }
            case 15: {
                objectToMap.put("dataState", "OA\u5ba1\u6838");
                break;
            }
            case -1: {
                objectToMap.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 17: {
                objectToMap.put("dataState", "\u9884\u4ed8\u6b3e\u5ba1\u6838");
                break;
            }
            default: {
                objectToMap.put("dataState", "\u672a\u77e5\u72b6\u6001:" + objectToMap.get("dataState"));
            }
        }
        return objectToMap;
    }

    protected Map<String, Object> coverOrderInfoListStateToYg(Map<String, Object> map, OcContractReDomain oc, OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == map || null == oc || null == ocContractGoodsDomain) {
            return null;
        }
        BigDecimal goodsCamount = null == ocContractGoodsDomain.getGoodsCamount() ? BigDecimal.ZERO : ocContractGoodsDomain.getGoodsCamount();
        BigDecimal contractGoodsSendnum = null == ocContractGoodsDomain.getContractGoodsSendnum() ? BigDecimal.ZERO : ocContractGoodsDomain.getContractGoodsSendnum();
        BigDecimal contractGoodsRefnum = null == ocContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : ocContractGoodsDomain.getContractGoodsRefnum();
        BigDecimal contractGoodsPrice = null == ocContractGoodsDomain.getContractGoodsPrice() ? BigDecimal.ZERO : ocContractGoodsDomain.getContractGoodsPrice();
        BigDecimal contractGoodsMoney = null == ocContractGoodsDomain.getContractGoodsMoney() ? BigDecimal.ZERO : ocContractGoodsDomain.getContractGoodsMoney();
        BigDecimal pricesetNprice = null == ocContractGoodsDomain.getPricesetNprice() ? BigDecimal.ZERO : ocContractGoodsDomain.getPricesetNprice();
        BigDecimal goodsAhnum = null == ocContractGoodsDomain.getGoodsAhnum() ? BigDecimal.ZERO : ocContractGoodsDomain.getGoodsAhnum();
        BigDecimal goodsAhweight = null == ocContractGoodsDomain.getGoodsAhweight() ? BigDecimal.ZERO : ocContractGoodsDomain.getGoodsAhweight();
        String goodsNo = StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsNo()) ? ocContractGoodsDomain.getSkuNo() : ocContractGoodsDomain.getGoodsNo();
        map.put("goodsNo", goodsNo);
        map.put("goodsName", ocContractGoodsDomain.getGoodsName());
        map.put("goodsCamount", goodsCamount);
        map.put("partsnameNumunit", ocContractGoodsDomain.getPartsnameNumunit());
        map.put("contractGoodsPrice", contractGoodsPrice);
        map.put("contractGoodsMoney", contractGoodsMoney);
        map.put("pricesetNprice", pricesetNprice);
        map.put("goodsAhnum", goodsAhnum);
        map.put("goodsAhweight", goodsAhweight);
        map.put("productareaName", null == ocContractGoodsDomain.getProductareaName() ? "" : ocContractGoodsDomain.getProductareaName());
        map.put("goodsContract", null == ocContractGoodsDomain.getGoodsContract() ? "" : ocContractGoodsDomain.getGoodsContract());
        map.put("goodsDay", DateUtils.getDateString((Date)ocContractGoodsDomain.getGoodsDay(), (String)"yyyy-MM-dd"));
        if (null != ocContractGoodsDomain.getContractGoodsAppraise() && ocContractGoodsDomain.getContractGoodsAppraise() == 1) {
            map.put("contractGoodsAppraise", "\u662f");
        } else {
            map.put("contractGoodsAppraise", "\u5426");
        }
        map.put("warehouseName", ocContractGoodsDomain.getWarehouseName());
        BigDecimal dGoodsCamount = BigDecimal.ZERO;
        BigDecimal dContractGoodsMoney = BigDecimal.ZERO;
        if (oc.getDataState() == 2) {
            dGoodsCamount = goodsCamount.subtract(contractGoodsSendnum).subtract(contractGoodsRefnum);
            dContractGoodsMoney = dGoodsCamount.multiply(contractGoodsPrice);
        }
        map.put("dGoodsCamount", dGoodsCamount);
        map.put("dContractGoodsMoney", dContractGoodsMoney);
        BigDecimal dcGoodsCamount = BigDecimal.ZERO;
        BigDecimal dcContractGoodsMoney = BigDecimal.ZERO;
        HashMap<String, Object> querySendContractMap = new HashMap<String, Object>();
        querySendContractMap.put("tenantCode", oc.getTenantCode());
        querySendContractMap.put("contractBillcode", oc.getContractBillcode());
        querySendContractMap.put("dataState", 10);
        SupQueryResult<SgSendgoodsReDomain> sgSendgoodsReDomainSupQueryResult = this.sgSendgoodsService.querySendgoodsPage(querySendContractMap);
        if (!EmptyUtil.isEmpty(sgSendgoodsReDomainSupQueryResult) && !ListUtil.isEmpty((Collection)sgSendgoodsReDomainSupQueryResult.getList())) {
            for (SgSendgoodsReDomain sgSendgoodsReDomain : sgSendgoodsReDomainSupQueryResult.getList()) {
                HashMap<String, Object> querySendGoodsMap = new HashMap<String, Object>();
                querySendGoodsMap.put("sendgoodsCode", sgSendgoodsReDomain.getSendgoodsCode());
                querySendGoodsMap.put("tenantCode", oc.getTenantCode());
                SupQueryResult<SgSendgoodsGoodsReDomain> sgSendgoodsGoodsReDomainPage = this.sgSendgoodsService.querySendgoodsGoodsPage(querySendGoodsMap);
                if (EmptyUtil.isEmpty(sgSendgoodsGoodsReDomainPage) || !ListUtil.isNotEmpty((Collection)sgSendgoodsGoodsReDomainPage.getList())) continue;
                for (SgSendgoodsGoodsReDomain sgSendgoodsGoodsReDomain : sgSendgoodsGoodsReDomainPage.getList()) {
                    if (!StringUtils.equals((CharSequence)sgSendgoodsGoodsReDomain.getGoodsNo(), (CharSequence)goodsNo) && !StringUtils.equals((CharSequence)sgSendgoodsGoodsReDomain.getSkuNo(), (CharSequence)goodsNo)) continue;
                    dcGoodsCamount = dcGoodsCamount.add(null == sgSendgoodsGoodsReDomain.getGoodsCamount() ? BigDecimal.ZERO : sgSendgoodsGoodsReDomain.getGoodsCamount());
                    dcContractGoodsMoney = dcContractGoodsMoney.add((sgSendgoodsGoodsReDomain.getContractGoodsPrice() == null ? BigDecimal.ZERO : sgSendgoodsGoodsReDomain.getContractGoodsPrice()).multiply(null == sgSendgoodsGoodsReDomain.getGoodsCamount() ? BigDecimal.ZERO : sgSendgoodsGoodsReDomain.getGoodsCamount()));
                }
            }
        }
        map.put("dcGoodsCamount", dcGoodsCamount);
        map.put("dcContractGoodsMoney", dcContractGoodsMoney);
        BigDecimal dfhGoodsCamount = BigDecimal.ZERO;
        BigDecimal dfhContractGoodsMoney = BigDecimal.ZERO;
        querySendContractMap.put("dataState", 8);
        SupQueryResult<SgSendgoodsReDomain> dfsendgoodsPage = this.sgSendgoodsService.querySendgoodsPage(querySendContractMap);
        if (!EmptyUtil.isEmpty(dfsendgoodsPage) && !ListUtil.isEmpty((Collection)dfsendgoodsPage.getList())) {
            for (SgSendgoodsReDomain sgSendgoodsReDomain : dfsendgoodsPage.getList()) {
                HashMap<String, Object> querySendGoodsMap = new HashMap<String, Object>();
                querySendGoodsMap.put("sendgoodsCode", sgSendgoodsReDomain.getSendgoodsCode());
                querySendGoodsMap.put("tenantCode", oc.getTenantCode());
                SupQueryResult<SgSendgoodsGoodsReDomain> sgSendgoodsGoodsReDomainPage = this.sgSendgoodsService.querySendgoodsGoodsPage(querySendGoodsMap);
                if (EmptyUtil.isEmpty(sgSendgoodsGoodsReDomainPage) || !ListUtil.isNotEmpty((Collection)sgSendgoodsGoodsReDomainPage.getList())) continue;
                for (SgSendgoodsGoodsReDomain sgSendgoodsGoodsReDomain : sgSendgoodsGoodsReDomainPage.getList()) {
                    if (!StringUtils.equals((CharSequence)sgSendgoodsGoodsReDomain.getGoodsNo(), (CharSequence)goodsNo) && !StringUtils.equals((CharSequence)sgSendgoodsGoodsReDomain.getSkuNo(), (CharSequence)goodsNo)) continue;
                    dfhGoodsCamount = dfhGoodsCamount.add(null == sgSendgoodsGoodsReDomain.getGoodsCamount() ? BigDecimal.ZERO : sgSendgoodsGoodsReDomain.getGoodsCamount());
                    dfhContractGoodsMoney = dfhContractGoodsMoney.add((sgSendgoodsGoodsReDomain.getContractGoodsPrice() == null ? BigDecimal.ZERO : sgSendgoodsGoodsReDomain.getContractGoodsPrice()).multiply(null == sgSendgoodsGoodsReDomain.getGoodsCamount() ? BigDecimal.ZERO : sgSendgoodsGoodsReDomain.getGoodsCamount()));
                }
            }
        }
        map.put("dfhGoodsCamount", dfhGoodsCamount);
        map.put("dfhContractGoodsMoney", dfhContractGoodsMoney);
        BigDecimal yGoodsCamount = BigDecimal.ZERO;
        BigDecimal yContractGoodsMoney = BigDecimal.ZERO;
        querySendContractMap.put("dataState", 9);
        SupQueryResult<SgSendgoodsReDomain> sendgoodsPage = this.sgSendgoodsService.querySendgoodsPage(querySendContractMap);
        if (!EmptyUtil.isEmpty(sendgoodsPage) && !ListUtil.isEmpty((Collection)sendgoodsPage.getList())) {
            for (SgSendgoodsReDomain sgSendgoodsReDomain : sendgoodsPage.getList()) {
                HashMap<String, Object> querySendGoodsMap = new HashMap<String, Object>();
                querySendGoodsMap.put("sendgoodsCode", sgSendgoodsReDomain.getSendgoodsCode());
                querySendGoodsMap.put("tenantCode", oc.getTenantCode());
                SupQueryResult<SgSendgoodsGoodsReDomain> sgSendgoodsGoodsReDomainPage = this.sgSendgoodsService.querySendgoodsGoodsPage(querySendGoodsMap);
                if (EmptyUtil.isEmpty(sgSendgoodsGoodsReDomainPage) || !ListUtil.isNotEmpty((Collection)sgSendgoodsGoodsReDomainPage.getList())) continue;
                for (SgSendgoodsGoodsReDomain sgSendgoodsGoodsReDomain : sgSendgoodsGoodsReDomainPage.getList()) {
                    if (!StringUtils.equals((CharSequence)sgSendgoodsGoodsReDomain.getGoodsNo(), (CharSequence)goodsNo) && !StringUtils.equals((CharSequence)sgSendgoodsGoodsReDomain.getSkuNo(), (CharSequence)goodsNo)) continue;
                    yGoodsCamount = yGoodsCamount.add(null == sgSendgoodsGoodsReDomain.getGoodsCamount() ? BigDecimal.ZERO : sgSendgoodsGoodsReDomain.getGoodsCamount());
                    yContractGoodsMoney = yContractGoodsMoney.add((sgSendgoodsGoodsReDomain.getContractGoodsPrice() == null ? BigDecimal.ZERO : sgSendgoodsGoodsReDomain.getContractGoodsPrice()).multiply(null == sgSendgoodsGoodsReDomain.getGoodsCamount() ? BigDecimal.ZERO : sgSendgoodsGoodsReDomain.getGoodsCamount()));
                }
            }
        }
        map.put("yGoodsCamount", yGoodsCamount);
        map.put("yContractGoodsMoney", yContractGoodsMoney);
        BigDecimal oaGoodsCamount = BigDecimal.ZERO;
        BigDecimal oaContractGoodsMoney = BigDecimal.ZERO;
        if (oc.getDataState() == 15) {
            oaGoodsCamount = goodsCamount;
            oaContractGoodsMoney = contractGoodsMoney;
        }
        map.put("oaGoodsCamount", oaGoodsCamount);
        map.put("oaContractGoodsMoney", oaContractGoodsMoney);
        BigDecimal yfGoodsCamount = BigDecimal.ZERO;
        BigDecimal yfContractGoodsMoney = BigDecimal.ZERO;
        if (oc.getDataState() == 17) {
            yfGoodsCamount = goodsCamount;
            yfContractGoodsMoney = contractGoodsMoney.multiply(new BigDecimal(0.3)).setScale(2, 4);
        }
        map.put("yfGoodsCamount", yfGoodsCamount);
        map.put("yfContractGoodsMoney", yfContractGoodsMoney);
        map.put("gmtCreate", DateUtils.getDateString((Date)oc.getGmtCreate(), (String)"yyyy-MM-dd"));
        return map;
    }

    protected Map<String, Object> coverPreSaleReportExport(Map<String, Object> map, OcContractReDomain oc) {
        BigDecimal goodsAssistweight;
        PmPromotionReDomain promotionByCode;
        BigDecimal contractMoneyNo = BigDecimal.ZERO;
        BigDecimal contractMoneys = BigDecimal.ZERO;
        BigDecimal goodsNumSumBefore = BigDecimal.ZERO;
        BigDecimal goodsSendNumSumNo = BigDecimal.ZERO;
        BigDecimal goodsSendNumSum = BigDecimal.ZERO;
        BigDecimal goodsNumSumNo = BigDecimal.ZERO;
        BigDecimal contractPmoneyNo = BigDecimal.ZERO;
        BigDecimal contractPmoney = BigDecimal.ZERO;
        HashMap<String, Object> ocParam = new HashMap<String, Object>();
        ocParam.put("contractType", "85,86,67");
        ocParam.put("childFlag", true);
        ocParam.put("contractBbillcode", oc.getContractBillcode());
        ocParam.put("tenantCode", oc.getTenantCode());
        SupQueryResult<OcContractReDomain> ocContractResult = this.ocContractService.queryContractPageReDomain(ocParam);
        this.logger.error("coverPreSaleReportExport.ocContractResult====", (Object)JsonUtil.buildNormalBinder().toJson(ocContractResult));
        if (ocContractResult != null && ListUtil.isNotEmpty((Collection)ocContractResult.getList())) {
            for (OcContractReDomain contractReDomain : ocContractResult.getList()) {
                if (contractReDomain.getContractPayamoney() != null) {
                    contractPmoney = contractPmoney.add(contractReDomain.getContractPayamoney());
                }
                if (contractReDomain.getDataState() == 1 || contractReDomain.getDataState().compareTo(1) == 0 || contractReDomain.getDataState().compareTo(-1) == 0 || contractReDomain.getDataState().compareTo(-1) == 0) {
                    if (ListUtil.isNotEmpty(contractReDomain.getGoodsList())) {
                        for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                            goodsNumSumBefore = goodsNumSumBefore.add(contractGoodsDomain.getGoodsCamount());
                            contractMoneys = contractMoneys.add(goodsNumSumBefore.multiply(contractGoodsDomain.getPricesetNprice()));
                        }
                    }
                    this.logger.error("coverPreSaleReportExport.\u5df2\u6279\u5f85\u4ed8\u6b3e\u6570\u91cf====" + contractReDomain.getDataState(), (Object)(goodsNumSumBefore + "====" + contractMoneys));
                }
                if (contractReDomain.getDataState() == 2 || contractReDomain.getDataState().compareTo(2) == 0) {
                    if (ListUtil.isNotEmpty(contractReDomain.getGoodsList())) {
                        for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                            goodsSendNumSumNo = goodsSendNumSumNo.add(contractGoodsDomain.getGoodsCamount());
                            contractMoneys = contractMoneys.add(goodsSendNumSumNo.multiply(contractGoodsDomain.getPricesetNprice()));
                        }
                    }
                    this.logger.error("coverPreSaleReportExport.\u5df2\u6279\u5f85\u53d1\u8d27\u6570\u91cf====" + contractReDomain.getDataState(), (Object)(goodsSendNumSumNo + "====" + contractMoneys));
                }
                if (contractReDomain.getDataState() != 3 && contractReDomain.getDataState() != 4 && contractReDomain.getDataState().compareTo(3) != 0 && contractReDomain.getDataState().compareTo(4) != 0) continue;
                if (ListUtil.isNotEmpty(contractReDomain.getGoodsList())) {
                    for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                        goodsSendNumSum = goodsSendNumSum.add(contractGoodsDomain.getContractGoodsSendnum());
                        contractMoneys = contractMoneys.add(goodsSendNumSum.multiply(contractGoodsDomain.getPricesetNprice()));
                    }
                }
                this.logger.error("coverPreSaleReportExport.\u5df2\u53d1\u6570\u91cf====" + contractReDomain.getDataState(), (Object)(goodsSendNumSum + "====" + contractMoneys));
            }
        }
        if (oc.getContractPayamoney() != null) {
            contractPmoneyNo = contractPmoneyNo.add(oc.getContractPayamoney().subtract(contractPmoney));
        }
        goodsNumSumNo = goodsNumSumNo.add(oc.getDataBnum().subtract(goodsNumSumBefore).subtract(goodsSendNumSumNo).subtract(goodsSendNumSum));
        contractMoneyNo = oc.getContractMoney().subtract(contractMoneys);
        map.put("contractPmoneyNo", contractPmoneyNo);
        map.put("contractMoneyNo", contractMoneyNo);
        map.put("contractMoneys", contractMoneys);
        map.put("goodsNumSumBefore", goodsNumSumBefore);
        map.put("goodsSendNumSumNo", goodsSendNumSumNo);
        map.put("goodsSendNumSum", goodsSendNumSum);
        map.put("goodsNumSumNo", goodsNumSumNo);
        map.put("contractPmoney", contractPmoney);
        if (StringUtils.isNotBlank((String)oc.getGoodsSupplierCode()) && (promotionByCode = this.pmPromotionService.getPromotionByCode(oc.getTenantCode(), oc.getGoodsSupplierCode())) != null) {
            map.put("invUrl", promotionByCode.getPromotionActcode());
        }
        if ((goodsAssistweight = oc.getGoodsAssistweight()) == null) {
            goodsAssistweight = BigDecimal.ZERO;
        }
        map.put("goodsAssistweight", goodsAssistweight + "%");
        if (BigDecimal.ZERO.compareTo(goodsAssistweight) == 0) {
            map.put("goodsAssistweight", "\u65e0");
        }
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5df2\u786e\u8ba4");
                break;
            }
            case -1: {
                map.put("dataState", "\u5df2\u5173\u95ed");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected List<Map<String, Object>> coverOcContractPreSaleExport(Map<String, Object> map, OcContractReDomain oc) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (null == map || null == oc) {
            return null;
        }
        BigDecimal goodsAssistweight = oc.getGoodsAssistweight();
        if (goodsAssistweight == null) {
            goodsAssistweight = BigDecimal.ZERO;
        }
        map.put("goodsAssistweight", goodsAssistweight + "%");
        if (BigDecimal.ZERO.compareTo(goodsAssistweight) == 0) {
            map.put("goodsAssistweight", "\u65e0");
        }
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u5173\u95ed");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5df2\u786e\u8ba4");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        BigDecimal goodsNumSumNo = BigDecimal.ZERO;
        HashMap<String, Object> ocParam = new HashMap<String, Object>();
        ocParam.put("contractType", "85,86,67");
        ocParam.put("childFlag", true);
        ocParam.put("contractBbillcode", oc.getContractBillcode());
        ocParam.put("tenantCode", oc.getTenantCode());
        SupQueryResult<OcContractReDomain> ocContractResult = this.ocContractService.queryContractPageReDomain(ocParam);
        if (ocContractResult != null && ListUtil.isNotEmpty((Collection)ocContractResult.getList())) {
            for (OcContractReDomain contractReDomain : ocContractResult.getList()) {
                if ((contractReDomain.getDataState() == 1 || contractReDomain.getDataState().compareTo(1) == 0 || contractReDomain.getDataState().compareTo(-1) == 0 || contractReDomain.getDataState().compareTo(-1) == 0) && ListUtil.isNotEmpty(contractReDomain.getGoodsList())) {
                    for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                        goodsNumSumNo = goodsNumSumNo.add(contractGoodsDomain.getGoodsCamount());
                    }
                }
                if ((contractReDomain.getDataState() == 2 || contractReDomain.getDataState().compareTo(2) == 0) && ListUtil.isNotEmpty(contractReDomain.getGoodsList())) {
                    for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                        goodsNumSumNo = goodsNumSumNo.add(contractGoodsDomain.getGoodsCamount());
                    }
                }
                if (contractReDomain.getDataState() != 3 && contractReDomain.getDataState() != 4 && contractReDomain.getDataState().compareTo(3) != 0 && contractReDomain.getDataState().compareTo(4) != 0 || !ListUtil.isNotEmpty(contractReDomain.getGoodsList())) continue;
                for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                    goodsNumSumNo = goodsNumSumNo.add(contractGoodsDomain.getContractGoodsSendnum());
                }
            }
        }
        map.put("goodsNumSumNo", goodsNumSumNo);
        String payType = "";
        List<OcContractSettlDomain> ocContractSettlList = oc.getOcContractSettlList();
        if (ListUtil.isNotEmpty(ocContractSettlList)) {
            for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
                if (!StringUtils.isNotBlank((String)ocContractSettlDomain.getContractSettlBlance())) continue;
                if (StringUtils.isNotBlank((String)payType)) {
                    payType = payType + "\u3001";
                }
                HashMap<String, String> payMap = new HashMap<String, String>();
                payMap.put("CRP", "\u4fe1\u7528\u652f\u4ed8");
                payMap.put("VD", "\u652f\u4ed8\u8d26\u6237\u652f\u4ed8");
                payMap.put("ylwallet", "\u94f6\u8054\u94b1\u5305");
                payMap.put("ylcashier", "\u94f6\u8054\u6536\u94f6\u53f0");
                payType = payType + (payMap.containsKey(ocContractSettlDomain.getContractSettlBlance()) ? (String)payMap.get(ocContractSettlDomain.getContractSettlBlance()) + ocContractSettlDomain.getContractSettlGmoney() : "");
            }
        }
        map.put("cashback", payType);
        List<OcContractGoodsDomain> goodsList = oc.getGoodsList();
        if (ListUtil.isNotEmpty(goodsList)) {
            for (OcContractGoodsDomain goods : goodsList) {
                HashMap<String, Object> goodsMap = new HashMap<String, Object>();
                goodsMap.putAll(map);
                goodsMap.put("pntreeName", goods.getPntreeName());
                goodsMap.put("goodsCamount", goods.getGoodsCamount());
                goodsMap.put("contractGoodsPrice", goods.getContractGoodsPrice());
                goodsMap.put("brandName", goods.getBrandName());
                goodsMap.put("skuBarcode", goods.getSkuBarcode());
                goodsMap.put("goodsName", goods.getGoodsName());
                goodsMap.put("partsnameNumunit", goods.getPartsnameNumunit());
                mapList.add(goodsMap);
            }
        }
        return mapList;
    }

    protected List<Map<String, Object>> coverFreightDetails(Map<String, Object> map, OcContractReDomain oc) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (null == map || null == oc) {
            return null;
        }
        List<SgSendgoodsReDomain> sgSendgoodsReDomainList = oc.getSgSendgoodsReDomainList();
        if (ListUtil.isNotEmpty(sgSendgoodsReDomainList)) {
            for (SgSendgoodsReDomain sgSendgoodsReDomain : sgSendgoodsReDomainList) {
                HashMap<String, Object> sgMap = new HashMap<String, Object>();
                sgMap.putAll(map);
                sgMap.put("sendgoodsGetdate", DateUtils.getDateString((Date)sgSendgoodsReDomain.getSendgoodsGetdate(), (String)"yyyy-MM-dd HH:mm:ss"));
                sgMap.put("sgDataBmoney", sgSendgoodsReDomain.getContractMoney());
                sgMap.put("sgContractBillcode", sgSendgoodsReDomain.getContractBillcode());
                sgMap.put("sgPackageBillno", sgSendgoodsReDomain.getPackageBillno());
                sgMap.put("sendgoodsCode", sgSendgoodsReDomain.getSendgoodsCode());
                sgMap.put("sgGmtCreate", DateUtils.getDateString((Date)sgSendgoodsReDomain.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
                mapList.add(sgMap);
            }
        } else {
            mapList.add(map);
        }
        return mapList;
    }

    protected Map<String, Object> coverOrderInfoState(Map<String, Object> map, OcContractReDomain oc) {
        if (null == map || null == oc) {
            return null;
        }
        Integer dataState = oc.getDataState();
        String contractType = String.valueOf(oc.getContractType());
        String contractPmode = String.valueOf(oc.getContractPmode());
        String payType = "";
        List<OcContractSettlDomain> ocContractSettlList = oc.getOcContractSettlList();
        if (ListUtil.isNotEmpty(ocContractSettlList)) {
            for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
                if (!StringUtils.isNotBlank((String)ocContractSettlDomain.getContractSettlBlance())) continue;
                if (StringUtils.isNotBlank((String)payType)) {
                    payType = payType + "\u3001";
                }
                HashMap<String, String> payMap = new HashMap<String, String>();
                payMap.put("CRP", "\u4fe1\u7528\u652f\u4ed8");
                payMap.put("VD", "\u652f\u4ed8\u8d26\u6237\u652f\u4ed8");
                payMap.put("ylwallet", "\u94f6\u8054\u94b1\u5305");
                payMap.put("ylcashier", "\u94f6\u8054\u6536\u94f6\u53f0");
                payType = payType + (payMap.containsKey(ocContractSettlDomain.getContractSettlBlance()) ? (String)payMap.get(ocContractSettlDomain.getContractSettlBlance()) : "");
            }
        }
        map.put("contractPmode", payType);
        switch (contractType) {
            case "00": {
                map.put("contractType", "\u52a0\u76df\u5e97");
                break;
            }
            case "zy00": {
                map.put("contractType", "\u76f4\u8425\u5e97");
            }
        }
        switch (contractType) {
            case "00": {
                map.put("orderType", "\u5b9e\u7269\u8ba2\u5355");
                break;
            }
            case "06": {
                map.put("orderType", "\u79ef\u5206\u8ba2\u5355");
                break;
            }
            case "30": {
                map.put("orderType", "\u9884\u552e\u8ba2\u5355");
                break;
            }
            case "26": {
                map.put("orderType", "\u79d2\u6740\u8ba2\u5355");
                break;
            }
            default: {
                map.put("orderType", "\u5176\u4ed6");
            }
        }
        if ("zy00".equals(contractType) && 1 == dataState) {
            map.put("dataState", "\u5f85\u5ba1\u6838");
        } else {
            switch (dataState) {
                case 0: {
                    map.put("dataState", "\u5ba1\u6838");
                    break;
                }
                case 1: {
                    map.put("dataState", "\u5f85\u4ed8\u6b3e");
                    break;
                }
                case 2: {
                    map.put("dataState", "\u5f85\u53d1\u8d27");
                    break;
                }
                case 3: {
                    map.put("dataState", "\u5f85\u6536\u8d27");
                    break;
                }
                case 4: {
                    map.put("dataState", "\u5df2\u5b8c\u6210");
                    break;
                }
                case 5: {
                    map.put("dataState", "\u4ea4\u6613\u5b8c\u6210");
                    break;
                }
                case -1: {
                    map.put("dataState", "\u5df2\u53d6\u6d88");
                    break;
                }
                default: {
                    map.put("dataState", "\u5176\u4ed6");
                }
            }
        }
        BigDecimal contractSendnumMoney = BigDecimal.ZERO;
        BigDecimal contractOremoney = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty(oc.getGoodsList())) {
            for (OcContractGoodsDomain ocContractGoodsDomain : oc.getGoodsList()) {
                if (null == ocContractGoodsDomain.getContractGoodsSendnum()) continue;
                contractSendnumMoney = contractSendnumMoney.add(ocContractGoodsDomain.getContractGoodsPrice().multiply(ocContractGoodsDomain.getContractGoodsSendnum()));
                contractOremoney = contractOremoney.add(ocContractGoodsDomain.getContractGoodsMoney().subtract(ocContractGoodsDomain.getContractGoodsPrice().multiply(ocContractGoodsDomain.getContractGoodsSendnum())));
            }
        }
        map.put("contractSendnumMoney", contractSendnumMoney);
        map.put("contractOremoney", contractOremoney);
        return map;
    }

    protected Map<String, Object> coverOrderInfoStateToYgYs(Map<String, Object> map, OcContractReDomain oc, OcContractGoodsDomain ocContractGoodsDomain) {
        this.logger.error("orderexport.ykYsOrderListExport.ocContractGoodsDomain.2");
        if (null == map || null == oc || null == ocContractGoodsDomain) {
            return null;
        }
        map.put("goodsNo", StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsNo()) ? ocContractGoodsDomain.getSkuNo() : ocContractGoodsDomain.getGoodsNo());
        map.put("goodsName", ocContractGoodsDomain.getGoodsName());
        map.put("partsnameNumunit", ocContractGoodsDomain.getPartsnameNumunit());
        map.put("goodsCamount", null == ocContractGoodsDomain.getGoodsCamount() ? BigDecimal.ZERO.setScale(2, 4) : ocContractGoodsDomain.getGoodsCamount().setScale(2, 4));
        map.put("contractGoodsPrice", null == ocContractGoodsDomain.getContractGoodsPrice() ? BigDecimal.ZERO.setScale(2, 4) : ocContractGoodsDomain.getContractGoodsPrice().setScale(2, 4));
        map.put("pricesetNprice", null == ocContractGoodsDomain.getPricesetNprice() ? BigDecimal.ZERO.setScale(2, 4) : ocContractGoodsDomain.getPricesetNprice().setScale(2, 4));
        map.put("goodsAhweight", null == ocContractGoodsDomain.getGoodsAhweight() ? BigDecimal.ZERO.setScale(2, 4) : ocContractGoodsDomain.getGoodsAhweight().setScale(2, 4));
        map.put("goodsAhnum", null == ocContractGoodsDomain.getGoodsAhnum() ? BigDecimal.ZERO.setScale(2, 4) : ocContractGoodsDomain.getGoodsAhnum().setScale(2, 4));
        map.put("contractGoodsMoney", null == ocContractGoodsDomain.getContractGoodsMoney() ? BigDecimal.ZERO.setScale(2, 4) : ocContractGoodsDomain.getContractGoodsMoney().setScale(2, 4));
        map.put("goodsDay", DateUtils.getDateString((Date)ocContractGoodsDomain.getGoodsDay(), (String)"yyyy-MM-dd"));
        map.put("productareaName", null == ocContractGoodsDomain.getProductareaName() ? "" : ocContractGoodsDomain.getProductareaName());
        map.put("goodsContract", null == ocContractGoodsDomain.getGoodsContract() ? "" : ocContractGoodsDomain.getGoodsContract());
        if (null != ocContractGoodsDomain.getContractGoodsAppraise() && ocContractGoodsDomain.getContractGoodsAppraise() == 1) {
            map.put("contractGoodsAppraise", "\u662f");
        } else {
            map.put("contractGoodsAppraise", "\u5426");
        }
        map.put("warehouseName", null == ocContractGoodsDomain.getWarehouseName() ? "" : ocContractGoodsDomain.getWarehouseName());
        map.put("gmtCreate", DateUtils.getDateString((Date)oc.getGmtCreate(), (String)"yyyy-MM-dd"));
        if (oc.getDataState() == 1) {
            map.put("gmtModified", "");
        } else {
            map.put("gmtModified", DateUtils.getDateString((Date)oc.getGmtModified(), (String)"yyyy-MM-dd"));
        }
        Integer dataState = oc.getDataState();
        switch (dataState) {
            case 1: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 2: {
                map.put("dataState", "\u5df2\u901a\u8fc7");
                break;
            }
            case -2: {
                map.put("dataState", "\u5df2\u5173\u95ed");
                break;
            }
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            default: {
                map.put("dataState", "\u5176\u4ed6");
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderInfoStateToYg(Map<String, Object> map, OcContractReDomain oc) {
        if (null == map || null == oc) {
            return null;
        }
        Integer dataState = oc.getDataState();
        switch (dataState) {
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27\u7533\u8bf7");
                break;
            }
            case 15: {
                map.put("dataState", "\u5f85OA\u5ba1\u6838");
                break;
            }
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            default: {
                map.put("dataState", "\u5176\u4ed6");
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderStatePtD(Map<String, Object> map) {
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 3: {
                map.put("dataState", "\u5df2\u53d1\u8d27");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 4: {
                map.put("dataState", "\u4ea4\u6613\u6210\u529f");
                break;
            }
            case 0: {
                map.put("dataState", "\u5ba1\u6838");
                break;
            }
            case 5: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderStatePt(Map<String, Object> map) {
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 30: {
                map.put("dataState", "\u5f85\u6210\u56e2");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u53d1\u8d27");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderStatePgMh(Map<String, Object> map) {
        String contractType;
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        String mj = "\u7528\u6237\u540d" + (String)map.get("goodsReceiptMem") + "\u624b\u673a\u53f7" + (String)map.get("goodsReceiptPhone");
        map.put("mj", mj);
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case 8: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case 3: {
                map.put("dataState", "\u5f85\u6536\u8d27");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            case 30: {
                map.put("dataState", "\u5f85\u786e\u8ba4");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        Integer contractPmode = null == map.get("contractPmode") ? 8888 : Integer.valueOf(map.get("contractPmode").toString());
        switch (contractPmode) {
            case 3: {
                map.put("contractPmode", "\u6388\u4fe1\u652f\u4ed8");
                break;
            }
            case 4: {
                map.put("contractPmode", "\u4f59\u989d\u652f\u4ed8");
                break;
            }
            default: {
                map.put("contractPmode", "\u672a\u77e5\u72b6\u6001:" + map.get("contractPmode"));
            }
        }
        switch (contractType = String.valueOf(null == map.get("contractType") ? Integer.valueOf(8888) : map.get("contractType").toString())) {
            case "00": {
                map.put("contractType", "\u6807\u51c6\u8ba2\u5355");
                break;
            }
            case "75": {
                map.put("contractType", "\u6e05\u5e93\u8ba2\u5355");
                break;
            }
            case "76": {
                map.put("contractType", "\u514d\u8d39\u8ba2\u5355");
                break;
            }
            default: {
                map.put("contractType", "\u672a\u77e5\u72b6\u6001:" + map.get("contractType"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderStatePg(Map<String, Object> map) {
        String contractType;
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        String mj = "\u7528\u6237\u540d" + (String)map.get("goodsReceiptMem") + "\u624b\u673a\u53f7" + (String)map.get("goodsReceiptPhone");
        map.put("mj", mj);
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 0: {
                map.put("dataState", "\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u53d1\u8d27");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            case 5: {
                map.put("dataState", "\u4ea4\u6613\u6210\u529f");
                break;
            }
            case 9: {
                map.put("dataState", "\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u4ea4\u6613");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        Integer contractPmode = null == map.get("contractPmode") ? 8888 : Integer.valueOf(map.get("contractPmode").toString());
        switch (contractPmode) {
            case 0: {
                map.put("contractPmode", "\u7ebf\u4e0a");
                break;
            }
            case 1: {
                map.put("contractPmode", "\u7ebf\u4e0b");
                break;
            }
            case 3: {
                map.put("contractPmode", "\u8d27\u5230\u4ed8\u6b3e");
                break;
            }
            default: {
                map.put("contractPmode", "\u672a\u77e5\u72b6\u6001:" + map.get("contractPmode"));
            }
        }
        switch (contractType = String.valueOf(null == map.get("contractType") ? Integer.valueOf(8888) : map.get("contractType").toString())) {
            case "00": {
                map.put("contractType", "\u5b9e\u7269\u8ba2\u5355");
                break;
            }
            case "06": {
                map.put("contractType", "\u79ef\u5206\u8ba2\u5355");
                break;
            }
            case "30": {
                map.put("contractType", "\u9884\u552e\u8ba2\u5355");
                break;
            }
            case "28": {
                map.put("contractType", "\u865a\u62df\u8ba2\u5355");
                break;
            }
            case "65": {
                map.put("contractType", "\u65b0\u5e97\u8ba2\u5355");
                break;
            }
            case "66": {
                map.put("contractType", "\u5206\u8d27\u8ba2\u5355");
                break;
            }
            case "85": {
                map.put("contractType", "\u9884\u552e\u8ba2\u5355\u8f6c\u4e3a\u666e\u901a\u8ba2\u5355");
                break;
            }
            case "67": {
                map.put("contractType", "\u9884\u552e\u5206\u8d27\u8ba2\u5355");
                break;
            }
            case "86": {
                map.put("contractType", "\u9884\u552e\u8ba2\u5355\u8f6c\u4e3a\u666e\u901a\u7559\u8d27\u8ba2\u5355");
                break;
            }
            case "26": {
                map.put("contractType", "\u79d2\u6740\u8ba2\u5355");
                break;
            }
            default: {
                map.put("contractType", "\u672a\u77e5\u72b6\u6001:" + map.get("contractType"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderStateDimension(Map<String, Object> map) {
        String areaName;
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer refundFlag = null == map.get("refundFlag") ? null : Integer.valueOf(map.get("refundFlag").toString());
        String string = areaName = null == map.get("areaName") ? null : map.get("areaName").toString();
        if (StringUtils.isBlank((String)areaName)) {
            String sf = "";
            String ct = "";
            map.put("sf", sf);
            map.put("ct", ct);
        } else {
            String sf = areaName.substring(0, areaName.indexOf(","));
            map.put("sf", sf);
            StringBuffer ct = new StringBuffer();
            String[] strArray = areaName.split(",");
            ct = ct.append(strArray[2]);
            map.put("ct", ct);
        }
        return map;
    }

    protected Map<String, Object> coverOrderStateStr(Map<String, Object> map) {
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u8f6c\u5355");
                break;
            }
            case 5: {
                map.put("dataState", "\u751f\u4ea7\u4e2d");
                break;
            }
            case 0: {
                map.put("dataState", "\u5904\u7406\u4e2d");
                break;
            }
            case 7: {
                map.put("dataState", "\u5f85\u5206\u5382");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u51fa\u5e93");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> covOrderState(Map<String, Object> map) {
        String[] split;
        String goodsReceiptMem;
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        if (null != map.get("goodsReceiptArrdess")) {
            goodsReceiptMem = (String)map.get("goodsReceiptArrdess");
            split = goodsReceiptMem.split(",");
            map.put("goodsReceiptArrdess", split[0]);
        }
        if (null != map.get("goodsReceiptMem")) {
            goodsReceiptMem = (String)map.get("goodsReceiptMem");
            split = goodsReceiptMem.split(",");
            map.put("goodsReceiptMem", split[0]);
        }
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case 3: {
                map.put("dataState", "\u5f85\u6536\u8d27");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u6536\u8d27");
                break;
            }
            case 5: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderUser(String userinfoCode, String tenantCode) {
        UmUserinfoReDomainBean userinfoByCode = this.userService.getUserinfoByCode(userinfoCode, tenantCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != userinfoByCode) {
            map.put("userinfoOcode", userinfoByCode.getUserinfoOcode());
            map.put("cityName", userinfoByCode.getCityName());
        }
        return map;
    }

    protected Map<String, Object> coverOrderState(Map<String, Object> map) {
        String contractType;
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        String mj = "\u7528\u6237\u540d" + (String)map.get("goodsReceiptMem") + "\u624b\u673a\u53f7" + (String)map.get("goodsReceiptPhone");
        map.put("mj", mj);
        String lTime = (String)map.get("promotionBegintime") + (String)map.get("promotionEndtime");
        String YTime = (String)map.get("receiveStart") + (String)map.get("receiveEnd");
        map.put("lTime", lTime);
        map.put("YTime", YTime);
        Integer contractPmode = null == map.get("contractPmode") ? 8888 : Integer.valueOf(map.get("contractPmode").toString());
        switch (contractPmode) {
            case 0: {
                map.put("contractPmode", "\u7ebf\u4e0a");
                break;
            }
            case 1: {
                map.put("contractPmode", "\u7ebf\u4e0b");
                break;
            }
            case 3: {
                map.put("contractPmode", "\u8d27\u5230\u4ed8\u6b3e");
                break;
            }
            default: {
                map.put("contractPmode", "\u672a\u77e5\u72b6\u6001:" + map.get("contractPmode"));
            }
        }
        switch (contractType = String.valueOf(null == map.get("contractType") ? Integer.valueOf(8888) : map.get("contractType").toString())) {
            case "00": {
                map.put("contractType", "\u5b9e\u7269\u8ba2\u5355");
                break;
            }
            case "06": {
                map.put("contractType", "\u79ef\u5206\u8ba2\u5355");
                break;
            }
            case "30": {
                map.put("contractType", "\u9884\u552e\u8ba2\u5355");
                break;
            }
            case "26": {
                map.put("contractType", "\u79d2\u6740\u8ba2\u5355");
                break;
            }
            default: {
                map.put("contractType", "\u672a\u77e5\u72b6\u6001:" + map.get("contractType"));
            }
        }
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 0: {
                map.put("dataState", "\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u53d1\u8d27");
                break;
            }
            case 9: {
                map.put("dataState", "\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u4ea4\u6613");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            case 5: {
                map.put("dataState", "\u4ea4\u6613\u6210\u529f");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverFreightOrderState(Map<String, Object> map, OcContractReDomain oc) {
        String dataState;
        if (null == map || null == oc) {
            return new HashMap<String, Object>();
        }
        String contractOrigin = "";
        map.put("contractOrigin", contractOrigin);
        map.put("freightSettings", oc.getFreightSettings() + "%");
        switch (dataState = null == map.get("dataState") ? "8888" : String.valueOf(map.get("dataState").toString())) {
            case "1": {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case "2": {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            case "4": {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            case "-1": {
                map.put("dataState", "\u5df2\u5173\u95ed");
            }
        }
        String payType = "";
        List<OcContractSettlDomain> ocContractSettlList = oc.getOcContractSettlList();
        if (ListUtil.isNotEmpty(ocContractSettlList)) {
            for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
                if (!StringUtils.isNotBlank((String)ocContractSettlDomain.getContractSettlBlance())) continue;
                if (StringUtils.isNotBlank((String)payType)) {
                    payType = payType + "\u3001";
                }
                HashMap<String, String> payMap = new HashMap<String, String>();
                payMap.put("CRP", "\u4fe1\u7528\u652f\u4ed8");
                payMap.put("VD", "\u652f\u4ed8\u8d26\u6237\u652f\u4ed8");
                payMap.put("ylwallet", "\u94f6\u8054\u94b1\u5305");
                payMap.put("ylcashier", "\u94f6\u8054\u6536\u94f6\u53f0");
                payType = payType + (payMap.containsKey(ocContractSettlDomain.getContractSettlBlance()) ? (String)payMap.get(ocContractSettlDomain.getContractSettlBlance()) : "");
            }
        }
        map.put("contractPmode", payType);
        return map;
    }

    protected Map<String, Object> covercontractPayamoneyStr(Map<String, Object> map) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        Integer dataState = 0;
        String str = null;
        if (null != map.get("contractPayamoney") && map.get("tenantCode").equals("2019110100000001")) {
            str = map.get("contractPayamoney").toString().trim();
            Double v = Double.parseDouble(str);
            int b = v.intValue();
            dataState = b;
        }
        switch (dataState) {
            case 0: {
                map1.put("contractPayamoneyStr", "\u65e0");
                break;
            }
            case 1: {
                map1.put("contractPayamoneyStr", "\u6309\u6bd4\u4f8b");
                break;
            }
            case 2: {
                map1.put("contractPayamoneyStr", "\u56fa\u5b9a\u989d\u5ea6");
                break;
            }
            default: {
                map1.put("contractPayamoneyStr", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map1;
    }

    protected Map<String, Object> covertMap(OcContractGoodsDomain ocContractGoodsDomain) {
        HashMap<String, Object> orderDetaiMap = new HashMap<String, Object>();
        orderDetaiMap.put("classtreeName", ocContractGoodsDomain.getClasstreeName());
        orderDetaiMap.put("warehouseName", ocContractGoodsDomain.getWarehouseName());
        orderDetaiMap.put("goodsProperty5", ocContractGoodsDomain.getGoodsProperty5());
        orderDetaiMap.put("goodsSupplyweight", ocContractGoodsDomain.getGoodsSupplyweight());
        orderDetaiMap.put("partsnameWeightunitStr", ocContractGoodsDomain.getPartsnameWeightunit());
        orderDetaiMap.put("partsnameWeightunit", ocContractGoodsDomain.getPartsnameWeightunit());
        orderDetaiMap.put("goodsNo", ocContractGoodsDomain.getGoodsNo());
        orderDetaiMap.put("goodsName", ocContractGoodsDomain.getGoodsName());
        orderDetaiMap.put("goodsCamount", ocContractGoodsDomain.getGoodsCamount());
        orderDetaiMap.put("contractGoodsInmoney", ocContractGoodsDomain.getContractGoodsInmoney());
        orderDetaiMap.put("contractGoodsMoney", ocContractGoodsDomain.getContractGoodsMoney());
        orderDetaiMap.put("pricesetNprice", ocContractGoodsDomain.getPricesetNprice());
        orderDetaiMap.put("contractGoodsPrice", ocContractGoodsDomain.getContractGoodsPrice());
        orderDetaiMap.put("skuNo", ocContractGoodsDomain.getSkuNo());
        orderDetaiMap.put("skuName", ocContractGoodsDomain.getSkuName());
        orderDetaiMap.put("goodsProperty2", ocContractGoodsDomain.getGoodsProperty2());
        orderDetaiMap.put("goodsProperty3", ocContractGoodsDomain.getGoodsProperty3());
        orderDetaiMap.put("contractGoodsRemark", ocContractGoodsDomain.getContractGoodsRemark());
        orderDetaiMap.put("contractGoodsGtype", ocContractGoodsDomain.getContractGoodsGtype());
        orderDetaiMap.put("memo", ocContractGoodsDomain.getMemo());
        orderDetaiMap.put("goodsRemark", ocContractGoodsDomain.getGoodsRemark());
        orderDetaiMap.put("contractGoodsId", ocContractGoodsDomain.getContractGoodsId());
        orderDetaiMap.put("goodsOrdnum", ocContractGoodsDomain.getGoodsOrdnum());
        orderDetaiMap.put("skuName", ocContractGoodsDomain.getSkuName());
        if (null == ocContractGoodsDomain.getGoodsCamount()) {
            ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getGoodsOneweight()) {
            ocContractGoodsDomain.setGoodsOneweight(BigDecimal.ZERO);
        }
        BigDecimal qty = ocContractGoodsDomain.getGoodsCamount().multiply(ocContractGoodsDomain.getGoodsOneweight());
        orderDetaiMap.put("partsnameWeightunit", qty);
        orderDetaiMap.put("goodsSpec5", ocContractGoodsDomain.getGoodsSpec5());
        if (null == ocContractGoodsDomain.getGoodsOrdnum()) {
            ocContractGoodsDomain.setGoodsOrdnum(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getGoodsCamount()) {
            ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
        }
        orderDetaiMap.put("goodsOrdnumSimple", ocContractGoodsDomain.getGoodsOrdnum().subtract(ocContractGoodsDomain.getGoodsCamount()));
        if (null != ocContractGoodsDomain.getDataState()) {
            String contractGoodsDataState = "";
            contractGoodsDataState = -1 == ocContractGoodsDomain.getDataState() ? "\u53d6\u6d88" : "\u6b63\u5e38";
            orderDetaiMap.put("contractGoodsDataState", contractGoodsDataState);
        }
        return orderDetaiMap;
    }

    protected Map<String, Object> covertMapWtite(OcContractGoodsDomain ocContractGoodsDomain) {
        HashMap<String, Object> orderMaps = new HashMap<String, Object>();
        orderMaps.put("goodsNo", ocContractGoodsDomain.getGoodsNo());
        orderMaps.put("skuBarcode", ocContractGoodsDomain.getSkuBarcode());
        orderMaps.put("skuName", ocContractGoodsDomain.getSkuName());
        orderMaps.put("goodsName", ocContractGoodsDomain.getGoodsName());
        orderMaps.put("pntreeName", ocContractGoodsDomain.getPntreeName());
        orderMaps.put("classtreeName", ocContractGoodsDomain.getClasstreeName());
        orderMaps.put("classtreeCode", ocContractGoodsDomain.getClasstreeCode());
        orderMaps.put("partsnameNumunit", ocContractGoodsDomain.getPartsnameNumunit());
        orderMaps.put("goodsName", ocContractGoodsDomain.getGoodsName());
        orderMaps.put("goodsOneweight", ocContractGoodsDomain.getGoodsOneweight());
        orderMaps.put("pricesetNprice", ocContractGoodsDomain.getPricesetNprice());
        orderMaps.put("goodsInmoney", ocContractGoodsDomain.getContractGoodsInmoney());
        orderMaps.put("goodsNum", ocContractGoodsDomain.getGoodsNum());
        orderMaps.put("pricesetAsprice", ocContractGoodsDomain.getPricesetAsprice());
        orderMaps.put("goodsNum", ocContractGoodsDomain.getGoodsNum());
        orderMaps.put("contractGoodsInmoney", ocContractGoodsDomain.getContractGoodsInmoney());
        orderMaps.put("contractGoodsMoney", ocContractGoodsDomain.getContractGoodsMoney());
        orderMaps.put("goodsCamount", ocContractGoodsDomain.getGoodsCamount());
        orderMaps.put("goodsOrdnum", ocContractGoodsDomain.getGoodsOrdnum());
        orderMaps.put("goodsCode", ocContractGoodsDomain.getGoodsCode());
        orderMaps.put("contractGoodsPrice", ocContractGoodsDomain.getContractGoodsPrice());
        return orderMaps;
    }

    public List<OcContractReDomain> queryContractPlatForBalanceCom(HttpServletRequest request, String memberCcode) {
        SupQueryResult<OcContractReDomain> qlist;
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null == param) {
            return null;
        }
        param.put("memberCcode", memberCcode);
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("dataState", OcContractService.dataState_4);
        String erpFlag = (String)param.get("erpFlag");
        if (StringUtils.isBlank((String)erpFlag)) {
            erpFlag = "0";
        }
        if (null == (qlist = this.ocContractService.queryContractPageReDomain(param)) || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        List<OcContractReDomain> ocContractReDomainList = this.create(qlist.getList(), erpFlag);
        for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
            String erpCode = ocContractReDomain.getErpCode();
            if (StringUtils.isNotBlank((String)erpCode)) continue;
            String erpMsg = this.ocContractService.queryOrderIsMsg(ocContractReDomain.getContractBillcode());
            if (StringUtils.isNotBlank((String)erpMsg)) {
                ocContractReDomain.setMemo(erpMsg);
                continue;
            }
            List ocCflowPprocessReDomainList = this.ocCflowPprocessService.queryCflowPprocessPage(this.getQueryMapParam("contractBillcode,cflowPserviceCode,tenantCode", ocContractReDomain.getContractBillcode(), "P39", ocContractReDomain.getTenantCode())).getList();
            if (ListUtil.isEmpty((Collection)ocCflowPprocessReDomainList)) {
                erpMsg = "\u672a\u63a8\u9001\u4ea7\u751f\u63a8\u9001\u6570\u636e,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u6838\u67e5\uff01";
                ocContractReDomain.setMemo(erpMsg);
                continue;
            }
            if (ocCflowPprocessReDomainList.size() == 1) {
                OcCflowPprocessReDomain ocCflowPprocessReDomain = (OcCflowPprocessReDomain)ocCflowPprocessReDomainList.get(0);
                Integer dataState = ocCflowPprocessReDomain.getDataState();
                if (dataState == 2) {
                    erpMsg = "\u5df2\u63a8\u9001\u5bcc\u57fa\u672a\u5165\u673a,\u5bcc\u57fa\u5165\u673a\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e\u67e5\u770b\uff01";
                    ocContractReDomain.setMemo(erpMsg);
                }
                if (dataState != 3 && dataState != 0) continue;
                erpMsg = "\u63a8\u9001\u5f02\u5e38,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff01";
                ocContractReDomain.setMemo(erpMsg);
                continue;
            }
            boolean successflag = false;
            for (OcCflowPprocessReDomain ocCflowPprocessReDomain : ocCflowPprocessReDomainList) {
                Integer dataState = ocCflowPprocessReDomain.getDataState();
                if (dataState != 2) continue;
                successflag = true;
            }
            if (successflag) {
                erpMsg = "\u5df2\u63a8\u9001\u5bcc\u57fa\u672a\u5165\u673a,\u5bcc\u57fa\u5165\u673a\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e\u67e5\u770b\uff01";
                ocContractReDomain.setMemo(erpMsg);
                continue;
            }
            erpMsg = "\u63a8\u9001\u5f02\u5e38,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff01";
            ocContractReDomain.setMemo(erpMsg);
        }
        return ocContractReDomainList;
    }

    protected List<OcContractReDomain> create(List<OcContractReDomain> list, String erpFlag) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String nostr = this.getListToString(list);
        Map<String, Map<String, Object>> erpMap = this.queryErp(nostr);
        ArrayList<OcContractReDomain> relist = new ArrayList<OcContractReDomain>();
        for (OcContractReDomain ocContractReDomain : list) {
            if (MapUtil.isNotEmpty(erpMap)) {
                Map<String, Object> valueMap = erpMap.get(ocContractReDomain.getContractBillcode());
                if (MapUtil.isNotEmpty(valueMap)) {
                    Object erpAmt = valueMap.get("erpAmt");
                    if (null == erpAmt) {
                        erpAmt = "0";
                    }
                    ocContractReDomain.setErpAmt(new BigDecimal(erpAmt.toString()));
                    ocContractReDomain.setErpCode((String)valueMap.get("erpCode"));
                    ocContractReDomain.setErpDate((String)valueMap.get("erpDate"));
                    if ("2".equals(erpFlag)) continue;
                    relist.add(ocContractReDomain);
                    continue;
                }
                this.logger.debug(CODE + ".queryErp.valueMap.null", (Object)("valueMap:" + valueMap));
                if ("1".equals(erpFlag)) continue;
                relist.add(ocContractReDomain);
                continue;
            }
            this.logger.debug(CODE + ".queryErp.null", (Object)("erpMap:" + erpMap));
            if ("1".equals(erpFlag)) continue;
            relist.add(ocContractReDomain);
        }
        return relist;
    }

    private Map<String, Map<String, Object>> queryErp(String nostr) {
        if (StringUtils.isBlank((String)nostr)) {
            return null;
        }
        return this.ocContractService.queryOrderErpFlag(nostr);
    }

    private String getListToString(List<OcContractReDomain> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String noStr = "";
        for (OcContractReDomain ocContractReDomain : list) {
            if (StringUtils.isNotBlank((String)noStr)) {
                noStr = noStr + ",";
            }
            noStr = noStr + ocContractReDomain.getContractBillcode();
        }
        return noStr;
    }

    private UserSession getUserSession(String memberBcode, UserSession userSession) {
        if (StringUtils.isBlank((String)memberBcode) || null == userSession) {
            return null;
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = this.userService.getUserinfoByCode(memberBcode, userSession.getTenantCode());
        if (null == umUserinfoReDomainBean) {
            return null;
        }
        UserSession reuserSession = new UserSession();
        try {
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)userSession);
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)umUserinfoReDomainBean);
            reuserSession.setUserCode(userSession.getUserCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        SupQueryResult<UmGroupListReDomain> qmem = this.umGroupService.queryGroupListPage(this.getQueryMapParam("userinfoCode,tenantCode", umUserinfoReDomainBean.getUserinfoCode(), umUserinfoReDomainBean.getTenantCode()));
        if (null != qmem && ListUtil.isNotEmpty((Collection)qmem.getList())) {
            reuserSession.setGroupCode(((UmGroupListReDomain)qmem.getList().get(0)).getGroupCode());
            reuserSession.setGroupName(((UmGroupListReDomain)qmem.getList().get(0)).getGroupName());
        }
        return reuserSession;
    }

    public List<PmUserCouponReDomain> queryUserConByGoodsCom(HttpServletRequest request, String pmContractGoodsDomainListStr, String memberBcode, String contractPmode) {
        if (StringUtils.isBlank((String)pmContractGoodsDomainListStr)) {
            this.logger.error(CODE + ".queryUserConByGoodsCom", (Object)"param is null");
            return null;
        }
        try {
            UserSession userSession = this.getUserSession(request);
            if (null == userSession) {
                return null;
            }
            List pmContractGoodsDomainList = JsonUtil.buildNormalBinder().getJsonToList(pmContractGoodsDomainListStr, PmContractGoodsDomain.class);
            return this.ocContractService.queryUserCon(pmContractGoodsDomainList, this.ocContractService.getPmCheckBean(this.getPmChannel(request), this.getProappCode(request), this.getTenantCode(request), memberBcode, userSession.getMerberCompname(), userSession.getUserName(), contractPmode, userSession));
        }
        catch (Exception e) {
            this.logger.error(CODE + ".queryUserConByGoodsCom", (Object)"Exception", (Throwable)e);
            return null;
        }
    }

    public SupQueryResult<OcConsumeBigData> queryAllUserOcConsumeBigDataPageCom(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.ocContractService.queryAllUserOcConsumeBigDataPage(param);
    }

    public List<OcConsumeBigData> queryAllOcConsumeBigDataByDayCom(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.ocContractService.queryAllOcConsumeBigDataByDay(param);
    }

    public SupQueryResult<OcConsumeBigData> queryAllOcConsumeBigDataForSellerPageCom(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.ocContractService.queryAllOcConsumeBigDataForSellerPage(param);
    }

    public HtmlJsonReBean getOrderInvUrlCom(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (MapUtil.isEmpty(param)) {
            this.logger.error(CODE + ".getOrderInvUrl.param.null", (Object)"param is null");
            return new HtmlJsonReBean("error", "param is null");
        }
        HashMap<String, Object> queryUserinfoMap = new HashMap<String, Object>();
        queryUserinfoMap.put("userinfoCode", param.get("memberCcode"));
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReResult = this.userService.queryUserinfoPage(queryUserinfoMap);
        if (ListUtil.isEmpty((Collection)umUserinfoReResult.getList())) {
            this.logger.error(CODE + ".getOrderInvUrl.queryUserinfoPage.null", (Object)"shop is null");
            return new HtmlJsonReBean("error", "shop is null");
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUserinfoReResult.getList().get(0);
        String shopId = umUserinfoReDomainBean.getUserinfoOcode();
        String requestUrl = "";
        String requestKey = "";
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isNotBlank((String)tenantCode)) {
            requestKey = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestOrderInvUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)requestKey);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error(CODE + ".getOrderInvUrl.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + requestKey + ",tenantCode:" + tenantCode));
            return new HtmlJsonReBean("error", "requestUrl is null");
        }
        String orderInvSecretKey = tenantCode.concat("-").concat("SS_SECRET").concat("-").concat(shopId);
        String shopScreact = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)orderInvSecretKey);
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.SupDisUtil.null", (Object)"shopScreact is null");
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.null", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String[] split = shopScreact.split("-");
        if (null == split || split.length != 2) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.split", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String key = split[0];
        String secret = split[1];
        String ddh = shopId + param.get("contractBillcode").toString();
        String je = param.get("dataBmoney").toString();
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.key or secret.null", (Object)(key + "-" + secret));
            return new HtmlJsonReBean("error", "key or secret is null");
        }
        if (StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.secretMap.null", (Object)(shopId + ":shopScreact is null"));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String md5_2 = MD5Util.MD5((String)(key + ddh + MD5Util.MD5((String)(secret + ddh)) + je));
        String url = requestUrl + "?k=" + key + "," + ddh + "," + je + "," + md5_2 + ",$";
        return new HtmlJsonReBean((Object)url);
    }

    public HtmlJsonReBean getOrderInvUrlForPlatCom(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (MapUtil.isEmpty(param)) {
            this.logger.error(CODE + ".getOrderInvUrl.param.null", (Object)"param is null");
            return new HtmlJsonReBean("error", "param is null");
        }
        if (StringUtils.isBlank((String)((String)param.get("memberCcode")))) {
            this.logger.error(CODE + ".getOrderInvUrl.memberCcode.null", (Object)"param is null");
            return new HtmlJsonReBean("error", "memberCcode is null");
        }
        HashMap<String, Object> queryUserinfoMap = new HashMap<String, Object>();
        queryUserinfoMap.put("userinfoCode", param.get("memberCcode"));
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReResult = this.userService.queryUserinfoPage(queryUserinfoMap);
        if (ListUtil.isEmpty((Collection)umUserinfoReResult.getList())) {
            this.logger.error(CODE + ".getOrderInvUrl.queryUserinfoPage.null", (Object)"shop is null");
            return new HtmlJsonReBean("error", "shop is null");
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUserinfoReResult.getList().get(0);
        String shopId = umUserinfoReDomainBean.getUserinfoOcode();
        if (StringUtils.isBlank((String)shopId)) {
            this.logger.error(CODE + ".getOrderInvUrl.shopId.null", param.get("memberCcode"));
            return new HtmlJsonReBean("error", "shopId is null");
        }
        String requestUrl = "";
        String requestKey = "";
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isNotBlank((String)tenantCode)) {
            requestKey = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestOrderInvUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)requestKey);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error(CODE + ".getOrderInvUrl.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + requestKey + ",tenantCode:" + tenantCode));
            return new HtmlJsonReBean("error", "requestUrl is null");
        }
        String orderInvSecretKey = tenantCode.concat("-").concat("SS_SECRET").concat("-").concat(shopId);
        String shopScreact = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)orderInvSecretKey);
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.SupDisUtil.null", (Object)"shopScreact is null");
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.null", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String[] split = shopScreact.split("-");
        if (null == split || split.length != 2) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.split", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String key = split[0];
        String secret = split[1];
        String ddh = shopId + param.get("contractBillcode").toString();
        String je = param.get("dataBmoney").toString();
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.key or secret.null", (Object)(key + "-" + secret));
            return new HtmlJsonReBean("error", "key or secret is null");
        }
        if (StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.secretMap.null", (Object)(shopId + ":shopScreact is null"));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String md5_2 = MD5Util.MD5((String)(key + ddh + MD5Util.MD5((String)(secret + ddh)) + je));
        String url = requestUrl + "?k=" + key + "," + ddh + "," + je + "," + md5_2 + ",$";
        this.logger.debug(CODE + ".getOrderInvUrlForPlatCom.url", (Object)url);
        String text = "";
        try {
            int width = 120;
            String widthStr = (String)param.get("width");
            if (StringUtils.isNotBlank((String)widthStr)) {
                width = Integer.valueOf(widthStr);
            }
            int height = 120;
            String heightStr = (String)param.get("height");
            if (StringUtils.isNotBlank((String)heightStr)) {
                height = Integer.valueOf(heightStr);
            }
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.MARGIN, 0);
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            BitMatrix bitMatrix = qrCodeWriter.encode(url, BarcodeFormat.QR_CODE, width, height, hints);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream(bitMatrix, "PNG", outputStream);
            text = Base64.encodeBase64String((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.debug(CODE + ".getOrderInvUrlForPlatCom.text", (Object)text);
        return new HtmlJsonReBean((Object)text);
    }

    public HtmlJsonReBean updateContractDelcodeCom(HttpServletRequest request, String contractBillcode, String contractDelcode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractDelcode)) {
            this.logger.error(CODE + ".updateContractDelcodeCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractOneByCode(param);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".updateContractDelcodeCom.ocContractReDomain", (Object)((Object)param).toString());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63d0\u8d27\u7801\u6709\u8bef");
        }
        if (!contractDelcode.equals(ocContractReDomain.getContractDelcode())) {
            UmUserinfoReDomainBean umUserinfoReDomainBean = this.userService.getUserinfoByCode(ocContractReDomain.getMemberBcode(), this.getTenantCode(request));
            if (null == umUserinfoReDomainBean) {
                this.logger.error(CODE + ".updateContractDelcodeCom.umUserinfoReDomainBean", (Object)contractDelcode);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63d0\u8d27\u7801\u6709\u8bef");
            }
            if (!contractDelcode.equals(umUserinfoReDomainBean.getUserinfoUcode())) {
                this.logger.error(CODE + ".updateContractDelcodeCom.userinfoUcode", (Object)contractDelcode);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63d0\u8d27\u7801\u6709\u8bef");
            }
        }
        if (3 != ocContractReDomain.getDataState()) {
            this.logger.error(CODE + ".updateContractDelcodeCom.dataState", (Object)ocContractReDomain.getDataState());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
        }
        return this.ocContractService.sendContractNext(contractBillcode, this.getTenantCode(request), null);
    }

    public HtmlJsonReBean updateContractUserinfoCodeCom(HttpServletRequest request, String contractBillcodes, String userinfoCode) {
        if (StringUtils.isBlank((String)contractBillcodes) || StringUtils.isBlank((String)userinfoCode)) {
            this.logger.error(CODE + ".updateContractUserinfoCodeCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryContractForUserBySupplierCode.userSession", (Object)"userSession is null");
            return null;
        }
        for (String contractBillcode : this.getcodeStrList(contractBillcodes)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("contractBillcode", contractBillcode);
            param.put("tenantCode", this.getTenantCode(request));
            param.put("userinfoCode", userinfoCode);
            OcContractReDomain contractByCode = this.ocContractService.getContractByCode(param);
            if (null == contractByCode) {
                this.logger.error(CODE + ".updateContractUserinfoCodeCom.contractByCode", (Object)contractByCode);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u53f7\u6709\u8bef");
            }
            if (3 != contractByCode.getDataState()) {
                this.logger.error(CODE + ".updateContractUserinfoCodeCom.dataState", (Object)contractByCode.getDataState());
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
            }
            if (userSession.getUserPcode().equals(contractByCode.getGoodsSupplierCode())) continue;
            this.logger.error(CODE + ".updateContractUserinfoCodeCom.goodsSupplierCode", (Object)contractByCode.getGoodsSupplierCode());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u914d\u9001\u5546\u6709\u8bef");
        }
        for (String contractBillcode : this.getcodeStrList(contractBillcodes)) {
            this.ocContractService.sendContractNext(contractBillcode, this.getTenantCode(request), null);
        }
        return new HtmlJsonReBean();
    }

    protected List<String> getcodeStrList(String codesStr) {
        String[] codeStr = codesStr.split(",");
        ArrayList<String> codeList = new ArrayList<String>();
        for (String code : codeStr) {
            codeList.add(code);
        }
        return codeList;
    }

    public HtmlJsonReBean updateContractStateExtendCom(Integer contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)contractId) || null == dataState) {
            this.logger.error(CODE + ".cancelContractForAll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null != oldDataState) {
            OcContractReDomain contract = this.ocContractService.getContract(contractId);
            if (null == contract) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "contract is null");
            }
            if (contract.getDataState().intValue() != oldDataState.intValue()) {
                return new HtmlJsonReBean("error", "\u72b6\u6001\u5df2\u53d8\u5316");
            }
        }
        return this.ocContractService.updateContractStateExtend(contractId, dataState, oldDataState);
    }

    public String sendUpdateContracbal(String contractBillcode, String fundType, String feeName, String tenantCode, Map<String, Object> map) {
        return this.ocContractService.sendUpdateContracbal(contractBillcode, fundType, feeName, tenantCode, map);
    }

    protected SupQueryResult<OcClinicRankingDomain> queryClinicRankingCom(HttpServletRequest request, Map<String, Object> map) {
        String METHOD_NAME = ".queryClinicRankingCom";
        this.logger.debug(CODE + ".queryClinicRankingCom", (Object)JsonUtil.buildNonEmptyBinder().toJson(map));
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        if (map.get("startDate") == null) {
            map.put("startDate", sf.format(new Date()));
        }
        if (map.get("endDate") == null) {
            map.put("endDate", sf.format(new Date()));
        }
        HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
        queryUserinfoPageMap.put("userinfoQuality", "service");
        queryUserinfoPageMap.put("tenantCode", this.getTenantCode(request));
        queryUserinfoPageMap.put("userinfoCode", map.get("departCode"));
        queryUserinfoPageMap.put("userinfoParentCode", map.get("companyCode"));
        queryUserinfoPageMap.put("rows", map.get("rows"));
        queryUserinfoPageMap.put("page", map.get("page"));
        queryUserinfoPageMap.put("startRow", map.get("startRow"));
        queryUserinfoPageMap.put("endRow", map.get("endRow"));
        if (map.get("cityCode") == null) {
            queryUserinfoPageMap.put("provinceCode", map.get("provinceCode"));
        } else {
            queryUserinfoPageMap.put("cityCode", map.get("cityCode"));
        }
        queryUserinfoPageMap.put("fuzzy", true);
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult = this.userService.queryUserinfoPage(queryUserinfoPageMap);
        List umUserinfoReDomainBeanList = new ArrayList();
        if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
            umUserinfoReDomainBeanList = umUserinfoReDomainBeanSupQueryResult.getList();
        }
        HashMap<String, Object> queryUserinfoPageAllMap = new HashMap<String, Object>();
        queryUserinfoPageAllMap.put("tenantCode", map.get("tenantCode"));
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanAllSupQueryResult = this.userService.queryUserinfoPage(queryUserinfoPageAllMap);
        List userinfoAllList = umUserinfoReDomainBeanAllSupQueryResult.getList();
        ArrayList<OcClinicRankingDomain> list = new ArrayList<OcClinicRankingDomain>();
        for (int i = 0; i < umUserinfoReDomainBeanList.size(); ++i) {
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            this.logger.debug(CODE + ".queryClinicRankingCom", (Object)("===================getUserinfoParentCode->" + ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode() + "===getUserinfoCode->" + ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode()));
            queryContractPageMap.put("companyCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode());
            queryContractPageMap.put("departCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            queryContractPageMap.put("tenantCode", map.get("tenantCode"));
            queryContractPageMap.put("gmtCreateQstart", map.get("startDate") + " 00:00:00");
            queryContractPageMap.put("gmtCreateQend", map.get("endDate") + " 23:59:59");
            SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(queryContractPageMap);
            List ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
            List<String> everyDayList = this.getBetweenDates(map.get("startDate").toString(), map.get("endDate").toString());
            ArrayList<OcClinckDataDomain> ocClinckDataDomainList = new ArrayList<OcClinckDataDomain>();
            for (int j = 0; j < everyDayList.size(); ++j) {
                queryContractPageMap.put("gmtCreateQstart", everyDayList.get(j) + " 00:00:00");
                queryContractPageMap.put("gmtCreateQend", everyDayList.get(j) + " 23:59:59");
                SupQueryResult<OcContractReDomain> everyDayDataQueryResult = this.ocContractService.queryContractPage(queryContractPageMap);
                List everyDayDataList = everyDayDataQueryResult.getList();
                BigDecimal price = new BigDecimal(0);
                for (int k = 0; k < everyDayDataList.size(); ++k) {
                    price = price.add(((OcContractReDomain)everyDayDataList.get(k)).getDataBmoney());
                }
                OcClinckDataDomain ocClinckDataDomain = new OcClinckDataDomain();
                ocClinckDataDomain.setDate(everyDayList.get(j));
                ocClinckDataDomain.setTotal(everyDayDataList.size());
                ocClinckDataDomain.setPrice(price);
                ocClinckDataDomainList.add(ocClinckDataDomain);
            }
            BigDecimal price = new BigDecimal(0);
            if (ListUtil.isNotEmpty((Collection)ocContractReDomainList)) {
                for (int j = 0; j < ocContractReDomainList.size(); ++j) {
                    price = price.add(((OcContractReDomain)ocContractReDomainList.get(j)).getDataBmoney());
                }
            }
            OcClinicRankingDomain ocClinicRankingDomain = new OcClinicRankingDomain();
            ocClinicRankingDomain.setSalesAmount(price);
            ocClinicRankingDomain.setProvince(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getProvinceName());
            ocClinicRankingDomain.setCity(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getCityName());
            ocClinicRankingDomain.setClinic(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCompname());
            ocClinicRankingDomain.setOrderTotal(ocContractReDomainList.size());
            ocClinicRankingDomain.setChartData(ocClinckDataDomainList);
            if (ListUtil.isNotEmpty((Collection)userinfoAllList)) {
                for (int j = 0; j < userinfoAllList.size(); ++j) {
                    if (!((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCode().equals(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode())) continue;
                    if (((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoType() == 1) {
                        ocClinicRankingDomain.setStaff(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCompname());
                        break;
                    }
                    if (((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoType() == 2) {
                        ocClinicRankingDomain.setDistributor(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCompname());
                        break;
                    }
                    this.logger.debug(CODE + ".queryClinicRankingCom", (Object)"\u672a\u77e5\u7c7b\u578b\uff01");
                    break;
                }
            }
            list.add(ocClinicRankingDomain);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcClinicRankingDomain> queryCityClinicRankingCom(HttpServletRequest request, Map<String, Object> map, UserSession userSession) {
        SupQueryResult supQueryResult = new SupQueryResult();
        UmUserinfoReDomainBean umUserinfoReDomainBean = this.userService.getUserInfoByUserinfoCode(userSession.getUserPcode(), this.getTenantCode(request));
        List<OcClinicRankingDomain> list = new ArrayList();
        if (null == umUserinfoReDomainBean || StringUtils.isEmpty((String)umUserinfoReDomainBean.getCityName())) {
            this.logger.error(CODE + ".queryCityClinicRankingCom.umUserinfoReDomainBean.null", (Object)userSession.getUserPcode());
            return supQueryResult;
        }
        HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
        queryUserinfoPageMap.put("userinfoQuality", "service");
        queryUserinfoPageMap.put("tenantCode", this.getTenantCode(request));
        queryUserinfoPageMap.put("cityName", umUserinfoReDomainBean.getCityName());
        queryUserinfoPageMap.put("fuzzy", true);
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult = this.userService.queryUserinfoPage(queryUserinfoPageMap);
        if (null == umUserinfoReDomainBeanSupQueryResult || ListUtil.isEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryCityClinicRankingCom.umUserinfoReDomainBeanSupQueryResult.null", queryUserinfoPageMap);
            return supQueryResult;
        }
        for (UmUserinfoReDomainBean userinfoReDomainBean : umUserinfoReDomainBeanSupQueryResult.getList()) {
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            OcClinicRankingDomain ocClinicRankingDomain = new OcClinicRankingDomain();
            queryContractPageMap.put("departCode", userinfoReDomainBean.getUserinfoCode());
            queryContractPageMap.put("tenantCode", map.get("tenantCode"));
            String firstDayByMonth = ContractComCon.getFirstDayByMonth(DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd"));
            queryContractPageMap.put("gmtCreate", firstDayByMonth);
            Map<String, Object> countMoneyNew = this.ocContractService.getCountMoneyNew(queryContractPageMap);
            ocClinicRankingDomain.setSalesAmount(null == countMoneyNew.get("sumMoney") ? BigDecimal.ZERO : new BigDecimal(countMoneyNew.get("sumMoney").toString()));
            ocClinicRankingDomain.setClinic(userinfoReDomainBean.getUserinfoCompname());
            ocClinicRankingDomain.setOrderTotal((Integer)countMoneyNew.get("ocCountTools"));
            list.add(ocClinicRankingDomain);
        }
        Collections.sort(list, new Comparator<OcClinicRankingDomain>(){

            @Override
            public int compare(OcClinicRankingDomain o1, OcClinicRankingDomain o2) {
                return o2.getSalesAmount().compareTo(o1.getSalesAmount());
            }
        });
        if (list.size() > 10) {
            list = list.subList(0, 10);
        }
        if (ListUtil.isEmpty(list)) {
            this.logger.debug(CODE + ".queryCityClinicRankingCom.list.list.null");
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    private List<String> getBetweenDates(String date1, String date2) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        Date start = null;
        Date end = null;
        try {
            start = sf.parse(date1);
            end = sf.parse(date2);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(5, -1);
        tempStart.add(6, 1);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        tempEnd.add(5, 1);
        while (tempStart.before(tempEnd)) {
            result.add(sf.format(tempStart.getTime()));
            tempStart.add(6, 1);
        }
        return result;
    }

    protected SupQueryResult<OcBusinessDimensionDomain> queryBusinessDimensionCom(HttpServletRequest request, Map<String, Object> map) {
        String METHOD_NAME = ".queryBusinessDimensionCom";
        this.logger.debug(CODE + ".queryBusinessDimensionCom", (Object)JsonUtil.buildNonEmptyBinder().toJson(map));
        HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
        queryUserinfoPageMap.put("userinfoQuality", "group");
        queryUserinfoPageMap.put("tenantCode", map.get("tenantCode"));
        queryUserinfoPageMap.put("userinfoCode", map.get("dentistCode"));
        queryUserinfoPageMap.put("userinfoParentCode", map.get("clinicCode"));
        queryUserinfoPageMap.put("gmtCreateQstart", map.get("startDate"));
        queryUserinfoPageMap.put("gmtCreateQend", map.get("endDate"));
        queryUserinfoPageMap.put("rows", map.get("rows"));
        queryUserinfoPageMap.put("page", map.get("page"));
        queryUserinfoPageMap.put("startRow", map.get("startRow"));
        queryUserinfoPageMap.put("endRow", map.get("endRow"));
        if (map.get("cityCode") == null) {
            queryUserinfoPageMap.put("provinceCode", map.get("provinceCode"));
        } else {
            queryUserinfoPageMap.put("cityCode", map.get("cityCode"));
        }
        queryUserinfoPageMap.put("fuzzy", true);
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult = this.userService.queryUserinfoPage(queryUserinfoPageMap);
        List umUserinfoReDomainBeanList = new ArrayList();
        if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
            umUserinfoReDomainBeanList = umUserinfoReDomainBeanSupQueryResult.getList();
        }
        HashMap<String, Object> queryUserinfoPageAllMap = new HashMap<String, Object>();
        queryUserinfoPageAllMap.put("tenantCode", map.get("tenantCode"));
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanAllSupQueryResult = this.userService.queryUserinfoPage(queryUserinfoPageAllMap);
        List userinfoAllList = umUserinfoReDomainBeanAllSupQueryResult.getList();
        this.logger.debug(CODE + ".queryBusinessDimensionCom", (Object)("========================\u6839\u636e\u4f9b\u5e94\u5546/\u5458\u5de5\u6392\u9664\u524d->" + umUserinfoReDomainBeanList.size()));
        if (map.get("companyCode") != null) {
            Iterator iterator = umUserinfoReDomainBeanList.iterator();
            while (iterator.hasNext()) {
                UmUserinfoReDomainBean next = (UmUserinfoReDomainBean)iterator.next();
                for (int i = 0; i < userinfoAllList.size(); ++i) {
                    if (!next.getUserinfoParentCode().equals(((UmUserinfoReDomainBean)userinfoAllList.get(i)).getUserinfoCode())) continue;
                    Boolean flag = true;
                    for (int j = 0; j < userinfoAllList.size(); ++j) {
                        if (!((UmUserinfoReDomainBean)userinfoAllList.get(i)).getUserinfoParentCode().equals(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCode()) || !((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCode().equals(map.get("companyCode"))) continue;
                        flag = false;
                        break;
                    }
                    if (!flag.booleanValue()) continue;
                    iterator.remove();
                }
            }
        }
        this.logger.debug(CODE + ".queryBusinessDimensionCom", (Object)("========================\u6839\u636e\u4f9b\u5e94\u5546/\u5458\u5de5\u6392\u9664\u540e->" + umUserinfoReDomainBeanList.size()));
        if (map.get("startDate") == null && map.get("endDate") == null) {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            if (map.get("firstSaleStartDate") == null) {
                map.put("firstSaleStartDate", sf.format(new Date()) + " 00:00:00");
            }
            if (map.get("firstSaleEndDate") == null) {
                map.put("firstSaleEndDate", sf.format(new Date()) + " 23:59:59");
            }
            Iterator iterator = umUserinfoReDomainBeanList.iterator();
            while (iterator.hasNext()) {
                UmUserinfoReDomainBean next = (UmUserinfoReDomainBean)iterator.next();
                HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
                UmUserinfoReDomainBean umUserinfoReDomainBean = this.getParentUmUserinfoReDomainBean(next, userinfoAllList);
                if (umUserinfoReDomainBean != null) {
                    queryContractPageMap.put("companyCode", umUserinfoReDomainBean.getUserinfoCode());
                }
                queryContractPageMap.put("departCode", next.getUserinfoParentCode());
                queryContractPageMap.put("employeeCode", next.getUserinfoCode());
                queryContractPageMap.put("tenantCode", map.get("tenantCode"));
                SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(queryContractPageMap);
                List ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
                OcContractReDomain firstSaleOrder = this.getFirstSaleOrder(ocContractReDomainList);
                if (firstSaleOrder == null) {
                    this.logger.debug(CODE + ".queryBusinessDimensionCom", (Object)"========================firstSaleOrder->null");
                    iterator.remove();
                    continue;
                }
                try {
                    this.logger.debug(CODE + ".queryBusinessDimensionCom", (Object)("========================\u65f6\u95f4->" + firstSaleOrder.getGmtCreate()));
                    if (firstSaleOrder.getGmtCreate().compareTo(sf.parse(map.get("firstSaleStartDate").toString())) != -1 && firstSaleOrder.getGmtCreate().compareTo(sf.parse(map.get("firstSaleEndDate").toString())) != 1) continue;
                    iterator.remove();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        this.logger.debug(CODE + ".queryBusinessDimensionCom", (Object)("========================\u6839\u636e\u9996\u6b21\u9500\u552e\u65f6\u95f4\u6392\u9664\u540e->" + umUserinfoReDomainBeanList.size()));
        ArrayList<OcBusinessDimensionDomain> list = new ArrayList<OcBusinessDimensionDomain>();
        for (int i = 0; i < umUserinfoReDomainBeanList.size(); ++i) {
            this.logger.debug(CODE + ".queryBusinessDimensionCom", (Object)("===================getUserinfoParentCode->" + ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode() + "===getUserinfoCode->" + ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode()));
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            UmUserinfoReDomainBean umUserinfoReDomainBean = this.getParentUmUserinfoReDomainBean((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i), userinfoAllList);
            if (umUserinfoReDomainBean != null) {
                queryContractPageMap.put("companyCode", umUserinfoReDomainBean.getUserinfoCode());
            }
            queryContractPageMap.put("departCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode());
            queryContractPageMap.put("employeeCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            queryContractPageMap.put("tenantCode", map.get("tenantCode"));
            this.logger.debug(CODE + ".queryBusinessDimensionCom", (Object)"========================\u6309\u7167\u6ce8\u518c\u65f6\u95f4\u6bb5\u67e5\u8be2");
            if (map.get("startDate") == null && map.get("endDate") == null) {
                this.logger.debug(CODE + ".queryBusinessDimensionCom", (Object)"========================\u6309\u7167\u9996\u6b21\u9500\u552e\u65f6\u95f4\u6bb5\u67e5\u8be2");
                queryContractPageMap.put("gmtCreateQstart", map.get("firstSaleStartDate"));
                queryContractPageMap.put("gmtCreateQend", map.get("firstSaleEndDate"));
            }
            SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(queryContractPageMap);
            List ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
            BigDecimal price = new BigDecimal(0);
            for (int j = 0; j < ocContractReDomainList.size(); ++j) {
                price = price.add(((OcContractReDomain)ocContractReDomainList.get(j)).getDataBmoney());
            }
            if (map.get("salesAmountStrat") != null && map.get("salesAmountEnd") != null ? price.compareTo(new BigDecimal(map.get("salesAmountStrat").toString())) == -1 || price.compareTo(new BigDecimal(map.get("salesAmountEnd").toString())) == 1 : (map.get("salesAmountStrat") != null && map.get("salesAmountEnd") == null ? price.compareTo(new BigDecimal(map.get("salesAmountStrat").toString())) == -1 : map.get("salesAmountStrat") == null && map.get("salesAmountEnd") != null && price.compareTo(new BigDecimal(map.get("salesAmountEnd").toString())) == 1)) continue;
            List<String> everyDayList = null;
            everyDayList = map.get("startDate") == null && map.get("endDate") == null ? this.getBetweenDates(map.get("firstSaleStartDate").toString(), map.get("firstSaleEndDate").toString()) : this.getBetweenDates(map.get("startDate").toString(), map.get("endDate").toString());
            ArrayList<OcClinckDataDomain> ocClinckDataDomainList = new ArrayList<OcClinckDataDomain>();
            for (int j = 0; j < everyDayList.size(); ++j) {
                queryContractPageMap.put("gmtCreateQstart", everyDayList.get(j) + " 00:00:00");
                queryContractPageMap.put("gmtCreateQend", everyDayList.get(j) + " 23:59:59");
                SupQueryResult<OcContractReDomain> everyDayDataQueryResult = this.ocContractService.queryContractPage(queryContractPageMap);
                List everyDayDataList = everyDayDataQueryResult.getList();
                BigDecimal priceToday = new BigDecimal(0);
                for (int k = 0; k < everyDayDataList.size(); ++k) {
                    priceToday = priceToday.add(((OcContractReDomain)everyDayDataList.get(k)).getDataBmoney());
                }
                OcClinckDataDomain ocClinckDataDomain = new OcClinckDataDomain();
                ocClinckDataDomain.setDate(everyDayList.get(j));
                ocClinckDataDomain.setTotal(everyDayDataList.size());
                ocClinckDataDomain.setPrice(priceToday);
                ocClinckDataDomainList.add(ocClinckDataDomain);
            }
            queryContractPageMap.put("gmtCreateQstart", null);
            queryContractPageMap.put("gmtCreateQend", null);
            SupQueryResult<OcContractReDomain> everyDayDataQueryResult = this.ocContractService.queryContractPage(queryContractPageMap);
            List nowDataList = everyDayDataQueryResult.getList();
            OcContractReDomain firstSaleOrder = this.getFirstSaleOrder(nowDataList);
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            OcBusinessDimensionDomain ocBusinessDimensionDomain = new OcBusinessDimensionDomain();
            ocBusinessDimensionDomain.setSalesAmount(price);
            ocBusinessDimensionDomain.setRegistrationDate(sf.format(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getGmtCreate()));
            if (firstSaleOrder != null) {
                ocBusinessDimensionDomain.setFirstSaleDate(sf.format(firstSaleOrder.getGmtCreate()));
            }
            ocBusinessDimensionDomain.setProvince(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getProvinceName());
            ocBusinessDimensionDomain.setDentist(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCompname());
            ocBusinessDimensionDomain.setCity(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getCityName());
            ocBusinessDimensionDomain.setOrderTotal(ocContractReDomainList.size());
            ocBusinessDimensionDomain.setChartData(ocClinckDataDomainList);
            for (int j = 0; j < userinfoAllList.size(); ++j) {
                if (!((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCode().equals(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode())) continue;
                for (int k = 0; k < userinfoAllList.size(); ++k) {
                    if (!((UmUserinfoReDomainBean)userinfoAllList.get(k)).getUserinfoCode().equals(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoParentCode())) continue;
                    if (((UmUserinfoReDomainBean)userinfoAllList.get(k)).getUserinfoType() == 1) {
                        ocBusinessDimensionDomain.setStaff(((UmUserinfoReDomainBean)userinfoAllList.get(k)).getUserinfoCompname());
                        break;
                    }
                    if (((UmUserinfoReDomainBean)userinfoAllList.get(k)).getUserinfoType() == 2) {
                        ocBusinessDimensionDomain.setDistributor(((UmUserinfoReDomainBean)userinfoAllList.get(k)).getUserinfoCompname());
                        break;
                    }
                    this.logger.error(CODE + ".queryBusinessDimensionCom", (Object)"\u672a\u77e5\u7c7b\u578b\uff01");
                    break;
                }
                ocBusinessDimensionDomain.setClinic(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCompname());
                break;
            }
            list.add(ocBusinessDimensionDomain);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    private UmUserinfoReDomainBean getParentUmUserinfoReDomainBean(UmUserinfoReDomainBean umUserinfoReDomainBean, List<UmUserinfoReDomainBean> userinfoAllList) {
        String METHOD_NAME = "getParentUmUserinfoReDomainBean";
        UmUserinfoReDomainBean ub = null;
        block0: for (int j = 0; j < userinfoAllList.size(); ++j) {
            if (!umUserinfoReDomainBean.getUserinfoParentCode().equals(userinfoAllList.get(j).getUserinfoCode())) continue;
            for (int k = 0; k < userinfoAllList.size(); ++k) {
                if (!userinfoAllList.get(j).getUserinfoParentCode().equals(userinfoAllList.get(k).getUserinfoCode())) continue;
                ub = userinfoAllList.get(k);
                break block0;
            }
            break;
        }
        return ub;
    }

    private OcContractReDomain getFirstSaleOrder(List<OcContractReDomain> ocContractReDomains) {
        if (ocContractReDomains.isEmpty()) {
            return null;
        }
        Collections.sort(ocContractReDomains, new Comparator<OcContractReDomain>(){

            @Override
            public int compare(OcContractReDomain o1, OcContractReDomain o2) {
                return o1.getGmtCreate().compareTo(o2.getGmtCreate());
            }
        });
        return ocContractReDomains.get(0);
    }

    protected SupQueryResult<OcClorstDataStatisticsDomain> queryOcClorstDataStatistics(HttpServletRequest request, Map<String, Object> map) {
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)"================================\u5206\u9500\u5546\u5458\u5de5\u6570\u636e\u7edf\u8ba1================================");
        if (map.get("userinfoCode") == null) {
            this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u5165\u53c2\u4e3a\u7a7a\uff01userinfoCode->" + map.get("userinfoCode")));
            return null;
        }
        HashMap<String, Object> queryClinicMap = new HashMap<String, Object>();
        queryClinicMap.put("userinfoParentCode", map.get("userinfoCode"));
        queryClinicMap.put("userinfoQuality", "service");
        queryClinicMap.put("fuzzy", true);
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanAllSupQueryResult = this.userService.queryUserinfoPage(queryClinicMap);
        List clinicAllList = new ArrayList();
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================umUserinfoReDomainBeanAllSupQueryResult===->" + umUserinfoReDomainBeanAllSupQueryResult));
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================umUserinfoReDomainBeanAllSupQueryResult.getList()===->" + umUserinfoReDomainBeanAllSupQueryResult.getList()));
        if (umUserinfoReDomainBeanAllSupQueryResult != null && umUserinfoReDomainBeanAllSupQueryResult.getList() != null) {
            clinicAllList = umUserinfoReDomainBeanAllSupQueryResult.getList();
        }
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8bca\u6240===clinicAllList.size()->" + clinicAllList.size()));
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8bca\u6240===clinicAllList->" + JsonUtil.buildNonEmptyBinder().toJson(clinicAllList)));
        Integer orderClinicTotal = 0;
        Integer dentistsTotal = 0;
        Integer orderDentistsTotal = 0;
        for (int i = 0; i < clinicAllList.size(); ++i) {
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            queryContractPageMap.put("departCode", ((UmUserinfoReDomainBean)clinicAllList.get(i)).getUserinfoCode());
            SupQueryResult<OcContractReDomain> everyDayDataQueryResult = this.ocContractService.queryContractPage(queryContractPageMap);
            List contractReList = everyDayDataQueryResult.getList();
            if (!contractReList.isEmpty()) {
                orderClinicTotal = orderClinicTotal + 1;
            }
            HashMap<String, Object> queryDentistsMap = new HashMap<String, Object>();
            queryDentistsMap.put("userinfoParentCode", ((UmUserinfoReDomainBean)clinicAllList.get(i)).getUserinfoCode());
            queryDentistsMap.put("userinfoQuality", "group");
            queryDentistsMap.put("fuzzy", true);
            SupQueryResult<UmUserinfoReDomainBean> dentistsSupQueryResult = this.userService.queryUserinfoPage(queryDentistsMap);
            this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================dentistsSupQueryResult->" + dentistsSupQueryResult));
            List dentistsAllList = new ArrayList();
            if (dentistsSupQueryResult != null && dentistsSupQueryResult.getList() != null) {
                dentistsAllList = dentistsSupQueryResult.getList();
            }
            this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================dentistsAllList->" + dentistsAllList));
            this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u7259\u533b===dentistsAllList.size()->" + dentistsAllList.size()));
            this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u7259\u533b===dentistsAllList->" + JsonUtil.buildNonEmptyBinder().toJson(dentistsAllList)));
            dentistsTotal = dentistsTotal + dentistsAllList.size();
            for (int j = 0; j < dentistsAllList.size(); ++j) {
                HashMap<String, Object> queryContractDentistsMap = new HashMap<String, Object>();
                queryContractDentistsMap.put("employeeCode", ((UmUserinfoReDomainBean)dentistsAllList.get(j)).getUserinfoCode());
                SupQueryResult<OcContractReDomain> dentistsQueryResult = this.ocContractService.queryContractPage(queryContractDentistsMap);
                List dsList = dentistsQueryResult.getList();
                if (dsList.isEmpty()) continue;
                orderDentistsTotal = orderDentistsTotal + 1;
            }
        }
        HashMap<String, Object> queryContractTotalMap = new HashMap<String, Object>();
        queryContractTotalMap.put("companyCode", map.get("userinfoCode"));
        SupQueryResult<OcContractReDomain> totalQueryResult = this.ocContractService.queryContractPage(queryContractTotalMap);
        List contractTotalList = totalQueryResult.getList();
        BigDecimal orderPriceTotal = new BigDecimal(0);
        BigDecimal receivedAmountTotal = new BigDecimal(0);
        for (int i = 0; i < contractTotalList.size(); ++i) {
            orderPriceTotal = orderPriceTotal.add(((OcContractReDomain)contractTotalList.get(i)).getContractInmoney());
            if (((OcContractReDomain)contractTotalList.get(i)).getDataState() != 4) continue;
            receivedAmountTotal = receivedAmountTotal.add(((OcContractReDomain)contractTotalList.get(i)).getDataBmoney());
        }
        OcClorstDataStatisticsDomain ocClorstDataStatisticsDomain = new OcClorstDataStatisticsDomain();
        ocClorstDataStatisticsDomain.setClinicTotal(clinicAllList.size());
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8bca\u6240\u603b\u6570->" + clinicAllList.size()));
        ocClorstDataStatisticsDomain.setOrderClinicTotal(orderClinicTotal);
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u4e0b\u5355\u8bca\u6240\u6570->" + orderClinicTotal));
        ocClorstDataStatisticsDomain.setDentistsTotal(dentistsTotal);
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u603b\u7259\u533b\u6570->" + dentistsTotal));
        ocClorstDataStatisticsDomain.setOrderDentistsTotal(orderDentistsTotal);
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u4e0b\u5355\u7259\u533b\u6570->" + orderDentistsTotal));
        ocClorstDataStatisticsDomain.setOrderTotal(contractTotalList.size());
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8ba2\u5355\u603b\u6570->" + contractTotalList.size()));
        ocClorstDataStatisticsDomain.setOrderPriceTotal(orderPriceTotal);
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8ba2\u5355\u603b\u6570->" + orderPriceTotal));
        ocClorstDataStatisticsDomain.setReceivedAmountTotal(receivedAmountTotal);
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u5b9e\u6536\u603b\u91d1\u989d->" + receivedAmountTotal));
        ArrayList<OcClorstDataStatisticsDomain> list = new ArrayList<OcClorstDataStatisticsDomain>();
        list.add(ocClorstDataStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, umUserinfoReDomainBeanAllSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcClorstDataStatisticsDomain> queryOcClinicStatisticsData(HttpServletRequest request, Map<String, Object> map) {
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanAllSupQueryResult;
        Map<String, Object> countMoneyNew = this.ocContractService.getCountMoneyNew(map);
        OcClorstDataStatisticsDomain ocClorstDataStatisticsDomain = new OcClorstDataStatisticsDomain();
        HashMap<String, Object> queryClinicMap = new HashMap<String, Object>();
        queryClinicMap.put("tenantCode", this.getTenantCode(request));
        if (map.get("companyCode") != null) {
            queryClinicMap.put("userinfoParentCode", map.get("companyCode"));
        }
        if (map.get("departCode") != null) {
            queryClinicMap.put("userinfoParentCode", map.get("departCode"));
        }
        if (queryClinicMap.get("userinfoParentCode") != null && (umUserinfoReDomainBeanAllSupQueryResult = this.userService.queryUserinfoPage(queryClinicMap)) != null) {
            ocClorstDataStatisticsDomain.setDentistsTotal(Integer.valueOf(umUserinfoReDomainBeanAllSupQueryResult.getTotal() + ""));
            this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u603b\u7259\u533b\u6570->" + Integer.valueOf(umUserinfoReDomainBeanAllSupQueryResult.getTotal() + "")));
        }
        ocClorstDataStatisticsDomain.setOrderTotal((Integer)countMoneyNew.get("ocCountTools"));
        ocClorstDataStatisticsDomain.setOrderPriceTotal(null == countMoneyNew.get("sumDataBmoney") ? BigDecimal.ZERO : new BigDecimal(countMoneyNew.get("sumDataBmoney").toString()));
        ocClorstDataStatisticsDomain.setReceivedAmountTotal(null == countMoneyNew.get("sumMoney") ? BigDecimal.ZERO : new BigDecimal(countMoneyNew.get("sumMoney").toString()));
        ArrayList<OcClorstDataStatisticsDomain> list = new ArrayList<OcClorstDataStatisticsDomain>();
        list.add(ocClorstDataStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcClorstDataStatisticsDomain> queryOcDentistStatisticsData(HttpServletRequest request, Map<String, Object> map) {
        this.logger.debug(CODE + ".queryOcDentistStatisticsData", (Object)"================================\u7259\u533b\u6570\u636e\u7edf\u8ba1================================");
        if (map.get("userinfoCode") == null) {
            this.logger.error(CODE + ".queryOcDentistStatisticsData", (Object)("================================\u5165\u53c2\u4e3a\u7a7a\uff01userinfoCode->" + map.get("userinfoCode")));
            return null;
        }
        HashMap<String, Object> queryContractTotalMap = new HashMap<String, Object>();
        queryContractTotalMap.put("employeeCode", map.get("userinfoCode"));
        SupQueryResult<OcContractReDomain> totalQueryResult = this.ocContractService.queryContractPage(queryContractTotalMap);
        List contractTotalList = totalQueryResult.getList();
        BigDecimal orderPriceTotal = new BigDecimal(0);
        BigDecimal receivedAmountTotal = new BigDecimal(0);
        for (int i = 0; i < contractTotalList.size(); ++i) {
            if (((OcContractReDomain)contractTotalList.get(i)).getContractInmoney() == null) continue;
            orderPriceTotal = orderPriceTotal.add(((OcContractReDomain)contractTotalList.get(i)).getContractInmoney());
            if (((OcContractReDomain)contractTotalList.get(i)).getDataState() != 4 || ((OcContractReDomain)contractTotalList.get(i)).getDataBmoney() == null) continue;
            receivedAmountTotal = receivedAmountTotal.add(((OcContractReDomain)contractTotalList.get(i)).getDataBmoney());
        }
        OcClorstDataStatisticsDomain ocClorstDataStatisticsDomain = new OcClorstDataStatisticsDomain();
        ocClorstDataStatisticsDomain.setOrderTotal(contractTotalList.size());
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8ba2\u5355\u603b\u6570->" + contractTotalList.size()));
        ocClorstDataStatisticsDomain.setOrderPriceTotal(orderPriceTotal);
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8ba2\u5355\u603b\u6570->" + orderPriceTotal));
        ocClorstDataStatisticsDomain.setReceivedAmountTotal(receivedAmountTotal);
        this.logger.debug(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u5b9e\u6536\u603b\u91d1\u989d->" + receivedAmountTotal));
        ArrayList<OcClorstDataStatisticsDomain> list = new ArrayList<OcClorstDataStatisticsDomain>();
        list.add(ocClorstDataStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, totalQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcContractReDomain> queryContractPageRate(HttpServletRequest request, String fileName, Map<String, Object> param) {
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u8ba2\u5355\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((String)excelTemplate) && "ag".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderNewHeadExcelParam());
            } else if ("ms".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderMsHeadExcelParam());
            } else if ("retailer".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxHeadExcelParam());
            } else if ("retailerDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxDetaiHeadExcelParam());
            } else if ("pg".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgHeadExcelParam());
            } else if ("pgDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgDetailHeadExcelParam());
            } else {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderHeadExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            this.logger.error(CODE + ".queryContractPageCom.1111", (Object)(param + "=:=" + infoMap));
            try {
                this.exportComExcel(request, param, infoMap, "oc.contract.queryContractPageReDomain", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryContractPageCom.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.ocContractService.queryContractPageReDomain(param);
    }

    protected SupQueryResult<OcClinicReportDomain> queryOcClinicReport(HttpServletRequest request, Map<String, Object> map) {
        SupQueryResult supQueryResult = new SupQueryResult();
        map.put("userinfoQuality", "service");
        HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
        queryUserinfoPageMap.put("page", "1");
        queryUserinfoPageMap.put("rows", "1");
        queryUserinfoPageMap.put("userinfoQuality", "group");
        queryUserinfoPageMap.put("fuzzy", true);
        queryUserinfoPageMap.put("tenantCode", this.getTenantCode(request));
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult = this.userService.queryUserinfoPage(map);
        if (null == umUserinfoReDomainBeanSupQueryResult || ListUtil.isEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList())) {
            return supQueryResult;
        }
        ArrayList<OcClinicReportDomain> list = new ArrayList<OcClinicReportDomain>();
        for (UmUserinfoReDomainBean umUserinfoReDomainBean : umUserinfoReDomainBeanSupQueryResult.getList()) {
            OcClinicReportDomain ocClinicReportDomain = new OcClinicReportDomain();
            ocClinicReportDomain.setClinic(umUserinfoReDomainBean.getUserinfoCompname());
            queryUserinfoPageMap.put("userinfoParentCode", umUserinfoReDomainBean.getUserinfoCode());
            SupQueryResult<UmUserinfoReDomainBean> umusr = this.userService.queryUserinfoPage(queryUserinfoPageMap);
            ocClinicReportDomain.setDentistsTotal(umusr.getTotal());
            ocClinicReportDomain.setCity(umUserinfoReDomainBean.getCityName());
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            queryContractPageMap.put("departCode", umUserinfoReDomainBean.getUserinfoCode());
            queryContractPageMap.put("tenantCode", map.get("tenantCode"));
            Map<String, Object> countMoneyNew = this.ocContractService.getCountMoneyNew(queryContractPageMap);
            this.logger.debug(CODE + ".queryOcClinicReport.countMoneyNew", countMoneyNew);
            ocClinicReportDomain.setOrderTotal((Integer)countMoneyNew.get("ocCountTools"));
            ocClinicReportDomain.setOrderPriceTotal(null == countMoneyNew.get("sumDataBmoney") ? BigDecimal.ZERO : new BigDecimal(countMoneyNew.get("sumDataBmoney").toString()));
            ocClinicReportDomain.setRefundPriceTotal(null == countMoneyNew.get("sumDataBmoney") ? BigDecimal.ZERO : new BigDecimal(countMoneyNew.get("sumRefundMoney").toString()));
            ocClinicReportDomain.setEffectivePriceTotal(null == countMoneyNew.get("sumMoney") ? BigDecimal.ZERO : new BigDecimal(countMoneyNew.get("sumMoney").toString()));
            ocClinicReportDomain.setReturningServantPriceTotal(this.getPteBalanceamtPriceTotal(umUserinfoReDomainBean.getUserinfoCode(), map.get("tenantCode").toString()));
            list.add(ocClinicReportDomain);
        }
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcDistributorEmployeeReportDomain> queryOcDistributorEmployeeReport(HttpServletRequest request, Map<String, Object> map) {
        this.logger.debug(CODE + ".queryOcDistributorEmployeeReport", (Object)"================================\u5206\u9500\u5546/\u5458\u5de5\u62a5\u8868================================");
        this.logger.debug(CODE + ".queryOcDistributorEmployeeReport", (Object)("================================map->" + JsonUtil.buildNonEmptyBinder().toJson(map) + "================================"));
        HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
        queryUserinfoPageMap.put("userinfoQuality", "retailer");
        queryUserinfoPageMap.put("tenantCode", map.get("tenantCode"));
        queryUserinfoPageMap.put("userinfoCode", map.get("companyCode"));
        queryUserinfoPageMap.put("rows", map.get("rows"));
        queryUserinfoPageMap.put("page", map.get("page"));
        queryUserinfoPageMap.put("startRow", map.get("startRow"));
        queryUserinfoPageMap.put("endRow", map.get("endRow"));
        if (map.get("cityCode") == null) {
            queryUserinfoPageMap.put("provinceCode", map.get("provinceCode"));
        } else {
            queryUserinfoPageMap.put("cityCode", map.get("cityCode"));
        }
        queryUserinfoPageMap.put("fuzzy", true);
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult = this.userService.queryUserinfoPage(queryUserinfoPageMap);
        List umUserinfoReDomainBeanList = new ArrayList();
        if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
            umUserinfoReDomainBeanList = umUserinfoReDomainBeanSupQueryResult.getList();
        }
        ArrayList<OcDistributorEmployeeReportDomain> list = new ArrayList<OcDistributorEmployeeReportDomain>();
        for (int i = 0; i < umUserinfoReDomainBeanList.size(); ++i) {
            OcDistributorEmployeeReportDomain ocDistributorEmployeeReportDomain = new OcDistributorEmployeeReportDomain();
            ocDistributorEmployeeReportDomain.setDistributorName(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCompname());
            HashMap<String, Object> clinicMap = new HashMap<String, Object>();
            clinicMap.put("userinfoQuality", "service");
            clinicMap.put("tenantCode", map.get("tenantCode"));
            clinicMap.put("userinfoParentCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            clinicMap.put("fuzzy", true);
            SupQueryResult<UmUserinfoReDomainBean> umClinicSupQueryResult = this.userService.queryUserinfoPage(clinicMap);
            List umClinicBeanList = new ArrayList();
            if (umClinicSupQueryResult != null && umClinicSupQueryResult.getList() != null) {
                umClinicBeanList = umClinicSupQueryResult.getList();
            }
            ocDistributorEmployeeReportDomain.setClinicTotal(umClinicBeanList.size());
            if (umClinicBeanList.isEmpty()) {
                ocDistributorEmployeeReportDomain.setDentistTotal(0);
            }
            for (int j = 0; j < umClinicBeanList.size(); ++j) {
                HashMap<String, Object> dentistMap = new HashMap<String, Object>();
                dentistMap.put("userinfoQuality", "group");
                dentistMap.put("tenantCode", map.get("tenantCode"));
                dentistMap.put("userinfoParentCode", ((UmUserinfoReDomainBean)umClinicBeanList.get(j)).getUserinfoCode());
                dentistMap.put("fuzzy", true);
                SupQueryResult<UmUserinfoReDomainBean> umDentistSupQueryResult = this.userService.queryUserinfoPage(dentistMap);
                List umDentistBeanList = new ArrayList();
                if (umDentistSupQueryResult != null && umDentistSupQueryResult.getList() != null) {
                    umDentistBeanList = umDentistSupQueryResult.getList();
                }
                ocDistributorEmployeeReportDomain.setDentistTotal(umDentistBeanList.size());
            }
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            queryContractPageMap.put("companyCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            queryContractPageMap.put("tenantCode", map.get("tenantCode"));
            SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(queryContractPageMap);
            List ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
            ocDistributorEmployeeReportDomain.setOrderTotal(ocContractReDomainList.size());
            ocDistributorEmployeeReportDomain.setOrderPriceTotal(this.getPriceTotal(ocContractReDomainList));
            ocDistributorEmployeeReportDomain.setRefundPriceTotal(this.getRefundPriceTotal(ocContractReDomainList, map.get("tenantCode").toString()));
            ocDistributorEmployeeReportDomain.setEffectivePriceTotal(ocDistributorEmployeeReportDomain.getOrderPriceTotal().subtract(ocDistributorEmployeeReportDomain.getRefundPriceTotal()));
            ocDistributorEmployeeReportDomain.setReturningServantPriceTotal(this.getPteBalanceamtPriceTotal(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode(), map.get("tenantCode").toString()));
            list.add(ocDistributorEmployeeReportDomain);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcDentalReportDomain> queryOcDentalReport(HttpServletRequest request, Map<String, Object> map) {
        this.logger.debug(CODE + ".queryOcDentalReport", (Object)"================================\u7259\u533b\u62a5\u8868================================");
        this.logger.debug(CODE + ".queryOcDentalReport", (Object)("================================map->" + JsonUtil.buildNonEmptyBinder().toJson(map) + "================================"));
        HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
        queryUserinfoPageMap.put("userinfoQuality", "group");
        queryUserinfoPageMap.put("tenantCode", map.get("tenantCode"));
        queryUserinfoPageMap.put("userinfoSort", map.get("userinfoSort"));
        queryUserinfoPageMap.put("rows", map.get("rows"));
        queryUserinfoPageMap.put("page", map.get("page"));
        queryUserinfoPageMap.put("startRow", map.get("startRow"));
        queryUserinfoPageMap.put("endRow", map.get("endRow"));
        if (map.get("cityCode") == null) {
            queryUserinfoPageMap.put("provinceCode", map.get("provinceCode"));
        } else {
            queryUserinfoPageMap.put("cityCode", map.get("cityCode"));
        }
        queryUserinfoPageMap.put("fuzzy", true);
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult = this.userService.queryUserinfoPage(queryUserinfoPageMap);
        List umUserinfoReDomainBeanList = new ArrayList();
        if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
            umUserinfoReDomainBeanList = umUserinfoReDomainBeanSupQueryResult.getList();
        }
        HashMap<String, Object> queryUserinfoPageAllMap = new HashMap<String, Object>();
        queryUserinfoPageAllMap.put("tenantCode", map.get("tenantCode"));
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanAllSupQueryResult = this.userService.queryUserinfoPage(queryUserinfoPageAllMap);
        List userinfoAllList = umUserinfoReDomainBeanAllSupQueryResult.getList();
        if (map.get("departCode") != null) {
            Iterator iterator = umUserinfoReDomainBeanList.iterator();
            while (iterator.hasNext()) {
                UmUserinfoReDomainBean next = (UmUserinfoReDomainBean)iterator.next();
                Boolean flag = true;
                for (int i = 0; i < userinfoAllList.size(); ++i) {
                    if (!next.getUserinfoParentCode().equals(((UmUserinfoReDomainBean)userinfoAllList.get(i)).getUserinfoCode()) || !((UmUserinfoReDomainBean)userinfoAllList.get(i)).getUserinfoCode().equals(map.get("departCode"))) continue;
                    flag = false;
                    break;
                }
                if (!flag.booleanValue()) continue;
                iterator.remove();
            }
        }
        ArrayList<OcDentalReportDomain> list = new ArrayList<OcDentalReportDomain>();
        for (int i = 0; i < umUserinfoReDomainBeanList.size(); ++i) {
            OcDentalReportDomain ocDentalReportDomain = new OcDentalReportDomain();
            ocDentalReportDomain.setType(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getQualityQtypeName());
            ocDentalReportDomain.setName(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCompname());
            for (int j = 0; j < userinfoAllList.size(); ++j) {
                if (!((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCode().equals(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode())) continue;
                ocDentalReportDomain.setClinic(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCompname());
                break;
            }
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            queryContractPageMap.put("employeeCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            queryContractPageMap.put("tenantCode", map.get("tenantCode"));
            SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(queryContractPageMap);
            List ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
            ocDentalReportDomain.setOrderTotal(ocContractReDomainList.size());
            ocDentalReportDomain.setOrderPriceTotal(this.getPriceTotal(ocContractReDomainList));
            ocDentalReportDomain.setRefundPriceTotal(this.getRefundPriceTotal(ocContractReDomainList, map.get("tenantCode").toString()));
            ocDentalReportDomain.setEffectivePriceTotal(ocDentalReportDomain.getOrderPriceTotal().subtract(ocDentalReportDomain.getRefundPriceTotal()));
            ocDentalReportDomain.setReturningServantPriceTotal(this.getPteBalanceamtPriceTotal(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode(), map.get("tenantCode").toString()));
            list.add(ocDentalReportDomain);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    private BigDecimal getRefundPriceTotal(List<OcContractReDomain> ocContractReDomainList, String tenantCode) {
        BigDecimal refundPriceTotal = new BigDecimal(0);
        for (int j = 0; j < ocContractReDomainList.size(); ++j) {
            HashMap<String, Object> queryRefundPageMap = new HashMap<String, Object>();
            queryRefundPageMap.put("contractBillcode", ocContractReDomainList.get(j).getContractBillcode());
            queryRefundPageMap.put("tenantCode", tenantCode);
            SupQueryResult<OcRefundReDomain> ocRefundReDomainSupQueryResult = this.ocRefundService.queryRefundPage(queryRefundPageMap);
            List ocRefundList = ocRefundReDomainSupQueryResult.getList();
            for (OcRefundReDomain ocRefundReDomain : ocRefundList) {
                refundPriceTotal = refundPriceTotal.add(ocRefundReDomain.getContractMoney());
            }
        }
        return refundPriceTotal;
    }

    private BigDecimal getPteBalanceamtPriceTotal(String memberCode, String tenantCode) {
        HashMap<String, Object> pteBalanceamtMap = new HashMap<String, Object>();
        pteBalanceamtMap.put("memberCode", memberCode);
        pteBalanceamtMap.put("tenantCode", tenantCode);
        SupQueryResult<PteBalanceamtReDomain> pteBalanceamtReDomainSupQueryResult = this.pteBalanceamtService.queryBalanceamtPage(pteBalanceamtMap);
        List list = pteBalanceamtReDomainSupQueryResult.getList();
        BigDecimal pteBalanceamtPriceTotal = new BigDecimal(0);
        for (PteBalanceamtReDomain pteBalanceamtReDomain : list) {
            pteBalanceamtPriceTotal = pteBalanceamtPriceTotal.add(pteBalanceamtReDomain.getBalanceAllamount());
        }
        return pteBalanceamtPriceTotal;
    }

    private BigDecimal getPriceTotal(List<OcContractReDomain> ocContractReDomainList) {
        BigDecimal priceTotal = new BigDecimal(0);
        for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
            priceTotal = priceTotal.add(ocContractReDomain.getContractInmoney());
        }
        return priceTotal;
    }

    protected HtmlJsonReBean createOrderRule(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".createOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)((OrderDomain)orderDomainList.get(0)).getContractType())) {
            if (StringUtils.isBlank((String)contractType)) {
                contractType = ContractType.CON.getCode();
            }
            ((OrderDomain)orderDomainList.get(0)).setContractType(contractType);
        }
        if (StringUtils.isBlank((String)contractType)) {
            contractType = ((OrderDomain)orderDomainList.get(0)).getContractType();
        }
        TypeBean typeBean = this.ocShoppingService.getOcSetting(contractType, userSession.getTenantCode());
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean = this.getOrgUserRuleBean(memberBcode, userSession, this.getCompanyCode(request), userSession.getTenantCode());
        } else {
            try {
                orgUserBean = this.getOrgUserBean(userSession.getUserPcode(), userSession, null, userSession.getTenantCode(), orderDomainList, typeBean);
            }
            catch (Exception e) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
            }
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getEmployeeCode())) {
            orgUserBean.setEmployeeCode(((OrderDomain)orderDomainList.get(0)).getEmployeeCode());
            orgUserBean.setEmployeeName(((OrderDomain)orderDomainList.get(0)).getEmployeeName());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartCode())) {
            orgUserBean.setDepartCode(((OrderDomain)orderDomainList.get(0)).getDepartCode());
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartShortname())) {
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getCompanyCode())) {
            orgUserBean.setCompanyCode(((OrderDomain)orderDomainList.get(0)).getCompanyCode());
            orgUserBean.setCompanyShortname(((OrderDomain)orderDomainList.get(0)).getCompanyShortname());
        }
        this.makeChannel(orderDomainList, request);
        String appmanageIcode = ((OrderDomain)orderDomainList.get(0)).getAppmanageIcode();
        if (StringUtils.isBlank((String)appmanageIcode)) {
            appmanageIcode = this.getProappCode(request);
        }
        return this.ocShoppingService.createOcOrderRule(orderDomainList, contractType, userSession, appmanageIcode, this.getOauthEnvCode(request), orgUserBean, contractProperty, memberBcode);
    }

    public OrgUserBean getOrgUserRuleBean(String memberBcode, UserSession userSession, String companyCode, String tenantCode) {
        if (null == userSession || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = null;
        String userCode = userSession.getUserCode();
        if (StringUtils.isNotBlank((String)companyCode)) {
            orgUserBean = this.orgCompanyService.getEmpByUserCode(userCode, companyCode, tenantCode);
        }
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            UmUserinfoReDomainBean umUserinfoReDomainBean;
            SupQueryResult<UmUserinfoReDomainBean> umUser;
            SupQueryResult<CtCustrelReDomain> qcust = this.ctCustrelService.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", memberBcode, tenantCode));
            this.logger.debug(qcust.toString() + "12345");
            if (null != qcust && ListUtil.isNotEmpty((Collection)qcust.getList())) {
                CtCustrelReDomain ctustrelReDomain = (CtCustrelReDomain)qcust.getList().get(0);
                orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
                orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
                orgUserBean.setCompanyCode(ctustrelReDomain.getCompanyCode());
                orgUserBean.setEmployeeCode(ctustrelReDomain.getEmployeeCode());
                orgUserBean.setEmployeeName(ctustrelReDomain.getEmployeeName());
                orgUserBean.setDepartCode(ctustrelReDomain.getDepartCode());
                orgUserBean.setDepartShortname(ctustrelReDomain.getDepartName());
                orgUserBean.setCompanyShortname(ctustrelReDomain.getCompanyShortname());
            }
            if (null != (umUser = this.userService.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", memberBcode, tenantCode))) && ListUtil.isNotEmpty((Collection)umUser.getList()) && "1".equals((umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUser.getList().get(0)).getQualityQtypeCode())) {
                HashMap<String, Object> ddmap = new HashMap<String, Object>();
                ddmap.put("flagSettingCode", "exchangerate");
                SupQueryResult<DdFalgSettingReDomain> ddFalgSettingReDomainSupQueryResult = this.ddFalgSettingService.queryFalgSettingPage(ddmap);
                DdFalgSettingReDomain ddFalgSettingReDomain = (DdFalgSettingReDomain)ddFalgSettingReDomainSupQueryResult.getList().get(0);
                this.logger.debug(ddFalgSettingReDomain.toString() + "111222");
                this.logger.debug(orgUserBean.toString() + "1111111");
                orgUserBean.setPricesetCurrency(ddFalgSettingReDomain.getFlagSettingPro());
            }
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode()) && !userSession.getCompanyCode().equals(orgUserBean.getCompanyCode())) {
            orgUserBean.setCompanyCode(userSession.getCompanyCode());
            orgUserBean.setCompanyShortname(userSession.getCompanyShortname());
        }
        return orgUserBean;
    }

    protected SupQueryResult<OcCommissionStatisticsDomain> queryOcCommissionStatisticsDomain(HttpServletRequest request, Map<String, Object> map) {
        this.logger.debug(CODE + ".queryOcCommissionStatisticsDomain", (Object)"================================\u8fd4\u4f63\u6570\u636e\u7edf\u8ba1================================");
        this.logger.debug(CODE + ".queryOcCommissionStatisticsDomain", (Object)("================================map->" + JsonUtil.buildNonEmptyBinder().toJson(map) + "================================"));
        if (map.get("userinfoCode") == null || map.get("tenantCode") == null || "".equals(map.get("userinfoCode").toString().trim())) {
            this.logger.debug(CODE + ".queryOcCommissionStatisticsDomain", (Object)"\u8bf7\u6c42\u53c2\u6570\u4e3anull\u6216\u8005\u4e3a\u7a7a");
            return null;
        }
        OcCommissionStatisticsDomain ocCommissionStatisticsDomain = new OcCommissionStatisticsDomain();
        ocCommissionStatisticsDomain.setReturningServantTotal(this.getPteBalanceamtPriceTotal(map.get("userinfoCode").toString(), map.get("tenantCode").toString()));
        this.logger.debug(CODE + ".queryOcCommissionStatisticsDomain", (Object)("================================\u8fd4\u4f63\u603b\u91d1\u989d->" + ocCommissionStatisticsDomain.getReturningServantTotal() + "================================"));
        ocCommissionStatisticsDomain.setRebateBalance(this.getVdFaccountOuterForAmount(map.get("userinfoCode").toString(), map.get("tenantCode").toString()));
        this.logger.debug(CODE + ".queryOcCommissionStatisticsDomain", (Object)("================================\u8fd4\u4f63\u4f59\u989d->" + ocCommissionStatisticsDomain.getRebateBalance() + "================================"));
        ocCommissionStatisticsDomain.setWithdrawalTotal(ocCommissionStatisticsDomain.getReturningServantTotal().subtract(ocCommissionStatisticsDomain.getRebateBalance()));
        this.logger.debug(CODE + ".queryOcCommissionStatisticsDomain", (Object)("================================\u8fd4\u4f63\u63d0\u73b0\u91d1\u989d->" + ocCommissionStatisticsDomain.getWithdrawalTotal() + "================================"));
        ArrayList<OcCommissionStatisticsDomain> list = new ArrayList<OcCommissionStatisticsDomain>();
        list.add(ocCommissionStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    private BigDecimal getVdFaccountOuterForAmount(String merchantCode, String tenantCode) {
        List<VdFaccountInfo> vdFaccountInfos1;
        String type = merchantCode.substring(0, 1);
        String faccountType = "101";
        if ("2".equals(type)) {
            faccountType = "201";
        }
        if (ListUtil.isEmpty(vdFaccountInfos1 = this.vdFaccountOuterService.queryOuterFaccount(merchantCode, faccountType, tenantCode))) {
            this.logger.error(CODE + ".vdFaccountInfos1.null", (Object)(merchantCode + "====" + faccountType + "====" + tenantCode));
            return new BigDecimal(0);
        }
        return vdFaccountInfos1.get(0).getFaccountAmount();
    }

    protected HtmlJsonReBean createOrderpc(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".createOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)((OrderDomain)orderDomainList.get(0)).getContractType())) {
            if (StringUtils.isBlank((String)contractType)) {
                contractType = ContractType.CON.getCode();
            }
            ((OrderDomain)orderDomainList.get(0)).setContractType(contractType);
        }
        if (StringUtils.isBlank((String)contractType)) {
            contractType = ((OrderDomain)orderDomainList.get(0)).getContractType();
        }
        TypeBean typeBean = this.ocShoppingService.getOcSetting(contractType, userSession.getTenantCode());
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            try {
                orgUserBean = this.getOrgUserBean(memberBcode, userSession, this.getCompanyCode(request), userSession.getTenantCode(), orderDomainList, typeBean);
            }
            catch (Exception e) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
            }
        } else {
            orgUserBean = this.getOrgUserBeanpc(userSession.getUserPcode(), userSession, null, userSession.getTenantCode());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getEmployeeCode())) {
            orgUserBean.setEmployeeCode(((OrderDomain)orderDomainList.get(0)).getEmployeeCode());
            orgUserBean.setEmployeeName(((OrderDomain)orderDomainList.get(0)).getEmployeeName());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartCode())) {
            orgUserBean.setDepartCode(((OrderDomain)orderDomainList.get(0)).getDepartCode());
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartShortname())) {
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getCompanyCode())) {
            orgUserBean.setCompanyCode(((OrderDomain)orderDomainList.get(0)).getCompanyCode());
            orgUserBean.setCompanyShortname(((OrderDomain)orderDomainList.get(0)).getCompanyShortname());
        }
        this.makeChannel(orderDomainList, request);
        return this.ocShoppingService.createOcOrderRule(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, contractProperty, memberBcode);
    }

    public OrgUserBean getOrgUserBeanpc(String memberBcode, UserSession userSession, String companyCode, String tenantCode) {
        SupQueryResult<CtCustrelReDomain> qcust;
        if (null == userSession || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = null;
        String userCode = userSession.getUserCode();
        if (StringUtils.isNotBlank((String)companyCode)) {
            orgUserBean = this.orgCompanyService.getEmpByUserCode(userCode, companyCode, tenantCode);
        }
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode) && null != (qcust = this.ctCustrelService.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", memberBcode, tenantCode))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
            UmUserinfoReDomainBean umUserinfoReDomainBean;
            CtCustrelReDomain ctustrelReDomain = (CtCustrelReDomain)qcust.getList().get(0);
            orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
            orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            orgUserBean.setCompanyCode(ctustrelReDomain.getCompanyCode());
            orgUserBean.setEmployeeCode(ctustrelReDomain.getEmployeeCode());
            orgUserBean.setEmployeeName(ctustrelReDomain.getEmployeeName());
            orgUserBean.setDepartCode(ctustrelReDomain.getDepartCode());
            orgUserBean.setDepartShortname(ctustrelReDomain.getDepartName());
            orgUserBean.setCompanyShortname(ctustrelReDomain.getCompanyShortname());
            SupQueryResult<UmUserinfoReDomainBean> umUser = this.userService.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", memberBcode, tenantCode));
            if (null != umUser && ListUtil.isNotEmpty((Collection)umUser.getList()) && "1".equals((umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUser.getList().get(0)).getQualityQtypeCode())) {
                HashMap<String, Object> ddmap = new HashMap<String, Object>();
                ddmap.put("flagSettingCode", "exchangerate");
                SupQueryResult<DdFalgSettingReDomain> ddFalgSettingReDomainSupQueryResult = this.ddFalgSettingService.queryFalgSettingPage(ddmap);
                DdFalgSettingReDomain ddFalgSettingReDomain = (DdFalgSettingReDomain)ddFalgSettingReDomainSupQueryResult.getList().get(0);
                this.logger.debug(ddFalgSettingReDomain.toString() + "111222");
                this.logger.debug(orgUserBean.toString() + "1111111");
                orgUserBean.setPricesetCurrency(ddFalgSettingReDomain.getFlagSettingPro());
            }
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode()) && !userSession.getCompanyCode().equals(orgUserBean.getCompanyCode())) {
            orgUserBean.setCompanyCode(userSession.getCompanyCode());
            orgUserBean.setCompanyShortname(userSession.getCompanyShortname());
        }
        return orgUserBean;
    }

    public static String getFirstDayByMonth(String date) {
        if (date.contains("-")) {
            date = date.replaceAll("-", "");
        } else if (date.length() < 6 || date.length() > 10) {
            System.out.println("\u65e5\u671f\u9519\u8bef\uff01");
        }
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(4, 6));
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, cal.getActualMinimum(5));
        return new SimpleDateFormat("yyyy-MM-dd ").format(cal.getTime());
    }

    protected SupQueryResult<DaOpsumOrderlistReDomain> queryDaopsumOrderListPageCon(HttpServletRequest request, Map<String, Object> map) {
        this.logger.debug(CODE + ".queryDaopsumOrderListPageCon", (Object)"================================da_opsum_orderlist================================");
        map.put("tenantCode", this.getUserSession(request).getTenantCode());
        if (map.get("opsumCode") == null || "".equals(map.get("opsumCode"))) {
            this.logger.debug(CODE + ".queryDaopsumOrderListPageCon", (Object)"================================\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff01================================");
            return null;
        }
        return this.daOpsumOrderlistService.queryOpsumOrderListPage(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel(HttpServletRequest request, Map<String, Object> paramMap, Map<String, Object> infoMap, List<Map<String, Object>> fromDataList) {
        this.logger.error("paramMap-_=+is", paramMap);
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(infoMap)) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
            return;
        }
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        if (null == infoMap.get("userCode")) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"userCode is null");
            return;
        }
        String userCode = (String)infoMap.get("userCode");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        long timeMillis = System.currentTimeMillis();
        String formatData = sdf.format(timeMillis);
        String fileName = null == infoMap.get("fileName") ? "" : (String)infoMap.get("fileName");
        fileName = formatData + "-" + fileName;
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = infoMap.get("headMap");
        if (null == headMap) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMap", (Object)(" =:= " + infoMap));
            return;
        }
        List headMapList = JsonUtil.buildNormalBinder().getJsonToListByMap(JsonUtil.buildNormalBinder().toJson(headMap), Object.class);
        if (ListUtil.isEmpty((Collection)headMapList)) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMapList", (Object)(" is null " + JsonUtil.buildNormalBinder().toJson(headMap)));
            return;
        }
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            HSSFCellStyle hSSFCellStyle = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setFontHeightInPoints((short)10);
            font.setBold(true);
            hSSFCellStyle.setFont(font);
            cell.setCellStyle(hSSFCellStyle);
        }
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        ArrayList<String> data = null;
        for (Map map : fromDataList) {
            data = new ArrayList<String>();
            for (Map map1 : headMapList) {
                String beanName = map1.get("dataName").toString();
                String value = "";
                if (StringUtils.isNotBlank((String)beanName)) {
                    String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    if ("null".equals(value)) {
                        value = "";
                    }
                }
                data.add(value);
            }
            String[] array = data.toArray(new String[data.size()]);
            dataList.add(array);
        }
        try {
            ExportExcelUtlis.exportExcel((HSSFSheet)sheet, (HSSFRow)row, (String[])headers, dataList, (String)"yyyy-MM-dd HH:mm:ss", (int)0);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.exportExcel", (Object)"Exception");
            return;
        }
        String fileType = "xls";
        String string = request.getSession().getServletContext().getRealPath("/") + "../../temp/" + fileName + "." + fileType;
        if (StringUtils.isBlank((String)string)) {
            this.logger.error("SpringmvnNewController.exportComExcel.tempPath", (Object)string);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(string);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            this.logger.error("SpringmvnNewController.exportComExcel.close", (Throwable)e);
            return;
        }
        finally {
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException beanName) {}
            }
        }
        byte[] bytes = null;
        try {
            bytes = ExportExcelUtlis.InputStreamByteArray((String)string);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.InputStreamByteArray", (Object)"Exception");
            return;
        }
        this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
    }

    public void saveExcel(byte[] bytes, String fileName, String userCode, String fileType, String tenantCode) {
        if (bytes == null || bytes.length <= 0 || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveExcel", (Object)(bytes.length + "-" + fileName + "-" + userCode + "--" + fileType + "-" + tenantCode));
            return;
        }
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileOwner(userCode);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileContext(bytes);
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])bytes));
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(fileName);
        fileBean.setSize(Long.valueOf(1L));
        this.saveFile(fileBean, tenantCode, "FILE_11", fmFileReDomainBean);
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"param is null");
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"Exception", (Throwable)e);
            return null;
        }
        return fmFileReDomainBean;
    }

    public HtmlJsonReBean updateContractGoodsCom(HttpServletRequest request, OcContractGoodsReDomain contractGoods) {
        if (null == contractGoods) {
            this.logger.error(CODE + ".updateContractGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        contractGoods.setTenantCode(this.getTenantCode(request));
        return this.ocContractService.updateContractGoods(contractGoods);
    }

    public HtmlJsonReBean updateContractStateByCode(HttpServletRequest request, OcContractReDomain contract) {
        if (null == contract) {
            this.logger.error(CODE + ".updateContractGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contract.getContractBillcode());
        map.put("dataState", 2);
        map.put("oldDataState", contract.getDataState());
        return this.ocContractService.updateContractStateByCode(map);
    }

    public OcContractGoodsDomain checkContractGoodsPm(OcContractGoodsDomain ContractGoodsDomain, UserSession userSession) {
        ContractGoodsDomain.setGoodsAhnum(this.getSkuOneNum(ContractGoodsDomain, userSession));
        ContractGoodsDomain.setGoodsTopweight(this.getSalequota(ContractGoodsDomain, userSession));
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("tenantCode", ContractGoodsDomain.getTenantCode());
        map1.put("promotionCode", ContractGoodsDomain.getGinfoCode());
        SupQueryResult<PmPromotionRangelistReDomain> pmPromotionRangelistReDomainSupQueryResult = this.pmPromotionRangelistService.queryPromotionRangelistPage(map1);
        if (ListUtil.isNotEmpty((Collection)pmPromotionRangelistReDomainSupQueryResult.getList())) {
            for (PmPromotionRangelistReDomain pmPromotionRangelistDomain : pmPromotionRangelistReDomainSupQueryResult.getList()) {
                if (!pmPromotionRangelistDomain.getRangeCode().equals(ContractGoodsDomain.getSkuNo())) continue;
                if (null != pmPromotionRangelistDomain.getDiscountAmount()) {
                    ContractGoodsDomain.setGoodsSupplynum(new BigDecimal(pmPromotionRangelistDomain.getDiscountAmount()));
                }
                if (null == pmPromotionRangelistDomain.getCouponOnceAnums()) {
                    pmPromotionRangelistDomain.setCouponOnceAnums(0);
                }
                if (null != pmPromotionRangelistDomain.getCouponOnceAnums()) {
                    ContractGoodsDomain.setGoodsTopnum(new BigDecimal(pmPromotionRangelistDomain.getCouponOnceAnums()));
                }
                ContractGoodsDomain.setPricesetNprice(pmPromotionRangelistDomain.getDiscountAmount1());
                if (null != pmPromotionRangelistDomain.getGoodsMinnum()) {
                    ContractGoodsDomain.setGoodsMinnum(pmPromotionRangelistDomain.getGoodsMinnum());
                }
                if (null != pmPromotionRangelistDomain.getGoodsNum1()) {
                    ContractGoodsDomain.setGoodsAhnum(pmPromotionRangelistDomain.getGoodsNum1());
                }
                if (null != pmPromotionRangelistDomain.getDiscountAmount() && 0 == pmPromotionRangelistDomain.getDiscountAmount()) {
                    ContractGoodsDomain.setGoodsTopweight(null);
                }
                if (null == pmPromotionRangelistDomain.getDiscountAmount() || 0 == pmPromotionRangelistDomain.getDiscountAmount()) continue;
                Integer sum = pmPromotionRangelistDomain.getDiscountAmount() - pmPromotionRangelistDomain.getCouponOnceAnums();
                ContractGoodsDomain.setGoodsTopweight(new BigDecimal(sum));
            }
        }
        return ContractGoodsDomain;
    }

    public BigDecimal checkContractGoodsNum(OcContractGoodsDomain ContractGoodsDomain, OcContractEditDomain editDomain) {
        BigDecimal goodsNumSum = BigDecimal.ZERO;
        HashMap<String, Object> ocParam = new HashMap<String, Object>();
        ocParam.put("contractType", "85,86,67");
        ocParam.put("childFlag", true);
        ocParam.put("contractBbillcode", editDomain.getContractBillcode());
        SupQueryResult<OcContractReDomain> ocContractResult = this.ocContractService.queryContractPageReDomain(ocParam);
        this.logger.error("\u9884\u552e\u8f6c\u6b63\u5f0f\u8ba2\u5355====", (Object)JsonUtil.buildNormalBinder().toJson(ocContractResult));
        if (ocContractResult != null && ListUtil.isNotEmpty((Collection)ocContractResult.getList())) {
            for (OcContractReDomain contractReDomain : ocContractResult.getList()) {
                for (OcContractGoodsDomain goods : contractReDomain.getGoodsList()) {
                    if (!ContractGoodsDomain.getSkuNo().equals(goods.getSkuNo())) continue;
                    if ((contractReDomain.getDataState() == 1 || contractReDomain.getDataState().compareTo(1) == 0 || contractReDomain.getDataState().compareTo(-1) == 0 || contractReDomain.getDataState().compareTo(-1) == 0) && ListUtil.isNotEmpty(contractReDomain.getGoodsList())) {
                        for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                            goodsNumSum = goodsNumSum.add(contractGoodsDomain.getGoodsCamount());
                        }
                    }
                    if ((contractReDomain.getDataState() == 2 || contractReDomain.getDataState().compareTo(2) == 0) && ListUtil.isNotEmpty(contractReDomain.getGoodsList())) {
                        for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                            goodsNumSum = goodsNumSum.add(contractGoodsDomain.getGoodsCamount());
                        }
                    }
                    if (contractReDomain.getDataState() != 3 && contractReDomain.getDataState() != 4 && contractReDomain.getDataState().compareTo(3) != 0 && contractReDomain.getDataState().compareTo(4) != 0 || !ListUtil.isNotEmpty(contractReDomain.getGoodsList())) continue;
                    for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                        goodsNumSum = goodsNumSum.add(contractGoodsDomain.getContractGoodsSendnum());
                    }
                }
            }
        }
        return goodsNumSum;
    }

    public BigDecimal getSkuOneNum(OcContractGoodsDomain ContractGoodsDomain, UserSession userSession) {
        BigDecimal goodsAhnum = BigDecimal.ZERO;
        if (null == ContractGoodsDomain || null == userSession) {
            this.logger.error(CODE + ".getSkuOneNum", (Object)"isnull");
            return goodsAhnum;
        }
        List<RsSkuOneDomain> skuOneList = this.rsSkuOneService.getSkuOne(ContractGoodsDomain.getSkuNo(), ContractGoodsDomain.getGoodsNo(), null, ContractGoodsDomain.getTenantCode());
        this.logger.error(CODE + ".getSkuOneNum", (Object)JsonUtil.buildNormalBinder().toJson(skuOneList));
        if (ListUtil.isEmpty(skuOneList)) {
            this.logger.error(CODE + ".skuOneList.getSkuOneNum", (Object)"isnull");
            return goodsAhnum;
        }
        RsSkuOneDomain skuOneDomain = skuOneList.get(0);
        this.makeSkuOneDomainList(skuOneDomain, userSession);
        goodsAhnum = skuOneDomain.getSkuOneNum();
        return goodsAhnum;
    }

    public BigDecimal getSalequota(OcContractGoodsDomain ContractGoodsDomain, UserSession userSession) {
        BigDecimal goodsTopnum = BigDecimal.ZERO;
        if (null == ContractGoodsDomain || null == userSession) {
            this.logger.error(CODE + ".getSalequota", (Object)"isnull");
            return goodsTopnum;
        }
        SalequotaGoods salequotaGoods = new SalequotaGoods();
        salequotaGoods.setMemberBcode(ContractGoodsDomain.getMemberBcode());
        if (StringUtils.isBlank((String)ContractGoodsDomain.getMemberBcode())) {
            salequotaGoods.setMemberBcode(userSession.getUserPcode());
        }
        salequotaGoods.setTenantCode(ContractGoodsDomain.getTenantCode());
        salequotaGoods.setQuotaflag(true);
        ArrayList<GoodsDomain> goodsDomainList = new ArrayList<GoodsDomain>();
        GoodsDomain goodsDomain = new GoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)goodsDomain, (Object)ContractGoodsDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7ec4\u88c5\u5f02\u5e38=======", (Object)JsonUtil.buildNormalBinder().toJson((Object)ContractGoodsDomain));
        }
        goodsDomainList.add(goodsDomain);
        salequotaGoods.setGoodsDomainList(goodsDomainList);
        this.logger.error("checkStSalequota.salequotaGoods\u5f00\u59cb=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)salequotaGoods));
        SalequotaGoods checkSalequota = this.stSalequotaService.checkSalequota(salequotaGoods);
        this.logger.error("checkStSalequota.salequotaGoods\u7ed3\u675f=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)checkSalequota));
        if (checkSalequota != null) {
            GoodsDomain goodsDomain1 = checkSalequota.getGoodsDomainList().get(0);
            goodsTopnum = goodsDomain1.getSalequotaNums();
        }
        return goodsTopnum;
    }

    private void makeSkuOneDomainList(RsSkuOneDomain skuOneDomain, UserSession userSession) {
        if (ListUtil.isNotEmpty(skuOneDomain.getRsSkuOnelistDomainList())) {
            RsSkuOnelistDomain rsSkuOnelistDomain = this.rsSkuOneService.checkSkuOne(skuOneDomain.getRsSkuOnelistDomainList(), userSession);
            this.logger.error(CODE + ".skuOneList.makeSkuOneDomainList", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuOnelistDomain));
            if (null != rsSkuOnelistDomain && null != rsSkuOnelistDomain.getSkuOneNum()) {
                skuOneDomain.setSkuOneNum(rsSkuOnelistDomain.getSkuOneNum());
            }
        }
    }

    public HtmlJsonReBean updateContractByCode(Map<String, Object> map) {
        if (null == map) {
            this.logger.error(CODE + ".updateContractCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractService.updateContractByCode(map);
    }

    public HtmlJsonReBean sendSaveEncapsulation(HttpServletRequest request, List<OcContractGoodsDomain> ocContractGoodsReDomainList) throws ApiException {
        if (ListUtil.isEmpty(ocContractGoodsReDomainList)) {
            this.logger.error(CODE + ".sendSaveEncapsulation.ocContractGoodsReDomainList", (Object)"ocContractGoodsReDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, List<OcContractGoodsDomain>> hash = new HashMap<String, List<OcContractGoodsDomain>>();
        ArrayList<OcContractGoodsDomain> domainList = null;
        for (OcContractGoodsDomain ocContractGoodsReDomain : ocContractGoodsReDomainList) {
            if (StringUtils.isBlank((String)ocContractGoodsReDomain.getContractBillcode())) {
                this.logger.error(CODE + ".sendSaveSplitContract.ocContractDomain", (Object)"contractBillcode is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            try {
                if (StringUtils.isNotBlank((String)ocContractGoodsReDomain.getGoodsSpec5())) {
                    Date date = new SimpleDateFormat("yyyyMMdd").parse(ocContractGoodsReDomain.getGoodsSpec5());
                    ocContractGoodsReDomain.setGoodsDay(date);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ocContractGoodsReDomain.setGoodsSpec5(null);
            domainList = (ArrayList<OcContractGoodsDomain>)hash.get(ocContractGoodsReDomain.getContractBillcode());
            if (null == domainList) {
                domainList = new ArrayList<OcContractGoodsDomain>();
                hash.put(ocContractGoodsReDomain.getContractBillcode(), domainList);
            }
            domainList.add(ocContractGoodsReDomain);
        }
        if (MapUtil.isEmpty(hash)) {
            this.logger.error(CODE + ".sendSaveSplitContract.hash", (Object)"hash is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        this.logger.error("hash=======", (Object)JsonUtil.buildNonNullBinder().toJson(hash));
        HtmlJsonReBean ds = this.makeOccontract(request, hash);
        if (null == ds || "error".equals(ds.getSysRecode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return new HtmlJsonReBean();
    }

    public static void main(String[] args) {
        try {
            Date date = new SimpleDateFormat("yyyyMMdd").parse("20220825");
            System.out.print("");
            OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
            ocContractGoodsDomain.setGoodsDay(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public HtmlJsonReBean makeOccontract(HttpServletRequest request, Map<String, List<OcContractGoodsDomain>> hash) {
        OcContractReDomain ocContractReDomain = null;
        OcContractGoodsDomain ocContractGoodsReDomain = null;
        ArrayList<String> bilList = new ArrayList<String>();
        for (String key : hash.keySet()) {
            this.logger.error("=======+++++\u5f00\u59cb", (Object)key);
            List<OcContractGoodsDomain> hashGoodsList = hash.get(key);
            if (ListUtil.isEmpty(hashGoodsList)) {
                this.logger.error(CODE + "makeOccontract.hashGoodsList", (Object)key);
                bilList.add(key);
                continue;
            }
            ocContractGoodsReDomain = hashGoodsList.get(0);
            String memberMcode = ocContractGoodsReDomain.getMemberMcode();
            String memberMname = ocContractGoodsReDomain.getMemberMname();
            String channelCode = ocContractGoodsReDomain.getChannelCode();
            String channelName = ocContractGoodsReDomain.getChannelName();
            String memberBcode = ocContractGoodsReDomain.getMemberBcode();
            String memberBname = ocContractGoodsReDomain.getMemberBname();
            String warUrl = ocContractGoodsReDomain.getMemberCcode();
            String warOcode = ocContractGoodsReDomain.getMemberCname();
            String areaCode = ocContractGoodsReDomain.getAreaCode();
            if (StringUtils.isBlank((String)areaCode)) {
                this.logger.error(CODE + "makeOccontract.areaCode", (Object)JsonUtil.buildNonNullBinder().toJson((Object)ocContractGoodsReDomain));
                bilList.add(key);
                continue;
            }
            String areaName = ocContractGoodsReDomain.getAreaName();
            if (StringUtils.isBlank((String)areaName)) {
                this.logger.error(CODE + "makeOccontract.areaName", (Object)JsonUtil.buildNonNullBinder().toJson((Object)ocContractGoodsReDomain));
                bilList.add(key);
                continue;
            }
            HashMap userMap = new HashMap();
            HashMap<String, Object> userQueryMap = new HashMap<String, Object>();
            userQueryMap.put("departCode", memberMcode);
            userQueryMap.put("userinfoOcode", memberBcode);
            userQueryMap.put("userinfoChannelcode", channelCode);
            userQueryMap.put("tenantCode", this.getTenantCode(request));
            SupQueryResult<UmUserinfoReDomainBean> userReuslt = this.userService.queryUserinfoPage(userQueryMap);
            if (EmptyUtil.isEmpty(userReuslt) || ListUtil.isEmpty((Collection)userReuslt.getList())) {
                this.logger.error(CODE + ".sendSaveEncapsulation==3", (Object)((Object)userQueryMap).toString());
                bilList.add(key);
                continue;
            }
            userQueryMap.clear();
            UmUserinfoReDomainBean umUserinfoDomain = (UmUserinfoReDomainBean)userReuslt.getList().get(0);
            String userinfoCode = umUserinfoDomain.getUserinfoCode();
            userQueryMap.put("companyOcode", memberMcode);
            userQueryMap.put("tenantCode", this.getTenantCode(request));
            SupQueryResult<OrgCompanyReDomain> queryResutl = this.orgCompanyService.queryCompanyPage(userQueryMap);
            if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                this.logger.error(CODE + ".makeOccontract.null", (Object)JsonUtil.buildNormalBinder().toJson(userQueryMap));
                bilList.add(key);
                continue;
            }
            userQueryMap.clear();
            OrgCompanyReDomain orgCompanyReDomain = (OrgCompanyReDomain)queryResutl.getList().get(0);
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("tenantCode", this.getTenantCode(request));
            paramsMap.put("departShortcode", channelCode);
            paramsMap.put("companyCode", orgCompanyReDomain.getCompanyCode());
            paramsMap.put("userinfoSort", "1");
            SupQueryResult<OrgDepartReDomain> orgDepartQueryResult = this.orgDepartService.queryDepartPage(paramsMap);
            if (EmptyUtil.isEmpty(orgDepartQueryResult) || ListUtil.isEmpty((Collection)orgDepartQueryResult.getList())) {
                this.logger.error(CODE + ".makeOccontract.depart.null:", paramsMap);
                bilList.add(key);
                continue;
            }
            String departCode = ((OrgDepartReDomain)orgDepartQueryResult.getList().get(0)).getDepartCode();
            paramsMap.clear();
            paramsMap.put("tenantCode", this.getTenantCode(request));
            paramsMap.put("departCode", departCode);
            paramsMap.put("companyCode", orgCompanyReDomain.getCompanyCode());
            paramsMap.put("userinfoQuality", "depart");
            SupQueryResult<UmUserinfoReDomainBean> userinfoQueryResult = this.userService.queryUserinfoPage(paramsMap);
            if (EmptyUtil.isEmpty(userinfoQueryResult) || ListUtil.isEmpty((Collection)userinfoQueryResult.getList())) {
                this.logger.error(CODE + ".makeOccontract.userinfoQueryResult.null:", paramsMap);
                bilList.add(key);
                continue;
            }
            String departUserinfoCode = ((UmUserinfoReDomainBean)userinfoQueryResult.getList().get(0)).getUserinfoCode();
            paramsMap.clear();
            paramsMap.put("tenantCode", this.getTenantCode(request));
            paramsMap.put("memberCode", departUserinfoCode);
            SupQueryResult<DisChannelReDomain> disChannelReDomainQueryResult = this.disChannelService.queryChannelPage(paramsMap);
            if (EmptyUtil.isEmpty(disChannelReDomainQueryResult) || ListUtil.isEmpty((Collection)disChannelReDomainQueryResult.getList())) {
                this.logger.error(CODE + ".makeOccontract.disChannelReDomainQueryResult.null:", paramsMap);
                bilList.add(key);
                continue;
            }
            DisChannelReDomain disChannel = (DisChannelReDomain)disChannelReDomainQueryResult.getList().get(0);
            ocContractReDomain = new OcContractReDomain();
            ocContractReDomain.setMemberBcode(userinfoCode);
            ocContractReDomain.setMemberBname(umUserinfoDomain.getUserinfoCompname());
            ocContractReDomain.setGoodsReceiptPhone(ocContractGoodsReDomain.getMemberContactPhone());
            ocContractReDomain.setGoodsReceiptArrdess(ocContractGoodsReDomain.getGoodsProperty4());
            ocContractReDomain.setChannelCode(disChannel.getChannelCode());
            ocContractReDomain.setChannelName(disChannel.getChannelName());
            ocContractReDomain.setMemberCode(disChannel.getMemberCode());
            ocContractReDomain.setMemberName(disChannel.getMemberName());
            ocContractReDomain.setContractBillcode(ocContractGoodsReDomain.getContractBillcode());
            ocContractReDomain.setContractBbillcode(ocContractGoodsReDomain.getContractBillcode());
            ocContractReDomain.setContractProperty("0");
            ocContractReDomain.setCustrelCode(memberBcode);
            ocContractReDomain.setDepartShortname(orgCompanyReDomain.getCompanyName());
            ocContractReDomain.setContractType("87");
            ocContractReDomain.setContractTypepro("01");
            ocContractReDomain.setContractBlance("0");
            ocContractReDomain.setContractPmode("3");
            ocContractReDomain.setContractPumode("0");
            ocContractReDomain.setGoodsWeight(BigDecimal.ZERO);
            ocContractReDomain.setPricesetRefrice(BigDecimal.ZERO);
            ocContractReDomain.setContractPaygmoney(BigDecimal.ZERO);
            ocContractReDomain.setContractPaydate(new Date());
            ocContractReDomain.setDataBweight(BigDecimal.ZERO);
            ocContractReDomain.setGoodsPbillno("0");
            ocContractReDomain.setContractShow(0);
            ocContractReDomain.setContractEcflag(0);
            ocContractReDomain.setContractInvstate(0);
            ocContractReDomain.setGoodsLogmoney(BigDecimal.ZERO);
            ocContractReDomain.setGoodsReceiptPhone(ocContractGoodsReDomain.getMemberContactPhone());
            ocContractReDomain.setAppmanageIcode("029");
            ocContractReDomain.setTenantCode(this.getTenantCode(request));
            ocContractReDomain.setGoodsReceiptMem(ocContractGoodsReDomain.getMemberContact());
            ocContractReDomain.setContractAppraise(0);
            ocContractReDomain.setRefundFlag(0);
            ocContractReDomain.setGoodsClass("B2B-DEA");
            BigDecimal contractInmoney = BigDecimal.ZERO;
            BigDecimal contractMoney = BigDecimal.ZERO;
            BigDecimal goodsMoney = BigDecimal.ZERO;
            BigDecimal dataBmoney = BigDecimal.ZERO;
            BigDecimal dataBnum = BigDecimal.ZERO;
            ArrayList<OcContractGoodsDomain> goodsDomainList = new ArrayList<OcContractGoodsDomain>();
            for (OcContractGoodsDomain goodsReDomain : hashGoodsList) {
                if (EmptyUtil.isEmpty((Object)goodsReDomain.getGoodsCamount()) || EmptyUtil.isEmpty((Object)goodsReDomain.getGoodsNum()) || EmptyUtil.isEmpty((Object)goodsReDomain.getContractGoodsMoney()) || EmptyUtil.isEmpty((Object)EmptyUtil.isEmpty((Object)goodsReDomain.getGoodsAhweight())) || EmptyUtil.isEmpty((Object)goodsReDomain.getPricesetNprice()) || EmptyUtil.isEmpty((Object)goodsReDomain.getContractGoodsPrice()) || EmptyUtil.isEmpty((Object)goodsReDomain.getGoodsAhnum()) || EmptyUtil.isEmpty((Object)goodsReDomain.getGoodsProperty5())) {
                    paramsMap.clear();
                }
                goodsReDomain.setGoodsProperty4(null);
                goodsReDomain.setMemberMcode(null);
                goodsReDomain.setMemberMname(null);
                goodsReDomain.setMemberCcode(null);
                goodsReDomain.setMemberCname(null);
                goodsReDomain.setAreaCode(null);
                goodsReDomain.setAreaName(null);
                goodsReDomain.setMemberContact(null);
                goodsReDomain.setMemberContactPhone(null);
                paramsMap.put("tenantCode", this.getTenantCode(request));
                paramsMap.put("channelCode", disChannel.getChannelCode());
                paramsMap.put("goodsNo", goodsReDomain.getGoodsShowno());
                paramsMap.put("children", "true");
                SupQueryResult<RsResourceGoodsReDomain> resourceGoodss = this.rsResourceGoodsService.queryResourceGoodsPage(paramsMap);
                if (null == resourceGoodss || ListUtil.isEmpty((Collection)resourceGoodss.getList())) {
                    this.logger.error(CODE + ".makeOccontract.hashGoodsList.resourceGoodss", paramsMap);
                    goodsDomainList.clear();
                    break;
                }
                RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)resourceGoodss.getList().get(0);
                if (ListUtil.isEmpty(rsResourceGoodsReDomain.getSkuList())) {
                    this.logger.error(CODE + ".makeOccontract.hashGoodsList.skuList", (Object)JsonUtil.buildNonNullBinder().toJson(resourceGoodss));
                    goodsDomainList.clear();
                    break;
                }
                paramsMap.clear();
                RsSkuReDomain rsSkuDomain = rsResourceGoodsReDomain.getSkuList().get(0);
                goodsReDomain.setSkuCode(rsSkuDomain.getSkuCode());
                goodsReDomain.setSkuName(rsSkuDomain.getSkuName());
                goodsReDomain.setSkuNo(rsSkuDomain.getSkuNo());
                goodsReDomain.setGoodsNo(rsSkuDomain.getSkuNo());
                goodsReDomain.setSkuShowno(rsSkuDomain.getSkuShowno());
                goodsReDomain.setSpuCode(rsResourceGoodsReDomain.getSpuCode());
                goodsReDomain.setGoodsCode(rsResourceGoodsReDomain.getGoodsCode());
                goodsReDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                goodsReDomain.setClasstreeName(rsResourceGoodsReDomain.getClasstreeName());
                goodsReDomain.setClasstreeCode(rsResourceGoodsReDomain.getClasstreeCode());
                goodsReDomain.setPntreeCode(rsResourceGoodsReDomain.getPntreeCode());
                goodsReDomain.setPntreeName(rsResourceGoodsReDomain.getPntreeName());
                goodsReDomain.setGoodsRemark(rsResourceGoodsReDomain.getGoodsRemark());
                goodsReDomain.setGoodsMinnum(rsResourceGoodsReDomain.getGoodsMinnum());
                goodsReDomain.setGoodsOneweight(BigDecimal.ZERO);
                goodsReDomain.setGoodsWeight(BigDecimal.ZERO);
                goodsReDomain.setGoodsSupplynum(rsResourceGoodsReDomain.getGoodsSupplynum());
                goodsReDomain.setGoodsProperty(rsResourceGoodsReDomain.getGoodsProperty());
                goodsReDomain.setGoodsProperty1(memberMcode);
                goodsReDomain.setGoodsProperty2(warUrl);
                goodsReDomain.setGoodsProperty3(rsResourceGoodsReDomain.getGoodsProperty3());
                goodsReDomain.setGoodsOrdnum(goodsReDomain.getGoodsCamount());
                goodsReDomain.setGoodsOrdweight(BigDecimal.ZERO);
                goodsReDomain.setPartsnameNumunit(rsResourceGoodsReDomain.getPartsnameNumunit());
                goodsReDomain.setPartsnameWeightunit(rsResourceGoodsReDomain.getPartsnameWeightunit());
                goodsReDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
                goodsReDomain.setContractGoodsPefmoney(BigDecimal.ZERO);
                goodsReDomain.setContractGoodsPefprice(BigDecimal.ZERO);
                goodsReDomain.setContractGoodsType(0);
                goodsReDomain.setContractGoodsGtype("0");
                goodsReDomain.setGoodsCweight(BigDecimal.ZERO);
                goodsReDomain.setPricesetMakeprice(goodsReDomain.getPricesetNprice());
                goodsReDomain.setPricesetAsprice(goodsReDomain.getPricesetNprice());
                goodsReDomain.setPricesetBaseprice(goodsReDomain.getPricesetNprice());
                goodsReDomain.setGoodsOrigin("11");
                goodsReDomain.setGoodsPro("0");
                goodsReDomain.setGoodsType("00");
                goodsReDomain.setPricesetType(rsResourceGoodsReDomain.getPricesetType());
                goodsReDomain.setPricesetRefrice(BigDecimal.ZERO);
                goodsReDomain.setPricesetPrefprice(BigDecimal.ZERO);
                goodsReDomain.setTenantCode(this.getTenantCode(request));
                goodsReDomain.setGoodsClass("B2B-DEA");
                goodsReDomain.setRefundFlag(0);
                goodsReDomain.setBrandCode(rsResourceGoodsReDomain.getBrandCode());
                goodsReDomain.setBrandName(rsResourceGoodsReDomain.getBrandName());
                goodsReDomain.setDataPic(rsResourceGoodsReDomain.getDataPic());
                goodsReDomain.setDataOpbillstate(0);
                goodsReDomain.setMemberBcode(userinfoCode);
                goodsReDomain.setMemberBname(umUserinfoDomain.getUserinfoCompname());
                goodsReDomain.setChannelCode(disChannel.getChannelCode());
                goodsReDomain.setChannelName(disChannel.getChannelName());
                goodsReDomain.setMemberCode(disChannel.getMemberCode());
                goodsReDomain.setMemberName(disChannel.getMemberName());
                goodsReDomain.setMemberMname(disChannel.getMemberMname());
                goodsReDomain.setMemberMcode(disChannel.getMemberMcode());
                goodsReDomain.setContractBillcode(ocContractGoodsReDomain.getContractBillcode());
                BigDecimal money = goodsReDomain.getPricesetNprice().multiply(goodsReDomain.getGoodsCamount());
                goodsReDomain.setContractGoodsInmoney(money);
                contractInmoney = contractInmoney.add(goodsReDomain.getContractGoodsInmoney());
                contractMoney = contractMoney.add(goodsReDomain.getContractGoodsMoney());
                dataBmoney = dataBmoney.add(goodsReDomain.getGoodsAhweight());
                dataBnum = dataBnum.add(goodsReDomain.getGoodsCamount());
                goodsDomainList.add(goodsReDomain);
            }
            if (ListUtil.isEmpty(goodsDomainList)) {
                this.logger.error(CODE + ".makeOccontract.hashGoodsList.goodsDomainList", (Object)key);
                bilList.add(key);
                continue;
            }
            if (contractMoney.compareTo(new BigDecimal(areaCode)) != 0) {
                this.logger.error(CODE + ".makeOccontract.contractMoney.areaCode", (Object)("contractMoney:" + contractMoney + ",ocContractGoodsReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsReDomain)));
                bilList.add(key);
                continue;
            }
            if (dataBmoney.compareTo(new BigDecimal(areaName)) != 0) {
                this.logger.error(CODE + ".makeOccontract.contractMoney.areaName", (Object)("contractMoney:" + dataBmoney + ",ocContractGoodsReDomain:" + JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsReDomain)));
                bilList.add(key);
                continue;
            }
            ocContractReDomain.setContractInmoney(contractInmoney);
            ocContractReDomain.setContractMoney(contractMoney);
            ocContractReDomain.setGoodsMoney(contractMoney);
            ocContractReDomain.setDataBmoney(dataBmoney);
            ocContractReDomain.setGoodsPmbillno(dataBmoney.toString());
            ocContractReDomain.setDataBnum(dataBnum);
            ocContractReDomain.setGoodsNum(dataBnum);
            ocContractReDomain.setCashback(dataBmoney);
            ocContractReDomain.setGoodsPmoney(BigDecimal.ZERO);
            ocContractReDomain.setContractRemark(ocContractGoodsReDomain.getMemo());
            OcPackageDomain ocPackageDomain = new OcPackageDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)ocPackageDomain, (Object)ocContractReDomain);
                ocPackageDomain.setGoodsInmoney(contractMoney);
                ocPackageDomain.setGoodsMoney(contractInmoney);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocPackageDomain.setContractGoodsList(goodsDomainList);
            ArrayList<OcPackageDomain> ocPackageDomains = new ArrayList<OcPackageDomain>();
            ocPackageDomains.add(ocPackageDomain);
            ocContractReDomain.setPackageList(ocPackageDomains);
            this.ocContractEngineService.sendsaveContractRe(ocContractReDomain);
        }
        if (ListUtil.isNotEmpty(bilList)) {
            this.logger.error(CODE + ".makeOccontract.bilList", (Object)JsonUtil.buildNormalBinder().toJson(bilList));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null", (Object)JsonUtil.buildNormalBinder().toJson(bilList));
        }
        return new HtmlJsonReBean();
    }
}

