/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.data;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.da.DaOpsetDomain;
import cn.com.qj.bff.domain.da.DaOrderTotalDomain;
import cn.com.qj.bff.domain.da.DaOrderTotalReDomain;
import cn.com.qj.bff.domain.um.ExcelExportTemplate;
import cn.com.qj.bff.service.da.DaOrderTotalService;
import cn.com.qj.bff.service.nm.NmNoService;
import cn.com.qj.bff.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/da/orderTotal"}, name="\u6c47\u603b\u7c7b\u578b\u8bbe\u7f6e")
public class DaOrderTotalCon
extends SpringmvnNewController {
    private static String CODE = "da.orderTotal.con";
    @Autowired
    private DaOrderTotalService daOrderTotalService;
    @Autowired
    NmNoService nmNoService;

    @Override
    protected String getContext() {
        return "orderTotal";
    }

    @RequestMapping(value={"saveOrderTotal.json"}, name="\u5bf9\u8d26\u5355\u65b0\u589e")
    @ResponseBody
    public HtmlJsonReBean saveOpset(HttpServletRequest request, String daOrderTotalDomain) {
        if (null == daOrderTotalDomain) {
            this.logger.error(CODE + ".saveOrderTotal.daOrderTotalDomain", (Object)"daOrderTotalDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "daOrderTotalDomain is null");
        }
        DaOrderTotalDomain daOrderTotalDomainPage = (DaOrderTotalDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(daOrderTotalDomain, DaOrderTotalDomain.class);
        String orderTotalCode = this.nmNoService.createMaxBillNumber(null, "DaOrderTotal", "daOrderTotal", this.getTenantCode(request));
        orderTotalCode = "DZD" + DateUtils.getDateString((Date)new Date(), (String)"yyyyMMdd") + orderTotalCode.substring(orderTotalCode.length() - 4);
        daOrderTotalDomainPage.setOrderTotalCode(orderTotalCode);
        daOrderTotalDomainPage.setTenantCode(this.getTenantCode(request));
        daOrderTotalDomainPage.setChannelCode(this.getChannelCode(request));
        return this.daOrderTotalService.saveDaOrderTotal(daOrderTotalDomainPage);
    }

    @RequestMapping(value={"getOrderTotal.json"}, name="\u83b7\u53d6\u5bf9\u8d26\u5355\u8be6\u60c5")
    @ResponseBody
    public DaOrderTotalReDomain getOrderTotal(Integer orderTotalId) {
        if (StringUtils.isBlank((Integer)orderTotalId)) {
            this.logger.error(CODE + ".getOrderTotal.orderTotalId", (Object)"orderTotalId is null");
            return null;
        }
        return this.daOrderTotalService.getDaOrderTotal(orderTotalId);
    }

    @RequestMapping(value={"queryDaOrderTotalPage.json"}, name="\u5bf9\u8d26\u5355\u67e5\u770b\u5217\u8868\u4ee5\u53ca\u5bfc\u51fa\u529f\u80fd")
    @ResponseBody
    public SupQueryResult<DaOrderTotalReDomain> queryDaOrderTotalPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.remove("channelCode");
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (!flag.booleanValue()) {
            return this.daOrderTotalService.queryOrderTotalPage(param);
        }
        SupQueryResult<DaOrderTotalReDomain> daOrderTotalReDomainSupQueryResult = this.daOrderTotalService.queryOrderTotalPage(param);
        if (ListUtil.isEmpty((Collection)daOrderTotalReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryDaOrderTotalPage.daOrderTotalReDomainSupQueryResult.getList()", (Object)"daOrderTotalReDomainSupQueryResult.getList() is null");
            return null;
        }
        String fileName = "daOrderTotalList";
        if (null != param && !EmptyUtil.isEmpty((Object)param.get("fileName"))) {
            fileName = param.get("fileName") + "";
        }
        return this.queryDaOrderTotalPageComes(request, fileName, param);
    }

    @RequestMapping(value={"updateDaOrderTotalState.json"}, name="\u66f4\u65b0\u5bf9\u8d26\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDaOrderTotalState(String orderTotalId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)orderTotalId)) {
            this.logger.error(CODE + ".updateOpsetState.orderTotalId", (Object)"orderTotalId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "orderTotalId is null");
        }
        if (null == dataState) {
            this.logger.error(CODE + ".updateOpsetState.dataState", (Object)"dataState is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "dataState is null");
        }
        if (null == oldDataState) {
            this.logger.error(CODE + ".updateOpsetState.oldDataState", (Object)"oldDataState is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "oldDataState is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderTotalDate2", new Date());
        return this.daOrderTotalService.updateOrderTotalState(Integer.valueOf(orderTotalId), dataState, oldDataState, map);
    }

    @RequestMapping(value={"updateOpset.json"}, name="\u66f4\u65b0\u6c47\u603b\u7c7b\u578b\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateOpset(HttpServletRequest request, DaOpsetDomain daOpsetDomain) {
        if (null == daOpsetDomain) {
            this.logger.error(CODE + ".updateOpset", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsetDomain.setTenantCode(this.getTenantCode(request));
        return this.daOrderTotalService.updateOpset(daOpsetDomain);
    }

    @RequestMapping(value={"deleteOpset.json"}, name="\u5220\u9664\u6c47\u603b\u7c7b\u578b\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteOpset(Integer opsetId) {
        if (StringUtils.isBlank((Integer)opsetId)) {
            this.logger.error(CODE + ".deleteOpset", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOrderTotalService.deleteOpset(opsetId);
    }

    protected SupQueryResult<DaOrderTotalReDomain> queryDaOrderTotalPageComes(HttpServletRequest request, String fileName, Map<String, Object> param) {
        UserSession userSession;
        if (StringUtils.isBlank((String)fileName)) {
            fileName = "\u5bf9\u8d26\u5355\u5217\u8868";
        }
        String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("headMap", ExcelExportTemplate.covertDaOrderTotalExcelParam());
        infoMap.put("userCode", userCode);
        infoMap.put("fileName", fileName);
        this.logger.debug(CODE + ".queryDaOrderTotalPageComes.params+infoMap", (Object)(param + "=:=" + infoMap));
        try {
            this.exportComExcel(request, param, infoMap, "da.daordertotal.queryOrderTotalPage", null);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".queryDaOrderTotalPageComes.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
        return null;
    }

    @Override
    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".makeExcelData.supQueryResult", (Object)(" is null" + json));
            return null;
        }
        List daOrderTotalReDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DaOrderTotalReDomain.class);
        if (ListUtil.isEmpty((Collection)daOrderTotalReDomainList)) {
            this.logger.error(CODE + ".makeExcelData.daOrderTotalReDomainList", (Object)(" is null" + json));
            return null;
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (DaOrderTotalReDomain ur : daOrderTotalReDomainList) {
            Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)ur), String.class, Object.class);
            Map<String, Object> stringObjectMap = this.coverUserState(objectToMap);
            mapList.add(stringObjectMap);
        }
        return mapList;
    }

    protected Map<String, Object> coverUserState(Map<String, Object> map) {
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 0: {
                map.put("dataState", "\u5f85\u8fd8\u6b3e");
                break;
            }
            case 1: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        if (map.get("orderTotalDate") != null) {
            map.put("orderTotalDate", map.get("orderTotalDate") + "-" + map.get("orderTotalDate1"));
        }
        if (map.get("orderTotalType") != null) {
            map.put("orderTotalType", "\u6388\u4fe1\u8d26\u5355");
        }
        return map;
    }
}

