/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.util;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
    public static SimpleDateFormat format1 = new SimpleDateFormat("yyyyMMdd HH:mm:ss");

    public static Date getFinallyDate(Date date) {
        String temp = format.format(date);
        temp = temp + " 23:59:59";
        try {
            return format1.parse(temp);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getStartDate(Date date) {
        String temp = format.format(date);
        temp = temp + " 00:00:00";
        try {
            return format1.parse(temp);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getYearFirstDay(int year) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        Date yearFirstDay = cal.getTime();
        return DateUtil.getStartDate(yearFirstDay);
    }

    public static Date getYearLastDay(int year) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        cal.roll(6, -1);
        Date yearLastDay = cal.getTime();
        return DateUtil.getFinallyDate(yearLastDay);
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        LocalDate firstDayOfMonth = LocalDate.of(year, month, 1);
        return DateUtil.convertToDate(firstDayOfMonth);
    }

    public static Date getLastDayOfMonth(int year, int month) {
        LocalDate lastDayOfMonth = YearMonth.of(year, month).atEndOfMonth();
        return DateUtil.convertToDate(lastDayOfMonth);
    }

    public static Date getFirstDayOfQuarter(int year, int quarter) {
        int month = (quarter - 1) * 3 + 1;
        return DateUtil.getFirstDayOfMonth(year, month);
    }

    public static Date getLastDayOfQuarter(int year, int quarter) {
        int month = quarter * 3;
        return DateUtil.getLastDayOfMonth(year, month);
    }

    public static Date convertToDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static void main(String[] args) {
        Date firstDayOfMonth = DateUtil.getFirstDayOfMonth(2025, 4);
        Date lastDayOfMonth = DateUtil.getLastDayOfMonth(2025, 4);
        System.out.println("4\u6708\u7b2c\u4e00\u5929: " + firstDayOfMonth);
        System.out.println("4\u6708\u6700\u540e\u4e00\u5929: " + lastDayOfMonth);
        Date firstDayOfQ2 = DateUtil.getFirstDayOfQuarter(2025, 2);
        Date lastDayOfQ2 = DateUtil.getLastDayOfQuarter(2025, 2);
        System.out.println("Q2\u7b2c\u4e00\u5929: " + firstDayOfQ2);
        System.out.println("Q2\u6700\u540e\u4e00\u5929: " + lastDayOfQ2);
    }
}

