/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.um;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.core.util.HtmlUtil;
import cn.com.qj.bff.domain.um.AmAddress;
import cn.com.qj.bff.domain.um.UmAddressDomain;
import cn.com.qj.bff.domain.um.UmAddressReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoDomain;
import cn.com.qj.bff.service.mh.ExService;
import cn.com.qj.bff.service.um.UmAddressService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/address"}, name="\u7528\u6237\u5730\u5740\u4fe1\u606f")
public class AddressCon
extends SpringmvcController {
    private static String CODE = "um.address.con";
    @Autowired
    private UmAddressService umAddressService;
    @Autowired
    ExService exService;

    @Override
    protected String getContext() {
        return "address";
    }

    @RequestMapping(value={"saveAddress.json"}, name="\u589e\u52a0\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAddress(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".saveAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umAddressDomain.setTenantCode(this.getTenantCode(request));
        HtmlJsonReBean htmlJsonReBean = this.umAddressService.saveAddress(umAddressDomain);
        if (!htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        umAddressDomain.setAddressCode(htmlJsonReBean.getDataObj().toString());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getAddress.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public UmAddressReDomain getAddress(HttpServletRequest request, Integer addressId) {
        if (StringUtils.isBlank((Integer)addressId)) {
            this.logger.error(CODE + ".getAddress", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getAddress", (Object)"UserSession is null");
            return null;
        }
        UmAddressReDomain umAddressReDomain = this.umAddressService.getAddress(addressId);
        if (null == umAddressReDomain) {
            return null;
        }
        if (!umAddressReDomain.getUserCode().equals(userSession.getUserPcode())) {
            return null;
        }
        return umAddressReDomain;
    }

    @RequestMapping(value={"updateAddress.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAddress(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".updateAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmAddressReDomain address = this.umAddressService.getAddress(umAddressDomain.getAddressId());
        if (null == address || !address.getUserCode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".updateAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umAddressDomain.setUserCode(userSession.getUserPcode());
        umAddressDomain.setUserName(userSession.getMerberCompname());
        umAddressDomain.setTenantCode(this.getTenantCode(request));
        this.exService.sendUserAdressToSap(umAddressDomain);
        return this.umAddressService.updateAddress(umAddressDomain);
    }

    @RequestMapping(value={"deleteAddress.json"}, name="\u5220\u9664\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAddress(HttpServletRequest request, Integer addressId) {
        if (StringUtils.isBlank((Integer)addressId)) {
            this.logger.error(CODE + ".deleteAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".deleteAddress", (Object)"UserSession is null");
            return null;
        }
        UmAddressReDomain umAddressReDomain = this.umAddressService.getAddress(addressId);
        if (null == umAddressReDomain) {
            return null;
        }
        return this.umAddressService.deleteAddress(addressId);
    }

    @RequestMapping(value={"queryAddressPage.json"}, name="\u67e5\u8be2\u7528\u6237\u5730\u5740\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmAddressReDomain> queryAddressPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umAddressService.queryAddressPage(param);
    }

    @RequestMapping(value={"updateAddressState.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAddressState(String addressId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)addressId)) {
            this.logger.error(CODE + ".updateAddressState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umAddressService.updateAddressState(Integer.valueOf(addressId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateAddressDefault.json"}, name="\u66f4\u65b0\u7528\u6237\u9ed8\u8ba4\u5730\u5740")
    @ResponseBody
    public HtmlJsonReBean updateAddressDefault(HttpServletRequest request, String addressCode) {
        if (StringUtils.isBlank((String)addressCode)) {
            this.logger.error(CODE + ".updateAddressDefault", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAddressDefault", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umAddressService.updateAddressDefault(userSession.getUserPcode(), addressCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"getDefAddress.json"}, name="\u83b7\u53d6\u7528\u6237\u9ed8\u8ba4\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public UmAddressReDomain getDefAddress(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getDefAddress", (Object)"UserSession is null");
            return null;
        }
        return this.umAddressService.getDefAddressBymerberCode(userSession.getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"queryAddressBymerberCode.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868")
    @ResponseBody
    public List<UmAddressReDomain> queryAddressBymerberCode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryAddressBymerberCode", (Object)"UserSession is null");
            return null;
        }
        userSession = this.getUserSessionByMemberBcode(request, userSession);
        return this.umAddressService.queryAddressBymerberCode(userSession.getUserCode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"queryAddressForUser.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868")
    @ResponseBody
    public List<UmAddressReDomain> queryAddressForUser(HttpServletRequest request, String userinfoCode) {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        return this.umAddressService.queryAddressBymerberCode(userinfoCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"saveAddressForUser.json"}, name="\u589e\u52a0\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAddressForUser(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".saveAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddressForUser", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umAddressDomain.setUserCode(userSession.getUserPcode());
        umAddressDomain.setUserName(userSession.getMerberCompname());
        umAddressDomain.setTenantCode(this.getTenantCode(request));
        return this.umAddressService.saveAddress(umAddressDomain);
    }

    @RequestMapping(value={"queryAmUserAddressByCode.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868(AM)")
    @ResponseBody
    public List<AmAddress> queryAmUserAddressByCode(HttpServletRequest request) {
        return this.umAddressService.queryAmUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"updateAmUserAddressByCode.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u5217\u8868(AM)")
    @ResponseBody
    public HtmlJsonReBean updateAmUserAddressByCode(HttpServletRequest request, String amAddressesStr) {
        List amAddresses = JsonUtil.buildNonDefaultBinder().getJsonToList(amAddressesStr, AmAddress.class);
        if (ListUtil.isEmpty((Collection)amAddresses)) {
            this.logger.error(CODE + ".saveAddressForUser", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6d4b\u8bd5\u9519\u8bef");
        }
        return this.umAddressService.updateAmUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request), amAddresses);
    }

    @RequestMapping(value={"getAmUserByCode.json"}, name="\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f(AM)")
    @ResponseBody
    public UmUserinfoDomain getAmUserByCode(HttpServletRequest request) {
        return this.umAddressService.getAmUserByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"queryUserAddressByCode.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868(address)")
    @ResponseBody
    public List<AmAddress> queryUserAddressByCode(HttpServletRequest request, String addressCode, String addressType) {
        return this.umAddressService.queryUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request), addressCode, addressType);
    }

    @RequestMapping(value={"updateUserAddressByCode.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u5217\u8868(address)")
    @ResponseBody
    public HtmlJsonReBean updateUserAddressByCode(HttpServletRequest request, String amAddressesStr) {
        List amAddresses = JsonUtil.buildNonDefaultBinder().getJsonToList(amAddressesStr, AmAddress.class);
        if (ListUtil.isEmpty((Collection)amAddresses)) {
            this.logger.error(CODE + ".amAddresses", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u683c\u5f0f\u9519\u8bef");
        }
        return this.umAddressService.updateUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request), amAddresses);
    }

    @RequestMapping(value={"deleteUserAddressByCode.json"}, name="\u751f\u4ea7\u5730\u5740\u5217\u8868(address)")
    @ResponseBody
    public HtmlJsonReBean deleteUserAddressByCode(HttpServletRequest request, String amAddressesStr) {
        List amAddresses = JsonUtil.buildNonDefaultBinder().getJsonToList(amAddressesStr, AmAddress.class);
        if (ListUtil.isEmpty((Collection)amAddresses)) {
            this.logger.error(CODE + ".amAddresses", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u683c\u5f0f\u9519\u8bef");
        }
        return this.umAddressService.deleteUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request), amAddresses);
    }

    @RequestMapping(value={"saveUserAddressByCode.json"}, name="\u65b0\u589e\u5730\u5740\u5217\u8868(address)")
    @ResponseBody
    public HtmlJsonReBean saveUserAddressByCode(HttpServletRequest request, String amAddressesStr) {
        List amAddresses = JsonUtil.buildNonDefaultBinder().getJsonToList(amAddressesStr, AmAddress.class);
        if (ListUtil.isEmpty((Collection)amAddresses)) {
            this.logger.error(CODE + ".amAddresses", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u683c\u5f0f\u9519\u8bef");
        }
        return this.umAddressService.saveUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request), amAddresses);
    }

    @Override
    public UserSession getUserSessionByMemberBcode(HttpServletRequest request, UserSession userSession) {
        String memberBcode;
        Map resultMap = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (Objects.nonNull(resultMap) && resultMap.get("memberBcode") != null && Objects.nonNull(memberBcode = resultMap.get("memberBcode").toString())) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        return userSession;
    }
}

