/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.appmanage;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.am.AmPparamDomain;
import cn.com.qj.bff.domain.am.AmPparamReDomain;
import cn.com.qj.bff.service.am.PinfoService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/pparam"})
public class PparamCon
extends SpringmvcController {
    private static String CODE = "am.pparam.con";
    @Autowired
    private PinfoService pinfoService;

    @Override
    protected String getContext() {
        return "pparam";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmPparamDomain amPparamDomain) {
        if (null == amPparamDomain) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoService.savePparam(amPparamDomain);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer pparamId, ModelMap modelMap) {
        modelMap.put((Object)"pparamReBean", (Object)this.getPparam(pparamId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmPparamDomain amPparamDomain) {
        if (null == amPparamDomain) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoService.updatePparam(amPparamDomain);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer pparamId) {
        if (StringUtils.isBlank((Integer)pparamId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoService.deletePparam(pparamId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer pparamId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)pparamId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pinfoService.updatePparamState(pparamId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer pparamId, ModelMap modelMap) {
        modelMap.put((Object)"pparamReBean", (Object)this.getPparam(pparamId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getPparam(Integer pparamId) {
        String rs = "{}";
        if (StringUtils.isBlank((Integer)pparamId)) {
            this.logger.error(CODE + ".getPparam", (Object)"pparamId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.pinfoService.getPparam(pparamId));
        }
        return rs;
    }

    @RequestMapping(value={"getPparam.json"})
    @ResponseBody
    public AmPparamReDomain getPparamFor(Integer pparamId) {
        if (StringUtils.isBlank((Integer)pparamId)) {
            this.logger.error(CODE + ".getPparamFor", (Object)"param is null");
            return null;
        }
        return this.pinfoService.getPparam(pparamId);
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map<String, Object> param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pinfoService.queryPparamPage(param);
    }

    @RequestMapping(value={"queryPparamLoadCache.json"}, name="Pparam\u52a0\u8f7dCACHE")
    @ResponseBody
    public HtmlJsonReBean queryPparamLoadCache() {
        return this.pinfoService.queryPinfoLoadCache();
    }
}

