/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.resources;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.fm.FmFileReDomainBean;
import cn.com.qj.bff.domain.rs.RsGoodsFileDomain;
import cn.com.qj.bff.domain.rs.RsGoodsFileReDomain;
import cn.com.qj.bff.service.fm.FileService;
import cn.com.qj.bff.service.rs.RsGoodsOtherService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/rs/goodsFile"}, name="\u5546\u54c1\u6587\u4ef6")
public class GoodsFileCon
extends SpringmvcController {
    private static String CODE = "rs.goodsFile.con";
    @Autowired
    private RsGoodsOtherService rsGoodsOtherService;
    @Autowired
    private FileService fileService;

    @Override
    protected String getContext() {
        return "goodsFile";
    }

    @RequestMapping(value={"uploadGoodsFile.json"}, name="\u4e0a\u4f20\u5546\u54c1\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFile(HttpServletRequest request, MultipartFile file, String fileSort) throws Exception {
        String filename;
        String prefix;
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFile", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String fileOwner = null;
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".uploadGoodsFile", (Object)"\u672a\u767b\u9646");
            return null;
        }
        fileOwner = "plat".equals(userSession.getUserinfoQuality()) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
        if (!(file == null || file.isEmpty() || (prefix = (filename = file.getOriginalFilename()).substring(filename.lastIndexOf(".") + 1)).equals("jpg") || prefix.equals("JPG") || prefix.equals("gif") || prefix.equals("GIF") || prefix.equals("png") || prefix.equals("PNG") || prefix.equals("jpeg") || prefix.equals("JPEG"))) {
            throw new Exception("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u53ea\u80fd\u4e3ajpg\u3001jpeg\uff0cgif\u3001png\uff0c\u73b0\u5728\u6587\u4ef6\u7c7b\u578b\u4e3a\uff1a" + prefix);
        }
        return this.fileService.saveFileO(file, tenantCode, fileSort, fileOwner);
    }

    @RequestMapping(value={"uploadGoodsFileImg.json"}, name="\u4e0a\u4f20\u5546\u54c1\u6587\u4ef6\uff08\u9650\u5236:\u56fe\u7247\uff09")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFileImg(HttpServletRequest request, MultipartFile file, String fileSort) throws Exception {
        String filename;
        String prefix;
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFile", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String fileOwner = null;
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".uploadGoodsFile", (Object)"\u672a\u767b\u9646");
            return null;
        }
        fileOwner = "plat".equals(userSession.getUserinfoQuality()) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
        if (!(file == null || file.isEmpty() || (prefix = (filename = file.getOriginalFilename()).substring(filename.lastIndexOf(".") + 1)).equals("jpg") || prefix.equals("JPG") || prefix.equals("gif") || prefix.equals("GIF") || prefix.equals("png") || prefix.equals("PNG"))) {
            throw new Exception("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u53ea\u80fd\u4e3ajpg\u3001gif\u3001png\uff0c\u73b0\u5728\u6587\u4ef6\u7c7b\u578b\u4e3a\uff1a" + prefix);
        }
        return this.fileService.saveFileO(file, tenantCode, fileSort, fileOwner);
    }

    @RequestMapping(value={"uploadGoodsFiles.json"}, name="\u4e0a\u4f20\u5546\u54c1\u6587\u4ef6(\u6539\u7248)")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFiles(HttpServletRequest request, MultipartFile file) {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFiles", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileService.saveFile(file, tenantCode, "FILE_GD");
    }

    @RequestMapping(value={"uploadGoodsFilesByChannelCode.json"}, name="\u4e0a\u4f20\u6e20\u9053\u5546\u54c1\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFilesByChannelCode(HttpServletRequest request, MultipartFile file, String channelCode) {
        if (null == file || StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".uploadGoodsFilesByChannelCode", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileService.saveFile(file, tenantCode, "FILE_" + channelCode);
    }

    @RequestMapping(value={"uploadGoodsFileFroAt.json"}, name="\u4e0a\u4f20\u5546\u54c1\u6587\u4ef6-\u7ade\u4ef7")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFileFroAt(HttpServletRequest request, MultipartFile file, String fileSort) {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFile", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileService.saveFile(file, tenantCode, fileSort);
    }

    @RequestMapping(value={"uploadGoodsFileForPaas.json"}, name="\u4e0a\u4f20\u5546\u54c1\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFileForPaas(HttpServletRequest request, MultipartFile file, String fileSort) {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFileForPaas", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileService.saveFile(file, tenantCode, fileSort);
    }

    @RequestMapping(value={"uploadGoodsFileForCms.json"}, name="\u4e0a\u4f20\u5546\u54c1\u6587\u4ef6Cms")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFileForCms(HttpServletRequest request, MultipartFile file, String fileSort) {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFileForCms", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileService.saveFile(file, tenantCode, fileSort);
    }

    @RequestMapping(value={"uploadGoodsFileForBus.json"}, name="\u4e0a\u4f20\u5546\u54c1\u6587\u4ef6Bus")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFileForBus(HttpServletRequest request, MultipartFile file, String fileSort) {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFileForBus", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileService.saveFile(file, tenantCode, fileSort);
    }

    @RequestMapping(value={"uploadGoodsFileFromBrand.json"}, name="\u4e0a\u4f20\u5546\u54c1\u6587\u4ef6-\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFileFromBrand(HttpServletRequest request, MultipartFile file, String fileSort) {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFileFromBrand", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileService.saveFile(file, tenantCode, fileSort);
    }

    @RequestMapping(value={"saveGoodsFile.json"}, name="\u589e\u52a0\u5546\u54c1\u6587\u4ef6")
    @ResponseBody
    public HtmlJsonReBean saveGoodsFile(HttpServletRequest request, RsGoodsFileDomain goodsFileDomain) {
        if (null == goodsFileDomain) {
            this.logger.error(CODE + ".saveGoodsFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        goodsFileDomain.setTenantCode(this.getTenantCode(request));
        return this.rsGoodsOtherService.saveGoodsFile(goodsFileDomain);
    }

    @RequestMapping(value={"getGoodsFile.json"}, name="\u83b7\u53d6\u5546\u54c1\u6587\u4ef6\u4fe1\u606f")
    @ResponseBody
    public RsGoodsFileDomain getGoodsFile(String goodsFileId) {
        if (StringUtils.isBlank((String)goodsFileId)) {
            this.logger.error(CODE + ".getGoodsFile", (Object)"param is null");
            return null;
        }
        return this.rsGoodsOtherService.getGoodsFile(Integer.valueOf(goodsFileId));
    }

    @RequestMapping(value={"updateGoodsFile.json"}, name="\u66f4\u65b0\u5546\u54c1\u6587\u4ef6")
    @ResponseBody
    public HtmlJsonReBean updateGoodsFile(HttpServletRequest request, RsGoodsFileDomain goodsFileDomain) {
        if (null == goodsFileDomain) {
            this.logger.error(CODE + ".updateGoodsFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        goodsFileDomain.setTenantCode(this.getTenantCode(request));
        return this.rsGoodsOtherService.updateGoodsFile(goodsFileDomain);
    }

    @RequestMapping(value={"deleteGoodsFile.json"}, name="\u5220\u9664\u5546\u54c1\u6587\u4ef6")
    @ResponseBody
    public HtmlJsonReBean deleteGoodsFile(String goodsFileId) {
        if (StringUtils.isBlank((String)goodsFileId)) {
            this.logger.error(CODE + ".deleteGoodsFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsOtherService.deleteGoodsFile(Integer.valueOf(goodsFileId));
    }

    @RequestMapping(value={"queryGoodsFilePage.json"}, name="\u67e5\u8be2\u5546\u54c1\u6587\u4ef6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsGoodsFileReDomain> queryGoodsFilePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            String exportFuzzy = null == param || null == param.get("exportFuzzy") ? "false" : (String)param.get("exportFuzzy");
            Boolean flagStr = Boolean.valueOf(exportFuzzy);
            if (flagStr.booleanValue()) {
                param.put("fuzzy", true);
            }
        }
        return this.rsGoodsOtherService.queryGoodsFilePage(param);
    }

    @RequestMapping(value={"updateGoodsFileState.json"}, name="\u66f4\u65b0\u5546\u54c1\u6587\u4ef6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGoodsFileState(String goodsFileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsFileId)) {
            this.logger.error(CODE + ".updateGoodsFileState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsOtherService.updateGoodsFileState(Integer.valueOf(goodsFileId), dataState, oldDataState);
    }

    @RequestMapping(value={"addGoodsFiles.json"}, name="\u6279\u91cf\u6dfb\u52a0\u5546\u54c1\u6587\u4ef6")
    @ResponseBody
    public HtmlJsonReBean saveGoodsFiles(HttpServletRequest request, String paramStr, String paramGoods) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List goodsList = JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, RsGoodsFileDomain.class);
        List goods = JsonUtil.buildNonDefaultBinder().getJsonToList(paramGoods, RsGoodsFileDomain.class);
        if (goodsList == null) {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "goods is null");
        }
        for (RsGoodsFileDomain RsResourceGoods : goodsList) {
            RsResourceGoods.setTenantCode(tenantCode);
        }
        for (RsGoodsFileDomain RsResourceGoods : goods) {
            RsResourceGoods.setTenantCode(tenantCode);
        }
        this.rsGoodsOtherService.saveGoodsFiles(goodsList);
        this.rsGoodsOtherService.saveGoodsFile(goods);
        return new HtmlJsonReBean();
    }

    public static void main(String[] args) {
        String base64DataStr = "data:image/png;base64,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";
        String prefix = base64DataStr.substring(5, base64DataStr.indexOf(";base64,"));
        System.out.println(prefix);
        System.out.println(prefix.substring(prefix.indexOf("/") + 1));
    }

    @RequestMapping(value={"uploadGoodsFileByBase64.json"}, name="\u901a\u8fc7base64\u4e0a\u4f20\u5546\u54c1\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFileByBase64(HttpServletRequest request, String base64DataStr, String fileSort, String fileName) throws Exception {
        MockMultipartFile file;
        if (StringUtils.isBlank((String)base64DataStr)) {
            this.logger.error(CODE + ".uploadGoodsFileByBase64", (Object)"param is null");
            return null;
        }
        String prefix = base64DataStr.substring(5, base64DataStr.indexOf(";base64,"));
        prefix = prefix.substring(prefix.indexOf("/") + 1);
        byte[] fileS = Base64.decodeBase64((String)(base64DataStr = base64DataStr.replaceAll(" ", "+").substring(base64DataStr.indexOf(";base64,") + 8)));
        if (null == fileS) {
            this.logger.error(CODE + ".uploadGoodsFileByBase64.error", (Object)"data is error");
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fileS);
        if (StringUtils.isBlank((String)fileName)) {
            fileName = this.createUUIDString() + "." + prefix;
        }
        if ((file = new MockMultipartFile(ContentType.APPLICATION_OCTET_STREAM.toString(), fileName, null, (InputStream)inputStream)) == null || file.isEmpty()) {
            this.logger.error(CODE + ".uploadGoodsFileByBase64.flie", (Object)"file is error");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String fileOwner = null;
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".uploadGoodsFile", (Object)"\u672a\u767b\u9646");
            return null;
        }
        fileOwner = "plat".equals(userSession.getUserinfoQuality()) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
        if (fileName.lastIndexOf(".") > 0) {
            prefix = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        if (!(!StringUtils.isNotBlank((String)prefix) || prefix.equals("jpg") || prefix.equals("JPG") || prefix.equals("gif") || prefix.equals("GIF") || prefix.equals("png") || prefix.equals("PNG") || prefix.equals("jpeg") || prefix.equals("JPEG"))) {
            throw new Exception("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u53ea\u80fd\u4e3ajpg\u3001jpeg\uff0cgif\u3001png\uff0c\u73b0\u5728\u6587\u4ef6\u7c7b\u578b\u4e3a\uff1a" + prefix);
        }
        return this.fileService.saveFileO((MultipartFile)file, tenantCode, fileSort, fileOwner);
    }
}

