/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.controller.order.OrderConstants;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.ct.CtCustrelReDomain;
import cn.com.qj.bff.domain.oc.GoodsBean;
import cn.com.qj.bff.domain.oc.GoodsNumDomain;
import cn.com.qj.bff.domain.oc.OcNvrReDomain;
import cn.com.qj.bff.domain.oc.OcShoppingDomain;
import cn.com.qj.bff.domain.oc.OcShoppingGoodsDTO;
import cn.com.qj.bff.domain.oc.OcShoppingGoodsDomain;
import cn.com.qj.bff.domain.oc.OcShoppingGoodsReDomain;
import cn.com.qj.bff.domain.oc.OcShoppingReDomain;
import cn.com.qj.bff.domain.oc.OcShoppingpackgeDomain;
import cn.com.qj.bff.domain.oc.TypeBean;
import cn.com.qj.bff.domain.org.OrgEmployeeReDomain;
import cn.com.qj.bff.domain.org.OrgUserBean;
import cn.com.qj.bff.domain.pm.PmCheckBean;
import cn.com.qj.bff.domain.pm.PmPromotionInDomain;
import cn.com.qj.bff.domain.pm.PmPromotionRangelistDomain;
import cn.com.qj.bff.domain.pm.PromotionConstants;
import cn.com.qj.bff.domain.pm.PromotionForOcReDomain;
import cn.com.qj.bff.domain.rs.RsClasstreeReDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.um.UmGroupListReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.domain.wl.WlFreightExpReDomain;
import cn.com.qj.bff.domain.wl.WlFreightExpallReDomain;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.service.ct.CtCustrelService;
import cn.com.qj.bff.service.es.SearchengineService;
import cn.com.qj.bff.service.oc.OcConstants;
import cn.com.qj.bff.service.oc.OcNvrService;
import cn.com.qj.bff.service.oc.OcShoppingService;
import cn.com.qj.bff.service.org.OrgCompanyService;
import cn.com.qj.bff.service.org.OrgEmployeeService;
import cn.com.qj.bff.service.pm.PmPromotionService;
import cn.com.qj.bff.service.rs.RsClasstreeService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.um.UmGroupService;
import cn.com.qj.bff.service.um.UmQualityQtypeSkuService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.service.upm.UpmUpointsService;
import cn.com.qj.bff.service.wl.WlFreightTemService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class ShoppingComCon
extends SpringmvcController {
    private static String CODE = "oc.shoppingcom.con";
    @Autowired
    private OrgCompanyService orgCompanyService;
    @Autowired
    private OrgEmployeeService orgEmployeeService;
    @Autowired
    private OcShoppingService ocShoppingService;
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private PmPromotionService pmPromotionService;
    @Autowired
    private CtCustrelService ctCustrelService;
    @Autowired
    private UpmUpointsService upmUpointsService;
    @Autowired
    private OcNvrService ocNvrService;
    @Autowired
    private UmQualityQtypeSkuService umQualityQtypeSkuService;
    @Autowired
    private UserService userService;
    @Autowired
    private WlFreightTemService wlFreightTemService;
    @Autowired
    private RsClasstreeService rsClasstreeService;
    @Autowired
    private SearchengineService searchengineService;
    @Autowired
    UmGroupService umGroupService;

    @Override
    protected String getContext() {
        return "shoppingcom";
    }

    public RsSkuReDomain getRsByNo(String skuNo, String memberCcode, String channelCode, String tenantCode, String goodsType) {
        SupQueryResult<RsSkuReDomain> qrs = this.rsSkuService.querySkuOnePage(this.getQueryMapParam("skuNo,memberCcode,channelCode,tenantCode,goodsType", skuNo, memberCcode, channelCode, tenantCode, goodsType));
        if (null == qrs || ListUtil.isEmpty((Collection)qrs.getList())) {
            return null;
        }
        if (StringUtils.isBlank((String)goodsType)) {
            for (RsSkuReDomain rsSkuReDomain : qrs.getList()) {
                if ("24".equals(rsSkuReDomain.getGoodsType()) || "25".equals(rsSkuReDomain.getGoodsType()) || "26".equals(rsSkuReDomain.getGoodsType()) || "27".equals(rsSkuReDomain.getGoodsType()) || "28".equals(rsSkuReDomain.getGoodsType()) || "29".equals(rsSkuReDomain.getGoodsType())) continue;
                return rsSkuReDomain;
            }
        }
        return (RsSkuReDomain)qrs.getList().get(0);
    }

    public List<RsSkuReDomain> getRsByNo(Map<String, Object> map) {
        SupQueryResult<RsSkuReDomain> rsSkuReDomainSupQueryResult = this.rsSkuService.querySkuPage(map);
        if (ListUtil.isNotEmpty((Collection)rsSkuReDomainSupQueryResult.getList())) {
            return rsSkuReDomainSupQueryResult.getList();
        }
        return null;
    }

    public List<RsSkuReDomain> findRsSkuByNo(String skuNoStr, String channelCode, String tenantCode) {
        return this.searchengineService.findReSkuListBySkuNo(skuNoStr, channelCode, tenantCode);
    }

    public RsSkuReDomain getRsByCode(String skuCode, String tenantCode) {
        RsSkuReDomain rsSkuReDomain = this.rsSkuService.getSkuByCode(this.getQueryMapParam("skuCode,tenantCode", skuCode, tenantCode));
        return rsSkuReDomain;
    }

    public String getEmp(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        SupQueryResult<OrgEmployeeReDomain> qemp = this.orgEmployeeService.queryEmployeePage(this.getQueryMapParam("userCode,userinfoCode,tenantCode", userSession.getUserCode(), userSession.getUserPcode(), userSession.getTenantCode()));
        if (null == qemp || ListUtil.isEmpty((Collection)qemp.getList())) {
            return null;
        }
        return ((OrgEmployeeReDomain)qemp.getList().get(0)).getEmployeeCode();
    }

    public HtmlJsonReBean saveShoppingCom(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveShoppingCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingService.saveShopping(ocShoppingDomain);
    }

    public OcShoppingReDomain getShoppingCom(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".getShoppingCom", (Object)"param is null");
            return null;
        }
        return this.ocShoppingService.getShopping(Integer.valueOf(shoppingId));
    }

    public HtmlJsonReBean updateShoppingCom(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".updateShoppingCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingService.updateShopping(ocShoppingDomain);
    }

    public HtmlJsonReBean deleteShoppingCom(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".deleteShoppingCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] shoppingIdS = shoppingId.split(",");
        if (null == shoppingIdS || shoppingIdS.length <= 0) {
            this.logger.error(CODE + ".deleteShopping1", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (int i = 0; i < shoppingIdS.length; ++i) {
            htmlJsonReBean = this.ocShoppingService.deleteShopping(Integer.valueOf(shoppingIdS[i]));
        }
        return htmlJsonReBean;
    }

    public SupQueryResult<Integer> wishListsCom(HttpServletRequest request, Map<String, Object> param) {
        SupQueryResult number = new SupQueryResult();
        SupQueryResult<OcShoppingGoodsReDomain> ocShoppingGoodsReDomainSupQueryResult = this.ocShoppingService.queryShoppingGoodsPage(param);
        if (null == ocShoppingGoodsReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingGoodsReDomainSupQueryResult.getList())) {
            number.setTotal(0L);
            return number;
        }
        number.setTotal(ocShoppingGoodsReDomainSupQueryResult.getTotal());
        return number;
    }

    public SupQueryResult<Integer> shoppingListCom(HttpServletRequest request, Map<String, Object> param) {
        SupQueryResult number = new SupQueryResult();
        SupQueryResult<OcShoppingGoodsReDomain> ocShoppingGoodsReDomainSupQueryResult = this.ocShoppingService.queryShoppingGoodsPage(param);
        if (null == ocShoppingGoodsReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingGoodsReDomainSupQueryResult.getList())) {
            number.setTotal(0L);
            return number;
        }
        number.setTotal(ocShoppingGoodsReDomainSupQueryResult.getTotal());
        return number;
    }

    public SupQueryResult<OcShoppingReDomain> queryShoppingPageCom(HttpServletRequest request, Map<String, Object> param, String memberBcode) {
        return this.queryShopping(request, param, memberBcode);
    }

    public SupQueryResult<OcShoppingReDomain> queryShoppingPageComNew(HttpServletRequest request, Map<String, Object> param, String memberBcode) {
        return this.queryShoppingNew(request, param, memberBcode);
    }

    protected PmCheckBean getPmCheckBean(HttpServletRequest request, UserSession userSession, String contractPmode) {
        if (null == request) {
            return null;
        }
        String userPhone = "";
        if (null != userSession) {
            userPhone = userSession.getUserPhone();
        }
        return this.ocShoppingService.getPmCheckBean(BaseInterUtil.getChannelCode((HttpServletRequest)request), this.getProappCode(request), this.getTenantCode(request), null == userSession ? null : userSession.getUserPcode(), null == userSession ? null : userSession.getMerberCompname(), null == userSession ? null : userSession.getUserCode(), contractPmode, userPhone);
    }

    private SupQueryResult<OcShoppingReDomain> queryShopping(HttpServletRequest request, Map<String, Object> param, String memberBcode) {
        HashMap<String, String> fcodeMap;
        SupQueryResult<OcShoppingReDomain> ocShoppingReDomainSupQueryResult;
        UserSession userSession = this.getUserSession(request);
        String areaCode = null;
        String cityCode = null;
        String provinceCode = null;
        String rodeCode = null;
        if (param.get("roadCode") != null) {
            rodeCode = param.get("roadCode").toString();
            param.remove("roadCode");
        }
        if (param.get("areaCode") != null) {
            areaCode = param.get("areaCode").toString();
            param.remove("areaCode");
        }
        if (param.get("cityCode") != null) {
            cityCode = param.get("cityCode").toString();
            param.remove("cityCode");
        }
        if (param.get("provinceCode") != null) {
            provinceCode = param.get("provinceCode").toString();
            param.remove("provinceCode");
        }
        if (null == userSession) {
            this.logger.error("EXCEPTION:" + CODE + ".queryShopping.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        if (null == (ocShoppingReDomainSupQueryResult = this.ocShoppingService.queryShoppingPage(param, fcodeMap = new HashMap<String, String>())) || ListUtil.isEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryShopping.", (Object)("ocShoppingReDomainSupQueryResult is null" + param));
            return null;
        }
        List<OcShoppingReDomain> ocShoppingReDomainList = ocShoppingReDomainSupQueryResult.getList();
        PmCheckBean pmCheckBean = this.getPmCheckBean(request, userSession, (String)param.get("contractPmode"));
        if (StringUtils.isNotBlank((String)areaCode) || StringUtils.isNotBlank((String)cityCode) || StringUtils.isNotBlank((String)provinceCode)) {
            try {
                this.checkOcShoppingAddressRange(ocShoppingReDomainSupQueryResult.getList(), areaCode, cityCode, provinceCode, rodeCode, userSession.getTenantCode(), fcodeMap);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".checkOcShoppingAddressRange =====\u6821\u9a8c\u914d\u9001\u8303\u56f4.ex=====", (Throwable)e);
            }
        }
        ocShoppingReDomainList = ocShoppingReDomainSupQueryResult.getList();
        if (null != param.get("notCheck") && "false".equals(param.get("notCheck"))) {
            this.checkOcShoppingState(ocShoppingReDomainList, this.getTenantCode(request), this.getMerchantCode(request));
        }
        if (null == param.get("noCheckPm")) {
            ocShoppingReDomainList = this.ocShoppingService.checkPromotionForShoppingList(ocShoppingReDomainList, pmCheckBean);
        }
        ocShoppingReDomainSupQueryResult.setRows((List)ocShoppingReDomainList);
        this.logger.error("queryShoppingPage.ocShoppingReDomainList2", (Object)JsonUtil.buildNormalBinder().toJson(ocShoppingReDomainList));
        if (ListUtil.isNotEmpty(ocShoppingReDomainList)) {
            for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
                if (!ListUtil.isNotEmpty(ocShoppingReDomain.getShoppingpackageList())) continue;
                for (OcShoppingpackgeDomain ocShoppingpackgeDomain : ocShoppingReDomain.getShoppingpackageList()) {
                    BigDecimal sumMoney = BigDecimal.ZERO;
                    BigDecimal sunNum = BigDecimal.ZERO;
                    if (ListUtil.isNotEmpty(ocShoppingpackgeDomain.getShoppingGoodsList())) {
                        for (OcShoppingGoodsDomain ocShoppingGoodsDomain : ocShoppingpackgeDomain.getShoppingGoodsList()) {
                            if (ocShoppingGoodsDomain.getShoppingGoodsCheck() != null && 0 != ocShoppingGoodsDomain.getShoppingGoodsCheck()) continue;
                            sumMoney = sumMoney.add(ocShoppingGoodsDomain.getPricesetNprice().multiply(ocShoppingGoodsDomain.getGoodsCamount()));
                            sunNum = sunNum.add(ocShoppingGoodsDomain.getGoodsCamount());
                        }
                    }
                    ocShoppingpackgeDomain.setSumMoney(sumMoney);
                    ocShoppingpackgeDomain.setSumNum(sunNum);
                }
            }
            ocShoppingReDomainSupQueryResult.setRows(ocShoppingReDomainList);
        }
        this.logger.error("queryShoppingPage.ocShoppingReDomainList3", (Object)JsonUtil.buildNormalBinder().toJson(ocShoppingReDomainList));
        return ocShoppingReDomainSupQueryResult;
    }

    private void checkOcShoppingAddressRange(List<OcShoppingReDomain> ocShoppingReDomainList, String areaCode, String cityCode, String provinceCode, String rodeCode, String tenantCode) {
        Long dateStart = System.currentTimeMillis();
        HashMap<String, Object> freightMap = new HashMap<String, Object>();
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
                    if (this.checkGoodsAddressRangeNew(ocShoppingGoodsDomain.getFreightTemCode(), areaCode, cityCode, provinceCode, rodeCode, tenantCode, freightMap)) {
                        ocShoppingGoodsDomain.setFlagAddressRange(OrderConstants.FLAG_ADDRESS_RANGE_0);
                        continue;
                    }
                    ocShoppingGoodsDomain.setFlagAddressRange(OrderConstants.FLAG_ADDRESS_RANGE_1);
                }
            }
        }
    }

    private void checkOcShoppingAddressRange(List<OcShoppingReDomain> ocShoppingReDomainList, String areaCode, String cityCode, String provinceCode, String rodeCode, String tenantCode, Map<String, String> fcode) {
        this.logger.error(CODE + ".checkOcShoppingAddressRange =====\u6821\u9a8c\u914d\u9001\u8303\u56f4=====", (Object)("areaCode:" + areaCode));
        Long dateStart = System.currentTimeMillis();
        if (MapUtil.isEmpty(fcode)) {
            fcode = new HashMap<String, String>();
        }
        HashMap<String, Object> freightMap = new HashMap<String, Object>();
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
                    if (this.checkGoodsAddressRangeNew(fcode.get(ocShoppingGoodsDomain.getSkuCode()), areaCode, cityCode, provinceCode, rodeCode, tenantCode, freightMap)) {
                        ocShoppingGoodsDomain.setFlagAddressRange(OrderConstants.FLAG_ADDRESS_RANGE_0);
                        continue;
                    }
                    ocShoppingGoodsDomain.setFlagAddressRange(OrderConstants.FLAG_ADDRESS_RANGE_1);
                }
            }
        }
        this.logger.error(CODE + ".checkOcShoppingAddressRange =====\u6821\u9a8c\u914d\u9001\u8303\u56f4.time:=====", (Object)(System.currentTimeMillis() - dateStart));
    }

    private SupQueryResult<OcShoppingReDomain> queryShoppingNew(HttpServletRequest request, Map<String, Object> param, String memberBcode) {
        SupQueryResult<OcShoppingReDomain> ocShoppingReDomainSupQueryResult;
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryShopping.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        if (null == (ocShoppingReDomainSupQueryResult = this.ocShoppingService.queryShoppingPage(param)) || ListUtil.isEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryShopping.", (Object)("ocShoppingReDomainSupQueryResult is null" + param));
            return null;
        }
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainSupQueryResult.getList()) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                this.makeShowShoppingDomainListNew(shoppingpackage, userSession);
            }
        }
        TypeBean typeBean = this.ocShoppingService.getOcSetting(((OcShoppingReDomain)ocShoppingReDomainSupQueryResult.getList().get(0)).getShoppingType(), tenantCode, null, "BBC", null);
        List<OcShoppingReDomain> ocShoppingReDomainList = ocShoppingReDomainSupQueryResult.getList();
        if (this.ocShoppingService.checkPm(typeBean)) {
            PmCheckBean pmCheckBean = this.getPmCheckBean(request, userSession, (String)param.get("contractPmode"));
            ocShoppingReDomainList = this.ocShoppingService.checkPromotionForShoppingList(ocShoppingReDomainList, pmCheckBean);
            ocShoppingReDomainSupQueryResult.setRows(ocShoppingReDomainList);
        }
        this.makeOcShoppingReDomain(ocShoppingReDomainSupQueryResult.getList(), userSession);
        return ocShoppingReDomainSupQueryResult;
    }

    private void makeOcShoppingSoReDomain(List<OcShoppingReDomain> ocShoppingReDomainList, String memberCode) {
        if (ListUtil.isNotEmpty(ocShoppingReDomainList)) {
            for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
                if (!ListUtil.isNotEmpty(ocShoppingReDomain.getShoppingpackageList())) continue;
                for (OcShoppingpackgeDomain ocShoppingpackgeDomain : ocShoppingReDomain.getShoppingpackageList()) {
                    if (!ocShoppingpackgeDomain.getPbCode().equals("0022")) continue;
                    List<OcShoppingGoodsDomain> shoppingGoodsList = ocShoppingpackgeDomain.getShoppingGoodsList();
                    for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingGoodsList) {
                        this.ocShoppingService.updateShoppingGoodsListCheckState(memberCode, ocShoppingReDomain.getShoppingCode(), ocShoppingGoodsDomain.getShoppingGoodsId().toString(), 1);
                        ocShoppingGoodsDomain.setShoppingGoodsCheck(1);
                    }
                }
            }
        }
    }

    private void checkOcShoppingState(List<OcShoppingReDomain> ocShoppingReDomainList, String tenantCode, String memberCode) {
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            if (StringUtils.isBlank((String)ocShoppingReDomain.getShoppingCode())) continue;
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                if (!ListUtil.isNotEmpty(shoppingpackage.getShoppingGoodsList())) continue;
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
                    if (null == ocShoppingGoodsDomain || !StringUtils.isNotBlank((String)ocShoppingGoodsDomain.getShoppingCode())) continue;
                    if ("1".equals(ocShoppingGoodsDomain.getFlagAddressRange())) {
                        ocShoppingGoodsDomain.setShoppingGoodsCheck(1);
                    }
                    if (0 == ocShoppingGoodsDomain.getDataState()) continue;
                    ocShoppingGoodsDomain.setShoppingGoodsCheck(1);
                }
            }
        }
    }

    private void makeOcShoppingReDomain(List<OcShoppingReDomain> ocShoppingReDomainList, UserSession userSession) {
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                this.makeShoppingDomainList(shoppingpackage, userSession);
            }
        }
    }

    private void makeShowShoppingDomainList(OcShoppingpackgeDomain shoppingpackage, UserSession userSession) {
        List objmapList = JsonUtil.buildNormalBinder().getJsonToListByMap(JsonUtil.buildNormalBinder().toJson(shoppingpackage.getShoppingGoodsList()), Object.class);
        List<Map<String, Object>> list = this.rsResourceGoodsService.getShoppGoodMemPriceReBean(objmapList, userSession, shoppingpackage.getChannelCode(), shoppingpackage.getTenantCode());
        if (ListUtil.isEmpty(list)) {
            return;
        }
        List rsShoppingDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(list), OcShoppingGoodsDomain.class);
        if (ListUtil.isNotEmpty((Collection)rsShoppingDomainList)) {
            shoppingpackage.setShoppingGoodsList(rsShoppingDomainList);
        }
    }

    private void makeShoppingDomainList(OcShoppingpackgeDomain shoppingpackage, UserSession userSession) {
        shoppingpackage.setSumMoney(BigDecimal.ZERO);
        shoppingpackage.setSumNum(BigDecimal.ZERO);
        shoppingpackage.setSumWeight(BigDecimal.ZERO);
        shoppingpackage.setSumRefMoney(BigDecimal.ZERO);
        for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
            if (null == ocShoppingGoodsDomain.getGoodsCamount()) {
                ocShoppingGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            if (null == ocShoppingGoodsDomain.getGoodsCweight()) {
                ocShoppingGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
            }
            if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                ocShoppingGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            if (null != ocShoppingGoodsDomain.getShoppingGoodsCheck() && 0 != ocShoppingGoodsDomain.getShoppingGoodsCheck()) continue;
            shoppingpackage.setSumMoney(shoppingpackage.getSumMoney().add(ocShoppingGoodsDomain.getPricesetNprice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
            shoppingpackage.setSumNum(shoppingpackage.getSumNum().add(ocShoppingGoodsDomain.getGoodsCamount()));
            shoppingpackage.setSumWeight(shoppingpackage.getSumWeight().add(ocShoppingGoodsDomain.getGoodsCweight()));
            shoppingpackage.setSumRefMoney(shoppingpackage.getSumRefMoney().add(ocShoppingGoodsDomain.getPricesetRefrice().multiply(ocShoppingGoodsDomain.getGoodsCamount())));
        }
    }

    public HtmlJsonReBean updateShoppingGoodsPmInfoCom(HttpServletRequest request, String shoppingGoodsId, String promotionCode) {
        if (StringUtils.isBlank((String)shoppingGoodsId) || StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".updateShoppingGoodsPmInfo", (Object)" param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.ocShoppingService.updateShoppingGoodsPmInfo(Integer.valueOf(shoppingGoodsId), promotionCode);
    }

    public HtmlJsonReBean updateShoppingGoodsCheckStateCom(HttpServletRequest request, String shoppingGoodsIdStr, String shoppingCode, Integer checkState) {
        String[] shoppingGoodsIdS;
        String memberCode = this.getMerchantCode(request);
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".updateShoppingGoodsCheckStateCom", (Object)" shoppingGoodsIdStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        for (String shoppingGoodsId : shoppingGoodsIdS = shoppingGoodsIdStr.split("\\,")) {
            OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.ocShoppingService.getShoppingGoods(Integer.valueOf(shoppingGoodsId));
            if (null == ocShoppingGoodsReDomain) {
                this.logger.error(CODE + ".updateShoppingGoodsCheckStateCom.shoppingGoodsId", (Object)shoppingGoodsId);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "error");
            }
            if (memberCode.equals(ocShoppingGoodsReDomain.getMemberBcode())) continue;
            this.logger.error(CODE + ".updateShoppingGoodsCheckStateCom.memberCode", (Object)(shoppingGoodsId + "=" + memberCode + "=" + ocShoppingGoodsReDomain.getMemberBcode()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f\u6709\u8bef");
        }
        return this.ocShoppingService.updateShoppingGoodsListCheckState(memberCode, shoppingCode, shoppingGoodsIdStr, checkState);
    }

    public HtmlJsonReBean updateShoppingGoodsCheckStateComCrm(HttpServletRequest request, String shoppingGoodsIdStr, String shoppingCode, Integer checkState) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param.get("memberBcode")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "memberBcod\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String memberCode = param.get("memberBcode").toString();
        return this.ocShoppingService.updateShoppingGoodsListCheckState(memberCode, shoppingCode, shoppingGoodsIdStr, checkState);
    }

    public HtmlJsonReBean updateShoppingGoodsNumCom(HttpServletRequest request, Integer shoppingGoodsId, BigDecimal amount, BigDecimal goodWeight) {
        if (StringUtils.isBlank((Integer)shoppingGoodsId) || null == amount && null == goodWeight) {
            this.logger.error("EXCEPTION:" + CODE + ".updateShoppingGoodsNum.param", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingService.updateShoppingGoodsNum(shoppingGoodsId, amount, goodWeight);
    }

    public HtmlJsonReBean updateShoppingGoodsNumComByCode(String shoppingGoodsCode, BigDecimal amount, BigDecimal goodWeight, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode) || null == amount && null == goodWeight || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("EXCEPTION:" + CODE + ".updateShoppingGoodsNumComByCode.param", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingService.updateShoppingGoodsNumByCode(shoppingGoodsCode, amount, goodWeight, tenantCode);
    }

    public HtmlJsonReBean updateShoppingGoodsNumByCodeAndCheckLimit(String shoppingGoodsCode, BigDecimal amount, BigDecimal goodWeight, String tenantCode, Integer countsLimit) {
        if (StringUtils.isBlank((String)tenantCode) || null == amount && null == goodWeight || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("EXCEPTION:" + CODE + ".updateShoppingGoodsNumByCodeAndCheckLimit.param", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingService.updateShoppingGoodsNumByCodeAndCheckLimit(shoppingGoodsCode, amount, goodWeight, tenantCode, countsLimit);
    }

    public HtmlJsonReBean updateShoppingStateCom(String shoppingId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".updateShoppingState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingService.updateShoppingState(Integer.valueOf(shoppingId), dataState, oldDataState);
    }

    public HtmlJsonReBean saveContractByOcShoppingCom(HttpServletRequest request, OcShoppingDomain ocShoppingDomain, String contractTypepro) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveContractByOcShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingService.saveContractByOcShopping(ocShoppingDomain, contractTypepro);
    }

    public HtmlJsonReBean insertShoppingGoodsCom(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".insertShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".insertShoppingGoods", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)ocShoppingGoodsDomain.getMemberBcode())) {
            ocShoppingGoodsDomain.setMemberBcode(userSession.getUserPcode());
            ocShoppingGoodsDomain.setMemberBname(userSession.getMerberCompname());
        }
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingService.insertShoppingGoods(ocShoppingGoodsDomain);
    }

    public HtmlJsonReBean addShoppingGoodsBySpecCom(HttpServletRequest request, String goodsCode, String specStr, String memberBcode) {
        List spcList;
        RsSkuReDomain rsSkuReDomain;
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(CODE + ".addShoppingGoodsBySpecCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        if (null == (rsSkuReDomain = this.rsSkuService.getSkuBySpec(spcList = JsonUtil.buildNormalBinder().getJsonToList(specStr, String.class), goodsCode, tenantCode))) {
            this.logger.error(CODE + ".addShoppingGoodsBySpecCom", (Object)(specStr.toString() + "-" + goodsCode + "-" + tenantCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
        }
        if (null != userSession && rsSkuReDomain.getMemberCode().equals(userSession.getUserPcode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u80fd\u8d2d\u4e70\u81ea\u5df1\u5546\u54c1");
        }
        if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().subtract(new BigDecimal(1)).intValue() < 0) {
            this.logger.error(CODE + ".addShoppingGoodsBySpecCom", (Object)(specStr.toString() + "-" + goodsCode + "-" + tenantCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff01");
        }
        rsSkuReDomain = this.rsSkuService.getSkuMemPriceReBean(rsSkuReDomain, userSession, rsSkuReDomain.getChannelCode(), rsSkuReDomain.getTenantCode());
        return new HtmlJsonReBean((Object)rsSkuReDomain);
    }

    protected HtmlJsonReBean saveShopping(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, UserSession userSession, OrgUserBean orgUserBean) {
        if (null == skuId) {
            this.logger.error("EXCEPTION:" + CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        if (null == userSession) {
            this.logger.error("EXCEPTION:" + CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (!ShoppingComCon.isIntegerValue(goodsNum)) {
            this.logger.error("EXCEPTION:" + CODE + ".saveShopping.goodsNum", (Object)goodsNum);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u662f\u4e3a\u5c0f\u6570");
        }
        String channelCode = this.getNowChannel(request);
        if (StringUtils.isBlank((String)channelCode)) {
            Map<String, Object> param = this.assemMapParam(request);
            channelCode = param.get("channelCode") + "";
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(channelCode);
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuId(skuId);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        ArrayList<GoodsBean> goodsBeanList = new ArrayList<GoodsBean>();
        goodsBeanList.add(goodsBean);
        return this.saveShoppingBean(request, goodsBeanList, userSession, orgUserBean);
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        boolean ret;
        try {
            bd.toBigIntegerExact();
            ret = true;
        }
        catch (ArithmeticException ex) {
            ret = false;
        }
        return ret;
    }

    protected HtmlJsonReBean saveShoppings(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, UserSession userSession, OrgUserBean orgUserBean) {
        if (null == skuId) {
            this.logger.error(CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        if (null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(this.getNowChannel(request));
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuId(skuId);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        ArrayList<GoodsBean> goodsBeanList = new ArrayList<GoodsBean>();
        goodsBeanList.add(goodsBean);
        return this.saveShoppingBean(request, goodsBeanList, userSession, orgUserBean);
    }

    private HtmlJsonReBean saveShoppingBean(HttpServletRequest request, List<GoodsBean> goodsBeanList, UserSession userSession, OrgUserBean orgUserBean) {
        if (ListUtil.isEmpty(goodsBeanList) || null == userSession) {
            this.logger.error("EXCEPTION:" + CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        ArrayList<OcShoppingGoodsDomain> shoppingGoodsList = new ArrayList<OcShoppingGoodsDomain>();
        try {
            for (GoodsBean goodsBean : goodsBeanList) {
                OcShoppingGoodsDomain ocShoppingGoodsDomain = this.ocShoppingService.createShoppingGoodsDomain(userSession, goodsBean, orgUserBean, "shop");
                if (null == ocShoppingGoodsDomain) {
                    this.logger.error("EXCEPTION:" + CODE + ".saveShopping", (Object)"ocShoppingGoodsDomain is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u6570\u636e\u5f02\u5e38\uff01");
                }
                shoppingGoodsList.add(ocShoppingGoodsDomain);
                if (ocShoppingGoodsDomain.getFlagAddCar() == null || OcConstants.FLAG_ADD_CAR_1.intValue() != ocShoppingGoodsDomain.getFlagAddCar().intValue()) continue;
                this.logger.error("EXCEPTION:" + CODE + ".createShoppingGoodsDomain =====\u4e0d\u53ef\u52a0\u5165\u8d2d\u7269\u8f66=====", (Object)("goodsCode:" + ocShoppingGoodsDomain.getSkuNo()));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u53ef\u52a0\u5165\u8d2d\u7269\u8f66\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error("EXCEPTION:" + CODE + ".saveShopping.ex", (Throwable)e);
            return new HtmlJsonReBean(CODE + ".saveContract.ex", e.getMessage());
        }
        return this.saveShoppingDomain(request, shoppingGoodsList);
    }

    public boolean checkUserGoodsLimitNumBySku(String tenantCode, Integer skuId, Integer goodsNum, String memberBcode) {
        this.logger.error(CODE + ".checkUserGoodsLimitNumBySku =====\u6821\u9a8c\u5546\u54c1\u9650\u8d2d\u6570\u91cf=====");
        try {
            RsSkuReDomain rsSkuReDomain = this.rsSkuService.getSku(skuId);
            if (rsSkuReDomain != null) {
                List<Map> arrayList = this.queryUserContractGoodsNum(tenantCode, rsSkuReDomain.getSkuNo(), memberBcode, rsSkuReDomain.getCountsLimitDate());
                return this.checkUserGoodsLimitNumNew(rsSkuReDomain.getSkuNo(), rsSkuReDomain.getCountsLimit(), goodsNum, arrayList);
            }
        }
        catch (Exception e) {
            this.logger.error(CODE + ".checkUserGoodsLimitNumBySku =====\u6821\u9a8c\u5546\u54c1\u9650\u8d2d\u6570.ex=====", (Throwable)e);
        }
        return true;
    }

    public boolean checkUserGoodsLimitNumNew(String skuNo, Integer countsLimit, Integer goodsNum, List<Map> arrayList) {
        if (countsLimit == null || countsLimit == 0) {
            return true;
        }
        if (goodsNum == null) {
            return true;
        }
        BigDecimal goodsNumRe = BigDecimal.ZERO;
        BigDecimal goodsNumFinal = BigDecimal.ZERO;
        String memberBcode = null;
        if (ListUtil.isNotEmpty(arrayList)) {
            for (Map map : arrayList) {
                if (map.get("SKU_NO") == null || map.get("goodsNum") == null || map.get("MEMBER_BCODE") == null || !skuNo.equals(map.get("SKU_NO").toString())) continue;
                goodsNumRe = new BigDecimal(map.get("goodsNum").toString());
                memberBcode = map.get("MEMBER_BCODE").toString();
                break;
            }
        }
        if ((goodsNumFinal = goodsNumRe.add(new BigDecimal(goodsNum))).compareTo(new BigDecimal(countsLimit)) == 1) {
            this.logger.error(CODE + ".checkUserGoodsLimitNumNew ====\u8d85\u9650\u8d2d====", (Object)("memberBcode:" + memberBcode + ",skuNo:" + skuNo + ",countsLimit:" + countsLimit + ",goodsNum:" + goodsNum + ",goodsNumRe:" + goodsNumRe));
            return false;
        }
        return true;
    }

    public List<Map> queryUserContractGoodsNum(String tenantCode, String skuNo, String memberBcode, Date gmtCreateStart) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)skuNo)) {
            params.put("skuNo", skuNo);
        }
        if (StringUtils.isNotBlank((String)memberBcode)) {
            params.put("memberBcode", memberBcode);
        }
        if (gmtCreateStart != null) {
            params.put("gmtCreateStart", gmtCreateStart);
        }
        params.put("dataStateStr", "0,1,2,3,5");
        List<Map> arrayList = this.ocShoppingService.queryUserContractGoodsNumM(params);
        if (ListUtil.isEmpty(arrayList)) {
            this.logger.error(CODE + ".queryUserContractGoodsNum =====\u67e5\u8be2\u5546\u54c1\u4e0b\u5355\u7edf\u8ba1=====", params);
        } else {
            this.logger.error(CODE + ".queryUserContractGoodsNum =====\u67e5\u8be2\u5546\u54c1\u4e0b\u5355\u7edf\u8ba1=====", (Object)arrayList.size());
        }
        return arrayList;
    }

    private HtmlJsonReBean saveShoppingDomain(HttpServletRequest request, List<OcShoppingGoodsDomain> shoppingGoodsList) {
        if (ListUtil.isEmpty(shoppingGoodsList)) {
            this.logger.error("EXCEPTION:" + CODE + ".saveShoppingDomain", (Object)"shoppingGoodsList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u5e93\u5b58\u4e0d\u8db3");
        }
        HtmlJsonReBean htmlJsonReBean = this.ocShoppingService.insertBatchShoppingGoods(shoppingGoodsList);
        return htmlJsonReBean;
    }

    public HtmlJsonReBean addShoppingGoodsCustCom(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode) {
        String userinfoCode = this.getUserInfo(request).getUserInfoCode();
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userinfoCode = memberBcode;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> pMap = new HashMap<String, Object>();
        pMap.put("userinfoCode", userinfoCode);
        pMap.put("tenantCode", tenantCode);
        List ctCustrelEmpReDomainsList = this.ctCustrelService.queryCustrelEmpPage(pMap).getList();
        if (ListUtil.isNotEmpty((Collection)ctCustrelEmpReDomainsList)) {
            UserSession userSession = this.getUserSession(request);
            OrgUserBean orgUserBean = null;
            if (StringUtils.isNotBlank((String)memberBcode)) {
                userSession = this.getUserSession(memberBcode, userSession);
                orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
            }
            return this.saveShopping(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, userSession, orgUserBean);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u5206\u914d\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
    }

    private UserSession getUserSession(String memberBcode, UserSession userSession) {
        if (StringUtils.isBlank((String)memberBcode) || null == userSession) {
            return null;
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = this.userService.getUserinfoByCode(memberBcode, userSession.getTenantCode());
        if (null == umUserinfoReDomainBean) {
            return null;
        }
        UserSession reuserSession = new UserSession();
        try {
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)userSession);
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)umUserinfoReDomainBean);
            reuserSession.setUserCode(userSession.getUserCode());
            reuserSession.setUserPcode(umUserinfoReDomainBean.getUserinfoCode());
            reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        }
        catch (Exception exception) {
            // empty catch block
        }
        reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        SupQueryResult<UmGroupListReDomain> qmem = this.umGroupService.queryGroupListPage(this.getQueryMapParam("userinfoCode,tenantCode", umUserinfoReDomainBean.getUserinfoCode(), umUserinfoReDomainBean.getTenantCode()));
        if (null != qmem && ListUtil.isNotEmpty((Collection)qmem.getList())) {
            reuserSession.setGroupCode(((UmGroupListReDomain)qmem.getList().get(0)).getGroupCode());
            reuserSession.setGroupName(((UmGroupListReDomain)qmem.getList().get(0)).getGroupName());
        }
        return reuserSession;
    }

    public HtmlJsonReBean addShoppingGoodsComBean(HttpServletRequest request, List<GoodsBean> goodsBeanList, String memberBcode) {
        UserSession userSession = this.getUserSession(request);
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        return this.saveShoppingBean(request, goodsBeanList, userSession, orgUserBean);
    }

    public HtmlJsonReBean addShoppingGoodsCom(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode) {
        UserSession userSession = this.getUserSession(request);
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        return this.saveShopping(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, userSession, orgUserBean);
    }

    public boolean checkGoodsAddressRange(String freightTemCode, String areaCode, String tenantCode) {
        this.logger.error(CODE + ".checkGoodsAddressRange =====\u6821\u9a8c\u914d\u9001\u8303\u56f4=====");
        Long dateStart = System.currentTimeMillis();
        HashMap<String, Object> mapFreight = new HashMap<String, Object>();
        mapFreight.put("tenantCode", tenantCode);
        mapFreight.put("freightExpCode", freightTemCode);
        mapFreight.put("freightExpallArea", areaCode + ",");
        this.logger.error(CODE + ".checkGoodsAddressRange =====\u6821\u9a8c\u914d\u9001\u8303\u56f4.params=====", mapFreight);
        SupQueryResult<WlFreightExpallReDomain> freightQueryResult = this.wlFreightTemService.queryFreightExpallPage(mapFreight);
        this.logger.error(CODE + ".checkGoodsAddressRange =====\u6821\u9a8c\u914d\u9001\u8303\u56f4.time:=====", (Object)(System.currentTimeMillis() - dateStart));
        return ListUtil.isNotEmpty((Collection)freightQueryResult.getList());
    }

    public boolean checkGoodsAddressRangeNew(String freightTemCode, String areaCode, String cityCode, String provinceCode, String rodeCode, String tenantCode, Map<String, Object> freightMap, boolean remot) {
        if (StringUtils.isBlank((String)freightTemCode)) {
            this.logger.error(CODE + ".checkGoodsAddressRange =====\u6821\u9a8c\u914d\u9001\u8303\u56f4.\u8fd0\u8d39\u6a21\u677f null=====");
            return true;
        }
        List wlFreightExpallReDomainList = null;
        String areaCodeStr = null;
        if (StringUtils.isNotBlank((String)areaCode)) {
            areaCodeStr = "," + areaCode + ",";
        }
        String cityCodeStr = null;
        if (StringUtils.isNotBlank((String)cityCode)) {
            cityCodeStr = "," + cityCode + ",";
        }
        String provinceCodeStr = null;
        if (StringUtils.isNotBlank((String)provinceCode)) {
            provinceCodeStr = "," + provinceCode + ",";
        }
        String rodeCodeStr = null;
        if (StringUtils.isNotBlank((String)rodeCode)) {
            rodeCodeStr = "," + rodeCode + ",";
        }
        HashMap<String, Object> mapFreight = new HashMap<String, Object>();
        mapFreight.put("tenantCode", tenantCode);
        mapFreight.put("freightExpCode", freightTemCode);
        SupQueryResult<WlFreightExpReDomain> wlFreightExpReDomainSupQueryResult = this.wlFreightTemService.queryFreightExpPage(mapFreight);
        if (wlFreightExpReDomainSupQueryResult == null || ListUtil.isEmpty((Collection)wlFreightExpReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".checkGoodsAddressRange =====.\u67e5\u8be2\u8fd0\u8d39\u6a21\u677f is null=====", wlFreightExpReDomainSupQueryResult);
            return false;
        }
        WlFreightExpReDomain wlFreightExpReDomain = (WlFreightExpReDomain)wlFreightExpReDomainSupQueryResult.getList().get(0);
        if (freightMap.get(freightTemCode) != null && ListUtil.isNotEmpty((Collection)((List)freightMap.get(freightTemCode)))) {
            wlFreightExpallReDomainList = (List)freightMap.get(freightTemCode);
        } else {
            String json = "";
            json = remot ? DisUtil.getRemotMap((String)"cache_freight_exp_all", (String)(tenantCode + "-" + freightTemCode)) : DisUtil.getMap((String)"cache_freight_exp_all", (String)(tenantCode + "-" + freightTemCode));
            if (StringUtils.isNotBlank((String)json)) {
                wlFreightExpallReDomainList = JsonUtil.buildNormalBinder().getJsonToList(json, WlFreightExpallReDomain.class);
            }
            if (ListUtil.isEmpty((Collection)wlFreightExpallReDomainList)) {
                SupQueryResult<WlFreightExpallReDomain> freightQueryResultNew = this.wlFreightTemService.queryFreightExpallPage(mapFreight);
                if (freightQueryResultNew != null && ListUtil.isNotEmpty((Collection)freightQueryResultNew.getList())) {
                    wlFreightExpallReDomainList = freightQueryResultNew.getList();
                } else if (ListUtil.isEmpty((Collection)wlFreightExpallReDomainList) && wlFreightExpReDomain.getFreightExpPayer().equals("shop")) {
                    return true;
                }
            }
            freightMap.put(freightTemCode, wlFreightExpallReDomainList);
        }
        if (ListUtil.isNotEmpty((Collection)wlFreightExpallReDomainList)) {
            for (WlFreightExpallReDomain wlFreightExpallReDomain : wlFreightExpallReDomainList) {
                if (!StringUtils.isNotBlank((String)wlFreightExpallReDomain.getFreightExpallArea())) continue;
                String areaCodeAllStr = "," + wlFreightExpallReDomain.getFreightExpallArea() + ",";
                if (StringUtils.isNotBlank((String)areaCodeStr) && areaCodeAllStr.contains(areaCodeStr)) {
                    return true;
                }
                if (StringUtils.isNotBlank((String)rodeCodeStr) && areaCodeAllStr.contains(rodeCodeStr)) {
                    return true;
                }
                if (StringUtils.isNotBlank((String)cityCodeStr) && areaCodeAllStr.contains(cityCodeStr)) {
                    return true;
                }
                if (!StringUtils.isNotBlank((String)provinceCodeStr) || !areaCodeAllStr.contains(provinceCodeStr)) continue;
                return true;
            }
        } else {
            this.logger.error(CODE + ".checkGoodsAddressRange =====\u6821\u9a8c\u914d\u9001\u8303\u56f4.\u67e5\u8be2\u8fd0\u8d39\u6a21\u677f query is null=====", (Object)("freightTemCode:" + freightTemCode));
            return false;
        }
        return false;
    }

    public boolean checkGoodsAddressRangeNew(String freightTemCode, String areaCode, String cityCode, String provinceCode, String rodeCode, String tenantCode, Map<String, Object> freightMap) {
        return this.checkGoodsAddressRangeNew(freightTemCode, areaCode, cityCode, provinceCode, rodeCode, tenantCode, freightMap, true);
    }

    public HtmlJsonReBean addShoppingGoodsComs(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode) {
        UserSession userSession = this.getUserSession(request);
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        return this.saveShoppings(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, userSession, orgUserBean);
    }

    private OrgUserBean getOrgUserBean(String memberBcode, String userCode, String companyCode, String tenantCode) {
        SupQueryResult<CtCustrelReDomain> qcust;
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyService.getEmpByUserCode(userCode, companyCode, tenantCode);
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode) && null != (qcust = this.ctCustrelService.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", memberBcode, tenantCode))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
            orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
        }
        return orgUserBean;
    }

    private HtmlJsonReBean saveShoppingSkuCodeCom(HttpServletRequest request, String goodsBeanStr, String memberBcode) {
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error(CODE + ".saveShoppingSkuCodeCom", (Object)"goodsBeanStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        List skuCodeList = JsonUtil.buildNormalBinder().getJsonToList(goodsBeanStr, GoodsBean.class);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveShoppingSkuCodeCom.UserSession", (Object)"UserSession is null");
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        return this.saveShoppingBean(request, skuCodeList, userSession, orgUserBean);
    }

    public HtmlJsonReBean addShoppingGoodsCodeCom(HttpServletRequest request, String goodsBeanStr, String memberBcode) {
        return this.saveShoppingSkuCodeCom(request, goodsBeanStr, memberBcode);
    }

    public OcShoppingGoodsReDomain getShoppingGoodsCom(String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".getShoppingGoodsCom", (Object)"param is null");
            return null;
        }
        return this.ocShoppingService.getShoppingGoods(Integer.valueOf(shoppingGoodsId));
    }

    public HtmlJsonReBean updateShoppingGoodsCom(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".updateShoppingGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingService.updateShoppingGoods(ocShoppingGoodsDomain);
    }

    public HtmlJsonReBean deleteShoppingGoodsCom(HttpServletRequest request, String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".deleteShoppingGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] shoppingGoodsIdS = shoppingGoodsId.split(",");
        if (null == shoppingGoodsIdS || shoppingGoodsIdS.length <= 0) {
            this.logger.error(CODE + ".deleteShoppingGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (String string : shoppingGoodsIdS) {
            idList.add(Integer.valueOf(string));
        }
        htmlJsonReBean = this.ocShoppingService.deleteShoppingGoodsBatch(idList);
        return htmlJsonReBean;
    }

    public HtmlJsonReBean deleteShoppingGoodsComByCode(HttpServletRequest request, String shoppingGoodsCode) {
        if (StringUtils.isBlank((String)shoppingGoodsCode)) {
            this.logger.error(CODE + ".deleteShoppingGoodsComByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] shoppingGoodsCodeS = shoppingGoodsCode.split(",");
        if (null == shoppingGoodsCodeS || shoppingGoodsCodeS.length <= 0) {
            this.logger.error(CODE + ".deleteShoppingGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        ArrayList<String> codeList = new ArrayList<String>();
        for (String string : shoppingGoodsCodeS) {
            codeList.add(string);
        }
        htmlJsonReBean = this.ocShoppingService.deleteShoppingGoodsBatchByCode(codeList, this.getTenantCode(request));
        return htmlJsonReBean;
    }

    public HtmlJsonReBean deleteShoppingGoodsBatchCom(String shoppingGoodsIdStr, Map<String, Object> map) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".deleteShoppingGoodsBatchCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List shoppingGoodsIdList = JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        ArrayList<Integer> shoppingGoodsIdListStr = new ArrayList<Integer>();
        for (Integer shoppingGoodsId : shoppingGoodsIdList) {
            map.put("shoppingGoodsId", shoppingGoodsId);
            SupQueryResult<OcShoppingGoodsReDomain> ocShoppingGoodsReDomainSupQueryResult = this.ocShoppingService.queryShoppingGoodsPage(map);
            if (!ListUtil.isNotEmpty((Collection)ocShoppingGoodsReDomainSupQueryResult.getList())) continue;
            shoppingGoodsIdListStr.add(shoppingGoodsId);
        }
        return this.ocShoppingService.deleteShoppingGoodsBatch(shoppingGoodsIdListStr);
    }

    public void sendShoppingBigData(List<OcShoppingGoodsDomain> shoppingGoodsList) {
        String value = "{\"paasLabel\":\"orderPayment\",\"message\":" + JsonUtil.buildNormalBinder().toJson(shoppingGoodsList) + "}";
        PostParamMap pmap = new PostParamMap("kafka.adapter.sendProducerInfo");
        pmap.putParam("topic", (Object)"paas_business");
        pmap.putParam("value", (Object)value);
        this.htmlIBaseService.sendMesReBeanInAsync(pmap);
    }

    public HtmlJsonReBean updateShoppingGoodsNumBatchCom(String goodsListStr) {
        if (StringUtils.isBlank((String)goodsListStr)) {
            this.logger.error(CODE + ".updateShoppingGoodsNumBatchCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsList = JsonUtil.buildNormalBinder().getJsonToList(goodsListStr, GoodsNumDomain.class);
        return this.ocShoppingService.updateShoppingGoodsNumBatch(goodsList);
    }

    public SupQueryResult<OcShoppingGoodsReDomain> queryShoppingGoodsPageCom(HttpServletRequest request, Map<String, Object> param) {
        return this.ocShoppingService.queryShoppingGoodsPage(param);
    }

    public HtmlJsonReBean updateShoppingGoodsStateCom(String shoppingGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".updateShoppingGoodsStateCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingService.updateShoppingGoodsState(Integer.valueOf(shoppingGoodsId), dataState, oldDataState);
    }

    /*
     * WARNING - void declaration
     */
    public List<OcShoppingReDomain> queryShoppingToContractCom(HttpServletRequest request, String shoppingGoodsIdStr, String memberBcode, String contractPmode) {
        void var13_24;
        void var11_17;
        List<OcShoppingReDomain> ocShoppingReDomainList;
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".queryShoppingToContractCom", (Object)"param is null");
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        this.logger.error(CODE + ".queryShoppingToContractCom =====\u67e5\u8be2\u8d2d\u7269\u8f66=====", param);
        List shoppingGoodsIdList = JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryShoppingToContractCom.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        if (ListUtil.isEmpty(ocShoppingReDomainList = this.ocShoppingService.queryShoppingToContract(shoppingGoodsIdList, this.getOauthEnvCode(request)))) {
            return null;
        }
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            if (ocShoppingReDomain.getMemberBcode().equals(userSession.getUserPcode())) continue;
            this.logger.error(CODE + ".queryShoppingToContractCom.getMemberBcode", (Object)"getMemberBcode is null");
            return null;
        }
        HashMap<Integer, String> tempMap = new HashMap<Integer, String>();
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain ocShoppingpackgeDomain : ocShoppingReDomain.getShoppingpackageList()) {
                this.makeShowShoppingDomainList(ocShoppingpackgeDomain, userSession);
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : ocShoppingpackgeDomain.getShoppingGoodsList()) {
                    tempMap.put(ocShoppingGoodsDomain.getShoppingGoodsId(), ocShoppingGoodsDomain.getGoodsClass());
                }
            }
        }
        ocShoppingReDomainList = this.ocShoppingService.makePm(ocShoppingReDomainList, null, this.getPmCheckBean(request, userSession, contractPmode));
        PmCheckBean pmCheckBean = this.getPmCheckBean(request, userSession, null);
        this.makeOcShoppingReDomain(ocShoppingReDomainList, userSession);
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
                    if (!StringUtils.isBlank((String)ocShoppingGoodsDomain.getGoodsClass())) continue;
                    ocShoppingGoodsDomain.setGoodsClass((String)tempMap.get(ocShoppingGoodsDomain.getShoppingGoodsId()));
                }
            }
        }
        Object var11_15 = null;
        String cityCode = null;
        Object var13_22 = null;
        String rodeCode = null;
        if (param.get("areaCode") != null) {
            String string = param.get("areaCode").toString();
            param.remove("areaCode");
        }
        if (param.get("cityCode") != null) {
            cityCode = param.get("cityCode").toString();
            param.remove("cityCode");
        }
        if (param.get("provinceCode") != null) {
            String string = param.get("provinceCode").toString();
            param.remove("provinceCode");
        }
        if (param.get("roadCode") != null) {
            rodeCode = param.get("roadCode").toString();
            param.remove("roadCode");
        }
        if (StringUtils.isNotBlank((String)var11_17) || StringUtils.isNotBlank((String)cityCode) || StringUtils.isNotBlank((String)var13_24)) {
            try {
                this.checkOcShoppingAddressRange(ocShoppingReDomainList, (String)var11_17, cityCode, (String)var13_24, rodeCode, userSession.getTenantCode());
            }
            catch (Exception exception) {
                this.logger.error(CODE + ".checkOcShoppingAddressRange =====\u6821\u9a8c\u914d\u9001\u8303\u56f4.ex=====", (Throwable)exception);
            }
        }
        return ocShoppingReDomainList;
    }

    /*
     * WARNING - void declaration
     */
    public List<OcShoppingReDomain> queryShoppingToContractComPlus(HttpServletRequest request, String shoppingGoodsIdStr, String memberBcode, String contractPmode) {
        void var17_24;
        Object reSkuListBySkuNo;
        List<OcShoppingReDomain> ocShoppingReDomainList;
        List ocShoppingGoodsDTOs;
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".queryShoppingToContractCom", (Object)"param is null");
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        boolean codeFlag = false;
        if (null != param.get("shoppingGoodsCodeStr") && StringUtils.isNotBlank((String)param.get("shoppingGoodsCodeStr").toString())) {
            ocShoppingGoodsDTOs = JsonUtil.buildNormalBinder().getJsonToList(param.get("shoppingGoodsCodeStr").toString(), OcShoppingGoodsDTO.class);
            codeFlag = true;
        } else {
            ocShoppingGoodsDTOs = JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, OcShoppingGoodsDTO.class);
        }
        if (ListUtil.isEmpty((Collection)ocShoppingGoodsDTOs)) {
            this.logger.error(CODE + ".queryShoppingToContractCom", (Object)"param is ocShoppingGoodsDomains null");
            return null;
        }
        HashMap<String, String> pmMap = new HashMap<String, String>();
        ArrayList<Integer> shoppingGoodsIdList = new ArrayList<Integer>();
        StringBuilder codeStringBuilder = new StringBuilder();
        for (OcShoppingGoodsDTO ocShoppingGoodsDomain : ocShoppingGoodsDTOs) {
            if (codeFlag) {
                codeStringBuilder.append(ocShoppingGoodsDomain.getShoppingGoodsCode()).append(",");
                pmMap.put(ocShoppingGoodsDomain.getShoppingGoodsCode(), ocShoppingGoodsDomain.getShoppingGoodsPm());
                continue;
            }
            shoppingGoodsIdList.add(ocShoppingGoodsDomain.getShoppingGoodsId());
            pmMap.put(ocShoppingGoodsDomain.getShoppingGoodsId().toString(), ocShoppingGoodsDomain.getShoppingGoodsPm());
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryShoppingToContractCom.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (codeFlag) {
            if (StringUtils.isBlank((String)codeStringBuilder.toString())) {
                this.logger.error(CODE + ".queryShoppingToContract", (Object)"ocShoppingReDomainSupQueryResult is null");
                return null;
            }
            codeStringBuilder.deleteCharAt(codeStringBuilder.length() - 1);
            HashMap param1 = new HashMap();
            param1.put("tenantCode", userSession.getTenantCode());
            param1.put("memberBcode", userSession.getUserPcode());
            param1.put("shoppingGoodsCode", codeStringBuilder.toString());
            SupQueryResult<OcShoppingReDomain> ocShoppingReDomainSupQueryResult = this.queryShoppingPage(param1);
            if (null == ocShoppingReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
                this.logger.error(CODE + ".queryShoppingToContract.ocShoppingReDomainSupQueryResult is null", (Object)param1);
                return null;
            }
            ocShoppingReDomainList = ocShoppingReDomainSupQueryResult.getList();
        } else {
            ocShoppingReDomainList = this.ocShoppingService.queryShoppingToContract(shoppingGoodsIdList, this.getOauthEnvCode(request));
        }
        if (ListUtil.isEmpty(ocShoppingReDomainList)) {
            return null;
        }
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            if (ocShoppingReDomain.getMemberBcode().equals(userSession.getUserPcode())) continue;
            this.logger.error(CODE + ".queryShoppingToContractCom.getMemberBcode", (Object)"getMemberBcode is null");
            return null;
        }
        ArrayList<String> skuCodeList = new ArrayList<String>();
        HashMap<String, String> fcodeMap = new HashMap<String, String>();
        HashMap<Integer, String> tempMap = new HashMap<Integer, String>();
        this.logger.error(CODE + ".queryShoppingToContractCom.codeFlag", (Object)codeFlag);
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
                    tempMap.put(ocShoppingGoodsDomain.getShoppingGoodsId(), ocShoppingGoodsDomain.getGoodsClass());
                    String pm = codeFlag ? (String)pmMap.get(ocShoppingGoodsDomain.getShoppingGoodsCode()) : (String)pmMap.get(ocShoppingGoodsDomain.getShoppingGoodsId().toString());
                    if (StringUtils.isNotBlank((String)pm)) {
                        ocShoppingGoodsDomain.setShoppingGoodsPm(pm);
                    } else {
                        ocShoppingGoodsDomain.setShoppingGoodsPm("-");
                    }
                    if (!StringUtils.isNotBlank((String)ocShoppingGoodsDomain.getSkuCode())) continue;
                    skuCodeList.add(ocShoppingGoodsDomain.getSkuCode());
                }
            }
        }
        if (!codeFlag && ListUtil.isNotEmpty(skuCodeList) && ListUtil.isNotEmpty(reSkuListBySkuNo = this.searchengineService.findReSkuListBySkuCode(String.join((CharSequence)",", skuCodeList), this.getTenantCode(request)))) {
            Iterator iterator = reSkuListBySkuNo.iterator();
            while (iterator.hasNext()) {
                RsSkuReDomain rsSkuReDomain = (RsSkuReDomain)iterator.next();
                if (!StringUtils.isNotBlank((String)rsSkuReDomain.getFreightTemCode())) continue;
                fcodeMap.put(rsSkuReDomain.getSkuCode(), rsSkuReDomain.getFreightTemCode());
            }
        }
        ocShoppingReDomainList = this.ocShoppingService.makePm(ocShoppingReDomainList, null, this.getPmCheckBean(request, userSession, contractPmode));
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
                    if (StringUtils.isBlank((String)ocShoppingGoodsDomain.getGoodsClass())) {
                        ocShoppingGoodsDomain.setGoodsClass((String)tempMap.get(ocShoppingGoodsDomain.getShoppingGoodsId()));
                    }
                    if (codeFlag || !StringUtils.isNotBlank((String)ocShoppingGoodsDomain.getSkuCode())) continue;
                    ocShoppingGoodsDomain.setFreightTemCode((String)fcodeMap.get(ocShoppingGoodsDomain.getSkuCode()));
                }
            }
        }
        String areaCode = null;
        Object var17_22 = null;
        String provinceCode = null;
        String rodeCode = null;
        if (param.get("areaCode") != null) {
            areaCode = param.get("areaCode").toString();
            param.remove("areaCode");
        }
        if (param.get("cityCode") != null) {
            String string = param.get("cityCode").toString();
            param.remove("cityCode");
        }
        if (param.get("provinceCode") != null) {
            provinceCode = param.get("provinceCode").toString();
            param.remove("provinceCode");
        }
        if (param.get("roadCode") != null) {
            rodeCode = param.get("roadCode").toString();
            param.remove("roadCode");
        }
        if (StringUtils.isNotBlank((String)areaCode) || StringUtils.isNotBlank((String)var17_24) || StringUtils.isNotBlank((String)provinceCode)) {
            try {
                this.checkOcShoppingAddressRange(ocShoppingReDomainList, areaCode, (String)var17_24, provinceCode, rodeCode, userSession.getTenantCode());
            }
            catch (Exception e) {
                this.logger.error(CODE + ".checkOcShoppingAddressRange =====\u6821\u9a8c\u914d\u9001\u8303\u56f4.ex=====", (Throwable)e);
            }
        }
        for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
            for (OcShoppingpackgeDomain shoppingpackage : ocShoppingReDomain.getShoppingpackageList()) {
                if (!ListUtil.isNotEmpty(shoppingpackage.getShoppingGoodsList())) continue;
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingpackage.getShoppingGoodsList()) {
                    if (2 == ocShoppingGoodsDomain.getDataState()) {
                        throw new ApiException("\u5546\u54c1\u5df2\u4e0b\u67b6");
                    }
                    if (3 != ocShoppingGoodsDomain.getDataState()) continue;
                    throw new ApiException("\u5e93\u5b58\u4e0d\u8db3");
                }
            }
        }
        return ocShoppingReDomainList;
    }

    public List<OcShoppingReDomain> queryToContractCodeCom(HttpServletRequest request, String skuCode, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String shoppingType, String contractNbillcode, String pricesetType, String memberBcode, String contractPmode) throws Exception {
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error(CODE + ".queryToContractCodeCom", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryToContractCodeCom.UserSession", (Object)"UserSession is null");
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(this.getNowChannel(request));
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuCode(skuCode);
        goodsBean.setContractNbillcode(contractNbillcode);
        goodsBean.setPricesetType(pricesetType);
        goodsBean.setShoppingType(shoppingType);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        OcShoppingDomain ocShoppingDomain = this.ocShoppingService.makeOcShoppingDomain(userSession, goodsBean, orgUserBean);
        return this.ocShoppingService.queryToContractDomain(ocShoppingDomain, null, this.getPmCheckBean(request, userSession, contractPmode));
    }

    public List<OcShoppingReDomain> queryToContractCodeListCom(HttpServletRequest request, String goodsBeanStr, String memberBcode, String contractPmode) throws Exception {
        List skuCodeList;
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error(CODE + ".queryToContractCodeList", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryToContractCodeList.UserSession", (Object)"UserSession is null");
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        if (ListUtil.isEmpty((Collection)(skuCodeList = JsonUtil.buildNormalBinder().getJsonToList(goodsBeanStr, GoodsBean.class)))) {
            this.logger.error(CODE + ".queryToContractCodeList.skuCodeList", (Object)"skuCodeList is null");
            return null;
        }
        skuCodeList.stream().forEach(p -> p.setTenantCode(this.getTenantCode(request)));
        List<OcShoppingDomain> ocShoppingDomainList = this.ocShoppingService.makeOcShoppingDomainList(userSession, skuCodeList, orgUserBean);
        return this.ocShoppingService.queryToContractDomainList(ocShoppingDomainList, null, this.getPmCheckBean(request, userSession, contractPmode));
    }

    public List<OcShoppingReDomain> queryToContractCom(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String memberBcode, String contractPmode, String contractPumode) throws Exception {
        String channelCode;
        Map<String, Object> assemMapParam = this.assemMapParam(request);
        this.logger.error("EXCEPTION:" + CODE + ".queryToContractCom params is", assemMapParam);
        String activityId = null;
        if (MapUtil.isNotEmpty(assemMapParam)) {
            String string = activityId = null == assemMapParam.get("activityId") ? null : assemMapParam.get("activityId").toString();
        }
        if (null == skuId) {
            this.logger.error("EXCEPTION:" + CODE + ".queryToContract.skuId", (Object)"skuId is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("EXCEPTION:" + CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        if (!ShoppingComCon.isIntegerValue(goodsNum)) {
            this.logger.error("EXCEPTION:" + CODE + ".makeOcShoppingDomain.goodsNum", (Object)goodsNum);
            return null;
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
            orgUserBean = this.getOrgUserBean(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        if (StringUtils.isBlank((String)(channelCode = this.getNowChannel(request)))) {
            Map<String, Object> param = this.assemMapParam(request);
            channelCode = param.get("channelCode") + "";
        }
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setChannelCode(channelCode);
        goodsBean.setGoodsNum(goodsNum);
        goodsBean.setGoodsWeght(goodsWeght);
        goodsBean.setProappCode(this.getProappCode(request));
        goodsBean.setSkuId(skuId);
        goodsBean.setShoppingGoodsPm(shoppingGoodsPm);
        if (assemMapParam.get("provinceCode") != null) {
            goodsBean.setAreaCode(assemMapParam.get("provinceCode").toString());
        }
        if (StringUtils.isNotBlank((String)activityId)) {
            goodsBean.setShoppingGoodsPm(activityId);
            goodsBean.setShoppingType("26");
        }
        goodsBean.setFlagCheckAddCar("true");
        OcShoppingDomain ocShoppingDomain = this.ocShoppingService.makeOcShoppingDomain(userSession, goodsBean, orgUserBean);
        PmCheckBean pmCheckBean = this.getPmCheckBean(request, userSession, contractPmode);
        pmCheckBean.setBuyType("2");
        List<OcShoppingReDomain> ocShoppingReDomainList = this.ocShoppingService.queryToContractDomain(ocShoppingDomain, activityId, pmCheckBean);
        for (OcShoppingDomain ocShoppingDomain2 : ocShoppingReDomainList) {
            BigDecimal goodsMoney = BigDecimal.ZERO;
            for (OcShoppingpackgeDomain ocShoppingpackgeDomain : ocShoppingDomain2.getShoppingpackageList()) {
                for (OcShoppingGoodsDomain shoppingGoodsDomain : ocShoppingpackgeDomain.getShoppingGoodsList()) {
                    if (StringUtils.isBlank((String)shoppingGoodsDomain.getFlagAddressRange()) || OrderConstants.FLAG_CONTRACT_PUMODE_1.equals(contractPumode)) {
                        this.logger.error("EXCEPTION:" + CODE + ".makeOcShoppingDomain.getFlagAddressRange is null");
                        shoppingGoodsDomain.setFlagAddressRange(OrderConstants.FLAG_ADDRESS_RANGE_0);
                    }
                    if (ListUtil.isNotEmpty(shoppingGoodsDomain.getPmPromotionList())) {
                        for (PromotionForOcReDomain promotion : shoppingGoodsDomain.getPmPromotionList()) {
                            if (!"0022".equals(promotion.getPbCode())) continue;
                            String cacheKey = promotion.getPromotionCode() + "-" + shoppingGoodsDomain.getTenantCode();
                            PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)SupDisUtil.getMapJson((String)"pm-promotion", (String)cacheKey, PmPromotionInDomain.class);
                            this.logger.error("pmPromotionInDomain=====3", (Object)JsonUtil.buildNormalBinder().toJson((Object)pmPromotionInDomain));
                            this.makeContractNprice(pmPromotionInDomain, shoppingGoodsDomain);
                        }
                    }
                    BigDecimal money = shoppingGoodsDomain.getGoodsCamount().multiply(shoppingGoodsDomain.getPricesetNprice());
                    goodsMoney = goodsMoney.add(money);
                }
                ocShoppingpackgeDomain.setGoodsMoney(goodsMoney);
            }
            ocShoppingDomain2.setGoodsMoney(goodsMoney);
        }
        return ocShoppingReDomainList;
    }

    private void makeContractNprice(PmPromotionInDomain pmPromotionInDomain, OcShoppingGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return;
        }
        if (null == pmPromotionInDomain) {
            return;
        }
        String cacheKey = pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTenantCode();
        List pmPromotionRangelistList = DisUtil.getListJson((String)("pm-promotion_rangelist-" + cacheKey), PmPromotionRangelistDomain.class);
        this.logger.error("pmPromotionRangelistList=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)pmPromotionRangelistList));
        if (ListUtil.isEmpty((Collection)pmPromotionRangelistList)) {
            return;
        }
        for (PmPromotionRangelistDomain pmPromotionRangelist : pmPromotionRangelistList) {
            if (null == pmPromotionInDomain.getRangeType() || pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_0.intValue()) continue;
            String value = "";
            String term = pmPromotionRangelist.getPprlTerm();
            if (pmPromotionInDomain.getRangeType().intValue() != PromotionConstants.RANGE_TYPE_1.intValue()) {
                if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_2.intValue()) {
                    value = ocContractGoodsDomain.getPntreeCode();
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_3.intValue()) {
                    value = ocContractGoodsDomain.getBrandCode();
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_4.intValue()) {
                    value = ocContractGoodsDomain.getClasstreeCode();
                } else if (pmPromotionInDomain.getRangeType().intValue() == PromotionConstants.RANGE_TYPE_5.intValue()) {
                    value = ocContractGoodsDomain.getSkuNo();
                }
            }
            if (StringUtils.isBlank((String)value)) continue;
            if (StringUtils.isBlank((String)term)) {
                term = "=";
            }
            if ("=".equals(term)) {
                if (!value.equals(pmPromotionRangelist.getRangeCode())) continue;
                ocContractGoodsDomain.setPricesetNprice(pmPromotionRangelist.getDiscountAmount1());
                continue;
            }
            if (value.equals(pmPromotionRangelist.getRangeCode())) continue;
            ocContractGoodsDomain.setPricesetNprice(pmPromotionRangelist.getDiscountAmount1());
        }
    }

    public List<RsSkuReDomain> queryToNvrGo(HttpServletRequest request, String goodsSpec, String memberCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("bomCode", goodsSpec);
        SupQueryResult<OcNvrReDomain> ocNvrReDomainSupQueryResult = this.ocNvrService.querynvrPage(map);
        if (null == ocNvrReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocNvrReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryToNvrGo", (Object)"ocNvrReDomainSupQueryResult is null");
            return null;
        }
        map.remove("bomCode");
        ArrayList<RsResourceGoodsReDomain> list = new ArrayList<RsResourceGoodsReDomain>();
        for (OcNvrReDomain ocNvrReDomain : ocNvrReDomainSupQueryResult.getList()) {
            map.put("goodsSpec", ocNvrReDomain.getBomCode1());
            map.put("memberCode", memberCode);
            map.put("goodsOrigin", "13");
            SupQueryResult<RsResourceGoodsReDomain> goodsReDomainSupQueryResult = this.rsResourceGoodsService.queryResourceGoodsPage(map);
            if (null == goodsReDomainSupQueryResult || !ListUtil.isNotEmpty((Collection)goodsReDomainSupQueryResult.getList())) continue;
            for (RsResourceGoodsReDomain reDomain : goodsReDomainSupQueryResult.getList()) {
                reDomain.setMschannelCode(ocNvrReDomain.getGoodsNum().toString());
                list.add(reDomain);
            }
        }
        if (ListUtil.isEmpty(list)) {
            this.logger.error(CODE + ".queryToNvrGo", (Object)"list is null");
            return null;
        }
        map.remove("goodsSpec");
        map.remove("memberCode");
        ArrayList<RsSkuReDomain> skuList = new ArrayList<RsSkuReDomain>();
        for (RsResourceGoodsReDomain goodsReDomain : list) {
            map.put("goodsCode", goodsReDomain.getGoodsCode());
            SupQueryResult<RsSkuReDomain> skuReDomainSupQueryResult = this.rsSkuService.querySkuPage(map);
            if (null == skuReDomainSupQueryResult || !ListUtil.isNotEmpty((Collection)skuReDomainSupQueryResult.getList())) continue;
            for (RsSkuReDomain sku : skuReDomainSupQueryResult.getList()) {
                sku.setGoodsTopnum(new BigDecimal(goodsReDomain.getMschannelCode()));
                skuList.add(sku);
            }
        }
        return skuList;
    }

    public SupQueryResult<OcShoppingReDomain> queryShoppingPage(Map<String, Object> param) {
        return this.ocShoppingService.queryShoppingPage(param);
    }

    public String checkOcContractGoodsDomainQuality(String goodsBeanStr, HttpServletRequest request, String memberBcode) {
        UmUserinfoReDomainBean userinfo;
        List skuCodeList = JsonUtil.buildNormalBinder().getJsonToList(goodsBeanStr, GoodsBean.class);
        if (ListUtil.isEmpty((Collection)skuCodeList)) {
            this.logger.error(CODE + ".queryToContractCodeList.skuCodeList", (Object)"skuCodeList is null");
            return "\u53c2\u6570\u9519\u8bef";
        }
        UserSession userSession = this.getUserSession(request);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        if (null == (userinfo = this.userService.getUserinfoByCode(userSession.getUserPcode(), userSession.getTenantCode()))) {
            return "\u4e3a\u83b7\u53d6\u7528\u6237\u4fe1\u606f";
        }
        String qualityQtypeCodes = userinfo.getQualityQtypeCode();
        for (GoodsBean goodsBean : skuCodeList) {
            RsSkuReDomain sku = this.rsSkuService.getSku(goodsBean.getSkuId());
            Boolean falg = this.umQualityQtypeSkuService.checkOcContractGoodsDomainQuality(sku.getGoodsNo(), qualityQtypeCodes, userSession.getTenantCode());
            if (falg.booleanValue()) continue;
            return "\u60a8\u4e0d\u5177\u5907\u8d2d\u4e70\u8be5\u5546\u54c1\u7684\u8d44\u8d28\uff0c\u8bf7\u8fdb\u884c\u5347\u7ea7";
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println();
    }

    private void makeShowShoppingDomainListNew(OcShoppingpackgeDomain shoppingpackage, UserSession userSession) {
        List objmapList = JsonUtil.buildNormalBinder().getJsonToListByMap(JsonUtil.buildNormalBinder().toJson(shoppingpackage.getShoppingGoodsList()), Object.class);
        List<Map<String, Object>> list = this.rsResourceGoodsService.getShoppGoodMemPriceReBean(objmapList, userSession, shoppingpackage.getChannelCode(), shoppingpackage.getTenantCode());
        if (ListUtil.isEmpty(list)) {
            return;
        }
        List rsShoppingDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(list), OcShoppingGoodsDomain.class);
        if (ListUtil.isNotEmpty((Collection)rsShoppingDomainList)) {
            ArrayList<OcShoppingGoodsDomain> ling = new ArrayList<OcShoppingGoodsDomain>();
            ArrayList<OcShoppingGoodsDomain> hao = new ArrayList<OcShoppingGoodsDomain>();
            ArrayList<OcShoppingGoodsDomain> ji = new ArrayList<OcShoppingGoodsDomain>();
            for (OcShoppingGoodsDomain rsResourceGoodsReDomain : rsShoppingDomainList) {
                if (null == rsResourceGoodsReDomain.getClasstreeCode() || "".equals(rsResourceGoodsReDomain.getClasstreeCode())) continue;
                String classtreeCode = rsResourceGoodsReDomain.getClasstreeCode();
                HashMap<String, Object> classMap = new HashMap<String, Object>();
                classMap.put("tenantCode", rsResourceGoodsReDomain.getTenantCode());
                if (StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getChannelCode())) {
                    classMap.put("channelCode", rsResourceGoodsReDomain.getChannelCode());
                }
                classMap.put("memberCode", rsResourceGoodsReDomain.getMemberCode());
                StringBuilder classtreeFullName = new StringBuilder();
                while (!"-1".equals(classtreeCode)) {
                    classMap.put("classtreeCode", classtreeCode);
                    RsClasstreeReDomain classtree = this.rsClasstreeService.getClasstreeByCode(classMap);
                    if (null == classtree) {
                        classMap.remove("channelCode");
                        SupQueryResult<RsClasstreeReDomain> queryResult = this.rsClasstreeService.queryClasstreePage(classMap);
                        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
                            return;
                        }
                        classtree = (RsClasstreeReDomain)queryResult.getList().get(0);
                        if (null == classtree) {
                            return;
                        }
                    }
                    classtreeFullName.insert(0, "," + classtree.getClasstreeCode());
                    classtreeCode = classtree.getClasstreeParentcode();
                    if (!StringUtils.isBlank((String)classtreeCode)) continue;
                    classtreeCode = "-1";
                }
                String fullName = classtreeFullName.toString();
                this.logger.error("classtreeFullName------------------------------------------------" + classtreeFullName);
                String topClasstreeCode = fullName.trim().split(",")[1];
                this.logger.error("topClasstreeCode------------------------------------------------" + topClasstreeCode);
                if ("2021032700000010".equals(topClasstreeCode)) {
                    ling.add(rsResourceGoodsReDomain);
                    continue;
                }
                if ("2021032700000040".equals(topClasstreeCode)) {
                    hao.add(rsResourceGoodsReDomain);
                    continue;
                }
                if (!"2021032700000001".equals(topClasstreeCode)) continue;
                ji.add(rsResourceGoodsReDomain);
            }
            String lingJson = JsonUtil.buildNormalBinder().toJson(ling);
            String haoJson = JsonUtil.buildNormalBinder().toJson(hao);
            String jiJson = JsonUtil.buildNormalBinder().toJson(ji);
            shoppingpackage.setAreaCode(lingJson);
            shoppingpackage.setAreaName(haoJson);
            shoppingpackage.setWarehouseName(jiJson);
            shoppingpackage.setShoppingGoodsList(rsShoppingDomainList);
        }
    }

    public HtmlJsonReBean saveShoppingDomainExt(HttpServletRequest request, List<GoodsBean> goodsBeanList, UserSession userSession, OrgUserBean orgUserBean) {
        ArrayList<OcShoppingGoodsDomain> shoppingGoodsList = new ArrayList<OcShoppingGoodsDomain>();
        try {
            for (GoodsBean goodsBean : goodsBeanList) {
                OcShoppingGoodsDomain ocShoppingGoodsDomain = this.ocShoppingService.createShoppingGoodsDomain(userSession, goodsBean, orgUserBean, "shop");
                if (null == ocShoppingGoodsDomain) {
                    this.logger.error(CODE + ".saveShopping", (Object)"ocShoppingGoodsDomain is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u6570\u636e\u5f02\u5e38\uff01");
                }
                shoppingGoodsList.add(ocShoppingGoodsDomain);
            }
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveOrder.ex", (Throwable)e);
            return new HtmlJsonReBean(CODE + ".saveContract.ex", e.getMessage());
        }
        return this.saveShoppingDomain(request, shoppingGoodsList);
    }
}

