/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.controller.order.ShoppingComCon;
import cn.com.qj.bff.convert.BffQueryResult;
import cn.com.qj.bff.convert.PureCglibCopier;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.GoodsBean;
import cn.com.qj.bff.domain.oc.OcShoppingDomain;
import cn.com.qj.bff.domain.oc.OcShoppingGoodsDomain;
import cn.com.qj.bff.domain.oc.OcShoppingGoodsReDomain;
import cn.com.qj.bff.domain.oc.OcShoppingReDomain;
import cn.com.qj.bff.domain.oc.OcShoppingpackgeDomain;
import cn.com.qj.bff.domain.oc.RsSkuDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/shopping"}, name="\u7528\u6237\u7aef\u8d2d\u7269\u8f66\u670d\u52a1")
public class ShoppingCon
extends ShoppingComCon {
    private static String CODE = "oc.shopping.con";
    @Autowired
    private PureCglibCopier pureCglibCopier;

    @Override
    protected String getContext() {
        return "shopping";
    }

    @RequestMapping(value={"saveShopping.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveShoppingCom(request, ocShoppingDomain);
    }

    @RequestMapping(value={"getShopping.json"}, name="\u83b7\u53d6\u8d2d\u7269\u8f66\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcShoppingReDomain getShopping(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".getShopping", (Object)"param is null");
            return null;
        }
        return this.getShoppingCom(shoppingId);
    }

    @RequestMapping(value={"updateShopping.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".updateShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShoppingCom(request, ocShoppingDomain);
    }

    @RequestMapping(value={"deleteShopping.json"}, name="\u5220\u9664\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShopping(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".deleteShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.deleteShoppingCom(shoppingId);
    }

    @RequestMapping(value={"wishLists.json"}, name="\u6e20\u9053\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public SupQueryResult<Integer> wishLists(HttpServletRequest request) {
        String memberCode;
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank((String)(memberCode = this.getMerchantCode(request)))) {
            this.logger.error(CODE + ".queryShoppingPage", (Object)"memberCode");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", memberCode);
        param.put("tenantCode", tenantCode);
        if (null != param) {
            param.put("order", true);
        }
        return this.wishListsCom(request, param);
    }

    @RequestMapping(value={"shoppingList.json"}, name="\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public SupQueryResult<Integer> shoppingList(HttpServletRequest request) {
        String memberCode;
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank((String)(memberCode = this.getMerchantCode(request)))) {
            this.logger.error(CODE + ".queryShoppingPage", (Object)"memberCode");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", memberCode);
        param.put("tenantCode", tenantCode);
        if (null != param) {
            param.put("order", true);
        }
        return this.shoppingListCom(request, param);
    }

    @RequestMapping(value={"queryShoppingPage.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public BffQueryResult<OcShoppingReDomain> queryShoppingPage(HttpServletRequest request) throws Exception {
        Map<String, Object> param = this.assemMapBuyParam(request);
        param.put("order", true);
        return this.pureCglibCopier.copy(this.queryShoppingPageCom(request, param, null), BffQueryResult.class);
    }

    public BffQueryResult<OcShoppingReDomain> queryShoppingPage(HttpServletRequest request, String noCheckPm) throws Exception {
        Map<String, Object> param = this.assemMapBuyParam(request);
        param.put("noCheckPm", noCheckPm);
        return this.pureCglibCopier.copy(this.queryShoppingPageCom(request, param, null), BffQueryResult.class);
    }

    @RequestMapping(value={"queryShoppingPageNew.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u670d\u52a1\u5206\u9875\u5217\u8868(\u65b0)")
    @ResponseBody
    public SupQueryResult<OcShoppingReDomain> queryShoppingPageNew(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        this.logger.error("param is ------>", (Object)param.toString());
        return this.queryShoppingPageComNew(request, param, null);
    }

    @RequestMapping(value={"updateShoppingGoodsPmInfo.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u7684\u8425\u9500\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsPmInfo(HttpServletRequest request, String shoppingGoodsId, String promotionCode) {
        if (StringUtils.isBlank((String)shoppingGoodsId) || StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".updateShoppingGoodsPmInfo", (Object)" param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.getShoppingGoods(shoppingGoodsId);
        if (null == ocShoppingGoodsReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u6570\u636e");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        String userPcode = userSession.getUserPcode();
        if (!userPcode.equals(ocShoppingGoodsReDomain.getMemberBcode())) {
            this.logger.error(CODE + ".updateShoppingGoodsPmInfo", (Object)(" userPcode\uff1a" + userPcode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d8a\u6743\u64cd\u4f5c");
        }
        return this.updateShoppingGoodsPmInfoCom(request, shoppingGoodsId, promotionCode);
    }

    @RequestMapping(value={"updateShoppingGoodsCheckState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u7684\u9009\u4e2d\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsCheckState(HttpServletRequest request, String shoppingGoodsIdStr, String shoppingCode, Integer checkState) {
        return this.updateShoppingGoodsCheckStateCom(request, shoppingGoodsIdStr, shoppingCode, checkState);
    }

    @RequestMapping(value={"updateShoppingGoodsNum.json"}, name="\u4fee\u6539\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsNum(HttpServletRequest request, Integer shoppingGoodsId, BigDecimal amount, BigDecimal goodWeight) {
        Map<String, Object> param = this.assemMapParam(request);
        String shoppingGoodsCode = null;
        if (null != param.get("shoppingGoodsCode")) {
            shoppingGoodsCode = param.get("shoppingGoodsCode").toString();
        }
        if (StringUtils.isBlank((Integer)shoppingGoodsId) && StringUtils.isBlank((String)shoppingGoodsCode)) {
            this.logger.error("EXCEPTION:" + CODE + ".updateShoppingGoodsNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == amount && null == goodWeight) {
            this.logger.error("EXCEPTION:" + CODE + ".updateShoppingGoodsNum", (Object)"amount or goodWeight is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Integer countLimit = 0;
        String channelCodeByType = BaseInterUtil.getChannelCodeByType((HttpServletRequest)request, (String)BaseInterUtil.QUA_BUY);
        if (null != param && null != param.get("skuNo")) {
            List<RsSkuReDomain> skuNo = null;
            try {
                skuNo = this.findRsSkuByNo(param.get("skuNo").toString(), channelCodeByType, this.getTenantCode(request));
            }
            catch (Exception e) {
                this.logger.error(CODE + ".updateShoppingGoodsNum \u672a\u547d\u4e2des ", param.get("skuNo"));
            }
            if (ListUtil.isEmpty(skuNo)) {
                Object skuNo1 = param.get("skuNo");
                param = new HashMap<String, Object>();
                param.put("tenantCode", this.getTenantCode(request));
                param.put("channelCode", channelCodeByType);
                param.put("skuNo", skuNo1);
                param.put("goodsType", "00");
                skuNo = this.getRsByNo(param);
            }
            if (ListUtil.isNotEmpty(skuNo)) {
                for (RsSkuReDomain rsSkuReDomain : skuNo) {
                    if (null == rsSkuReDomain.getGoodsSupplynum()) {
                        rsSkuReDomain.setGoodsSupplynum(BigDecimal.ZERO);
                    }
                    if (rsSkuReDomain.getGoodsSupplynum().compareTo(BigDecimal.ZERO) <= 0) {
                        this.logger.error("EXCEPTION:" + CODE + ".GoodsSupplynum", (Object)"\u5e93\u5b58\u4e0d\u8db3");
                        return new HtmlJsonReBean("error", "\u5e93\u5b58\u4e0d\u8db3");
                    }
                    if (1 != rsSkuReDomain.getDataOpbillstate()) {
                        this.logger.error("EXCEPTION:" + CODE + ".DataOpbillstate", (Object)"\u5546\u54c1\u5df2\u4e0b\u67b6");
                        return new HtmlJsonReBean("error", "\u5546\u54c1\u5df2\u4e0b\u67b6");
                    }
                    countLimit = rsSkuReDomain.getCountsLimit();
                }
            } else {
                this.logger.error("EXCEPTION:" + CODE + ".updateShoppingGoodsNum.skuNo", (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
                return new HtmlJsonReBean("error", "\u5546\u54c1\u4e0d\u5b58\u5728");
            }
        }
        if (StringUtils.isNotBlank((String)shoppingGoodsCode)) {
            return this.updateShoppingGoodsNumComByCode(shoppingGoodsCode, amount, goodWeight, this.getTenantCode(request));
        }
        return this.updateShoppingGoodsNumCom(request, shoppingGoodsId, amount, goodWeight);
    }

    @RequestMapping(value={"updateShoppingState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingState(String shoppingId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".updateShoppingState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShoppingStateCom(shoppingId, dataState, oldDataState);
    }

    @RequestMapping(value={"saveContractByOcShopping.json"}, name="\u4ece\u8d2d\u7269\u8f66\u4e2d\u4e0b\u5355")
    @ResponseBody
    public HtmlJsonReBean saveContractByOcShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain, String contractTypepro) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveContractByOcShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveContractByOcShoppingCom(request, ocShoppingDomain, contractTypepro);
    }

    @RequestMapping(value={"insertShoppingGoods.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean insertShoppingGoods(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".insertShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.insertShoppingGoodsCom(request, ocShoppingGoodsDomain);
    }

    @RequestMapping(value={"addShoppingGoodsBySpec.json"}, name="\u901a\u8fc7\u89c4\u683c\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsBySpec(HttpServletRequest request, String goodsCode, String specStr) {
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(CODE + ".addShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.addShoppingGoodsBySpecCom(request, goodsCode, specStr, null);
    }

    @RequestMapping(value={"addBatchShoppingGoodsBySpec.json"}, name="\u901a\u8fc7\u89c4\u683c\u6279\u91cf\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addBatchShoppingGoodsBySpec(HttpServletRequest request, String rsSkuDomainListJson) {
        if (StringUtils.isBlank((String)rsSkuDomainListJson)) {
            this.logger.error(CODE + ".addBatchShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rsSkuDomainList = JsonUtil.buildNormalBinder().getJsonToList(rsSkuDomainListJson, RsSkuDomain.class);
        boolean errorCode = true;
        HashMap<String, String> map = new HashMap<String, String>();
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            htmlJsonReBean = this.addShoppingGoodsBySpecCom(request, rsSkuDomain.getGoodsCode(), rsSkuDomain.getGoodsName(), null);
            if (!"-1".equals(htmlJsonReBean.getErrorCode())) continue;
            errorCode = false;
            map.put(rsSkuDomain.getGoodsCode() + "-" + rsSkuDomain.getGoodsName(), htmlJsonReBean.getMsg());
        }
        if (!errorCode) {
            htmlJsonReBean.setDataObj(map);
            return htmlJsonReBean;
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"addShoppingGoodss.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodss(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght) {
        return this.addShoppingGoodsCustCom(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, null);
    }

    @RequestMapping(value={"addShoppingGoods.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoods(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght) {
        int goodsNums = 0;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", this.getTenantCode(request));
        param.put("memberBcode", this.getMerchantCode(request));
        param.put("queryCount", false);
        SupQueryResult<OcShoppingReDomain> ocShoppingReDomainSupQueryResult = this.queryShoppingPage(param);
        if (null != ocShoppingReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
            for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainSupQueryResult.getList()) {
                if (!ListUtil.isNotEmpty(ocShoppingReDomain.getShoppingpackageList())) continue;
                for (OcShoppingpackgeDomain ocShoppingpackgeDomain : ocShoppingReDomain.getShoppingpackageList()) {
                    if (!ListUtil.isNotEmpty(ocShoppingpackgeDomain.getShoppingGoodsList())) continue;
                    goodsNums += ocShoppingpackgeDomain.getShoppingGoodsList().size();
                }
            }
        }
        if (goodsNums >= 50) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6dfb\u52a0\u5546\u54c1\u79cd\u7c7b\u4e0d\u80fd\u8d85\u8fc750");
        }
        HtmlJsonReBean htmlJsonReBean = this.addShoppingGoodsCom(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, null);
        if ("success".equals(htmlJsonReBean.getSysRecode())) {
            htmlJsonReBean.setMsg("\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f");
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"checkGoodsAddressRange.json"}, name="\u6821\u9a8c\u5546\u54c1\u6536\u8d27\u5730\u5740")
    @ResponseBody
    public HtmlJsonReBean checkGoodsAddressRangeC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (param.get("freightTemCode") == null) {
            this.logger.error("EXCEPTION:" + CODE + ".checkGoodsAddressRangeC.param", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u7f3a\u5931");
        }
        String areaCode = null;
        String cityCode = null;
        String provinceCode = null;
        String rodeCode = null;
        HashMap<String, Object> freightMap = new HashMap<String, Object>();
        if (param.get("roadCode") != null) {
            rodeCode = param.get("roadCode").toString();
            param.remove("roadCode");
        }
        if (param.get("areaCode") != null) {
            areaCode = param.get("areaCode").toString();
            param.remove("areaCode");
        }
        if (param.get("cityCode") != null) {
            cityCode = param.get("cityCode").toString();
            param.remove("cityCode");
        }
        if (param.get("provinceCode") != null) {
            provinceCode = param.get("provinceCode").toString();
            param.remove("provinceCode");
        }
        String goodsFlag = (String)param.get("goodsFlag");
        boolean flag = false;
        if (StringUtils.isNotBlank((String)goodsFlag)) {
            flag = true;
        }
        return new HtmlJsonReBean((Object)this.checkGoodsAddressRangeNew(param.get("freightTemCode").toString(), areaCode, cityCode, provinceCode, rodeCode, this.getTenantCode(request), freightMap, flag));
    }

    @RequestMapping(value={"addBatchShoppingGoods.json"}, name="\u6279\u91cf\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addBatchShoppingGoods(HttpServletRequest request, String goodsBeanListJson) {
        if (StringUtils.isBlank((String)goodsBeanListJson)) {
            this.logger.error(CODE + ".addBatchShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsBeanList = JsonUtil.buildNormalBinder().getJsonToList(goodsBeanListJson, GoodsBean.class);
        return this.addShoppingGoodsComBean(request, goodsBeanList, null);
    }

    @RequestMapping(value={"addShoppingGoodsByCode.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsByCode(HttpServletRequest request, String skuCode, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String goodsType) {
        if (StringUtils.isBlank((String)skuCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "skuCode\u4e3a\u7a7a");
        }
        RsSkuReDomain rsSkuReDomain = this.getRsByCode(skuCode, this.getTenantCode(request));
        if (null == rsSkuReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        return this.addShoppingGoodsCom(request, rsSkuReDomain.getSkuId(), shoppingGoodsPm, goodsNum, goodsWeght, null);
    }

    @RequestMapping(value={"addShoppingGoodsByNo.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsByNo(HttpServletRequest request, String skuNo, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String goodsType) {
        if (StringUtils.isBlank((String)skuNo)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u53f7\u4e3a\u7a7a");
        }
        RsSkuReDomain rsSkuReDomain = this.getRsByNo(skuNo, this.getMemberCcode(request), this.getNowChannel(request), this.getTenantCode(request), goodsType);
        this.logger.error(CODE + ".addShoppingGoodsByNo", (Object)(skuNo + ":" + this.getMemberCcode(request) + ":" + this.getNowChannel(request) + ":" + this.getTenantCode(request)));
        if (null == rsSkuReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        return this.addShoppingGoodsCom(request, rsSkuReDomain.getSkuId(), shoppingGoodsPm, goodsNum, goodsWeght, null);
    }

    @RequestMapping(value={"addShoppingGoodsForNo.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsForNo(HttpServletRequest request, String skuNo, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String goodsType) {
        if (StringUtils.isBlank((String)skuNo)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u53f7\u4e3a\u7a7a");
        }
        RsSkuReDomain rsSkuReDomain = this.getRsByNo(skuNo, this.getMemberCcode(request), this.getNowChannel(request), this.getTenantCode(request), goodsType);
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".addShoppingGoodsForNo", (Object)(skuNo + ":" + this.getMemberCcode(request) + ":" + this.getNowChannel(request) + ":" + this.getTenantCode(request)));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        return this.addShoppingGoodsCustCom(request, rsSkuReDomain.getSkuId(), shoppingGoodsPm, goodsNum, goodsWeght, null);
    }

    @RequestMapping(value={"addShoppingGoodsForCh.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsForCh(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght) {
        return this.addShoppingGoodsCustCom(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, null);
    }

    @RequestMapping(value={"addShoppingGoodsCode.json"}, name="\u901a\u8fc7SKUcode\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1,\u53ef\u4f20\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsCode(HttpServletRequest request, String goodsBeanStr) {
        return this.addShoppingGoodsCodeCom(request, goodsBeanStr, null);
    }

    @RequestMapping(value={"getShoppingGoods.json"}, name="\u83b7\u53d6\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcShoppingGoodsReDomain getShoppingGoods(String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".getShoppingGoods", (Object)"param is null");
            return null;
        }
        return this.getShoppingGoodsCom(shoppingGoodsId);
    }

    @RequestMapping(value={"updateShoppingGoods.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoods(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".updateShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShoppingGoodsCom(request, ocShoppingGoodsDomain);
    }

    @RequestMapping(value={"updateShoppingGood.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGood(HttpServletRequest request, String goodsStr) {
        if (StringUtils.isBlank((String)goodsStr)) {
            this.logger.error(CODE + ".updateShoppingGoodsNumBatchCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcShoppingGoodsDomain ocShoppingGoodsDomain = (OcShoppingGoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(goodsStr, OcShoppingGoodsDomain.class);
        return this.updateShoppingGoodsCom(request, ocShoppingGoodsDomain);
    }

    @RequestMapping(value={"deleteShoppingGoods.json"}, name="\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShoppingGoods(HttpServletRequest request, String shoppingGoodsId) {
        Map<String, Object> param = this.assemMapParam(request);
        String shoppingGoodsCode = null;
        if (null != param.get("shoppingGoodsCode")) {
            shoppingGoodsCode = param.get("shoppingGoodsCode").toString();
        }
        if (StringUtils.isBlank((String)shoppingGoodsId) && StringUtils.isBlank((String)shoppingGoodsCode)) {
            this.logger.error(CODE + ".deleteShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isNotBlank((String)shoppingGoodsCode)) {
            return this.deleteShoppingGoodsComByCode(request, shoppingGoodsCode);
        }
        return this.deleteShoppingGoodsCom(request, shoppingGoodsId);
    }

    @RequestMapping(value={"deleteShoppingGoodsBatch.json"}, name="\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShoppingGoodsBatch(HttpServletRequest request, String shoppingGoodsIdStr) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".deleteShoppingGoodsBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map<String, Object> paramStr = this.assemMapBuyParam(request);
        return this.deleteShoppingGoodsBatchCom(shoppingGoodsIdStr, paramStr);
    }

    @RequestMapping(value={"updateShoppingGoodsNumBatch.json"}, name="\u6279\u91cf\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsNumBatch(String goodsListStr) {
        if (StringUtils.isBlank((String)goodsListStr)) {
            this.logger.error(CODE + ".updateShoppingGoodsNumBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShoppingGoodsNumBatchCom(goodsListStr);
    }

    @RequestMapping(value={"queryShoppingGoodsPage.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShoppingGoodsReDomain> queryShoppingGoodsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryShoppingGoodsPageCom(request, param);
    }

    @RequestMapping(value={"queryShoppingGoodsByUser.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShoppingGoodsReDomain> queryShoppingGoodsByUser(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new SupQueryResult();
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
            param.put("memberBcode", userSession.getUserPcode());
        }
        return this.queryShoppingGoodsPageCom(request, param);
    }

    @RequestMapping(value={"queryShoppingGoodsByUserToMap.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public Map<String, BigDecimal> queryShoppingGoodsByUserToMap(HttpServletRequest request) {
        SupQueryResult<OcShoppingGoodsReDomain> shoppingGoodsPage;
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (null == userSession) {
            return resultMap;
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
            param.put("memberBcode", userSession.getUserPcode());
        }
        if (null != (shoppingGoodsPage = this.queryShoppingGoodsPageCom(request, param)) && ListUtil.isNotEmpty((Collection)shoppingGoodsPage.getList())) {
            for (OcShoppingGoodsReDomain shoppingGoods : shoppingGoodsPage.getList()) {
                if (null == resultMap.get(shoppingGoods.getGoodsCode())) {
                    resultMap.put(shoppingGoods.getGoodsCode(), shoppingGoods.getGoodsCamount());
                    continue;
                }
                BigDecimal value = ((BigDecimal)resultMap.get(shoppingGoods.getGoodsCode())).add(shoppingGoods.getGoodsCamount());
                resultMap.put(shoppingGoods.getGoodsCode(), value);
            }
        }
        return resultMap;
    }

    @RequestMapping(value={"updateShoppingGoodsState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsState(String shoppingGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".updateShoppingGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShoppingGoodsStateCom(shoppingGoodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"queryShoppingToContract.json"}, name="\u8d2d\u7269\u8f66\u7ed3\u7b97\u9875\u9762")
    @ResponseBody
    public List<OcShoppingReDomain> queryShoppingToContract(HttpServletRequest request, String shoppingGoodsIdStr, String contractPmode) throws Exception {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".queryShoppingToContract", (Object)"param is null");
            return null;
        }
        return this.queryShoppingToContractComPlus(request, shoppingGoodsIdStr, null, contractPmode);
    }

    @RequestMapping(value={"queryToContractCode.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762\u901a\u8fc7skuCode,\u4f20\u7c7b\u578b")
    @ResponseBody
    public List<OcShoppingReDomain> queryToContractCode(HttpServletRequest request, String skuCode, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String shoppingType, String contractNbillcode, String pricesetType, String contractPmode) throws Exception {
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error(CODE + ".queryToContractCode", (Object)"param is null");
            return null;
        }
        return this.queryToContractCodeCom(request, skuCode, shoppingGoodsPm, goodsNum, goodsWeght, shoppingType, contractNbillcode, pricesetType, null, contractPmode);
    }

    @RequestMapping(value={"queryToContractCodeList.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762\u901a\u8fc7skuCodeList,\u4f20\u7c7b\u578b")
    @ResponseBody
    public List<OcShoppingReDomain> queryToContractCodeList(HttpServletRequest request, String goodsBeanStr, String contractPmode) throws Exception {
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error(CODE + ".queryToContractCodeList", (Object)"param is null");
            return null;
        }
        return this.queryToContractCodeListCom(request, goodsBeanStr, null, contractPmode);
    }

    @RequestMapping(value={"queryToContractCodeListForNew.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762\u901a\u8fc7skuCodeList,\u4f20\u7c7b\u578b")
    @ResponseBody
    public List<OcShoppingReDomain> queryToContractCodeListForNew(HttpServletRequest request, String goodsBeanStr, String contractPmode) throws Exception {
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error(CODE + ".queryToContractCodeList", (Object)"param is null");
            return null;
        }
        return this.queryToContractCodeListCom(request, goodsBeanStr, null, contractPmode);
    }

    @RequestMapping(value={"queryToContract.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762")
    @ResponseBody
    public List<OcShoppingReDomain> queryToContract(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String contractPmode, String contractPumode) {
        try {
            if (null == skuId) {
                this.logger.error("EXCEPTION:" + CODE + ".queryToContract.skuId", (Object)"skuId is null");
                return null;
            }
            return this.queryToContractCom(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, null, contractPmode, contractPumode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"addBatchShoppingsGoods.json"}, name="\u6279\u91cf\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addBatchShoppingsGoods(HttpServletRequest request, String goodsBeanListJson) {
        if (StringUtils.isBlank((String)goodsBeanListJson)) {
            this.logger.error(CODE + ".addBatchShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsBeanList = JsonUtil.buildNormalBinder().getJsonToList(goodsBeanListJson, GoodsBean.class);
        return this.addShoppingGoodsComBean(request, goodsBeanList, null);
    }

    @RequestMapping(value={"queryToNvrGoods.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u4e2d\u5546\u54c1\u5bf9\u5e94\u7684\u539f\u578b\u673abom\u5546\u54c1")
    @ResponseBody
    public List<RsSkuReDomain> queryToNvrGoods(HttpServletRequest request, String goodsSpec, String memberCode) {
        if (StringUtils.isBlank((String)goodsSpec) || StringUtils.isBlank((String)memberCode)) {
            this.logger.error(CODE + ".queryToNvrGoods", (Object)"goodsSpec is null");
            return null;
        }
        return this.queryToNvrGo(request, goodsSpec, memberCode);
    }

    @RequestMapping(value={"checkGoodsQuality.json"}, name="\u67e5\u8be2\u7528\u6237\u5546\u54c1\u8d44\u8d28")
    @ResponseBody
    public HtmlJsonReBean checkGoodsQuality(HttpServletRequest request, String goodsBeanStr) {
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error(CODE + ".addBatchShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String mns = this.checkOcContractGoodsDomainQuality(goodsBeanStr, request, null);
        if (StringUtils.isNotBlank((String)mns)) {
            return new HtmlJsonReBean((Object)mns);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"checkGoodsQualityByBcode.json"}, name="\u67e5\u8be2\u7528\u6237\u5546\u54c1\u8d44\u8d28(\u4e1a\u52a1\u5458\u7aef)")
    @ResponseBody
    public HtmlJsonReBean checkGoodsQualityByBcode(HttpServletRequest request, String goodsBeanStr, String memberBcode) {
        if (StringUtils.isBlank((String)goodsBeanStr) || StringUtils.isBlank((String)memberBcode)) {
            this.logger.error(CODE + ".addBatchShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String mns = this.checkOcContractGoodsDomainQuality(goodsBeanStr, request, memberBcode);
        if (StringUtils.isNotBlank((String)mns)) {
            return new HtmlJsonReBean((Object)mns);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryShoppingTomemberCode.json"}, name="\u8d2d\u7269\u8f66\u7ed3\u7b97\u9875\u9762")
    @ResponseBody
    public List<OcShoppingReDomain> queryShoppingTomemberCode(HttpServletRequest request, String shoppingGoodsIdStr, String memberBcode) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr) || StringUtils.isBlank((String)memberBcode)) {
            this.logger.error(CODE + ".queryShoppingTomemberCode", (Object)"param is null");
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        param.put("memberBcode", memberBcode);
        SupQueryResult<OcShoppingReDomain> ocShoppingReDomainSupQueryResult = this.queryShoppingPageCom(request, param, null);
        if (null == ocShoppingReDomainSupQueryResult || ListUtil.isEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryShoppingToContract", (Object)"ocShoppingReDomainSupQueryResult is null");
            return null;
        }
        return this.queryShoppingToContractCom(request, shoppingGoodsIdStr, null, null);
    }
}

