/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.pay;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pte/payback"}, name="\u94f6\u884c\u901a\u77e5\u56de\u8c03")
public class PayBackCon
extends SpringmvcController {
    private static String CODE = "pte.payback.con";
    @Autowired
    private OcContractService ocContractService;

    @Override
    protected String getContext() {
        return "payback";
    }

    @RequestMapping(value={"http/get/{fchannelCode}/{tenantCode}/{fchannelPmode}/{businessOrderno}"}, method={RequestMethod.GET}, name="\u652f\u4ed8\u4e0b\u5355\u901a\u77e5")
    public String getBankReturn(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="fchannelCode") String fchannelCode, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="fchannelPmode") String fchannelPmode, @PathVariable(value="businessOrderno") String businessOrderno) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", businessOrderno);
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractByCode(map);
        if (null == ocContractReDomain) {
            this.logger.info(CODE + ".getBankReturn.null", (Object)((Object)map).toString());
        }
        return this.createHtml(ocContractReDomain);
    }

    @RequestMapping(value={"order.json"}, name="\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u67e5\u8be2")
    @ResponseBody
    public HtmlJsonReBean getOrderPayState(HttpServletRequest request, HttpServletResponse response, String contractBillcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("contractBillcode", contractBillcode);
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractByCode(map);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".getBankReturn.null", (Object)((Object)map).toString());
            return new HtmlJsonReBean(CODE + ".getBankReturn.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        Integer datastate = ocContractReDomain.getDataState();
        if (null == datastate || 2 != datastate) {
            return new HtmlJsonReBean(CODE + ".getBankReturn.datastate", "\u652f\u4ed8\u672a\u5b8c\u6210");
        }
        return new HtmlJsonReBean();
    }

    private String createHtml(OcContractReDomain ocContractReDomain) {
        Integer datastate = 0;
        String contractBillcode = "";
        String tenantCode = "";
        if (null != ocContractReDomain) {
            datastate = ocContractReDomain.getDataState();
            contractBillcode = ocContractReDomain.getContractBillcode();
            tenantCode = ocContractReDomain.getTenantCode();
        }
        String html = datastate + contractBillcode + tenantCode;
        return html;
    }

    @RequestMapping(value={"queryAuthCode.json"}, name="\u83b7\u53d6\u4f1a\u5355\u53f7\u7684\u9a8c\u8bc1\u7801")
    @ResponseBody
    public HtmlJsonReBean queryAuthCode(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug(CODE + ".queryAuthCode.json", (Object)"============================================\u83b7\u53d6\u4f1a\u5355\u53f7\u7684\u9a8c\u8bc1\u7801============================================");
        Map<String, Object> param = this.assemMapParam(request);
        HashMap<String, String> map = new HashMap<String, String>();
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        Map<String, Object> returnMap = this.ocContractService.queryAuthCode(param, tenantCode);
        if (returnMap.isEmpty()) {
            this.logger.error(CODE + ".queryAuthCode.null", (Object)((Object)map).toString());
            return new HtmlJsonReBean(CODE + ".queryAuthCode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return new HtmlJsonReBean(returnMap);
    }

    @RequestMapping(value={"queryReceipt.json"}, name="\u5206\u9875\u83b7\u53d6\u56de\u5355")
    @ResponseBody
    public HtmlJsonReBean queryReceipt(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug(CODE + ".queryReceipt.json", (Object)"============================================\u83b7\u53d6\u4f1a\u5355\u53f7\u7684\u9a8c\u8bc1\u7801============================================");
        Map<String, Object> param = this.assemMapParam(request);
        HashMap<String, String> map = new HashMap<String, String>();
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        Map<String, Object> returnMap = this.ocContractService.queryReceipt(param, tenantCode);
        if (returnMap.isEmpty()) {
            this.logger.error(CODE + ".queryReceipt.null", (Object)((Object)map).toString());
            return new HtmlJsonReBean(CODE + ".queryReceipt.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return new HtmlJsonReBean(returnMap);
    }
}

