/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.de;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.de.RsDeviceInfoDomain;
import cn.com.qj.bff.domain.de.RsDeviceInfoReDomain;
import cn.com.qj.bff.domain.rs.RsGoodsRelDomain;
import cn.com.qj.bff.domain.rs.RsGoodsRelReDomain;
import cn.com.qj.bff.domain.um.UmUserDomainBean;
import cn.com.qj.bff.domain.um.UmUserReDomainBean;
import cn.com.qj.bff.domain.um.UmUserinfoQuaDomain;
import cn.com.qj.bff.domain.um.UmUserinfoQuaReDomain;
import cn.com.qj.bff.service.de.RsDeviceInfoService;
import cn.com.qj.bff.service.rs.RsGoodsOtherService;
import cn.com.qj.bff.service.um.UmUserinfoQuaService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/deviceInfo"}, name="\u8bbe\u5907\u7ba1\u7406")
public class DeviceInfoCon
extends SpringmvcController {
    private static String CODE = "rs.deviceInfo.con";
    @Autowired
    private RsDeviceInfoService rsDeviceInfoService;
    @Autowired
    private UserService userService;
    @Autowired
    private UmUserinfoQuaService umUserinfoQuaService;
    @Autowired
    private RsGoodsOtherService rsGoodsOtherService;

    @Override
    protected String getContext() {
        return "deviceInfo";
    }

    @RequestMapping(value={"saveDeviceInfo.json"}, name="\u589e\u52a0\u8bbe\u5907\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveDeviceInfo(HttpServletRequest request, RsDeviceInfoDomain rsDeviceInfoDomain) {
        if (null == rsDeviceInfoDomain) {
            this.logger.error(CODE + ".saveDeviceInfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null != rsDeviceInfoDomain.getDeviceType() && 2 == rsDeviceInfoDomain.getDeviceType() && null == rsDeviceInfoDomain.getDevicePcode()) {
            this.logger.error(CODE + ".saveDeviceInfo", (Object)"devicePcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u914d\u4ef6\u5173\u8054\u8bbe\u5907\u4e0d\u80fd\u4e3a\u7a7a");
        }
        rsDeviceInfoDomain.setTenantCode(this.getTenantCode(request));
        HtmlJsonReBean htmlJsonReBean = this.rsDeviceInfoService.saveDeviceInfo(rsDeviceInfoDomain);
        if (ListUtil.isNotEmpty(rsDeviceInfoDomain.getRsGoodsRelReDomainList()) && null != rsDeviceInfoDomain.getDeviceType() && 1 == rsDeviceInfoDomain.getDeviceType() && null != htmlJsonReBean && "true".equals(htmlJsonReBean.getSysRecode())) {
            for (RsGoodsRelDomain rsGoodsRelReDomain : rsDeviceInfoDomain.getRsGoodsRelReDomainList()) {
                rsGoodsRelReDomain.setGoodsRelCode(rsDeviceInfoDomain.getDeviceCode());
                rsGoodsRelReDomain.setTenantCode(this.getTenantCode(request));
            }
            this.rsGoodsOtherService.saveGoodsRelList(rsDeviceInfoDomain.getRsGoodsRelReDomainList());
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveUserDeviceInfo.json"}, name="\u7ed1\u5b9a\u6211\u7684\u8bbe\u5907")
    @ResponseBody
    public HtmlJsonReBean saveUserDeviceInfo(HttpServletRequest request, RsDeviceInfoDomain rsDeviceInfoDomain) {
        if (null == rsDeviceInfoDomain || null == rsDeviceInfoDomain.getDeviceCode()) {
            this.logger.error(CODE + ".saveDeviceInfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || null == userSession.getUserPcode()) {
            this.logger.error(CODE + ".saveUserDeviceInfo", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u672a\u767b\u5f55");
        }
        RsDeviceInfoReDomain rsDeviceInfoReDomain = this.rsDeviceInfoService.getDeviceInfoByCode(this.getTenantCode(request), rsDeviceInfoDomain.getDeviceCode());
        if (null != rsDeviceInfoReDomain) {
            UmUserinfoQuaDomain quaDomain = new UmUserinfoQuaDomain();
            quaDomain.setUserinfoQuaKey("deviceCode");
            quaDomain.setUserinfoQuaVaule(rsDeviceInfoDomain.getDeviceCode());
            quaDomain.setUserinfoCode(userSession.getUserPcode());
            quaDomain.setTenantCode(this.getTenantCode(request));
            return this.umUserinfoQuaService.saveUserinfoQua(quaDomain);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bbe\u5907\u4fe1\u606f\u4e0d\u5b58\u5728");
    }

    @RequestMapping(value={"saveNowDeviceInfo.json"}, name="\u8bbe\u7f6e\u5f53\u524d\u8bbe\u5907")
    @ResponseBody
    public HtmlJsonReBean saveNowDeviceInfo(HttpServletRequest request, RsDeviceInfoDomain rsDeviceInfoDomain) {
        if (null == rsDeviceInfoDomain || null == rsDeviceInfoDomain.getDeviceCode()) {
            this.logger.error(CODE + ".saveDeviceInfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || null == userSession.getUserCode()) {
            this.logger.error(CODE + ".saveNowDeviceInfo", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u672a\u767b\u5f55");
        }
        RsDeviceInfoReDomain rsDeviceInfoReDomain = this.rsDeviceInfoService.getDeviceInfoByCode(this.getTenantCode(request), rsDeviceInfoDomain.getDeviceCode());
        if (null != rsDeviceInfoReDomain) {
            UmUserReDomainBean userByCode = this.userService.getUserByCode(userSession.getUserCode(), this.getTenantCode(request));
            if (null == userByCode) {
                this.logger.error(CODE + ".saveNowDeviceInfo", (Object)"userByCode is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
            umUserDomainBean.setUserId(userByCode.getUserId());
            umUserDomainBean.setUserMsg(rsDeviceInfoDomain.getDeviceCode());
            return this.userService.updateUser(umUserDomainBean);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bbe\u5907\u4fe1\u606f\u4e0d\u5b58\u5728");
    }

    @RequestMapping(value={"getDeviceInfo.json"}, name="\u83b7\u53d6\u8bbe\u5907\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public RsDeviceInfoReDomain getDeviceInfo(Integer deviceId) {
        if (StringUtils.isBlank((Integer)deviceId)) {
            this.logger.error(CODE + ".getDeviceInfo", (Object)"param is null");
            return null;
        }
        return this.rsDeviceInfoService.getDeviceInfo(deviceId);
    }

    @RequestMapping(value={"updateDeviceInfo.json"}, name="\u66f4\u65b0\u8bbe\u5907\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean updateDeviceInfo(HttpServletRequest request, RsDeviceInfoDomain rsDeviceInfoDomain) {
        if (null == rsDeviceInfoDomain) {
            this.logger.error(CODE + ".updateDeviceInfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsDeviceInfoDomain.setTenantCode(this.getTenantCode(request));
        return this.rsDeviceInfoService.updateDeviceInfo(rsDeviceInfoDomain);
    }

    @RequestMapping(value={"deleteDeviceInfo.json"}, name="\u5220\u9664\u8bbe\u5907\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteDeviceInfo(Integer deviceId) {
        if (StringUtils.isBlank((Integer)deviceId)) {
            this.logger.error(CODE + ".deleteDeviceInfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsDeviceInfoService.deleteDeviceInfo(deviceId);
    }

    @RequestMapping(value={"deleteUserDeviceInfo.json"}, name="\u5220\u9664\u6211\u7684\u8bbe\u5907\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteUserDeviceInfo(HttpServletRequest request, Integer deviceId) {
        if (StringUtils.isBlank((Integer)deviceId)) {
            this.logger.error(CODE + ".deleteDeviceInfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || null == userSession.getUserPcode()) {
            this.logger.error(CODE + ".deleteUserDeviceInfo", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u672a\u767b\u5f55");
        }
        RsDeviceInfoReDomain deviceInfo = this.rsDeviceInfoService.getDeviceInfo(deviceId);
        if (null == deviceInfo) {
            this.logger.error(CODE + ".deleteDeviceInfo", (Object)"deviceInfo is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bbe\u5907\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> userinfoQuaParam = new HashMap<String, Object>();
        userinfoQuaParam.put("tenantCode", this.getTenantCode(request));
        userinfoQuaParam.put("userinfoCode", userSession.getUserPcode());
        userinfoQuaParam.put("userinfoQuaKey", "deviceCode");
        userinfoQuaParam.put("userinfoQuaVaule", deviceInfo.getDeviceCode());
        SupQueryResult<UmUserinfoQuaReDomain> reDomainSupQueryResult = this.umUserinfoQuaService.queryUserinfoQuaPage(userinfoQuaParam);
        if (null != reDomainSupQueryResult && null != reDomainSupQueryResult.getList()) {
            Integer userinfoQuaId = ((UmUserinfoQuaReDomain)reDomainSupQueryResult.getList().get(0)).getUserinfoQuaId();
            return this.umUserinfoQuaService.deleteUserinfoQua(userinfoQuaId);
        }
        this.logger.error(CODE + ".deleteDeviceInfo", (Object)"reDomainSupQueryResult is null");
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bbe\u5907\u4fe1\u606f\u672a\u7ed1\u5b9a");
    }

    @RequestMapping(value={"queryDeviceInfoPage.json"}, name="\u67e5\u8be2\u8bbe\u5907\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsDeviceInfoReDomain> queryDeviceInfoPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsDeviceInfoService.queryDeviceInfoPage(param);
    }

    @RequestMapping(value={"queryUserDeviceInfoPage.json"}, name="\u67e5\u8be2\u7528\u6237\u8bbe\u5907\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsDeviceInfoReDomain> queryUserDeviceInfoPage(HttpServletRequest request) {
        UserSession userSession;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userSession = this.getUserSession(request))) {
            this.logger.error(CODE + ".queryUserDeviceInfoPage", (Object)"userSession is null");
            return new SupQueryResult();
        }
        String userPcode = userSession.getUserPcode();
        if (null != userPcode) {
            HashMap<String, Object> userinfoQuaParam = new HashMap<String, Object>();
            userinfoQuaParam.put("tenantCode", this.getTenantCode(request));
            userinfoQuaParam.put("userinfoCode", userPcode);
            userinfoQuaParam.put("userinfoQuaKey", "deviceCode");
            SupQueryResult<UmUserinfoQuaReDomain> reDomainSupQueryResult = this.umUserinfoQuaService.queryUserinfoQuaPage(userinfoQuaParam);
            this.logger.info(CODE + ".queryUserDeviceInfoPage", (Object)("reDomainSupQueryResult is " + JsonUtil.buildNormalBinder().toJson(reDomainSupQueryResult)));
            List<Object> deviceInfoCodeList = new ArrayList();
            if (null != reDomainSupQueryResult && null != reDomainSupQueryResult.getList()) {
                deviceInfoCodeList = reDomainSupQueryResult.getList().stream().filter(e -> null != e.getUserinfoQuaVaule()).map(UmUserinfoQuaDomain::getUserinfoQuaVaule).collect(Collectors.toList());
            }
            if (ListUtil.isNotEmpty(deviceInfoCodeList)) {
                param.put("deviceCode", String.join((CharSequence)",", deviceInfoCodeList));
                SupQueryResult<RsDeviceInfoReDomain> supQueryResult = this.rsDeviceInfoService.queryDeviceInfoPage(param);
                if (null != supQueryResult && null != supQueryResult.getList()) {
                    for (RsDeviceInfoReDomain infoReDomain : supQueryResult.getList()) {
                        if (infoReDomain.getDeviceCode().equals(userSession.getUserMsg())) {
                            infoReDomain.setChoice(true);
                            continue;
                        }
                        infoReDomain.setChoice(false);
                    }
                }
                return supQueryResult;
            }
        } else {
            this.logger.error(CODE + ".queryUserDeviceInfoPage", (Object)"userPcode is null");
        }
        return new SupQueryResult();
    }

    @RequestMapping(value={"updateDeviceInfoState.json"}, name="\u66f4\u65b0\u8bbe\u5907\u7ba1\u7406\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDeviceInfoState(String deviceId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)deviceId)) {
            this.logger.error(CODE + ".updateDeviceInfoState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsDeviceInfoService.updateDeviceInfoState(Integer.valueOf(deviceId), dataState, oldDataState);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"queryApplyDeviceInfoPage.json"}, name="\u67e5\u8be2\u5f53\u524d\u5546\u54c1\u9002\u7528\u8bbe\u5907\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsDeviceInfoReDomain> queryApplyDeviceInfoPage(HttpServletRequest request) {
        UserSession userSession;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param && param.containsKey("goodsCode")) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userSession = this.getUserSession(request))) {
            this.logger.error(CODE + ".queryApplyDeviceInfoPage", (Object)"userSession is null");
            return new SupQueryResult();
        }
        String userPcode = userSession.getUserPcode();
        if (null != userPcode) {
            void var10_12;
            HashMap<String, Object> queryMap = new HashMap<String, Object>();
            queryMap.put("goodsCode", param.get("goodsCode"));
            queryMap.put("tenantCode", this.getTenantCode(request));
            SupQueryResult<RsGoodsRelReDomain> relReDomainSupQueryResult = this.rsGoodsOtherService.queryGoodsRelPage(queryMap);
            if (null == relReDomainSupQueryResult || null == relReDomainSupQueryResult.getList()) return new SupQueryResult();
            List goodsRelGcodeList = relReDomainSupQueryResult.getList().stream().filter(e -> null != e.getGoodsRelGcode()).map(RsGoodsRelDomain::getGoodsRelGcode).collect(Collectors.toList());
            if (!ListUtil.isNotEmpty(goodsRelGcodeList)) return new SupQueryResult();
            HashMap<String, Object> userinfoQuaParam = new HashMap<String, Object>();
            userinfoQuaParam.put("tenantCode", this.getTenantCode(request));
            userinfoQuaParam.put("userinfoCode", userPcode);
            userinfoQuaParam.put("userinfoQuaKey", "deviceCode");
            userinfoQuaParam.put("userinfoQuaVaule", String.join((CharSequence)",", goodsRelGcodeList));
            SupQueryResult<UmUserinfoQuaReDomain> reDomainSupQueryResult = this.umUserinfoQuaService.queryUserinfoQuaPage(userinfoQuaParam);
            this.logger.info(CODE + ".queryApplyDeviceInfoPage", (Object)("reDomainSupQueryResult is " + JsonUtil.buildNormalBinder().toJson(reDomainSupQueryResult)));
            ArrayList arrayList = new ArrayList();
            if (null != reDomainSupQueryResult && null != reDomainSupQueryResult.getList()) {
                List list = reDomainSupQueryResult.getList().stream().filter(e -> null != e.getUserinfoQuaVaule()).map(UmUserinfoQuaDomain::getUserinfoQuaVaule).collect(Collectors.toList());
            }
            if (!ListUtil.isNotEmpty((Collection)var10_12)) return new SupQueryResult();
            param.put("deviceCode", String.join((CharSequence)",", (Iterable<? extends CharSequence>)var10_12));
            SupQueryResult<RsDeviceInfoReDomain> supQueryResult = this.rsDeviceInfoService.queryDeviceInfoPage(param);
            if (null == supQueryResult || null == supQueryResult.getList()) return supQueryResult;
            for (RsDeviceInfoReDomain infoReDomain : supQueryResult.getList()) {
                if (infoReDomain.getDeviceCode().equals(userSession.getUserMsg())) {
                    infoReDomain.setChoice(true);
                    continue;
                }
                infoReDomain.setChoice(false);
            }
            return supQueryResult;
        }
        this.logger.error(CODE + ".queryApplyDeviceInfoPage", (Object)"userPcode is null");
        return new SupQueryResult();
    }
}

